/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRuleIndex;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public final class MapCSSStyleIndex {
    final MapCSSRuleIndex nodeRules = new MapCSSRuleIndex();
    final MapCSSRuleIndex wayRules = new MapCSSRuleIndex();
    final MapCSSRuleIndex wayNoAreaRules = new MapCSSRuleIndex();
    final MapCSSRuleIndex relationRules = new MapCSSRuleIndex();
    final MapCSSRuleIndex multipolygonRules = new MapCSSRuleIndex();
    final MapCSSRuleIndex canvasRules = new MapCSSRuleIndex();

    public void clear() {
        this.nodeRules.clear();
        this.wayRules.clear();
        this.wayNoAreaRules.clear();
        this.relationRules.clear();
        this.multipolygonRules.clear();
        this.canvasRules.clear();
    }

    public void buildIndex(Stream<MapCSSRule> ruleStream) {
        this.clear();
        ruleStream.forEach(rule -> {
            Set bases = rule.selectors.stream().map(Selector::getBase).collect(Collectors.toSet());
            Map<String, MapCSSRule> selectorsByBase = bases.size() == 1 ? Collections.singletonMap((String)bases.iterator().next(), rule) : rule.selectors.stream().collect(Collectors.groupingBy(Selector::getBase, Collectors.collectingAndThen(Collectors.toList(), selectors -> new MapCSSRule((List<Selector>)selectors, rule.declaration))));
            selectorsByBase.forEach((base, optRule) -> {
                switch (base) {
                    case "node": {
                        this.nodeRules.add((MapCSSRule)optRule);
                        break;
                    }
                    case "way": {
                        this.wayNoAreaRules.add((MapCSSRule)optRule);
                        this.wayRules.add((MapCSSRule)optRule);
                        break;
                    }
                    case "area": {
                        this.wayRules.add((MapCSSRule)optRule);
                        this.multipolygonRules.add((MapCSSRule)optRule);
                        break;
                    }
                    case "relation": {
                        this.relationRules.add((MapCSSRule)optRule);
                        this.multipolygonRules.add((MapCSSRule)optRule);
                        break;
                    }
                    case "*": {
                        this.nodeRules.add((MapCSSRule)optRule);
                        this.wayRules.add((MapCSSRule)optRule);
                        this.wayNoAreaRules.add((MapCSSRule)optRule);
                        this.relationRules.add((MapCSSRule)optRule);
                        this.multipolygonRules.add((MapCSSRule)optRule);
                        break;
                    }
                    case "canvas": {
                        this.canvasRules.add((MapCSSRule)optRule);
                        break;
                    }
                    case "meta": 
                    case "setting": 
                    case "settings": {
                        break;
                    }
                    default: {
                        JosmRuntimeException e = new JosmRuntimeException(MessageFormat.format("Unknown MapCSS base selector {0}", base));
                        Logging.warn(I18n.tr("Failed to index validator rules. Error was: {0}", e.getMessage()));
                        Logging.error(e);
                    }
                }
            });
        });
        this.initIndex();
    }

    private void initIndex() {
        this.nodeRules.initIndex();
        this.wayRules.initIndex();
        this.wayNoAreaRules.initIndex();
        this.relationRules.initIndex();
        this.multipolygonRules.initIndex();
        this.canvasRules.initIndex();
    }

    public MapCSSRuleIndex get(IPrimitive p) {
        if (p instanceof INode) {
            return this.nodeRules;
        }
        if (p instanceof IWay) {
            if (OsmUtils.isFalse(p.get("area"))) {
                return this.wayNoAreaRules;
            }
            return this.wayRules;
        }
        if (p instanceof IRelation) {
            if (((IRelation)p).isMultipolygon()) {
                return this.multipolygonRules;
            }
            if (p.hasKey("#canvas")) {
                return this.canvasRules;
            }
            return this.relationRules;
        }
        throw new IllegalArgumentException("Unsupported type: " + p);
    }

    public Iterator<MapCSSRule> getRuleCandidates(IPrimitive osm) {
        return this.get(osm).getRuleCandidates(osm);
    }

    public boolean isEmpty() {
        return this.nodeRules.isEmpty() && this.wayRules.isEmpty() && this.wayNoAreaRules.isEmpty() && this.relationRules.isEmpty() && this.multipolygonRules.isEmpty() && this.canvasRules.isEmpty();
    }
}

