import { Bridge } from "matrix-appservice-bridge";
import { ClientPool } from "./ClientPool";
import { BridgedClient } from "./BridgedClient";
import { ConnectionInstance } from "./ConnectionInstance";
import { Message } from "matrix-org-irc";
import { IrcHandler } from "../bridge/IrcHandler";
import { IrcServer } from "./IrcServer";
export declare class IrcEventBroker {
    private readonly appServiceBridge;
    private readonly pool;
    private readonly ircHandler;
    private processed;
    private channelReqBuffer;
    private quitDebouncer;
    constructor(appServiceBridge: Bridge, pool: ClientPool, ircHandler: IrcHandler, servers: IrcServer[]);
    private attemptClaim;
    private hookIfClaimed;
    /**
     * This function is called when the quit debouncer has deemed it safe to start sending
     * quits from users who were debounced.
     * @param channel The channel to handle QUITs for.
     * @param server The channels server.
     * @param nicks The set of nicks for the channel.
     */
    private handleDebouncedQuit;
    sendMetadata(client: BridgedClient, msg: string, force?: boolean, err?: Message): void;
    addHooks(client: BridgedClient, connInst: ConnectionInstance): void;
    /**
     * This function "soft" queues functions acting on a single channel. This means
     * that messages will be processed in order, unless they take longer than `BUFFER_TIMEOUT_MS`
     * milliseconds, in which case they will "jump" the queue. This ensures that messages will be
     * hopefully ordered correctly, but will not arrive too late if the IRC bridge or the homeserver
     * is running slow.
     *
     * @param channel The channel to key the queue on.
     * @param req The request function
     * @param request The request object for logging to.
     */
    private bufferRequestToChannel;
    static isValidNick(nick: string): boolean;
}
