/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import eu.hansolo.tilesfx.addons.YearChart;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static final double SIZE = 400.0;
    private static final double WIDTH = 400.0;
    private static final double HEIGHT = 400.0;
    private static int noOfNodes = 0;
    private Tile tile1;
    private Tile tile2;
    private VBox yearBox;
    private DoubleProperty value;
    private long lastTimerCall;
    private AnimationTimer timer;

    @Override
    public void init() {
        this.value = new SimpleDoubleProperty();
        this.tile1 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.FIRE_SMOKE)).prefSize(400.0, 400.0)).title("Tile 1")).threshold(40.0)).animated(false)).build();
        this.tile2 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.FIRE_SMOKE)).prefSize(400.0, 400.0)).title("Tile 2")).threshold(40.0)).animated(false)).build();
        this.yearBox = new VBox();
        for (int year = 2010; year < 2021; ++year) {
            YearChart yearChart = new YearChart(Integer.toString(year), Color.WHITE, true, true);
            for (int i = 1; i < 13; ++i) {
                yearChart.set(i, RND.nextDouble() * 2.18 - 0.8);
            }
            Label yearLabel = new Label(yearChart.getText());
            yearLabel.setAlignment(Pos.CENTER_LEFT);
            yearLabel.setPrefWidth(40.0);
            HBox hBox = new HBox(5.0, yearLabel, yearChart);
            hBox.setAlignment(Pos.CENTER_LEFT);
            this.yearBox.getChildren().add(hBox);
        }
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            @Override
            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 5000000000L) {
                    Test.this.tile1.setValue(RND.nextDouble() * Test.this.tile1.getRange() + Test.this.tile1.getMinValue());
                    Test.this.tile2.setValue(RND.nextDouble() * Test.this.tile2.getRange() + Test.this.tile2.getMinValue());
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    @Override
    public void start(Stage stage) {
        HBox pane = new HBox(20.0, this.tile1, this.tile2);
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene(pane);
        stage.setTitle("Test");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes(pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    @Override
    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList<Node> tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args2) {
        Test.launch(args2);
    }
}

