/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumnModel;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Icons;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.daten.FilmResolution;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialog.MVPanelDownloadZiel;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.MVMessageDialog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogEditDownload
extends JDialog {
    private final DatenDownload datenDownload;
    public boolean ok;
    private final JTextField[] textfeldListe = new JTextField[40];
    private final JLabel[] labelListe = new JLabel[40];
    private final JCheckBox jCheckBoxRestart = new JCheckBox();
    private final JCheckBox jCheckBoxDownloadmanager = new JCheckBox();
    private final JCheckBox jCheckBoxUnterbrochen = new JCheckBox();
    private final JCheckBox jCheckBoxInfodatei = new JCheckBox();
    private final JCheckBox jCheckBoxSubtitle = new JCheckBox();
    private final JCheckBox jCheckBoxSpotlight = new JCheckBox();
    private final MVPanelDownloadZiel mVPanelDownloadZiel;
    private final boolean gestartet;
    private String dateiGroesse_HD = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private final JFrame parent;
    private final String orgProgArray;
    private FilmResolution.Enum resolution = FilmResolution.Enum.NORMAL;
    private final JLabel jLabelFilmHD = new JLabel();
    private final JLabel jLabelFilmUT = new JLabel();
    private static ImageIcon ja_sw_16;
    private final TableColumnModel columnModel;
    private static final Logger logger;
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JPanel jPanelExtra;
    private JPanel jPanelRes;
    private JRadioButton jRadioButtonResHd;
    private JRadioButton jRadioButtonResHi;
    private JRadioButton jRadioButtonResLo;
    private JScrollPane jScrollPane1;

    public DialogEditDownload(JFrame parent, boolean modal, DatenDownload ddownload, boolean ggestartet, TableColumnModel colModel) {
        super((Frame)parent, modal);
        this.initComponents();
        this.parent = parent;
        this.datenDownload = ddownload;
        this.gestartet = ggestartet;
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        ja_sw_16 = Icons.ICON_DIALOG_EIN_SW;
        this.columnModel = colModel;
        this.orgProgArray = this.datenDownload.arr[27];
        this.mVPanelDownloadZiel = new MVPanelDownloadZiel(parent, this.datenDownload, false);
        this.mVPanelDownloadZiel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonResHd.addActionListener(e -> this.changeRes());
        this.jRadioButtonResHi.addActionListener(e -> this.changeRes());
        this.jRadioButtonResLo.addActionListener(e -> this.changeRes());
        this.jButtonOk.addActionListener(e -> {
            if (this.check()) {
                this.dispose();
            }
        });
        this.jButtonAbbrechen.addActionListener(e -> this.dispose());
        this.getRootPane().setDefaultButton(this.jButtonOk);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.setupResolutionButtons();
        this.setExtra();
    }

    private void setupResolutionButtons() {
        this.jRadioButtonResHd.setEnabled(false);
        this.jRadioButtonResHi.setEnabled(false);
        this.jRadioButtonResLo.setEnabled(false);
        if (this.datenDownload.art != 1 && this.datenDownload.pSet == null) {
            this.jPanelRes.setVisible(false);
            return;
        }
        if (this.datenDownload.film != null) {
            this.jRadioButtonResHi.setEnabled(!this.gestartet);
            this.jRadioButtonResHi.setSelected(this.datenDownload.arr[21].equals(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL)));
            this.dateiGroesse_Hoch = this.datenDownload.film.getDateigroesse(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL));
            if (!this.dateiGroesse_Hoch.isEmpty()) {
                this.jRadioButtonResHi.setText(this.jRadioButtonResHi.getText() + "   [ " + this.dateiGroesse_Hoch + " MB ]");
            }
            if (!this.datenDownload.film.getUrlHighQuality().isEmpty()) {
                this.jRadioButtonResHd.setEnabled(!this.gestartet);
                this.jRadioButtonResHd.setSelected(this.datenDownload.arr[21].equals(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY)));
                this.dateiGroesse_HD = this.datenDownload.film.getDateigroesse(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY));
                if (!this.dateiGroesse_HD.isEmpty()) {
                    this.jRadioButtonResHd.setText(this.jRadioButtonResHd.getText() + "   [ " + this.dateiGroesse_HD + " MB ]");
                }
            }
            if (!this.datenDownload.film.getUrlKlein().isEmpty()) {
                this.jRadioButtonResLo.setEnabled(!this.gestartet);
                this.jRadioButtonResLo.setSelected(this.datenDownload.arr[21].equals(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)));
                this.dateiGroesse_Klein = this.datenDownload.film.getDateigroesse(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.LOW));
                if (!this.dateiGroesse_Klein.isEmpty()) {
                    this.jRadioButtonResLo.setText(this.jRadioButtonResLo.getText() + "   [ " + this.dateiGroesse_Klein + " MB ]");
                }
            }
        }
        this.resolution = this.getRadioButtonResolution();
    }

    private FilmResolution.Enum getRadioButtonResolution() {
        FilmResolution.Enum res = this.jRadioButtonResHd.isSelected() ? FilmResolution.Enum.HIGH_QUALITY : (this.jRadioButtonResLo.isSelected() ? FilmResolution.Enum.LOW : FilmResolution.Enum.NORMAL);
        return res;
    }

    private void changeRes() {
        FilmResolution.Enum res = this.getRadioButtonResolution();
        this.datenDownload.arr[21] = this.datenDownload.film.getUrlFuerAufloesung(res);
        this.textfeldListe[21].setText(this.datenDownload.arr[21]);
        String size = this.jRadioButtonResHd.isSelected() ? this.dateiGroesse_HD : (this.jRadioButtonResLo.isSelected() ? this.dateiGroesse_Klein : this.dateiGroesse_Hoch);
        if (this.datenDownload.art == 2 && this.datenDownload.pSet != null) {
            DatenDownload d = new DatenDownload(this.datenDownload.pSet, this.datenDownload.film, this.datenDownload.quelle, this.datenDownload.abo, this.datenDownload.arr[29], this.datenDownload.arr[30], res.toString());
            this.datenDownload.arr[26] = d.arr[26];
            this.datenDownload.arr[27] = d.arr[27];
            this.textfeldListe[26].setText(this.datenDownload.arr[26]);
            this.textfeldListe[27].setText(this.datenDownload.arr[27]);
        }
        this.datenDownload.setGroesse(size);
    }

    private void setExtra() {
        this.jPanelExtra.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            JLabel label;
            this.labelListe[i] = label = new JLabel("  " + this.columnModel.getColumn(i).getHeaderValue() + ": ");
            JTextField textfeld = new JTextField();
            textfeld.setEditable(false);
            textfeld.setText(this.datenDownload.arr[i]);
            this.textfeldListe[i] = textfeld;
            this.addExtraFeld(i, gridbag, c);
            c.gridy = ++zeile;
        }
        this.jPanelExtra.validate();
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c) {
        c.gridx = 0;
        c.weightx = 0.0;
        if (i == 34 || i == 22 || i == 7 || i == 6 || i == 39 || i == 10) {
            return;
        }
        if (!(this.datenDownload.art != 1 || i != 29 && i != 31 && i != 30 || this.gestartet)) {
            if (i == 29) {
                c.gridx = 1;
                c.weightx = 10.0;
                gridbag.setConstraints(this.mVPanelDownloadZiel, c);
                this.jPanelExtra.add(this.mVPanelDownloadZiel);
            }
        } else {
            switch (i) {
                case 28: {
                    this.labelListe[i].setForeground(Color.BLUE);
                    this.jCheckBoxRestart.setSelected(this.datenDownload.isRestart());
                    this.jCheckBoxRestart.addActionListener(new BeobCheckbox());
                    this.jCheckBoxRestart.setEnabled(!this.gestartet);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jCheckBoxRestart, c);
                    this.jPanelExtra.add(this.jCheckBoxRestart);
                    if (!this.datenDownload.isDownloadManager()) break;
                    this.jCheckBoxRestart.setEnabled(false);
                    break;
                }
                case 38: {
                    this.jCheckBoxDownloadmanager.setSelected(this.datenDownload.isDownloadManager());
                    this.jCheckBoxDownloadmanager.setEnabled(false);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jCheckBoxDownloadmanager, c);
                    this.jPanelExtra.add(this.jCheckBoxDownloadmanager);
                    break;
                }
                case 17: {
                    if (!this.datenDownload.isInterrupted()) {
                        return;
                    }
                    this.labelListe[i].setForeground(Color.BLUE);
                    this.jCheckBoxUnterbrochen.setSelected(this.datenDownload.isInterrupted());
                    this.jCheckBoxUnterbrochen.addActionListener(new BeobCheckbox());
                    this.jCheckBoxUnterbrochen.setEnabled(!this.gestartet);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jCheckBoxUnterbrochen, c);
                    this.jPanelExtra.add(this.jCheckBoxUnterbrochen);
                    break;
                }
                case 35: {
                    this.labelListe[i].setForeground(Color.BLUE);
                    this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(this.datenDownload.arr[35]));
                    this.jCheckBoxInfodatei.addActionListener(new BeobCheckbox());
                    this.jCheckBoxInfodatei.setEnabled(!this.gestartet);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jCheckBoxInfodatei, c);
                    this.jPanelExtra.add(this.jCheckBoxInfodatei);
                    break;
                }
                case 37: {
                    this.labelListe[i].setForeground(Color.BLUE);
                    this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(this.datenDownload.arr[37]));
                    this.jCheckBoxSubtitle.addActionListener(new BeobCheckbox());
                    this.jCheckBoxSubtitle.setEnabled(!this.gestartet);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jCheckBoxSubtitle, c);
                    this.jPanelExtra.add(this.jCheckBoxSubtitle);
                    break;
                }
                case 36: {
                    this.labelListe[i].setForeground(Color.BLUE);
                    this.jCheckBoxSpotlight.setSelected(Boolean.parseBoolean(this.datenDownload.arr[36]));
                    this.jCheckBoxSpotlight.addActionListener(new BeobCheckbox());
                    this.jCheckBoxSpotlight.setEnabled(!this.gestartet);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jCheckBoxSpotlight, c);
                    this.jPanelExtra.add(this.jCheckBoxSpotlight);
                    break;
                }
                case 15: {
                    this.jLabelFilmHD.setOpaque(false);
                    this.jLabelFilmHD.setIcon(ja_sw_16);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jLabelFilmHD, c);
                    this.jPanelExtra.add(this.jLabelFilmHD);
                    if (this.datenDownload.film != null) {
                        this.jLabelFilmHD.setVisible(this.datenDownload.film.isHighQuality());
                        break;
                    }
                    this.jLabelFilmHD.setVisible(false);
                    break;
                }
                case 16: {
                    this.jLabelFilmUT.setOpaque(false);
                    this.jLabelFilmUT.setIcon(ja_sw_16);
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.jLabelFilmUT, c);
                    this.jPanelExtra.add(this.jLabelFilmUT);
                    if (this.datenDownload.film != null) {
                        this.jLabelFilmUT.setVisible(this.datenDownload.film.hasSubtitle());
                        break;
                    }
                    this.jLabelFilmUT.setVisible(false);
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    if (this.datenDownload.art != 2) break;
                    if (this.datenDownload.arr[27].isEmpty()) {
                        this.labelListe[27].setForeground(Color.BLUE);
                        this.textfeldListe[26].setEditable(!this.gestartet);
                        this.textfeldListe[26].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(26));
                        gridbag.setConstraints(this.labelListe[27], c);
                        this.jPanelExtra.add(this.labelListe[27]);
                        c.gridx = 1;
                        c.weightx = 10.0;
                        gridbag.setConstraints(this.textfeldListe[26], c);
                        this.jPanelExtra.add(this.textfeldListe[26]);
                        break;
                    }
                    this.labelListe[i].setForeground(Color.BLUE);
                    this.textfeldListe[i].setEditable(!this.gestartet);
                    this.textfeldListe[i].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    JPanel jp = new JPanel();
                    jp.setBorder(BorderFactory.createTitledBorder(""));
                    GridBagLayout gb = new GridBagLayout();
                    GridBagConstraints gc = new GridBagConstraints();
                    gc.fill = 2;
                    gc.insets = new Insets(2, 2, 2, 2);
                    jp.setLayout(gb);
                    JButton jButtonReset = new JButton("");
                    jButtonReset.setToolTipText("Reset");
                    jButtonReset.setIcon(IconFontSwing.buildIcon(FontAwesome.REFRESH, 16.0f));
                    jButtonReset.addActionListener(e -> this.textfeldListe[27].setText(this.orgProgArray));
                    JButton jButtonHelp = new JButton("");
                    jButtonHelp.setIcon(IconFontSwing.buildIcon(FontAwesome.QUESTION_CIRCLE_O, 16.0f));
                    jButtonHelp.setToolTipText("Hilfe anzeigen");
                    jButtonHelp.addActionListener(e -> new DialogHilfe(this.parent, true, new GetFile().getHilfeSuchen("hilfetext_editDownloadProg.txt")).setVisible(true));
                    gc.gridy = 0;
                    gc.gridx = 0;
                    gc.weightx = 1.0;
                    gb.setConstraints(jButtonHelp, gc);
                    jp.add(jButtonHelp);
                    gc.gridx = 1;
                    gc.weightx = 10.0;
                    gb.setConstraints(this.textfeldListe[26], gc);
                    jp.add(this.textfeldListe[26]);
                    gc.gridy = 1;
                    gc.gridx = 0;
                    gc.weightx = 1.0;
                    gb.setConstraints(jButtonReset, gc);
                    jp.add(jButtonReset);
                    gc.gridx = 1;
                    gc.weightx = 10.0;
                    gb.setConstraints(this.textfeldListe[i], gc);
                    jp.add(this.textfeldListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(jp, c);
                    this.jPanelExtra.add(jp);
                    break;
                }
                default: {
                    switch (i) {
                        case 0: {
                            this.textfeldListe[i].setText(String.valueOf(this.datenDownload.nr));
                            break;
                        }
                        case 1: {
                            if (this.datenDownload.film == null) break;
                            this.textfeldListe[i].setText(String.valueOf(this.datenDownload.film.getFilmNr()));
                            break;
                        }
                        case 21: {
                            if (this.datenDownload.art != 1) break;
                            this.labelListe[i].setForeground(Color.BLUE);
                            this.textfeldListe[i].setEditable(!this.gestartet);
                            this.textfeldListe[i].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
                            break;
                        }
                        case 11: {
                            this.textfeldListe[i].setText(this.datenDownload.mVFilmSize.toString());
                            break;
                        }
                        case 8: {
                            this.textfeldListe[i].setText(Start.getTextProgress(this.datenDownload.isDownloadManager(), this.datenDownload.start));
                            break;
                        }
                        case 9: {
                            this.textfeldListe[i].setText(this.datenDownload.getTextRestzeit());
                            break;
                        }
                        case 32: {
                            switch (this.datenDownload.art) {
                                case 1: {
                                    this.textfeldListe[i].setText("direkter Download");
                                    break;
                                }
                                case 2: {
                                    this.textfeldListe[i].setText("Programm");
                                }
                            }
                            break;
                        }
                        case 33: {
                            switch (this.datenDownload.quelle) {
                                case -1: {
                                    this.textfeldListe[i].setText("Alle");
                                    break;
                                }
                                case 3: {
                                    this.textfeldListe[i].setText("Abo");
                                    break;
                                }
                                case 1: {
                                    this.textfeldListe[i].setText("Button");
                                    break;
                                }
                                case 2: {
                                    this.textfeldListe[i].setText("Download");
                                }
                            }
                            break;
                        }
                    }
                    gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    gridbag.setConstraints(this.textfeldListe[i], c);
                    this.jPanelExtra.add(this.textfeldListe[i]);
                }
            }
        }
    }

    private boolean downloadDateiLoeschen(DatenDownload datenDownload) {
        try {
            File file = new File(datenDownload.arr[31]);
            if (!file.exists()) {
                return true;
            }
            int ret = JOptionPane.showConfirmDialog(this.parent, "Die Aufl\u00f6sung wurde ge\u00e4ndert, der Film kann nicht weitergef\u00fchrt werden.\nDatei muss zuerst gel\u00f6scht werden.", "Film L\u00f6schen?", 0);
            if (ret != 0) {
                return false;
            }
            logger.info("Datei l\u00f6schen: {}", (Object)file.getAbsolutePath());
            if (!file.delete()) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.parent, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            logger.error("Fehler beim l\u00f6schen: {}", (Object)datenDownload.arr[31]);
        }
        return true;
    }

    private boolean check() {
        this.mVPanelDownloadZiel.setPfadName_geaendert();
        this.ok = this.jRadioButtonResHd.isSelected() && this.resolution != FilmResolution.Enum.HIGH_QUALITY || this.jRadioButtonResLo.isSelected() && this.resolution != FilmResolution.Enum.LOW || this.jRadioButtonResHi.isSelected() && this.resolution != FilmResolution.Enum.NORMAL ? this.downloadDateiLoeschen(this.datenDownload) : true;
        return this.ok;
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jPanelRes = new JPanel();
        JLabel jLabelRes = new JLabel();
        this.jRadioButtonResHd = new JRadioButton();
        this.jRadioButtonResHi = new JRadioButton();
        this.jRadioButtonResLo = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Download editieren");
        this.setMinimumSize(new Dimension(500, 0));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jPanelRes.setBorder(BorderFactory.createTitledBorder(""));
        jLabelRes.setText("Download-Qualit\u00e4t:");
        buttonGroup1.add(this.jRadioButtonResHd);
        this.jRadioButtonResHd.setText("H\u00f6chste/Hoch");
        buttonGroup1.add(this.jRadioButtonResHi);
        this.jRadioButtonResHi.setText("Mittel");
        buttonGroup1.add(this.jRadioButtonResLo);
        this.jRadioButtonResLo.setText("Niedrig");
        GroupLayout jPanelResLayout = new GroupLayout(this.jPanelRes);
        this.jPanelRes.setLayout(jPanelResLayout);
        jPanelResLayout.setHorizontalGroup(jPanelResLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResLayout.createSequentialGroup().addContainerGap().addComponent(jLabelRes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonResHd).addGap(18, 18, 18).addComponent(this.jRadioButtonResHi).addGap(18, 18, 18).addComponent(this.jRadioButtonResLo).addContainerGap(304, Short.MAX_VALUE)));
        jPanelResLayout.setVerticalGroup(jPanelResLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResLayout.createSequentialGroup().addContainerGap().addGroup(jPanelResLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelRes).addComponent(this.jRadioButtonResHd).addComponent(this.jRadioButtonResHi).addComponent(this.jRadioButtonResLo)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelRes, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 577, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelRes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonAbbrechen)).addContainerGap()));
        this.pack();
    }

    static {
        logger = LogManager.getLogger(DialogEditDownload.class);
    }

    private class BeobCheckbox
    implements ActionListener {
        private BeobCheckbox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditDownload.this.datenDownload.arr[28] = Boolean.toString(DialogEditDownload.this.jCheckBoxRestart.isSelected());
            DialogEditDownload.this.datenDownload.arr[17] = Boolean.toString(DialogEditDownload.this.jCheckBoxUnterbrochen.isSelected());
            DialogEditDownload.this.datenDownload.arr[35] = Boolean.toString(DialogEditDownload.this.jCheckBoxInfodatei.isSelected());
            DialogEditDownload.this.datenDownload.arr[37] = Boolean.toString(DialogEditDownload.this.jCheckBoxSubtitle.isSelected());
            DialogEditDownload.this.datenDownload.arr[36] = Boolean.toString(DialogEditDownload.this.jCheckBoxSpotlight.isSelected());
        }
    }

    private class BeobachterDocumentTextfeld
    implements DocumentListener {
        int nr;

        public BeobachterDocumentTextfeld(int n) {
            this.nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            DialogEditDownload.this.datenDownload.arr[this.nr] = DialogEditDownload.this.textfeldListe[this.nr].getText().trim();
            if (this.nr == 27) {
                DialogEditDownload.this.datenDownload.arr[26] = DatenProg.makeProgAufrufArray(DialogEditDownload.this.datenDownload.arr[27]);
                DialogEditDownload.this.textfeldListe[26].setText(DialogEditDownload.this.datenDownload.arr[26]);
            }
        }
    }
}

