/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaUserClassLoader
extends URLClassLoader {
    private HashMap<URL, String> urls = new HashMap();
    private Object link = null;
    private Method invoke = null;
    private Method get = null;
    private Method set = null;
    private Method array_get = null;
    private Method array_set = null;
    private Method create = null;

    public InlineJavaUserClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public void AddClassPath(String path) throws InlineJavaException {
        try {
            File p = new File(path);
            URL u = p.toURI().toURL();
            if (this.urls.get(u) == null) {
                this.urls.put(u, "1");
                this.addURL(u);
                InlineJavaUtils.debug(2, "added " + u + " to classpath");
            }
        }
        catch (MalformedURLException e) {
            throw new InlineJavaException("Can't add invalid classpath entry '" + path + "'");
        }
    }

    private synchronized void check_link() throws InlineJavaException {
        if (this.link == null) {
            try {
                InlineJavaUtils.debug(1, "loading InlineJavaUserClassLink via InlineJavaUserClassLoader");
                Class<?> c = Class.forName("InlineJavaUserClassLink", true, this);
                this.link = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.invoke = this.find_method(c, "invoke");
                this.get = this.find_method(c, "get");
                this.set = this.find_method(c, "set");
                this.array_get = this.find_method(c, "array_get");
                this.array_set = this.find_method(c, "array_set");
                this.create = this.find_method(c, "create");
            }
            catch (Exception e) {
                throw new InlineJavaException("InlineJavaUserClassLoader can't load InlineJavaUserClassLink: invalid classpath setup (" + e.getClass().getName() + ": " + e.getMessage() + ")");
            }
        }
    }

    private Method find_method(Class c, String name) throws InlineJavaException {
        Method[] ml = c.getMethods();
        for (int i = 0; i < ml.length; ++i) {
            if (!ml[i].getName().equals(name)) continue;
            return ml[i];
        }
        throw new InlineJavaException("Can't find method '" + name + "' in class InlineJavaUserClassLink");
    }

    private Object invoke_via_link(Method m, Object[] p) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InlineJavaException {
        try {
            return m.invoke(this.link, p);
        }
        catch (IllegalAccessException e) {
            throw new InlineJavaException("Can't invoke method from class InlineJavaUserClassLink: IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            throw new InlineJavaException("Can't invoke method from class InlineJavaUserClassLink: IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            if (t instanceof InstantiationException) {
                throw (InstantiationException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            if (t instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)t;
                throw re;
            }
            throw new InlineJavaException("Unexpected exception of type '" + t.getClass().getName() + "': " + t.getMessage());
        }
    }

    public Object invoke(Method m, Object o, Object[] p) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InlineJavaException {
        this.check_link();
        try {
            return this.invoke_via_link(this.invoke, new Object[]{m, o, p});
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public Object get(Field f, Object o) throws IllegalAccessException, IllegalArgumentException, InlineJavaException {
        this.check_link();
        try {
            return this.invoke_via_link(this.get, new Object[]{f, o});
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public void set(Field f, Object o, Object p) throws IllegalAccessException, IllegalArgumentException, InlineJavaException {
        this.check_link();
        try {
            this.invoke_via_link(this.set, new Object[]{f, o, p});
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public Object array_get(Object o, int idx) throws InlineJavaException {
        this.check_link();
        try {
            return this.invoke_via_link(this.array_get, new Object[]{o, idx});
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public void array_set(Object o, int idx, Object elem) throws IllegalArgumentException, InlineJavaException {
        this.check_link();
        try {
            this.invoke_via_link(this.array_set, new Object[]{o, idx, elem});
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public Object create(Class p, Object[] args, Class[] proto) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InlineJavaException {
        this.check_link();
        return this.invoke_via_link(this.create, new Object[]{p, args, proto});
    }
}

