/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class FtileBoxOld
extends AbstractFtile {
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static TextBlock createWbs(Style style, ISkinParam skinParam, Display label) {
        Style styleArrow = style;
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    public static TextBlock createMindMap(Style style, ISkinParam skinParam, Display label) {
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, style);
    }

    private FtileBoxOld(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(skinParam);
        Colors specBack = null;
        if (skinParam instanceof SkinParamColors) {
            specBack = ((SkinParamColors)skinParam).getColors();
        }
        this.style = style = style.eventuallyOverride(specBack);
        this.boxStyle = boxStyle;
        this.swimlane = swimlane;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet(), skinParam.getThemeStyle()));
        this.borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.horizontalAlignment = style.getHorizontalAlignment();
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        Sheet sheet = Parser.build(fc, this.horizontalAlignment, skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, style.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = ((Dimension2D)dimTotal).getWidth();
        double heightTotal = ((Dimension2D)dimTotal).getHeight();
        UDrawable shape = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        UStroke thickness = this.style.getStroke();
        ug = this.borderColor == null ? ug.apply(HColors.none()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(HColors.none().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        shape.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug);
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            this.tb.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth() - this.tbWidth(stringBounder), 0.0)));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            this.tb.drawU(ug.apply(new UTranslate((((Dimension2D)dimTotal).getWidth() - this.tbWidth(stringBounder)) / 2.0, 0.0)));
        }
    }

    private double tbWidth(StringBounder stringBounder) {
        return Math.max(this.minimumWidth, this.tb.calculateDimension(stringBounder).getWidth());
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = Dimension2DDouble.atLeast(dimRaw, this.minimumWidth, 0.0);
        return new FtileGeometry(dimRaw.getWidth() + this.boxStyle.getShield(), dimRaw.getHeight(), dimRaw.getWidth() / 2.0, 0.0, dimRaw.getHeight());
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return 0.0;
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBoxOld.this.calculateDimension(stringBounder);
            return ((Dimension2D)dim).getWidth();
        }
    }
}

