/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flowdiagram;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.flowdiagram.ActivityBox;
import net.sourceforge.plantuml.golem.MinMaxGolem;
import net.sourceforge.plantuml.golem.Path;
import net.sourceforge.plantuml.golem.Position;
import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.golem.TileArea;
import net.sourceforge.plantuml.golem.TileGeometry;
import net.sourceforge.plantuml.golem.TilesField;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class FlowDiagram
extends UmlDiagram
implements TextBlock {
    private static double SINGLE_SIZE_X = 100.0;
    private static double SINGLE_SIZE_Y = 35.0;
    private TilesField field;
    private final Map<Tile, ActivityBox> tilesBoxes = new HashMap<Tile, ActivityBox>();
    private Tile lastTile;

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Flow Diagram");
    }

    public FlowDiagram(ThemeStyle style, UmlSource source) {
        super(style, source, UmlDiagramType.FLOW, null);
    }

    public void lineSimple(TileGeometry orientation, String idDest, String label) {
        Tile newTile;
        if (this.field == null) {
            this.field = new TilesField();
            this.tilesBoxes.clear();
            newTile = this.field.getRoot();
        } else {
            newTile = this.field.createTile(this.lastTile, orientation);
        }
        ActivityBox box = new ActivityBox(newTile, idDest, label);
        this.tilesBoxes.put(newTile, box);
        this.lastTile = newTile;
    }

    public void linkSimple(TileGeometry orientation, String idDest) {
        Tile tile = this.getTileById(idDest);
        this.field.addPath(this.lastTile, tile, orientation);
    }

    private Tile getTileById(String id) {
        for (Map.Entry<Tile, ActivityBox> ent : this.tilesBoxes.entrySet()) {
            if (!ent.getValue().getId().equals(id)) continue;
            return ent.getKey();
        }
        throw new IllegalArgumentException(id);
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return ImageBuilder.imageBuilder(fileFormatOption).dimension(this.calculateDimension(fileFormatOption.getDefaultStringBounder(this.getSkinParam()))).margin(this.getDefaultMargins()).metadata(fileFormatOption.isWithMetadata() ? this.getMetadata() : null).seed(this.seed());
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this).write(os);
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        double y = 0.0;
        MinMaxGolem minMax = this.getMinMax();
        x -= (double)minMax.getMinX() * SINGLE_SIZE_X;
        y -= (double)minMax.getMinY() * SINGLE_SIZE_Y;
        StringBounder stringBounder = ug.getStringBounder();
        for (Map.Entry<Tile, ActivityBox> ent : this.tilesBoxes.entrySet()) {
            Tile tile = ent.getKey();
            Position pos = this.field.getPosition(tile);
            int xmin = pos.getXmin();
            int ymin = pos.getYmin();
            ActivityBox box = ent.getValue();
            Dimension2D dimBox = box.calculateDimension(stringBounder);
            double deltaX = SINGLE_SIZE_X * 2.0 - dimBox.getWidth();
            double deltaY = SINGLE_SIZE_Y * 2.0 - dimBox.getHeight();
            box.drawU(ug.apply(new UTranslate(x + (double)xmin * SINGLE_SIZE_X + deltaX / 2.0, y + (double)ymin * SINGLE_SIZE_Y + deltaY / 2.0)));
        }
        ug = ug.apply(HColors.MY_RED);
        ug = ug.apply(HColors.MY_RED.bg());
        UEllipse arrow = new UEllipse(7.0, 7.0);
        for (Path p : this.field.getPaths()) {
            TileArea start = p.getStart();
            TileArea dest = p.getDest();
            Point2D pStart = this.movePoint(this.getCenter(start), start.getTile(), start.getGeometry(), stringBounder);
            Point2D pDest = this.movePoint(this.getCenter(dest), dest.getTile(), dest.getGeometry(), stringBounder);
            ULine line = new ULine(pDest.getX() - pStart.getX(), pDest.getY() - pStart.getY());
            ug.apply(new UTranslate(x + pStart.getX(), y + pStart.getY())).draw(line);
            ug.apply(new UTranslate(x + pDest.getX() - 3.0, y + pDest.getY() - 3.0)).draw(arrow);
        }
    }

    private Point2D getCenter(TileArea area) {
        Tile tile = area.getTile();
        Position position = this.field.getPosition(tile);
        double x = position.getCenterX();
        double y = position.getCenterY();
        return new Point2D.Double(x * SINGLE_SIZE_X, y * SINGLE_SIZE_Y);
    }

    private Point2D movePoint(Point2D pt, Tile tile, TileGeometry tileGeometry, StringBounder stringBounder) {
        Dimension2D dim = this.tilesBoxes.get(tile).calculateDimension(stringBounder);
        double width = dim.getWidth();
        double height = dim.getHeight();
        double x = pt.getX();
        double y = pt.getY();
        switch (tileGeometry) {
            case SOUTH: {
                y += height / 2.0;
                break;
            }
            case NORTH: {
                y -= height / 2.0;
                break;
            }
            case EAST: {
                x += width / 2.0;
                break;
            }
            case WEST: {
                x -= width / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new Point2D.Double(x, y);
    }

    private MinMaxGolem getMinMax() {
        MinMaxGolem minMax = new MinMaxGolem();
        for (Tile tile : this.tilesBoxes.keySet()) {
            minMax.manage(this.field.getPosition(tile));
        }
        return minMax;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        MinMaxGolem minMax = this.getMinMax();
        return new Dimension2DDouble((double)minMax.getWidth() * SINGLE_SIZE_X, (double)minMax.getHeight() * SINGLE_SIZE_Y);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.same(0.0);
    }
}

