/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.next;

import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.core.NwGroup;
import net.sourceforge.plantuml.nwdiag.next.GridTextBlockSimple;
import net.sourceforge.plantuml.nwdiag.next.LinkedElement;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GridTextBlockDecorated
extends GridTextBlockSimple {
    public static final int NETWORK_THIN = 5;
    private final List<NwGroup> groups;
    private final List<Network> networks;

    public GridTextBlockDecorated(int lines, int cols, List<NwGroup> groups, List<Network> networks, ISkinParam skinparam) {
        super(lines, cols, skinparam);
        this.groups = groups;
        this.networks = networks;
    }

    @Override
    protected void drawGrid(UGraphic ug) {
        for (NwGroup group : this.groups) {
            this.drawGroups(ug, group, this.getSkinParam());
        }
        this.drawNetworkTube(ug);
        this.drawLinks(ug, this.getSkinParam().getCurrentStyleBuilder());
    }

    private void drawLinks(UGraphic ug, StyleBuilder styleBuilder) {
        Style style = this.getStyleDefinitionNetwork(SName.arrow).getMergedStyle(styleBuilder);
        HColor lineColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        ug = ug.apply(lineColor);
        StringBounder stringBounder = ug.getStringBounder();
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data.getNbCols(); ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                if (this.data.get(i, j) != null) {
                    this.data.get(i, j).drawLinks(ug, x, colWidth, lineHeight);
                }
                x += colWidth;
            }
        }
    }

    private void drawGroups(UGraphic ug, NwGroup group, ISkinParam skinParam) {
        StringBounder stringBounder = ug.getStringBounder();
        MinMax size = null;
        double y = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data.getNbCols(); ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                LinkedElement element = this.data.get(i, j);
                if (element != null && group.contains(element.getServer())) {
                    MinMax minMax = element.getMinMax(stringBounder, colWidth, lineHeight).translate(new UTranslate(x, y));
                    size = size == null ? minMax : size.addMinMax(minMax);
                }
                x += colWidth;
            }
            y += lineHeight;
        }
        if (size != null) {
            group.drawGroup(ug, size, skinParam);
        }
    }

    private boolean isThereALink(int j, Network network) {
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            LinkedElement element = this.data.get(i, j);
            if (element == null || !element.isLinkedTo(network)) continue;
            return true;
        }
        return false;
    }

    private StyleSignatureBasic getStyleDefinitionNetwork(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.nwdiagDiagram, sname);
    }

    private void drawNetworkTube(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double y = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            Network network = this.getNetwork(i);
            this.computeMixMax(this.data.getLine(i), stringBounder, network);
            URectangle rect = new URectangle(network.getXmax() - network.getXmin(), 5.0);
            UGraphic ug2 = ug.apply(new UTranslate(network.getXmin(), y));
            StyleBuilder styleBuilder = this.getSkinParam().getCurrentStyleBuilder();
            Style style = this.getStyleDefinitionNetwork(SName.network).getMergedStyle(styleBuilder);
            double deltaShadow = style.value(PName.Shadowing).asDouble();
            ug2 = ug2.apply(style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()));
            ug2 = ug2.apply(style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()).bg());
            rect.setDeltaShadow(deltaShadow);
            if (network != null && network.getColor() != null) {
                ug2 = ug2.apply(network.getColor().bg());
            }
            if (network != null) {
                network.setY(y);
            }
            if (network.isVisible()) {
                ug2.draw(rect);
            }
            y += this.lineHeight(stringBounder, i);
        }
    }

    private void computeMixMax(LinkedElement[] line, StringBounder stringBounder, Network network) {
        double x = 0.0;
        double xmin = network.isFullWidth() ? 0.0 : -1.0;
        double xmax = 0.0;
        for (int j = 0; j < line.length; ++j) {
            boolean hline = this.isThereALink(j, network);
            if (hline && xmin < 0.0) {
                xmin = x;
            }
            x += this.colWidth(stringBounder, j);
            if (!hline && !network.isFullWidth()) continue;
            xmax = x;
        }
        network.setMinMax(xmin, xmax);
    }

    private Network getNetwork(int i) {
        return this.networks.get(i);
    }
}

