/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.color.HColors;

class ExtremityDiamond
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final boolean fill;
    private final Point2D contact;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    public ExtremityDiamond(Point2D p1, double angle, boolean fill) {
        this.fill = fill;
        this.contact = new Point2D.Double(p1.getX(), p1.getY());
        angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        int xWing = 6;
        int yAperture = 4;
        this.polygon.addPoint(-6.0, -4.0);
        this.polygon.addPoint(-12.0, 0.0);
        this.polygon.addPoint(-6.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = this.fill ? ug.apply(HColors.changeBack(ug)) : ug.apply(HColors.none().bg());
        ug.draw(this.polygon);
    }

    @Override
    public Point2D isTooSmallSoGiveThePointCloserToThisOne(Point2D pt) {
        Point2D result = null;
        for (Point2D point2D : this.polygon.getPoints()) {
            if (result != null && !(point2D.distance(pt) < result.distance(pt))) continue;
            result = point2D;
        }
        return result;
    }
}

