/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageState2
extends AbstractEntityImage {
    private final Url url;
    private final SName sname;
    private final TextBlock asSmall;

    public EntityImageState2(ILeaf entity, ISkinParam skinParam, SName sname) {
        super(entity, skinParam);
        this.sname = sname;
        Stereotype stereotype = entity.getStereotype();
        USymbol symbol = USymbols.FRAME;
        SymbolContext ctx = this.getStyle().getSymbolContext(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        this.url = entity.getUrl99();
        TextBlock stereo = TextBlockUtils.empty(0.0, 0.0);
        TextBlock desc = BodyFactory.create2(skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), entity.getDisplay(), skinParam, stereotype, entity, this.getStyle());
        this.asSmall = symbol.asSmall(null, desc, stereo, ctx, skinParam.getStereotypeAlignment());
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.state);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asSmall.drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

