/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import java.util.Objects;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAbstract;

public class HColorGradient
extends HColorAbstract
implements HColor {
    private final HColor color1;
    private final HColor color2;
    private final char policy;

    HColorGradient(HColor color1, HColor color2, char policy) {
        if (color1 instanceof HColorGradient) {
            color1 = ((HColorGradient)color1).color1;
        }
        if (color2 instanceof HColorGradient) {
            color2 = ((HColorGradient)color2).color2;
        }
        this.color1 = Objects.requireNonNull(color1);
        this.color2 = Objects.requireNonNull(color2);
        this.policy = policy;
    }

    public final HColor getColor1() {
        return this.color1;
    }

    public final HColor getColor2() {
        return this.color2;
    }

    public final Color getColor(ColorMapper mapper, double coeff) {
        if (coeff > 1.0 || coeff < 0.0) {
            throw new IllegalArgumentException("c=" + coeff);
        }
        Color c1 = mapper.toColor(this.color1);
        Color c2 = mapper.toColor(this.color2);
        int vred = c2.getRed() - c1.getRed();
        int vgreen = c2.getGreen() - c1.getGreen();
        int vblue = c2.getBlue() - c1.getBlue();
        int red = c1.getRed() + (int)(coeff * (double)vred);
        int green = c1.getGreen() + (int)(coeff * (double)vgreen);
        int blue = c1.getBlue() + (int)(coeff * (double)vblue);
        return new Color(red, green, blue);
    }

    public final char getPolicy() {
        return this.policy;
    }
}

