info = {
    "name": "hsb",
    "date_order": "DMY",
    "january": [
        "jan",
        "januar",
        "januara"
    ],
    "february": [
        "feb",
        "februar",
        "februara"
    ],
    "march": [
        "měr",
        "měrc",
        "měrca"
    ],
    "april": [
        "apr",
        "apryl",
        "apryla"
    ],
    "may": [
        "mej",
        "meja",
        "meje"
    ],
    "june": [
        "jun",
        "junij",
        "junija"
    ],
    "july": [
        "jul",
        "julij",
        "julija"
    ],
    "august": [
        "awg",
        "awgust",
        "awgusta"
    ],
    "september": [
        "sep",
        "september",
        "septembra"
    ],
    "october": [
        "okt",
        "oktober",
        "oktobra"
    ],
    "november": [
        "now",
        "nowember",
        "nowembra"
    ],
    "december": [
        "dec",
        "december",
        "decembra"
    ],
    "monday": [
        "pón",
        "póndźela"
    ],
    "tuesday": [
        "wut",
        "wutora"
    ],
    "wednesday": [
        "srj",
        "srjeda"
    ],
    "thursday": [
        "štw",
        "štwórtk"
    ],
    "friday": [
        "pja",
        "pjatk"
    ],
    "saturday": [
        "sob",
        "sobota"
    ],
    "sunday": [
        "nje",
        "njedźela"
    ],
    "am": [
        "dopołdnja"
    ],
    "pm": [
        "popołdnju"
    ],
    "year": [
        "l",
        "lěto"
    ],
    "month": [
        "měs",
        "měsac"
    ],
    "week": [
        "tydź",
        "tydźeń"
    ],
    "day": [
        "d",
        "dźeń"
    ],
    "hour": [
        "h",
        "hodź",
        "hodźina"
    ],
    "minute": [
        "m",
        "min",
        "minuta"
    ],
    "second": [
        "s",
        "sek",
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "dźensa"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 month ago": [
            "tutón měsac"
        ],
        "0 second ago": [
            "now"
        ],
        "0 week ago": [
            "tutón tydźeń"
        ],
        "0 year ago": [
            "lětsa"
        ],
        "1 day ago": [
            "wčera"
        ],
        "1 month ago": [
            "zašły měsac"
        ],
        "1 week ago": [
            "zašły tydźeń"
        ],
        "1 year ago": [
            "loni"
        ],
        "in 1 day": [
            "jutře"
        ],
        "in 1 month": [
            "přichodny měsac"
        ],
        "in 1 week": [
            "přichodny tydźeń"
        ],
        "in 1 year": [
            "klětu"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "před (\\d+) d",
            "před (\\d+) dnj",
            "před (\\d+) dnjemi",
            "před (\\d+) dnjom"
        ],
        "\\1 hour ago": [
            "před (\\d+) h",
            "před (\\d+) hodź",
            "před (\\d+) hodźinami",
            "před (\\d+) hodźinu"
        ],
        "\\1 minute ago": [
            "před (\\d+) m",
            "před (\\d+) min",
            "před (\\d+) minutami",
            "před (\\d+) minutu"
        ],
        "\\1 month ago": [
            "před (\\d+) měs",
            "před (\\d+) měsacami",
            "před (\\d+) měsacom"
        ],
        "\\1 second ago": [
            "před (\\d+) s",
            "před (\\d+) sek",
            "před (\\d+) sekundami",
            "před (\\d+) sekundu"
        ],
        "\\1 week ago": [
            "před (\\d+) tydź",
            "před (\\d+) tydźenjemi",
            "před (\\d+) tydźenjom"
        ],
        "\\1 year ago": [
            "před (\\d+) l",
            "před (\\d+) lětami",
            "před (\\d+) lětom"
        ],
        "in \\1 day": [
            "za (\\d+) d",
            "za (\\d+) dnj",
            "za (\\d+) dnjow",
            "za (\\d+) dźeń"
        ],
        "in \\1 hour": [
            "za (\\d+) h",
            "za (\\d+) hodź",
            "za (\\d+) hodźin",
            "za (\\d+) hodźinu"
        ],
        "in \\1 minute": [
            "za (\\d+) m",
            "za (\\d+) min",
            "za (\\d+) minutow",
            "za (\\d+) minutu"
        ],
        "in \\1 month": [
            "za (\\d+) měs",
            "za (\\d+) měsac",
            "za (\\d+) měsacow"
        ],
        "in \\1 second": [
            "za (\\d+) s",
            "za (\\d+) sek",
            "za (\\d+) sekundow",
            "za (\\d+) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+) tydź",
            "za (\\d+) tydźenjow",
            "za (\\d+) tydźeń"
        ],
        "in \\1 year": [
            "za (\\d+) l",
            "za (\\d+) lět",
            "za (\\d+) lěto"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
