# -*- warn-indent:false;  -*-

# line 1 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"

# line 646 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"


# THIS IS A GENERATED FILE, DO NOT EDIT DIRECTLY
# This file was generated from lib/regexp_parser/scanner/scanner.rl

require 'regexp_parser/error'

class Regexp::Scanner
  # General scanner error (catch all)
  class ScannerError < Regexp::Parser::Error; end

  # Base for all scanner validation errors
  class ValidationError < Regexp::Parser::Error
    def initialize(reason)
      super reason
    end
  end

  # Unexpected end of pattern
  class PrematureEndError < ScannerError
    def initialize(where = '')
      super "Premature end of pattern at #{where}"
    end
  end

  # Invalid sequence format. Used for escape sequences, mainly.
  class InvalidSequenceError < ValidationError
    def initialize(what = 'sequence', where = '')
      super "Invalid #{what} at #{where}"
    end
  end

  # Invalid group. Used for named groups.
  class InvalidGroupError < ValidationError
    def initialize(what, reason)
      super "Invalid #{what}, #{reason}."
    end
  end

  # Invalid groupOption. Used for inline options.
  # TODO: should become InvalidGroupOptionError in v3.0.0 for consistency
  class InvalidGroupOption < ValidationError
    def initialize(option, text)
      super "Invalid group option #{option} in #{text}"
    end
  end

  # Invalid back reference. Used for name a number refs/calls.
  class InvalidBackrefError < ValidationError
    def initialize(what, reason)
      super "Invalid back reference #{what}, #{reason}"
    end
  end

  # The property name was not recognized by the scanner.
  class UnknownUnicodePropertyError < ValidationError
    def initialize(name)
      super "Unknown unicode character property name #{name}"
    end
  end

  # The POSIX class name was not recognized by the scanner.
  class UnknownPosixClassError < ValidationError
    def initialize(text)
      super "Unknown POSIX class #{text}"
    end
  end

  # Scans the given regular expression text, or Regexp object and collects the
  # emitted token into an array that gets returned at the end. If a block is
  # given, it gets called for each emitted token.
  #
  # This method may raise errors if a syntax error is encountered.
  # --------------------------------------------------------------------------
  def self.scan(input_object, options: nil, &block)
    new.scan(input_object, options: options, &block)
  end

  def scan(input_object, options: nil, &block)
    self.literal = nil
    stack = []

    input = input_object.is_a?(Regexp) ? input_object.source : input_object
    self.free_spacing = free_spacing?(input_object, options)
    self.spacing_stack = [{:free_spacing => free_spacing, :depth => 0}]

    data  = input.unpack("c*") if input.is_a?(String)
    eof   = data.length

    self.tokens = []
    self.block  = block_given? ? block : nil

    self.set_depth = 0
    self.group_depth = 0
    self.conditional_stack = []
    self.char_pos = 0

    
# line 104 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
class << self
	attr_accessor :_re_scanner_trans_keys
	private :_re_scanner_trans_keys, :_re_scanner_trans_keys=
end
self._re_scanner_trans_keys = [
	0, 0, -128, -65, -128, -65, 
	-128, -65, 41, 41, -62, 
	57, -128, -65, -62, 39, 
	-128, -65, -128, -65, -62, 62, 
	-128, -65, -62, 62, -128, 
	-65, -128, -65, 39, 60, 
	-62, 57, -128, -65, -62, 39, 
	-128, -65, -128, -65, 48, 
	57, 39, 57, 39, 57, 
	48, 57, 39, 39, -62, 62, 
	-128, -65, -62, 62, -128, 
	-65, -128, -65, 48, 57, 
	48, 62, 43, 62, 48, 57, 
	62, 62, 39, 60, -62, 
	57, -128, -65, -62, 39, 
	-128, -65, -128, -65, 48, 57, 
	39, 57, 39, 57, 48, 
	57, -62, 62, -128, -65, 
	-62, 62, -128, -65, -128, -65, 
	48, 57, 48, 62, 43, 
	62, 48, 57, 48, 57, 
	48, 125, 44, 125, 123, 123, 
	9, 122, 9, 125, 9, 
	122, -128, -65, -128, -65, 
	-128, -65, 38, 38, 58, 93, 
	58, 93, -128, -65, -128, 
	-65, -128, -65, 45, 45, 
	92, 92, 92, 92, 45, 45, 
	92, 92, 92, 92, 48, 
	123, 48, 102, 48, 102, 
	48, 102, 48, 102, 9, 125, 
	9, 125, 9, 125, 9, 
	125, 9, 125, 9, 125, 
	48, 123, -128, -65, -62, 39, 
	-128, -65, -128, -65, 41, 
	41, 41, 57, -128, -65, 
	-62, 62, -128, -65, -128, -65, 
	-62, 127, -62, -12, 1, 
	127, 1, 127, 9, 32, 
	33, 126, 10, 10, 63, 63, 
	33, 126, 33, 126, -62, 
	62, 43, 63, 43, 63, 
	43, 63, 65, 122, 44, 57, 
	68, 119, 80, 112, -62, 
	125, 38, 38, 38, 93, 
	58, 58, 67, 120, -62, 125, 
	48, 55, 48, 55, 77, 
	77, 45, 45, 0, 0, 
	67, 99, 45, 45, 0, 0, 
	92, 92, 48, 102, 39, 
	60, -62, 57, 49, 57, 
	41, 57, -62, 62, 0
]

class << self
	attr_accessor :_re_scanner_key_spans
	private :_re_scanner_key_spans, :_re_scanner_key_spans=
end
self._re_scanner_key_spans = [
	0, 64, 64, 64, 1, 120, 64, 102, 
	64, 64, 125, 64, 125, 64, 64, 22, 
	120, 64, 102, 64, 64, 10, 19, 19, 
	10, 1, 125, 64, 125, 64, 64, 10, 
	15, 20, 10, 1, 22, 120, 64, 102, 
	64, 64, 10, 19, 19, 10, 125, 64, 
	125, 64, 64, 10, 15, 20, 10, 10, 
	78, 82, 1, 114, 117, 114, 64, 64, 
	64, 1, 36, 36, 64, 64, 64, 1, 
	1, 1, 1, 1, 1, 76, 55, 55, 
	55, 55, 117, 117, 117, 117, 117, 117, 
	76, 64, 102, 64, 64, 1, 17, 64, 
	125, 64, 64, 190, 51, 127, 127, 24, 
	94, 1, 1, 94, 94, 125, 21, 21, 
	21, 58, 14, 52, 33, 188, 1, 56, 
	1, 54, 188, 8, 8, 1, 1, 0, 
	33, 1, 0, 1, 55, 22, 120, 9, 
	17, 125
]

class << self
	attr_accessor :_re_scanner_index_offsets
	private :_re_scanner_index_offsets, :_re_scanner_index_offsets=
end
self._re_scanner_index_offsets = [
	0, 0, 65, 130, 195, 197, 318, 383, 
	486, 551, 616, 742, 807, 933, 998, 1063, 
	1086, 1207, 1272, 1375, 1440, 1505, 1516, 1536, 
	1556, 1567, 1569, 1695, 1760, 1886, 1951, 2016, 
	2027, 2043, 2064, 2075, 2077, 2100, 2221, 2286, 
	2389, 2454, 2519, 2530, 2550, 2570, 2581, 2707, 
	2772, 2898, 2963, 3028, 3039, 3055, 3076, 3087, 
	3098, 3177, 3260, 3262, 3377, 3495, 3610, 3675, 
	3740, 3805, 3807, 3844, 3881, 3946, 4011, 4076, 
	4078, 4080, 4082, 4084, 4086, 4088, 4165, 4221, 
	4277, 4333, 4389, 4507, 4625, 4743, 4861, 4979, 
	5097, 5174, 5239, 5342, 5407, 5472, 5474, 5492, 
	5557, 5683, 5748, 5813, 6004, 6056, 6184, 6312, 
	6337, 6432, 6434, 6436, 6531, 6626, 6752, 6774, 
	6796, 6818, 6877, 6892, 6945, 6979, 7168, 7170, 
	7227, 7229, 7284, 7473, 7482, 7491, 7493, 7495, 
	7496, 7530, 7532, 7533, 7535, 7591, 7614, 7735, 
	7745, 7763
]

class << self
	attr_accessor :_re_scanner_indicies
	private :_re_scanner_indicies, :_re_scanner_indicies=
end
self._re_scanner_indicies = [
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 0, 6, 5, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 9, 9, 9, 9, 9, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 11, 10, 10, 10, 10, 10, 
	4, 10, 10, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 4, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 9, 9, 9, 
	9, 9, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 11, 10, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 4, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 4, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 14, 14, 
	14, 14, 14, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 16, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 4, 15, 15, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	15, 15, 15, 16, 11, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 0, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 14, 14, 14, 
	14, 14, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 11, 15, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 0, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 0, 18, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 19, 17, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 22, 22, 22, 22, 
	22, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 24, 23, 23, 23, 23, 
	23, 25, 23, 23, 26, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 17, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 22, 22, 
	22, 22, 22, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 24, 23, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 17, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	17, 28, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 17, 24, 17, 17, 17, 
	17, 17, 17, 17, 17, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 17, 
	24, 17, 17, 17, 29, 17, 29, 17, 
	17, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 17, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 17, 24, 
	17, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 32, 
	32, 32, 32, 32, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 34, 33, 33, 35, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 33, 33, 33, 33, 24, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 17, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 32, 32, 
	32, 32, 32, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 24, 33, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 17, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 17, 
	37, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 17, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 17, 17, 17, 
	17, 24, 17, 38, 17, 38, 17, 17, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 17, 17, 17, 17, 24, 17, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 17, 24, 17, 39, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 40, 17, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 43, 43, 43, 43, 43, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 45, 44, 44, 44, 44, 44, 46, 
	44, 44, 17, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 17, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 43, 43, 43, 43, 
	43, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 45, 44, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 17, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 17, 48, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 17, 45, 17, 17, 17, 17, 17, 
	17, 17, 17, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 17, 45, 17, 
	17, 17, 49, 17, 49, 17, 17, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 17, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 17, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 52, 52, 52, 52, 52, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	54, 53, 53, 17, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 53, 53, 53, 
	53, 45, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 17, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 52, 52, 52, 52, 52, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	45, 53, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 17, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 17, 56, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 17, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 17, 17, 17, 17, 45, 17, 57, 
	17, 57, 17, 17, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 17, 17, 
	17, 17, 45, 17, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 17, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 58, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 60, 
	58, 59, 58, 58, 58, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 60, 58, 62, 63, 64, 64, 
	64, 64, 64, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 64, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 64, 64, 63, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 63, 
	63, 63, 64, 63, 63, 63, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	63, 63, 63, 65, 64, 63, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	63, 64, 64, 64, 64, 64, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	64, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 64, 64, 63, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 63, 63, 63, 64, 63, 63, 
	63, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 63, 63, 63, 63, 64, 
	63, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 63, 63, 66, 63, 64, 
	64, 64, 64, 64, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 64, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 64, 64, 63, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	63, 63, 63, 64, 63, 63, 63, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 63, 63, 63, 63, 64, 63, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 63, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 63, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 63, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 63, 71, 70, 74, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	75, 73, 75, 73, 74, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 75, 73, 76, 
	73, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 63, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 63, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 63, 80, 63, 82, 81, 
	84, 81, 85, 63, 87, 86, 89, 86, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 63, 63, 63, 63, 63, 63, 
	63, 90, 90, 90, 90, 90, 90, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 90, 90, 90, 90, 90, 90, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 91, 63, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 63, 
	63, 63, 63, 63, 63, 63, 92, 92, 
	92, 92, 92, 92, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 92, 92, 
	92, 92, 92, 92, 63, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 63, 
	63, 63, 63, 63, 63, 63, 93, 93, 
	93, 93, 93, 93, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 93, 93, 
	93, 93, 93, 93, 63, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 63, 
	63, 63, 63, 63, 63, 63, 94, 94, 
	94, 94, 94, 94, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 94, 94, 
	94, 94, 94, 94, 63, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 63, 
	63, 63, 63, 63, 63, 63, 95, 95, 
	95, 95, 95, 95, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 95, 95, 
	95, 95, 95, 95, 63, 91, 91, 91, 
	91, 91, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 91, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 63, 63, 
	63, 63, 63, 63, 63, 96, 96, 96, 
	96, 96, 96, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 96, 96, 96, 
	96, 96, 96, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 94, 63, 91, 91, 91, 91, 91, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 91, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 63, 63, 63, 63, 
	63, 63, 63, 97, 97, 97, 97, 97, 
	97, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 97, 97, 97, 97, 97, 
	97, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 94, 
	63, 91, 91, 91, 91, 91, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	91, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 63, 63, 63, 63, 63, 63, 
	63, 98, 98, 98, 98, 98, 98, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 98, 98, 98, 98, 98, 98, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 94, 63, 91, 
	91, 91, 91, 91, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 91, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	63, 63, 63, 63, 63, 63, 63, 99, 
	99, 99, 99, 99, 99, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 99, 
	99, 99, 99, 99, 99, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 94, 63, 91, 91, 91, 
	91, 91, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 91, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 63, 63, 
	63, 63, 63, 63, 63, 100, 100, 100, 
	100, 100, 100, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 100, 100, 100, 
	100, 100, 100, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 94, 63, 91, 91, 91, 91, 91, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 91, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 94, 
	63, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 101, 101, 101, 101, 101, 
	101, 101, 102, 102, 102, 102, 102, 102, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 102, 102, 102, 102, 102, 102, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 63, 101, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 103, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 107, 107, 107, 
	107, 107, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 108, 104, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 103, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 103, 
	109, 103, 109, 103, 103, 103, 103, 103, 
	103, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 103, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 103, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 114, 114, 114, 114, 114, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 108, 111, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 103, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 103, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 115, 115, 115, 115, 115, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 116, 116, 116, 116, 
	116, 116, 116, 116, 117, 117, 117, 117, 
	117, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 118, 119, 119, 120, 121, 
	119, 119, 119, 122, 123, 124, 125, 119, 
	119, 126, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 127, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 128, 129, 
	130, 131, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 132, 133, 
	130, 119, 116, 63, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 115, 115, 115, 115, 115, 134, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 116, 134, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	117, 117, 117, 117, 117, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 118, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 116, 135, 
	118, 118, 118, 118, 118, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 118, 
	135, 119, 119, 134, 134, 119, 119, 119, 
	134, 134, 134, 134, 119, 119, 134, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 134, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 134, 134, 134, 134, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 134, 134, 134, 119, 134, 
	137, 120, 139, 138, 142, 141, 5, 141, 
	141, 141, 143, 144, 140, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 11, 141, 145, 
	142, 11, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 11, 141, 140, 141, 140, 141, 141, 
	141, 140, 140, 140, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 146, 141, 140, 140, 
	140, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	140, 141, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	14, 14, 14, 14, 14, 147, 147, 147, 
	147, 147, 147, 147, 147, 147, 147, 147, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	15, 15, 15, 15, 15, 15, 11, 15, 
	149, 148, 148, 148, 148, 148, 148, 148, 
	148, 148, 148, 148, 148, 148, 148, 148, 
	148, 148, 148, 148, 149, 148, 151, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 151, 150, 153, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	153, 152, 155, 155, 154, 154, 154, 154, 
	155, 154, 154, 154, 156, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 155, 154, 154, 154, 154, 
	154, 154, 154, 155, 154, 154, 154, 154, 
	157, 154, 154, 154, 158, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 155, 154, 160, 159, 159, 
	159, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 159, 161, 63, 63, 63, 
	161, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 161, 161, 63, 63, 63, 161, 
	161, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 161, 63, 63, 63, 
	161, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 161, 63, 63, 63, 161, 
	63, 162, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 162, 63, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 163, 163, 163, 163, 163, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 164, 67, 165, 
	67, 164, 164, 164, 164, 67, 166, 164, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	164, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 167, 168, 169, 170, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	67, 67, 67, 67, 164, 164, 164, 67, 
	172, 171, 174, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 175, 173, 73, 177, 179, 179, 178, 
	178, 178, 179, 178, 178, 178, 178, 179, 
	178, 178, 179, 178, 178, 179, 178, 178, 
	178, 179, 178, 178, 178, 179, 179, 179, 
	178, 178, 178, 179, 179, 179, 179, 179, 
	179, 178, 179, 178, 178, 178, 178, 178, 
	179, 178, 179, 178, 179, 179, 179, 179, 
	179, 179, 179, 178, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 180, 180, 180, 180, 180, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 181, 77, 
	77, 77, 181, 181, 181, 181, 77, 77, 
	181, 77, 182, 183, 183, 183, 183, 183, 
	183, 183, 184, 184, 77, 77, 77, 77, 
	77, 181, 77, 63, 63, 185, 186, 77, 
	77, 63, 186, 77, 77, 63, 77, 187, 
	77, 77, 188, 77, 186, 186, 77, 77, 
	77, 186, 186, 77, 63, 181, 181, 181, 
	181, 77, 77, 189, 189, 80, 186, 189, 
	189, 77, 186, 77, 77, 77, 77, 77, 
	189, 77, 188, 77, 189, 186, 189, 190, 
	189, 186, 191, 77, 63, 181, 181, 181, 
	77, 193, 193, 193, 193, 193, 193, 193, 
	193, 192, 195, 195, 195, 195, 195, 195, 
	195, 195, 194, 197, 81, 199, 198, 81, 
	201, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	202, 86, 204, 203, 86, 89, 86, 206, 
	206, 206, 206, 206, 206, 206, 206, 206, 
	206, 205, 205, 205, 205, 205, 205, 205, 
	206, 206, 206, 206, 206, 206, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	206, 206, 206, 206, 206, 206, 205, 208, 
	207, 207, 207, 207, 207, 209, 207, 207, 
	207, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 207, 207, 211, 207, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 107, 107, 107, 107, 
	107, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 108, 104, 104, 104, 104, 
	104, 212, 104, 104, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 104, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	212, 109, 212, 212, 212, 212, 212, 212, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 212, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 114, 114, 114, 114, 114, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 212, 111, 
	111, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 111, 111, 111, 111, 108, 
	111, 0
]

class << self
	attr_accessor :_re_scanner_trans_targs
	private :_re_scanner_trans_targs, :_re_scanner_trans_targs=
end
self._re_scanner_trans_targs = [
	99, 100, 1, 2, 99, 4, 99, 6, 
	8, 9, 7, 99, 11, 13, 14, 12, 
	109, 99, 16, 26, 17, 19, 20, 18, 
	99, 21, 25, 23, 22, 24, 27, 29, 
	30, 28, 31, 35, 33, 32, 34, 37, 
	46, 38, 40, 41, 39, 99, 42, 44, 
	43, 45, 47, 49, 50, 48, 51, 53, 
	52, 54, 99, 56, 99, 57, 59, 0, 
	60, 61, 116, 117, 62, 63, 117, 117, 
	117, 66, 67, 117, 117, 122, 68, 69, 
	72, 122, 125, 122, 127, 75, 122, 128, 
	122, 130, 78, 81, 79, 80, 122, 82, 
	83, 84, 85, 86, 87, 122, 132, 133, 
	90, 89, 91, 92, 93, 133, 94, 96, 
	95, 97, 98, 3, 101, 102, 103, 104, 
	105, 99, 106, 99, 110, 111, 99, 112, 
	99, 113, 99, 99, 114, 99, 99, 99, 
	99, 99, 99, 107, 99, 108, 99, 5, 
	99, 10, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 15, 36, 99, 
	55, 115, 58, 64, 117, 118, 119, 120, 
	117, 117, 117, 117, 117, 117, 65, 117, 
	117, 117, 121, 121, 70, 122, 123, 123, 
	122, 71, 122, 74, 122, 122, 77, 88, 
	122, 124, 122, 122, 122, 126, 122, 73, 
	122, 129, 131, 122, 76, 122, 122, 133, 
	134, 135, 136, 137, 133
]

class << self
	attr_accessor :_re_scanner_trans_actions
	private :_re_scanner_trans_actions, :_re_scanner_trans_actions=
end
self._re_scanner_trans_actions = [
	1, 2, 0, 0, 3, 4, 5, 0, 
	0, 0, 0, 6, 0, 0, 0, 0, 
	7, 8, 0, 0, 0, 0, 0, 0, 
	9, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 10, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 11, 0, 12, 0, 0, 0, 
	0, 0, 14, 15, 0, 0, 16, 17, 
	18, 0, 0, 19, 20, 21, 0, 0, 
	0, 23, 0, 24, 0, 0, 25, 0, 
	26, 0, 0, 0, 0, 0, 27, 0, 
	0, 0, 0, 0, 0, 28, 0, 29, 
	0, 0, 0, 0, 0, 30, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 33, 34, 35, 0, 0, 36, 0, 
	37, 38, 39, 40, 38, 41, 42, 43, 
	44, 45, 46, 47, 48, 0, 49, 0, 
	50, 0, 51, 52, 53, 54, 55, 56, 
	57, 58, 59, 60, 61, 0, 0, 62, 
	0, 64, 0, 0, 65, 0, 38, 66, 
	67, 68, 69, 70, 71, 72, 0, 73, 
	74, 75, 76, 77, 0, 78, 79, 80, 
	81, 0, 82, 0, 83, 84, 0, 0, 
	85, 0, 86, 87, 88, 38, 89, 0, 
	90, 38, 0, 91, 0, 92, 93, 94, 
	38, 38, 38, 38, 95
]

class << self
	attr_accessor :_re_scanner_to_state_actions
	private :_re_scanner_to_state_actions, :_re_scanner_to_state_actions=
end
self._re_scanner_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 31, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 63, 63, 63, 0, 0, 
	0, 63, 63, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 63, 0, 0, 
	0, 0
]

class << self
	attr_accessor :_re_scanner_from_state_actions
	private :_re_scanner_from_state_actions, :_re_scanner_from_state_actions=
end
self._re_scanner_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 32, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 32, 32, 32, 0, 0, 
	0, 32, 32, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 32, 0, 0, 
	0, 0
]

class << self
	attr_accessor :_re_scanner_eof_actions
	private :_re_scanner_eof_actions, :_re_scanner_eof_actions=
end
self._re_scanner_eof_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 13, 13, 13, 13, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 22, 
	22, 0, 22, 22, 0, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 22, 0, 0, 
	0, 0, 22, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
]

class << self
	attr_accessor :_re_scanner_eof_trans
	private :_re_scanner_eof_trans, :_re_scanner_eof_trans=
end
self._re_scanner_eof_trans = [
	0, 1, 1, 1, 5, 5, 5, 5, 
	5, 5, 5, 1, 1, 1, 1, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 59, 
	59, 59, 0, 0, 0, 0, 0, 0, 
	0, 71, 73, 73, 0, 0, 0, 0, 
	0, 84, 0, 0, 89, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 0, 135, 135, 136, 136, 
	135, 137, 139, 141, 141, 148, 149, 151, 
	153, 155, 160, 0, 0, 0, 172, 174, 
	177, 0, 0, 193, 195, 197, 197, 197, 
	201, 201, 201, 201, 206, 0, 213, 213, 
	213, 213
]

class << self
	attr_accessor :re_scanner_start
end
self.re_scanner_start = 99;
class << self
	attr_accessor :re_scanner_first_final
end
self.re_scanner_first_final = 99;
class << self
	attr_accessor :re_scanner_error
end
self.re_scanner_error = 0;

class << self
	attr_accessor :re_scanner_en_char_type
end
self.re_scanner_en_char_type = 115;
class << self
	attr_accessor :re_scanner_en_unicode_property
end
self.re_scanner_en_unicode_property = 116;
class << self
	attr_accessor :re_scanner_en_character_set
end
self.re_scanner_en_character_set = 117;
class << self
	attr_accessor :re_scanner_en_set_escape_sequence
end
self.re_scanner_en_set_escape_sequence = 121;
class << self
	attr_accessor :re_scanner_en_escape_sequence
end
self.re_scanner_en_escape_sequence = 122;
class << self
	attr_accessor :re_scanner_en_conditional_expression
end
self.re_scanner_en_conditional_expression = 133;
class << self
	attr_accessor :re_scanner_en_main
end
self.re_scanner_en_main = 99;


# line 744 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
    
# line 1421 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
begin
	p ||= 0
	pe ||= data.length
	cs = re_scanner_start
	top = 0
	ts = nil
	te = nil
	act = 0
end

# line 745 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
    
# line 1434 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _re_scanner_from_state_actions[cs] 
	when 32 then
# line 1 "NONE"
		begin
ts = p
		end
# line 1462 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	end
	_keys = cs << 1
	_inds = _re_scanner_index_offsets[cs]
	_slen = _re_scanner_key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 && 
			_re_scanner_trans_keys[_keys] <= _wide && 
			_wide <= _re_scanner_trans_keys[_keys + 1] 
		    ) then
			_re_scanner_indicies[ _inds + _wide - _re_scanner_trans_keys[_keys] ] 
		 else 
			_re_scanner_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	cs = _re_scanner_trans_targs[_trans]
	if _re_scanner_trans_actions[_trans] != 0
	case _re_scanner_trans_actions[_trans]
	when 34 then
# line 152 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
	when 4 then
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
	when 38 then
# line 1 "NONE"
		begin
te = p+1
		end
	when 64 then
# line 12 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/char_type.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts-1, te)
      when '\d'; emit(:type, :digit,      text)
      when '\D'; emit(:type, :nondigit,   text)
      when '\h'; emit(:type, :hex,        text)
      when '\H'; emit(:type, :nonhex,     text)
      when '\s'; emit(:type, :space,      text)
      when '\S'; emit(:type, :nonspace,   text)
      when '\w'; emit(:type, :word,       text)
      when '\W'; emit(:type, :nonword,    text)
      when '\R'; emit(:type, :linebreak,  text)
      when '\X'; emit(:type, :xgrapheme,  text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 14 then
# line 16 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/property.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      type = (text[1] == 'P') ^ (text[3] == '^') ? :nonproperty : :property

      name = data[ts+2..te-2].pack('c*').gsub(/[\^\s_\-]/, '').downcase

      token = self.class.short_prop_map[name] || self.class.long_prop_map[name]
      validation_error(:property, name) unless token

      self.emit(type, token.to_sym, text)

      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 17 then
# line 180 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-')
      emit(:set, :intersection, '&&')
     end
		end
	when 69 then
# line 185 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      if tokens.last[1] == :open
        emit(:set, :negate, text)
      else
        emit(:literal, :literal, text)
      end
     end
		end
	when 71 then
# line 206 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :intersection, copy(data, ts, te))
     end
		end
	when 67 then
# line 210 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 121
		_goto_level = _again
		next
	end

     end
		end
	when 65 then
# line 244 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:literal, :literal, copy(data, ts, te))
     end
		end
	when 15 then
# line 248 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 72 then
# line 194 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text)
      else
        emit(:set, :range, text)
      end
     end
		end
	when 75 then
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 117
		_goto_level = _again
		next
	end

     end
		end
	when 70 then
# line 248 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 16 then
# line 194 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text)
      else
        emit(:set, :range, text)
      end
     end
		end
	when 19 then
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 117
		_goto_level = _again
		next
	end

     end
		end
	when 77 then
# line 257 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = 117;
      	begin
		stack[top] = cs
		top+= 1
		cs = 122
		_goto_level = _again
		next
	end

     end
		end
	when 76 then
# line 263 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 81 then
# line 273 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 87 then
# line 279 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 78 then
# line 284 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts-1, te)
      when '\.';  emit(:escape, :dot,               text)
      when '\|';  emit(:escape, :alternation,       text)
      when '\^';  emit(:escape, :bol,               text)
      when '\$';  emit(:escape, :eol,               text)
      when '\?';  emit(:escape, :zero_or_one,       text)
      when '\*';  emit(:escape, :zero_or_more,      text)
      when '\+';  emit(:escape, :one_or_more,       text)
      when '\(';  emit(:escape, :group_open,        text)
      when '\)';  emit(:escape, :group_close,       text)
      when '\{';  emit(:escape, :interval_open,     text)
      when '\}';  emit(:escape, :interval_close,    text)
      when '\[';  emit(:escape, :set_open,          text)
      when '\]';  emit(:escape, :set_close,         text)
      when "\\\\";
        emit(:escape, :backslash, text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 84 then
# line 305 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      # \b is emitted as backspace only when inside a character set, otherwise
      # it is a word boundary anchor. A syntax might "normalize" it if needed.
      case text = copy(data, ts-1, te)
      when '\a'; emit(:escape, :bell,           text)
      when '\b'; emit(:escape, :backspace,      text)
      when '\e'; emit(:escape, :escape,         text)
      when '\f'; emit(:escape, :form_feed,      text)
      when '\n'; emit(:escape, :newline,        text)
      when '\r'; emit(:escape, :carriage,       text)
      when '\t'; emit(:escape, :tab,            text)
      when '\v'; emit(:escape, :vertical_tab,   text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 27 then
# line 321 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      if text[2] == '{'
        emit(:escape, :codepoint_list, text)
      else
        emit(:escape, :codepoint,      text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 93 then
# line 331 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :hex, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 23 then
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 25 then
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 82 then
# line 350 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 117 : 99));
      	begin
		stack[top] = cs
		top+= 1
		cs = 115
		_goto_level = _again
		next
	end

     end
		end
	when 83 then
# line 356 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 117 : 99));
      	begin
		stack[top] = cs
		top+= 1
		cs = 116
		_goto_level = _again
		next
	end

     end
		end
	when 21 then
# line 362 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 86 then
# line 279 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 92 then
# line 331 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 89 then
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 91 then
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 85 then
# line 1 "NONE"
		begin
	case act
	when 16 then
	begin begin p = ((te))-1; end

      text = copy(data, ts-1, te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
	when 17 then
	begin begin p = ((te))-1; end

      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
end 
			end
	when 30 then
# line 372 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te-1)
      emit(:conditional, :condition, text)
      emit(:conditional, :condition_close, ')')
     end
		end
	when 94 then
# line 378 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 99
		_goto_level = _again
		next
	end

     end
		end
	when 95 then
# line 378 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 99
		_goto_level = _again
		next
	end

     end
		end
	when 29 then
# line 378 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 99
		_goto_level = _again
		next
	end

     end
		end
	when 36 then
# line 391 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:meta, :dot, copy(data, ts, te))
     end
		end
	when 41 then
# line 395 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth
        emit(:conditional, :separator, copy(data, ts, te))
      else
        emit(:meta, :alternation, copy(data, ts, te))
      end
     end
		end
	when 40 then
# line 405 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :bol, copy(data, ts, te))
     end
		end
	when 33 then
# line 409 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :eol, copy(data, ts, te))
     end
		end
	when 61 then
# line 413 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:keep, :mark, copy(data, ts, te))
     end
		end
	when 60 then
# line 417 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '\A';  emit(:anchor, :bos,                text)
      when '\z';  emit(:anchor, :eos,                text)
      when '\Z';  emit(:anchor, :eos_ob_eol,         text)
      when '\b';  emit(:anchor, :word_boundary,      text)
      when '\B';  emit(:anchor, :nonword_boundary,   text)
      when '\G';  emit(:anchor, :match_start,        text)
      end
     end
		end
	when 39 then
# line 428 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      append_literal(data, ts, te)
     end
		end
	when 50 then
# line 443 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)

      conditional_stack << group_depth

      emit(:conditional, :open, text[0..-2])
      emit(:conditional, :condition_open, '(')
      	begin
		stack[top] = cs
		top+= 1
		cs = 133
		_goto_level = _again
		next
	end

     end
		end
	when 51 then
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 49 then
# line 488 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 6 then
# line 505 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '(?:';  emit(:group, :passive,      text)
      when '(?>';  emit(:group, :atomic,       text)
      when '(?~';  emit(:group, :absence,      text)

      when /^\(\?(?:<>|'')/
        validation_error(:group, 'named group', 'name is empty')

      when /^\(\?<[^>]+>/
        emit(:group, :named_ab,  text)

      when /^\(\?'[^']+'/
        emit(:group, :named_sq,  text)

      end
     end
		end
	when 10 then
# line 546 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when /^\\k(<>|'')/
        validation_error(:backref, 'backreference', 'ref ID is empty')
      when /^\\k(.)[^\p{digit}\-][^+\-]*\D$/
        emit(:backref, $1 == '<' ? :name_ref_ab : :name_ref_sq, text)
      when /^\\k(.)\d+\D$/
        emit(:backref, $1 == '<' ? :number_ref_ab : :number_ref_sq, text)
      when /^\\k(.)-\d+\D$/
        emit(:backref, $1 == '<' ? :number_rel_ref_ab : :number_rel_ref_sq, text)
      when /^\\k(.)[^\p{digit}\-].*[+\-]\d+\D$/
        emit(:backref, $1 == '<' ? :name_recursion_ref_ab : :name_recursion_ref_sq, text)
      when /^\\k(.)-?\d+[+\-]\d+\D$/
        emit(:backref, $1 == '<' ? :number_recursion_ref_ab : :number_recursion_ref_sq, text)
      end
     end
		end
	when 9 then
# line 565 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when /^\\g(<>|'')/
        validation_error(:backref, 'subexpression call', 'ref ID is empty')
      when /^\\g(.)[^\p{digit}+\->][^+\-]*/
        emit(:backref, $1 == '<' ? :name_call_ab : :name_call_sq, text)
      when /^\\g(.)\d+\D$/
        emit(:backref, $1 == '<' ? :number_call_ab : :number_call_sq, text)
      when /^\\g(.)[+-]\d+/
        emit(:backref, $1 == '<' ? :number_rel_call_ab : :number_rel_call_sq, text)
      end
     end
		end
	when 58 then
# line 581 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 54 then
# line 589 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 56 then
# line 597 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 12 then
# line 605 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:quantifier, :interval, copy(data, ts, te))
     end
		end
	when 45 then
# line 620 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 48 then
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 52 then
# line 488 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 46 then
# line 523 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      emit(:group, :capture, text)
     end
		end
	when 57 then
# line 581 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 53 then
# line 589 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 55 then
# line 597 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 62 then
# line 610 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 59 then
# line 616 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 122
		_goto_level = _again
		next
	end

     end
		end
	when 44 then
# line 620 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 43 then
# line 630 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :whitespace, copy(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 42 then
# line 641 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 3 then
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 11 then
# line 610 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      append_literal(data, ts, te)
     end
		end
	when 8 then
# line 616 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 122
		_goto_level = _again
		next
	end

     end
		end
	when 1 then
# line 1 "NONE"
		begin
	case act
	when 0 then
	begin	begin
		cs = 0
		_goto_level = _again
		next
	end
end
	when 40 then
	begin begin p = ((te))-1; end

      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
    end
	when 41 then
	begin begin p = ((te))-1; end

      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
    end
	when 55 then
	begin begin p = ((te))-1; end

      append_literal(data, ts, te)
    end
end 
			end
	when 74 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 117
		_goto_level = _again
		next
	end

     end
		end
	when 18 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 117
		_goto_level = _again
		next
	end

     end
		end
	when 88 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 90 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 24 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 26 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 28 then
# line 146 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    validation_error(:sequence, 'sequence', text)
  		end
# line 336 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 5 then
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 459 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:group, :comment, copy(data, ts, te))
     end
		end
	when 35 then
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 528 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth + 1
        conditional_stack.pop
        emit(:conditional, :close, copy(data, ts, te))
      else
        if spacing_stack.length > 1 &&
           spacing_stack.last[:depth] == group_depth + 1
          spacing_stack.pop
          self.free_spacing = spacing_stack.last[:free_spacing]
        end

        emit(:group, :close, copy(data, ts, te))
      end
     end
		end
	when 37 then
# line 154 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
# line 434 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 117
		_goto_level = _again
		next
	end

     end
		end
	when 68 then
# line 155 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 161 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :close, copy(data, ts, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 99
		_goto_level = _again
		next
	end

      end
     end
		end
	when 73 then
# line 155 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 170 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, copy(data, ts, te-1))
      emit(:set, :close, copy(data, ts+1, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 99
		_goto_level = _again
		next
	end

      end
     end
		end
	when 20 then
# line 155 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 219 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)

      type = :posixclass
      class_name = text[2..-3]
      if class_name[0] == '^'
        class_name = class_name[1..-1]
        type = :nonposixclass
      end

      unless self.class.posix_classes.include?(class_name)
        validation_error(:posix_class, text)
      end

      emit(type, class_name.to_sym, text)
     end
		end
	when 66 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 154 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
	when 80 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 273 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 16;		end
	when 79 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 279 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 17;		end
	when 7 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 488 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 41;		end
	when 2 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 641 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 55;		end
	when 47 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 152 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 40;		end
# line 2823 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	end
	end
	end
	if _goto_level <= _again
	case _re_scanner_to_state_actions[cs] 
	when 63 then
# line 1 "NONE"
		begin
ts = nil;		end
	when 31 then
# line 1 "NONE"
		begin
ts = nil;		end
# line 1 "NONE"
		begin
act = 0
		end
# line 2841 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	end

	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _re_scanner_eof_trans[cs] > 0
		_trans = _re_scanner_eof_trans[cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	  case _re_scanner_eof_actions[cs]
	when 13 then
# line 8 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/property.rl"
		begin

    raise PrematureEndError.new('unicode property')
  		end
	when 22 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 2875 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 746 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"

    # to avoid "warning: assigned but unused variable - testEof"
    testEof = testEof

    if cs == re_scanner_error
      text = copy(data, ts ? ts-1 : 0, -1)
      raise ScannerError.new("Scan error at '#{text}'")
    end

    raise PrematureEndError.new("(missing group closing paranthesis) "+
          "[#{group_depth}]") if in_group?
    raise PrematureEndError.new("(missing set closing bracket) "+
          "[#{set_depth}]") if in_set?

    # when the entire expression is a literal run
    emit_literal if literal

    tokens
  end

  # lazy-load property maps when first needed
  def self.short_prop_map
    @short_prop_map ||= parse_prop_map('short')
  end

  def self.long_prop_map
    @long_prop_map ||= parse_prop_map('long')
  end

  def self.parse_prop_map(name)
    File.read("#{__dir__}/scanner/properties/#{name}.csv").scan(/(.+),(.+)/).to_h
  end

  def self.posix_classes
    %w[alnum alpha ascii blank cntrl digit graph
       lower print punct space upper word xdigit]
  end

  # Emits an array with the details of the scanned pattern
  def emit(type, token, text)
    #puts "EMIT: type: #{type}, token: #{token}, text: #{text}, ts: #{ts}, te: #{te}"

    emit_literal if literal

    # Ragel runs with byte-based indices (ts, te). These are of little value to
    # end-users, so we keep track of char-based indices and emit those instead.
    ts_char_pos = char_pos
    te_char_pos = char_pos + text.length

    if block
      block.call type, token, text, ts_char_pos, te_char_pos
    end

    tokens << [type, token, text, ts_char_pos, te_char_pos]

    self.char_pos = te_char_pos
  end

  private

  attr_accessor :tokens, :literal, :block, :free_spacing, :spacing_stack,
                :group_depth, :set_depth, :conditional_stack, :char_pos

  def free_spacing?(input_object, options)
    if options && !input_object.is_a?(String)
      raise ArgumentError, 'options cannot be supplied unless scanning a String'
    end

    options = input_object.options if input_object.is_a?(::Regexp)

    return false unless options

    options & Regexp::EXTENDED != 0
  end

  def in_group?
    group_depth > 0
  end

  def in_set?
    set_depth > 0
  end

  # Copy from ts to te from data as text
  def copy(data, ts, te)
    data[ts...te].pack('c*').force_encoding('utf-8')
  end

  # Appends one or more characters to the literal buffer, to be emitted later
  # by a call to emit_literal.
  def append_literal(data, ts, te)
    self.literal = literal || []
    literal << copy(data, ts, te)
  end

  # Emits the literal run collected by calls to the append_literal method.
  def emit_literal
    text = literal.join
    self.literal = nil
    emit(:literal, :literal, text)
  end

  def emit_options(text)
    token = nil

    # Ruby allows things like '(?-xxxx)' or '(?xx-xx--xx-:abc)'.
    text =~ /\(\?([mixdau]*)(-(?:[mix]*))*(:)?/
    positive, negative, group_local = $1, $2, $3

    if positive.include?('x')
      self.free_spacing = true
    end

    # If the x appears in both, treat it like ruby does, the second cancels
    # the first.
    if negative && negative.include?('x')
      self.free_spacing = false
    end

    if group_local
      spacing_stack << {:free_spacing => free_spacing, :depth => group_depth}
      token = :options
    else
      # switch for parent group level
      spacing_stack.last[:free_spacing] = free_spacing
      token = :options_switch
    end

    emit(:group, token, text)
  end

  def emit_meta_control_sequence(data, ts, te, token)
    if data.last < 0x00 || data.last > 0x7F
      validation_error(:sequence, 'escape', token.to_s)
    end
    emit(:escape, token, copy(data, ts-1, te))
  end

  # Centralizes and unifies the handling of validation related
  # errors.
  def validation_error(type, what, reason = nil)
    error =
      case type
      when :backref      then InvalidBackrefError.new(what, reason)
      when :group        then InvalidGroupError.new(what, reason)
      when :group_option then InvalidGroupOption.new(what, reason)
      when :posix_class  then UnknownPosixClassError.new(what)
      when :property     then UnknownUnicodePropertyError.new(what)
      when :sequence     then InvalidSequenceError.new(what, reason)
      end

    raise error # unless @@config.validation_ignore
  end
end # module Regexp::Scanner
