/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.Scalable;

public class ScalePanel
extends JPanel
implements Observer,
MouseInputListener {
    private static final long serialVersionUID = -1422640859L;
    private static ImageIcon fitHeightIcon = Icons.getIcon("large/fit_height");
    private static ImageIcon fitWidthIcon = Icons.getIcon("large/fit_width");
    private static ImageIcon fitWindowIcon = Icons.getIcon("large/fit_window");
    private static ImageIcon normalSizeIcon = Icons.getIcon("large/normalsize");
    private JSlider scaleSlider;
    private JLabel sliderLabel;
    private Scalable scalable;
    private Point root = null;
    private int initialValue;
    public final Action fitWidthAction = new AbstractAction(){
        private static final long serialVersionUID = 2231002575786091241L;
        {
            this.putValue("ShortDescription", "Fit width");
            this.putValue("SmallIcon", fitWidthIcon);
            this.putValue("ActionID", "FIT_WIDTH");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScalePanel.this.fitWidth();
        }
    };
    public final Action fitHeightAction = new AbstractAction(){
        private static final long serialVersionUID = -778453888992105228L;
        {
            this.putValue("ShortDescription", "Fit height");
            this.putValue("SmallIcon", fitHeightIcon);
            this.putValue("ActionID", "FIT_HEIGHT");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScalePanel.this.fitHeight();
        }
    };
    public final Action fitWindowAction = new AbstractAction(){
        private static final long serialVersionUID = 288375725765949977L;
        {
            this.putValue("ShortDescription", "Fit window");
            this.putValue("SmallIcon", fitWindowIcon);
            this.putValue("ActionID", "FIT_WINDOW");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScalePanel.this.fitWindow();
        }
    };
    public final Action normalSizeAction = new AbstractAction(){
        private static final long serialVersionUID = -5840204247566703409L;
        {
            this.putValue("ShortDescription", "Zoom to 100 %");
            this.putValue("SmallIcon", normalSizeIcon);
            this.putValue("ActionID", "NORMAL_SIZE");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScalePanel.this.normalsize();
        }
    };

    public ScalePanel(boolean showButtons) {
        this.setLayout(new BorderLayout());
        this.sliderLabel = new JLabel();
        this.sliderLabel.setToolTipText("Zoom factor");
        this.sliderLabel.setPreferredSize(new Dimension(40, 1));
        this.sliderLabel.setOpaque(false);
        this.add((Component)this.sliderLabel, "West");
        this.scaleSlider = new JSlider(1, 400, 100);
        this.scaleSlider.setPreferredSize(new Dimension(100, 0));
        this.scaleSlider.setMaximumSize(new Dimension(100, 0));
        this.scaleSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ScalePanel.this.isEnabled() && e.getClickCount() == 2 && e.getButton() == 1) {
                    ScalePanel.this.scalable.setScale(1.0);
                }
            }
        });
        this.scaleSlider.setOpaque(false);
        this.scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double scale = (double)(ScalePanel.this.scaleSlider.getValue() * ScalePanel.this.scaleSlider.getValue()) / 40000.0;
                scale = Math.max(0.01, scale);
                ScalePanel.this.scalable.setScale(scale);
            }
        });
        this.add((Component)this.scaleSlider, "Center");
        if (showButtons) {
            JPanel sliderButtonsPanel = new JPanel();
            sliderButtonsPanel.setLayout(new GridLayout(1, 4));
            JButton normalSizeButton = new JButton(this.normalSizeAction);
            JButton fitHeightButton = new JButton(this.fitHeightAction);
            JButton fitWidthButton = new JButton(this.fitWidthAction);
            JButton fitWindowButton = new JButton(this.fitWindowAction);
            normalSizeButton.setMargin(new Insets(1, 1, 1, 1));
            normalSizeButton.setOpaque(false);
            fitHeightButton.setMargin(new Insets(1, 1, 1, 1));
            fitHeightButton.setOpaque(false);
            fitWidthButton.setMargin(new Insets(1, 1, 1, 1));
            fitWidthButton.setOpaque(false);
            fitWindowButton.setMargin(new Insets(1, 1, 1, 1));
            fitWindowButton.setOpaque(false);
            sliderButtonsPanel.add(normalSizeButton);
            sliderButtonsPanel.add(fitHeightButton);
            sliderButtonsPanel.add(fitWidthButton);
            sliderButtonsPanel.add(fitWindowButton);
            sliderButtonsPanel.setOpaque(false);
            this.add((Component)sliderButtonsPanel, "East");
        }
    }

    private void normalsize() {
        if (this.scalable != null) {
            this.scalable.setScale(1.0);
        }
    }

    private void fitWidth() {
        if (this.scalable != null) {
            this.scalable.fitWidth();
        }
    }

    private void fitHeight() {
        if (this.scalable != null) {
            this.scalable.fitHeight();
        }
    }

    private void fitWindow() {
        if (this.scalable != null) {
            this.scalable.fitSize();
        }
    }

    public void setScalable(Scalable scalable) {
        if (this.scalable != null) {
            this.scalable.asObservable().deleteObservers();
        }
        scalable.asObservable().addObserver(this);
        this.scalable = scalable;
        this.update(scalable.asObservable(), scalable);
    }

    public JSlider getSlider() {
        return this.scaleSlider;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.root = e.getPoint();
            this.initialValue = this.scaleSlider.getValue();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.root = null;
    }

    @Override
    public void setEnabled(boolean on) {
        super.setEnabled(on);
        this.scaleSlider.setEnabled(on);
        this.sliderLabel.setEnabled(on);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int dist;
        if (this.root != null && Math.abs(dist = (this.root.y - e.getPoint().y) / 4) > 0) {
            int newValue = this.initialValue + dist;
            newValue = Math.max(newValue, this.scaleSlider.getMinimum());
            newValue = Math.min(newValue, this.scaleSlider.getMaximum());
            this.scaleSlider.setValue(newValue);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        Scalable _scalable = (Scalable)arg;
        double scale = _scalable.getScale();
        int s = (int)(200.0 * Math.sqrt(scale));
        String text = (int)(scale * 100.0) + " %";
        this.sliderLabel.setText(text);
        this.scaleSlider.setValue(s);
    }
}

