/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolygon;

public class PolylineTo
extends AbstractPolygon {
    public PolylineTo() {
        super(6, 1, null, 0, null);
    }

    public PolylineTo(Rectangle bounds, int numberOfPoints, Point[] points) {
        this(6, 1, bounds, numberOfPoints, points);
    }

    protected PolylineTo(int id, int version, Rectangle bounds, int numberOfPoints, Point[] points) {
        super(id, version, bounds, numberOfPoints, points);
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r = emf.readRECTL();
        int n = emf.readDWORD();
        return new PolylineTo(r, n, emf.readPOINTL(n));
    }

    @Override
    public void render(EMFRenderer renderer) {
        Point[] points = this.getPoints();
        int numberOfPoints = this.getNumberOfPoints();
        GeneralPath currentFigure = renderer.getFigure();
        if (points != null) {
            for (int point = 0; point < numberOfPoints; ++point) {
                currentFigure.lineTo((float)points[point].getX(), (float)points[point].getY());
            }
        }
    }
}

