/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import com.google.common.collect.ComparisonChain;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Quantile
implements Comparable<Quantile> {
    public final double quantile;
    public final double error;

    public Quantile(double quantile, double error) {
        this.quantile = quantile;
        this.error = error;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Quantile)) {
            return false;
        }
        Quantile that = (Quantile)aThat;
        long qbits = Double.doubleToLongBits(this.quantile);
        long ebits = Double.doubleToLongBits(this.error);
        return qbits == Double.doubleToLongBits(that.quantile) && ebits == Double.doubleToLongBits(that.error);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.quantile) ^ Double.doubleToLongBits(this.error));
    }

    @Override
    public int compareTo(Quantile other) {
        return ComparisonChain.start().compare(this.quantile, other.quantile).compare(this.error, other.error).result();
    }

    public String toString() {
        return String.format("%.2f %%ile +/- %.2f%%", this.quantile * 100.0, this.error * 100.0);
    }
}

