/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;

public class CloseFilterInputStream
extends FilterInputStream {
    private static final String MESSAGE = MessageService.getTextMessage("J104");
    private boolean closed;

    public CloseFilterInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public int available() throws IOException {
        this.checkIfClosed();
        return super.available();
    }

    public int read() throws IOException {
        this.checkIfClosed();
        return super.read();
    }

    public int read(byte[] byArray) throws IOException {
        this.checkIfClosed();
        return super.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkIfClosed();
        return super.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        this.checkIfClosed();
        return super.skip(l);
    }

    private void checkIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(MESSAGE);
        }
    }
}

