/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class JoinNode
extends TableOperatorNode {
    public static final int INNERJOIN = 1;
    public static final int CROSSJOIN = 2;
    public static final int LEFTOUTERJOIN = 3;
    public static final int RIGHTOUTERJOIN = 4;
    public static final int FULLOUTERJOIN = 5;
    public static final int UNIONJOIN = 6;
    private boolean naturalJoin;
    private boolean optimized;
    private PredicateList leftPredicateList;
    private PredicateList rightPredicateList;
    protected boolean flattenableJoin = true;
    Vector aggregateVector;
    SubqueryList subqueryList;
    ValueNode joinClause;
    boolean joinClauseNormalized;
    PredicateList joinPredicates;
    ResultColumnList usingClause;
    Properties joinOrderStrategyProperties;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws StandardException {
        super.init(object, object2, object6);
        this.resultColumns = (ResultColumnList)object5;
        this.joinClause = (ValueNode)object3;
        this.joinClauseNormalized = false;
        this.usingClause = (ResultColumnList)object4;
        this.joinOrderStrategyProperties = (Properties)object7;
        if (this.resultColumns != null && this.leftResultSet.getReferencedTableMap() != null) {
            this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
            this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
        }
        this.joinPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        optimizer.trace(27, 0, 0, 0.0, null);
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftPredicateList(), costEstimate);
        for (int i = this.joinPredicates.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(i);
            if (!predicate.getPushable()) continue;
            this.joinPredicates.removeElementAt(i);
            this.getRightPredicateList().addElement(predicate);
        }
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightPredicateList(), this.leftResultSet.getCostEstimate());
        this.costEstimate = this.getCostEstimate(optimizer);
        this.costEstimate.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost() + this.rightResultSet.getCostEstimate().getEstimatedCost(), this.rightResultSet.getCostEstimate().rowCount(), this.rightResultSet.getCostEstimate().rowCount());
        this.adjustNumberOfRowsReturned(this.costEstimate);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, this.costEstimate);
        optimizer.considerCost(this, optimizablePredicateList, this.costEstimate, costEstimate);
        if (!this.optimized && this.subqueryList != null) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.costEstimate.rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.costEstimate;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        this.joinPredicates.addPredicate((Predicate)optimizablePredicate);
        RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
        ((Predicate)optimizablePredicate).getAndNode().accept(remapCRsVisitor);
        return true;
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        super.modifyAccessPath(jBitSet);
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
    }

    public ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        if (this.usingClause == null) {
            return this.getAllResultColumnsNoUsing(tableName);
        }
        ResultSetNode resultSetNode = this.getLogicalLeftResultSet();
        ResultColumnList resultColumnList = resultSetNode.getAllResultColumns(null).getJoinColumns(this.usingClause);
        ResultColumnList resultColumnList2 = this.leftResultSet.getAllResultColumns(tableName);
        ResultColumnList resultColumnList3 = this.rightResultSet.getAllResultColumns(tableName);
        if (resultColumnList2 != null) {
            resultColumnList2.removeJoinColumns(this.usingClause);
        }
        if (resultColumnList3 != null) {
            resultColumnList3.removeJoinColumns(this.usingClause);
        }
        if (resultColumnList2 == null) {
            if (resultColumnList3 == null) {
                return null;
            }
            resultColumnList3.resetVirtualColumnIds();
            return resultColumnList3;
        }
        if (resultColumnList3 == null) {
            resultColumnList2.resetVirtualColumnIds();
            return resultColumnList2;
        }
        resultColumnList.destructiveAppend(resultColumnList2);
        resultColumnList.destructiveAppend(resultColumnList3);
        resultColumnList.resetVirtualColumnIds();
        return resultColumnList;
    }

    private ResultColumnList getAllResultColumnsNoUsing(TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = this.leftResultSet.getAllResultColumns(tableName);
        ResultColumnList resultColumnList2 = this.rightResultSet.getAllResultColumns(tableName);
        if (resultColumnList == null) {
            return resultColumnList2;
        }
        if (resultColumnList2 == null) {
            return resultColumnList;
        }
        ResultColumnList resultColumnList3 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        resultColumnList3.nondestructiveAppend(resultColumnList);
        resultColumnList3.nondestructiveAppend(resultColumnList2);
        return resultColumnList3;
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultSetNode resultSetNode = this.getLogicalLeftResultSet();
        ResultSetNode resultSetNode2 = this.getLogicalRightResultSet();
        ResultColumn resultColumn = null;
        ResultColumn resultColumn2 = null;
        ResultColumn resultColumn3 = null;
        ResultColumn resultColumn4 = null;
        resultColumn = resultSetNode.getMatchingColumn(columnReference);
        if (resultColumn != null) {
            resultColumn2 = resultColumn;
            if (this.usingClause != null) {
                resultColumn4 = this.usingClause.getResultColumn(resultColumn.getName());
            }
        }
        if (resultColumn4 == null) {
            resultColumn3 = resultSetNode2.getMatchingColumn(columnReference);
        } else if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            resultColumn.setRightOuterJoinUsingClause(true);
        }
        if (resultColumn3 != null) {
            if (resultColumn != null) {
                throw StandardException.newException("42X03", columnReference.getSQLColumnName());
            }
            if (this instanceof HalfOuterJoinNode) {
                resultColumn3.setNullability(true);
            }
            resultColumn2 = resultColumn3;
        }
        if (this.resultColumns != null) {
            int n = this.resultColumns.size();
            for (int i = 0; i < n; ++i) {
                ResultColumn resultColumn5 = (ResultColumn)this.resultColumns.elementAt(i);
                VirtualColumnNode virtualColumnNode = (VirtualColumnNode)resultColumn5.getExpression();
                if (resultColumn2 != virtualColumnNode.getSourceColumn()) continue;
                resultColumn2 = resultColumn5;
                break;
            }
        }
        return resultColumn2;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        super.bindExpressions(fromList);
        if (this.naturalJoin) {
            this.usingClause = this.getCommonColumnsForNaturalJoin();
        }
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        super.bindResultColumns(fromList);
        this.buildRCL();
        this.deferredBindExpressions(fromList);
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.buildRCL();
        this.deferredBindExpressions(fromList);
    }

    private void buildRCL() throws StandardException {
        if (this.resultColumns != null) {
            return;
        }
        this.resultColumns = this.leftResultSet.getResultColumns();
        ResultColumnList resultColumnList = this.resultColumns.copyListAndObjects();
        this.leftResultSet.setResultColumns(resultColumnList);
        this.resultColumns.genVirtualColumnNodes(this.leftResultSet, resultColumnList, false);
        if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            this.resultColumns.setNullability(true);
        }
        ResultColumnList resultColumnList2 = this.rightResultSet.getResultColumns();
        ResultColumnList resultColumnList3 = resultColumnList2.copyListAndObjects();
        this.rightResultSet.setResultColumns(resultColumnList3);
        resultColumnList2.genVirtualColumnNodes(this.rightResultSet, resultColumnList3, false);
        resultColumnList2.adjustVirtualColumnIds(this.resultColumns.size());
        if (this instanceof HalfOuterJoinNode && !((HalfOuterJoinNode)this).isRightOuterJoin()) {
            resultColumnList2.setNullability(true);
        }
        this.resultColumns.nondestructiveAppend(resultColumnList2);
    }

    private void deferredBindExpressions(FromList fromList) throws StandardException {
        Object object;
        this.subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.aggregateVector = new Vector();
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.joinClause != null) {
            object = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            ((QueryTreeNodeVector)object).addElement((FromTable)this.leftResultSet);
            ((QueryTreeNodeVector)object).addElement((FromTable)this.rightResultSet);
            int n = this.orReliability(16384);
            this.joinClause = this.joinClause.bindExpression((FromList)object, this.subqueryList, this.aggregateVector);
            compilerContext.setReliability(n);
            SelectNode.checkNoWindowFunctions(this.joinClause, "ON");
            if (this.aggregateVector.size() > 0) {
                throw StandardException.newException("42Z07");
            }
        } else if (this.usingClause != null) {
            this.joinClause = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
            int n = this.usingClause.size();
            for (int i = 0; i < n; ++i) {
                ResultColumn resultColumn = (ResultColumn)this.usingClause.elementAt(i);
                fromList.insertElementAt(this.leftResultSet, 0);
                ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), ((FromTable)this.leftResultSet).getTableName(), this.getContextManager());
                columnReference = (ColumnReference)columnReference.bindExpression(fromList, this.subqueryList, this.aggregateVector);
                fromList.removeElementAt(0);
                fromList.insertElementAt(this.rightResultSet, 0);
                ColumnReference columnReference2 = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), ((FromTable)this.rightResultSet).getTableName(), this.getContextManager());
                columnReference2 = (ColumnReference)columnReference2.bindExpression(fromList, this.subqueryList, this.aggregateVector);
                fromList.removeElementAt(0);
                BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, columnReference, columnReference2, this.getContextManager());
                binaryComparisonOperatorNode.bindComparisonOperator();
                AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, this.joinClause, this.getContextManager());
                andNode.postBindFixup();
                this.joinClause = andNode;
            }
        }
        if (this.joinClause != null) {
            if (this.joinClause.requiresTypeFromContext()) {
                this.joinClause.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
            }
            if (((TypeId)(object = this.joinClause.getTypeId())).userType()) {
                this.joinClause = this.joinClause.genSQLJavaSQLTree();
            }
            if (!this.joinClause.getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) {
                throw StandardException.newException("42Y12", this.joinClause.getTypeServices().getTypeId().getSQLTypeName());
            }
        }
    }

    private ResultColumnList getCommonColumnsForNaturalJoin() throws StandardException {
        ResultColumnList resultColumnList = this.getLeftResultSet().getAllResultColumns(null);
        ResultColumnList resultColumnList2 = this.getRightResultSet().getAllResultColumns(null);
        List list = JoinNode.extractColumnNames(resultColumnList);
        list.retainAll(JoinNode.extractColumnNames(resultColumnList2));
        ResultColumnList resultColumnList3 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, null, this.getContextManager());
            resultColumnList3.addResultColumn(resultColumn);
        }
        return resultColumnList3;
    }

    private static List extractColumnNames(ResultColumnList resultColumnList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < resultColumnList.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            arrayList.add(resultColumn.getName());
        }
        return arrayList;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        ResultSetNode resultSetNode = super.preprocess(n, groupByList, fromList);
        if (this.joinClause != null) {
            this.normExpressions();
            if (this.subqueryList != null) {
                this.joinClause.preprocess(n, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
            }
            this.joinPredicates.pullExpressions(n, this.joinClause);
            this.joinPredicates.categorize();
            this.joinClause = null;
        }
        return resultSetNode;
    }

    void projectResultColumns() throws StandardException {
        this.leftResultSet.projectResultColumns();
        this.rightResultSet.projectResultColumns();
        this.resultColumns.pullVirtualIsReferenced();
        super.projectResultColumns();
    }

    public void normExpressions() throws StandardException {
        if (this.joinClauseNormalized) {
            return;
        }
        this.joinClause = this.joinClause.eliminateNots(false);
        this.joinClause = this.joinClause.putAndsOnTop();
        this.joinClause = this.joinClause.changeToCNF(false);
        this.joinClauseNormalized = true;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        FromTable fromTable2 = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(predicateList);
        fromTable.pushExpressions(this.getLeftPredicateList());
        this.pushExpressionsToRight(predicateList);
        fromTable2.pushExpressions(this.getRightPredicateList());
        this.grabJoinPredicates(predicateList);
    }

    protected void pushExpressionsToLeft(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        JBitSet jBitSet = fromTable.getReferencedTableMap();
        for (int i = predicateList.size() - 1; i >= 0; --i) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!predicate.getPushable() || !jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) continue;
            this.getLeftPredicateList().addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicateList.removeElementAt(i);
        }
    }

    private void pushExpressionsToRight(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.rightResultSet;
        JBitSet jBitSet = fromTable.getReferencedTableMap();
        for (int i = predicateList.size() - 1; i >= 0; --i) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!predicate.getPushable() || !jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) continue;
            this.getRightPredicateList().addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicateList.removeElementAt(i);
        }
    }

    private void grabJoinPredicates(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        FromTable fromTable2 = (FromTable)this.rightResultSet;
        JBitSet jBitSet = fromTable.getReferencedTableMap();
        JBitSet jBitSet2 = fromTable2.getReferencedTableMap();
        for (int i = predicateList.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!predicate.getPushable()) continue;
            JBitSet jBitSet3 = predicate.getReferencedSet();
            JBitSet jBitSet4 = (JBitSet)jBitSet2.clone();
            jBitSet4.or(jBitSet);
            if (!jBitSet4.contains(jBitSet3)) continue;
            this.joinPredicates.addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicateList.removeElementAt(i);
        }
    }

    public FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList.addElement((FromTable)this.leftResultSet);
        fromList.addElement((FromTable)this.rightResultSet);
        this.resultColumns.setRedundant();
        resultColumnList.remapColumnReferencesToExpressions();
        predicateList.remapColumnReferencesToExpressions();
        if (groupByList != null) {
            groupByList.remapColumnReferencesToExpressions();
        }
        if (valueNode != null) {
            valueNode.remapColumnReferencesToExpressions();
        }
        if (this.joinPredicates.size() > 0) {
            predicateList.destructiveAppend(this.joinPredicates);
        }
        if (this.subqueryList != null && this.subqueryList.size() > 0) {
            subqueryList.destructiveAppend(this.subqueryList);
        }
        return fromList;
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        return false;
    }

    public FromTable transformOuterJoins(ValueNode valueNode, int n) throws StandardException {
        if (valueNode == null) {
            ((FromTable)this.leftResultSet).transformOuterJoins(null, n);
            ((FromTable)this.rightResultSet).transformOuterJoins(null, n);
            return this;
        }
        this.leftResultSet = ((FromTable)this.leftResultSet).transformOuterJoins(valueNode, n);
        this.rightResultSet = ((FromTable)this.rightResultSet).transformOuterJoins(valueNode, n);
        return this;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, 1, null, null);
    }

    public void generateCore(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, n, this.joinClause, this.subqueryList);
    }

    protected void generateCore(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n, ValueNode valueNode, SubqueryList subqueryList) throws StandardException {
        if (this.joinPredicates != null) {
            valueNode = this.joinPredicates.restorePredicates();
            this.joinPredicates = null;
        }
        this.assignResultSetNumber();
        if (subqueryList != null && subqueryList.size() > 0) {
            subqueryList.setPointOfAttachment(this.resultSetNumber);
        }
        String string = n == 3 ? ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().halfOuterJoinResultSetMethodName() : ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().joinResultSetMethodName();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.getJoinArguments(activationClassBuilder, methodBuilder, valueNode);
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", n2);
    }

    private int getJoinArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, ValueNode valueNode) throws StandardException {
        int n = this.getNumJoinArguments();
        this.leftResultSet.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.leftResultSet.resultColumns.size());
        this.rightResultSet.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.rightResultSet.resultColumns.size());
        this.costEstimate = this.getFinalCostEstimate();
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = activationClassBuilder.newUserExprFun();
            valueNode.generate(activationClassBuilder, methodBuilder2);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
        methodBuilder.push(this.resultSetNumber);
        this.addOuterJoinArguments(activationClassBuilder, methodBuilder);
        this.oneRowRightSide(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        if (this.joinOrderStrategyProperties != null) {
            methodBuilder.push(PropertyUtil.sortProperties(this.joinOrderStrategyProperties));
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        return n;
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate costEstimate = this.leftResultSet.getFinalCostEstimate();
        CostEstimate costEstimate2 = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(costEstimate.getEstimatedCost() + costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.rowCount());
        return this.finalCostEstimate;
    }

    protected void oneRowRightSide(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.push(this.rightResultSet.isOneRowResultSet());
        methodBuilder.push(this.rightResultSet.isNotExists());
    }

    protected int getNumJoinArguments() {
        return 11;
    }

    protected int addOuterJoinArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        return 0;
    }

    public static String joinTypeToString(int n) {
        switch (n) {
            case 1: {
                return "INNER JOIN";
            }
            case 2: {
                return "CROSS JOIN";
            }
            case 3: {
                return "LEFT OUTER JOIN";
            }
            case 4: {
                return "RIGHT OUTER JOIN";
            }
            case 5: {
                return "FULL OUTER JOIN";
            }
            case 6: {
                return "UNION JOIN";
            }
        }
        return null;
    }

    protected PredicateList getLeftPredicateList() throws StandardException {
        if (this.leftPredicateList == null) {
            this.leftPredicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.leftPredicateList;
    }

    protected PredicateList getRightPredicateList() throws StandardException {
        if (this.rightPredicateList == null) {
            this.rightPredicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.rightPredicateList;
    }

    public int updateTargetLockMode() {
        return 6;
    }

    void notFlattenableJoin() {
        this.flattenableJoin = false;
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
    }

    public boolean isFlattenableJoinNode() {
        return this.flattenableJoin;
    }

    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, Vector vector) throws StandardException {
        return this.leftResultSet.isOrderedOn(columnReferenceArray, bl, vector);
    }

    public void printSubNodes(int n) {
    }

    void setSubqueryList(SubqueryList subqueryList) {
        this.subqueryList = subqueryList;
    }

    void setAggregateVector(Vector vector) {
        this.aggregateVector = vector;
    }

    void setNaturalJoin() {
        this.naturalJoin = true;
    }

    ResultSetNode getLogicalLeftResultSet() {
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        return this.rightResultSet;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.resultColumns != null) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(visitor);
        }
        if (this.joinClause != null) {
            this.joinClause = (ValueNode)this.joinClause.accept(visitor);
        }
        if (this.usingClause != null) {
            this.usingClause = (ResultColumnList)this.usingClause.accept(visitor);
        }
        if (this.joinPredicates != null) {
            this.joinPredicates = (PredicateList)this.joinPredicates.accept(visitor);
        }
    }

    public JBitSet LOJgetReferencedTables(int n) throws StandardException {
        JBitSet jBitSet = new JBitSet(n);
        jBitSet = this.leftResultSet.LOJgetReferencedTables(n);
        if (jBitSet == null) {
            return null;
        }
        jBitSet.or(this.rightResultSet.LOJgetReferencedTables(n));
        return jBitSet;
    }
}

