/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.PluginMeta;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.util.PathTrie;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.admin.ContainerPluginsApi;
import org.apache.solr.pkg.PackageLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomContainerPlugins
implements ClusterPropertiesListener,
MapWriter {
    private final ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final CoreContainer coreContainer;
    final ApiBag containerApiBag;
    private final Map<String, ApiInfo> currentPlugins = new HashMap<String, ApiInfo>();

    public boolean onChange(Map<String, Object> properties) {
        this.refresh();
        return false;
    }

    public CustomContainerPlugins(CoreContainer coreContainer, ApiBag apiBag) {
        this.coreContainer = coreContainer;
        this.containerApiBag = apiBag;
    }

    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.currentPlugins.forEach(ew.getBiConsumer());
    }

    public synchronized void refresh() {
        Map<String, Object> pluginInfos = null;
        try {
            pluginInfos = ContainerPluginsApi.plugins(this.coreContainer.zkClientSupplier);
        }
        catch (IOException e) {
            log.error("Could not read plugins data", (Throwable)e);
            return;
        }
        HashMap<String, PluginMeta> newState = new HashMap<String, PluginMeta>(pluginInfos.size());
        for (Map.Entry<String, Object> entry : pluginInfos.entrySet()) {
            try {
                newState.put(entry.getKey(), (PluginMeta)this.mapper.readValue(Utils.toJSON((Object)entry.getValue()), PluginMeta.class));
            }
            catch (Exception exception) {
                log.error("Invalid apiInfo configuration :", (Throwable)exception);
            }
        }
        HashMap<String, PluginMeta> currentState = new HashMap<String, PluginMeta>();
        for (Map.Entry<String, ApiInfo> entry : this.currentPlugins.entrySet()) {
            currentState.put(entry.getKey(), entry.getValue().info);
        }
        Map<String, Diff> map = CustomContainerPlugins.compareMaps(currentState, newState);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Diff> e : map.entrySet()) {
            Object old;
            if (e.getValue() == Diff.UNCHANGED) continue;
            if (e.getValue() == Diff.REMOVED) {
                ApiInfo apiInfo = this.currentPlugins.remove(e.getKey());
                if (apiInfo == null) continue;
                for (ApiHolder holder : apiInfo.holders) {
                    old = this.containerApiBag.unregister(holder.api.getEndPoint().method()[0], CustomContainerPlugins.getActualPath(apiInfo, holder.api.getEndPoint().path()[0]));
                    if (!(old instanceof Closeable)) continue;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)old});
                }
                continue;
            }
            PluginMeta info = (PluginMeta)newState.get(e.getKey());
            ApiInfo apiInfo = null;
            ArrayList<String> errs = new ArrayList<String>();
            apiInfo = new ApiInfo(info, errs);
            if (!errs.isEmpty()) {
                log.error(StrUtils.join(errs, (char)','));
                continue;
            }
            try {
                apiInfo.init();
            }
            catch (Exception exp) {
                log.error("Cannot install apiInfo ", (Throwable)exp);
                continue;
            }
            if (e.getValue() == Diff.ADDED) {
                for (ApiHolder holder : apiInfo.holders) {
                    this.containerApiBag.register(holder, CustomContainerPlugins.getTemplateVars(apiInfo.info));
                }
                this.currentPlugins.put(e.getKey(), apiInfo);
                continue;
            }
            old = this.currentPlugins.put(e.getKey(), apiInfo);
            for (ApiHolder holder : apiInfo.holders) {
                this.containerApiBag.register(holder, CustomContainerPlugins.getTemplateVars(apiInfo.info));
            }
            if (old == null) continue;
            for (ApiHolder oldHolder : ((ApiInfo)old).holders) {
                if (apiInfo.get(oldHolder.api.getEndPoint()) != null) continue;
                this.containerApiBag.unregister(oldHolder.getMethod(), CustomContainerPlugins.getActualPath((ApiInfo)old, oldHolder.getPath()));
            }
            if (!(old instanceof Closeable)) continue;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)old});
        }
    }

    private static String getActualPath(ApiInfo apiInfo, String path) {
        path = path.replaceAll("\\$path-prefix", ((ApiInfo)apiInfo).info.pathPrefix);
        path = path.replaceAll("\\$plugin-name", ((ApiInfo)apiInfo).info.name);
        return path;
    }

    private static Map<String, String> getTemplateVars(PluginMeta pluginMeta) {
        Map result = Utils.makeMap((Object[])new Object[]{"plugin-name", pluginMeta.name, "path-prefix", pluginMeta.pathPrefix});
        return result;
    }

    public ApiInfo createInfo(PluginMeta info, List<String> errs) {
        return new ApiInfo(info, errs);
    }

    public static Map<String, Diff> compareMaps(Map<String, ? extends Object> a, Map<String, ? extends Object> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return null;
        }
        HashMap<String, Diff> result = new HashMap<String, Diff>(Math.max(a.size(), b.size()));
        a.forEach((k, v) -> {
            Object newVal = b.get(k);
            if (newVal == null) {
                result.put((String)k, Diff.REMOVED);
                return;
            }
            result.put((String)k, Objects.equals(v, newVal) ? Diff.UNCHANGED : Diff.UPDATED);
        });
        b.forEach((k, v) -> {
            if (a.get(k) == null) {
                result.put((String)k, Diff.ADDED);
            }
        });
        for (Diff value : result.values()) {
            if (value == Diff.UNCHANGED) continue;
            return result;
        }
        return null;
    }

    public class ApiInfo
    implements ReflectMapWriter {
        List<ApiHolder> holders;
        @JsonProperty
        private final PluginMeta info;
        @JsonProperty(value="package")
        public final String pkg;
        private PackageLoader.Package.Version pkgVersion;
        private Class klas;
        Object instance;

        ApiHolder get(EndPoint endPoint) {
            for (ApiHolder holder : this.holders) {
                EndPoint e = holder.api.getEndPoint();
                if (!Objects.equals(endPoint.method()[0], e.method()[0]) || !Objects.equals(endPoint.path()[0], e.path()[0])) continue;
                return holder;
            }
            return null;
        }

        public ApiInfo(PluginMeta info, List<String> errs) {
            this.info = info;
            PluginInfo.ClassName klassInfo = new PluginInfo.ClassName(info.klass);
            this.pkg = klassInfo.pkg;
            if (this.pkg != null) {
                Optional<PackageLoader.Package.Version> ver = CustomContainerPlugins.this.coreContainer.getPackageLoader().getPackageVersion(this.pkg, info.version);
                if (!ver.isPresent()) {
                    CustomContainerPlugins.this.coreContainer.getPackageLoader().getPackageAPI().refreshPackages(null);
                    ver = CustomContainerPlugins.this.coreContainer.getPackageLoader().getPackageVersion(this.pkg, info.version);
                }
                if (!ver.isPresent()) {
                    PackageLoader.Package p = CustomContainerPlugins.this.coreContainer.getPackageLoader().getPackage(this.pkg);
                    if (p == null) {
                        errs.add("Invalid package " + klassInfo.pkg);
                        return;
                    }
                    errs.add("No such package version:" + this.pkg + ":" + info.version + " . available versions :" + p.allVersions());
                    return;
                }
                this.pkgVersion = ver.get();
                try {
                    this.klas = this.pkgVersion.getLoader().findClass(klassInfo.className, Object.class);
                }
                catch (Exception e) {
                    log.error("Error loading class", (Throwable)e);
                    errs.add("Error loading class " + e.toString());
                    return;
                }
            }
            try {
                this.klas = Class.forName(klassInfo.className);
            }
            catch (ClassNotFoundException e) {
                errs.add("Error loading class " + e.toString());
                return;
            }
            this.pkgVersion = null;
            if (!Modifier.isPublic(this.klas.getModifiers())) {
                errs.add("Class must be public and static : " + this.klas.getName());
                return;
            }
            try {
                List<Api> apis = AnnotatedApi.getApis(this.klas, null);
                for (Api api : apis) {
                    EndPoint endPoint = ((AnnotatedApi)api).getEndPoint();
                    if (endPoint.path().length > 1 || endPoint.method().length > 1) {
                        errs.add("Only one HTTP method and url supported for each API");
                    }
                    if (endPoint.method().length != 1 || endPoint.path().length != 1) {
                        errs.add("The @EndPint must have exactly one method and path attributes");
                    }
                    List pathSegments = StrUtils.splitSmart((String)endPoint.path()[0], (char)'/', (boolean)true);
                    PathTrie.replaceTemplates((List)pathSegments, (Map)CustomContainerPlugins.getTemplateVars(info));
                    if (!V2HttpCall.knownPrefixes.contains(pathSegments.get(0))) continue;
                    errs.add("path must not have a prefix: " + (String)pathSegments.get(0));
                }
            }
            catch (Exception e) {
                errs.add(e.toString());
            }
            if (!errs.isEmpty()) {
                return;
            }
            Constructor<?> constructor = this.klas.getConstructors()[0];
            if (constructor.getParameterTypes().length > 1 || constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] != CoreContainer.class) {
                errs.add("Must have a no-arg constructor or CoreContainer constructor and it must not be a non static inner class");
                return;
            }
            if (!Modifier.isPublic(constructor.getModifiers())) {
                errs.add("Must have a public constructor ");
                return;
            }
        }

        public void init() throws Exception {
            if (this.holders != null) {
                return;
            }
            Constructor<?> constructor = this.klas.getConstructors()[0];
            if (constructor.getParameterTypes().length == 0) {
                this.instance = constructor.newInstance(new Object[0]);
            } else if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == CoreContainer.class) {
                this.instance = constructor.newInstance(CustomContainerPlugins.this.coreContainer);
            } else {
                throw new RuntimeException("Must have a no-arg constructor or CoreContainer constructor ");
            }
            if (this.instance instanceof ResourceLoaderAware) {
                try {
                    ((ResourceLoaderAware)this.instance).inform((ResourceLoader)this.pkgVersion.getLoader());
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            this.holders = new ArrayList<ApiHolder>();
            for (Api api : AnnotatedApi.getApis(this.instance)) {
                this.holders.add(new ApiHolder((AnnotatedApi)api));
            }
        }
    }

    public static enum Diff {
        ADDED,
        REMOVED,
        UNCHANGED,
        UPDATED;

    }

    private static class ApiHolder
    extends Api {
        final AnnotatedApi api;

        protected ApiHolder(AnnotatedApi api) {
            super(api);
            this.api = api;
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            this.api.call(req, rsp);
        }

        public String getPath() {
            return this.api.getEndPoint().path()[0];
        }

        public SolrRequest.METHOD getMethod() {
            return this.api.getEndPoint().method()[0];
        }
    }
}

