/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.DocValuesRewriteMethod;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.query.SolrRangeQuery;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.HasImplicitIndexAnalyzer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.uninverting.UninvertingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldType
extends FieldProperties {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String POLY_FIELD_SEPARATOR = "___";
    protected String typeName;
    protected Map<String, String> args;
    protected int trueProperties;
    protected int falseProperties;
    protected int properties;
    private boolean isExplicitQueryAnalyzer;
    private boolean isExplicitAnalyzer;
    private Analyzer indexAnalyzer;
    private Analyzer queryAnalyzer;
    protected SimilarityFactory similarityFactory;
    protected Similarity similarity;
    protected String postingsFormat;
    protected String docValuesFormat;
    public static final String TYPE = "type";
    public static final String TYPE_NAME = "name";
    public static final String CLASS_NAME = "class";
    public static final String ANALYZER = "analyzer";
    public static final String INDEX = "index";
    public static final String INDEX_ANALYZER = "indexAnalyzer";
    public static final String QUERY = "query";
    public static final String QUERY_ANALYZER = "queryAnalyzer";
    public static final String MULTI_TERM = "multiterm";
    public static final String MULTI_TERM_ANALYZER = "multiTermAnalyzer";
    public static final String SIMILARITY = "similarity";
    public static final String CHAR_FILTER = "charFilter";
    public static final String CHAR_FILTERS = "charFilters";
    public static final String TOKENIZER = "tokenizer";
    public static final String FILTER = "filter";
    public static final String FILTERS = "filters";
    protected static final String AUTO_GENERATE_PHRASE_QUERIES = "autoGeneratePhraseQueries";
    protected static final String ENABLE_GRAPH_QUERIES = "enableGraphQueries";
    private static final String ARGS = "args";
    private static final String POSITION_INCREMENT_GAP = "positionIncrementGap";
    protected static final String SYNONYM_QUERY_STYLE = "synonymQueryStyle";

    public FieldType() {
        this.queryAnalyzer = this.indexAnalyzer = new DefaultAnalyzer(256);
    }

    public boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    public boolean isMultiValued() {
        return (this.properties & 0x200) != 0;
    }

    protected boolean hasProperty(int p) {
        return (this.properties & p) != 0;
    }

    public boolean isPolyField() {
        return false;
    }

    public boolean isPointField() {
        return false;
    }

    public boolean isUtf8Field() {
        return false;
    }

    public boolean useDocValuesAsStored() {
        return (this.properties & 0x20000) != 0;
    }

    public boolean multiValuedFieldCache() {
        return this.isTokenized();
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    public boolean write(IteratorWriter.ItemWriter itemWriter) {
        return false;
    }

    protected void setArgs(IndexSchema schema, Map<String, String> args) {
        this.properties = 5;
        float schemaVersion = schema.getVersion();
        if (schemaVersion < 1.1f) {
            this.properties |= 0x200;
        }
        if (schemaVersion > 1.1f) {
            this.properties |= 0x20;
        }
        if ((double)schemaVersion < 1.3) {
            args.remove("compressThreshold");
        }
        if (schemaVersion >= 1.6f) {
            this.properties |= 0x20000;
        }
        this.properties |= 0x80000;
        this.args = Collections.unmodifiableMap(args);
        HashMap<String, String> initArgs = new HashMap<String, String>(args);
        initArgs.remove(CLASS_NAME);
        this.trueProperties = FieldProperties.parseProperties(initArgs, true, false);
        this.falseProperties = FieldProperties.parseProperties(initArgs, false, false);
        this.properties &= ~this.falseProperties;
        this.properties |= this.trueProperties;
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        this.init(schema, initArgs);
        String positionInc = (String)initArgs.get(POSITION_INCREMENT_GAP);
        if (positionInc != null) {
            Analyzer analyzer = this.getIndexAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            analyzer = this.getQueryAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            initArgs.remove(POSITION_INCREMENT_GAP);
        }
        this.postingsFormat = (String)initArgs.remove("postingsFormat");
        this.docValuesFormat = (String)initArgs.remove("docValuesFormat");
        if (initArgs.size() > 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ") invalid arguments:" + initArgs);
        }
    }

    protected void restrictProps(int props) {
        if ((this.properties & props) != 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ") invalid properties:" + FieldType.propertiesToString(this.properties & props));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName + "{class=" + this.getClass().getName() + (this.indexAnalyzer != null ? ",analyzer=" + this.indexAnalyzer.getClass().getName() : "") + ",args=" + this.args + "}";
    }

    public IndexableField createField(SchemaField field, Object value) {
        String val;
        if (!field.indexed() && !field.stored()) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: {}", (Object)field);
            }
            return null;
        }
        try {
            val = this.toInternal(value.toString());
        }
        catch (RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while creating field '" + field + "' from value '" + value + "'", (Throwable)e);
        }
        if (val == null) {
            return null;
        }
        return this.createField(field.getName(), val, field);
    }

    protected IndexableField createField(String name, String val, IndexableFieldType type) {
        return new Field(name, (CharSequence)val, type);
    }

    public List<IndexableField> createFields(SchemaField field, Object value) {
        IndexableField f = this.createField(field, value);
        if (field.hasDocValues() && f.fieldType().docValuesType() == null) {
            throw new UnsupportedOperationException("This field type does not support doc values: " + this);
        }
        return f == null ? Collections.emptyList() : Collections.singletonList(f);
    }

    public String toInternal(String val) {
        return val;
    }

    public String toExternal(IndexableField f) {
        String val = f.stringValue();
        if (val == null) {
            val = f.binaryValue().utf8ToString();
        }
        return val;
    }

    public Object toObject(IndexableField f) {
        return this.toExternal(f);
    }

    public Object toObject(SchemaField sf, BytesRef term) {
        CharsRefBuilder ref = new CharsRefBuilder();
        this.indexedToReadable(term, ref);
        IndexableField f = this.createField(sf, ref.toString());
        return this.toObject(f);
    }

    public String indexedToReadable(String indexedForm) {
        return indexedForm;
    }

    public CharsRef indexedToReadable(BytesRef input, CharsRefBuilder output) {
        output.copyUTF8Bytes(input);
        return output.get();
    }

    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    public String storedToIndexed(IndexableField f) {
        return f.stringValue();
    }

    public String readableToIndexed(String val) {
        return this.toInternal(val);
    }

    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        String internal = this.readableToIndexed(val.toString());
        result.copyChars((CharSequence)internal);
    }

    public void setIsExplicitQueryAnalyzer(boolean isExplicitQueryAnalyzer) {
        this.isExplicitQueryAnalyzer = isExplicitQueryAnalyzer;
    }

    public boolean isExplicitQueryAnalyzer() {
        return this.isExplicitQueryAnalyzer;
    }

    public void setIsExplicitAnalyzer(boolean explicitAnalyzer) {
        this.isExplicitAnalyzer = explicitAnalyzer;
    }

    public boolean isExplicitAnalyzer() {
        return this.isExplicitAnalyzer;
    }

    public String getClassArg() {
        String className;
        if (null != this.args && null != (className = this.args.get(CLASS_NAME))) {
            return className;
        }
        return this.getClass().getName();
    }

    public Query getPrefixQuery(QParser parser, SchemaField sf, String termStr) {
        if ("".equals(termStr)) {
            return this.getExistenceQuery(parser, sf);
        }
        PrefixQuery query = new PrefixQuery(new Term(sf.getName(), termStr));
        query.setRewriteMethod(sf.getType().getRewriteMethod(parser, sf));
        return query;
    }

    public abstract UninvertingReader.Type getUninversionType(SchemaField var1);

    public Analyzer getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    protected boolean supportsAnalyzers() {
        return false;
    }

    public final void setIndexAnalyzer(Analyzer analyzer) {
        if (!this.supportsAnalyzers()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
        }
        this.indexAnalyzer = analyzer;
    }

    public final void setQueryAnalyzer(Analyzer analyzer) {
        if (!this.supportsAnalyzers()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
        }
        this.queryAnalyzer = analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public SimilarityFactory getSimilarityFactory() {
        return this.similarityFactory;
    }

    public NumberType getNumberType() {
        return null;
    }

    public void setSimilarity(SimilarityFactory similarityFactory) {
        this.similarityFactory = similarityFactory;
        this.similarity = similarityFactory.getSimilarity();
    }

    public String getPostingsFormat() {
        return this.postingsFormat;
    }

    public final String getDocValuesFormat() {
        return this.docValuesFormat;
    }

    public abstract void write(TextResponseWriter var1, String var2, IndexableField var3) throws IOException;

    public abstract SortField getSortField(SchemaField var1, boolean var2);

    protected static SortField getSortField(SchemaField field, SortField.Type sortType, boolean reverse, Object missingLow, Object missingHigh) {
        field.checkSortability();
        SortField sf = new SortField(field.getName(), sortType, reverse);
        FieldType.applySetMissingValue(field, sf, missingLow, missingHigh);
        return sf;
    }

    protected static SortField getSortedSetSortField(SchemaField field, SortedSetSelector.Type selector, boolean reverse, Object missingLow, Object missingHigh) {
        field.checkSortability();
        SortedSetSortField sf = new SortedSetSortField(field.getName(), reverse, selector);
        FieldType.applySetMissingValue(field, (SortField)sf, missingLow, missingHigh);
        return sf;
    }

    protected static SortField getSortedNumericSortField(SchemaField field, SortField.Type sortType, SortedNumericSelector.Type selector, boolean reverse, Object missingLow, Object missingHigh) {
        field.checkSortability();
        SortedNumericSortField sf = new SortedNumericSortField(field.getName(), sortType, reverse, selector);
        FieldType.applySetMissingValue(field, (SortField)sf, missingLow, missingHigh);
        return sf;
    }

    private static void applySetMissingValue(SchemaField field, SortField sortField, Object missingLow, Object missingHigh) {
        boolean reverse = sortField.getReverse();
        if (field.sortMissingLast()) {
            sortField.setMissingValue(reverse ? missingLow : missingHigh);
        } else if (field.sortMissingFirst()) {
            sortField.setMissingValue(reverse ? missingHigh : missingLow);
        }
    }

    protected SortField getStringSort(SchemaField field, boolean reverse) {
        MultiValueSelector selector;
        if (field.multiValued() && null != (selector = field.type.getDefaultMultiValueSelectorForSort(field, reverse))) {
            return FieldType.getSortedSetSortField(field, selector.getSortedSetSelectorType(), reverse, SortField.STRING_FIRST, SortField.STRING_LAST);
        }
        return FieldType.getSortField(field, SortField.Type.STRING, reverse, SortField.STRING_FIRST, SortField.STRING_LAST);
    }

    protected SortField getNumericSort(SchemaField field, NumberType type, boolean reverse) {
        MultiValueSelector selector;
        if (field.multiValued() && null != (selector = field.type.getDefaultMultiValueSelectorForSort(field, reverse))) {
            return FieldType.getSortedNumericSortField(field, type.sortType, selector.getSortedNumericSelectorType(), reverse, type.sortMissingLow, type.sortMissingHigh);
        }
        return FieldType.getSortField(field, type.sortType, reverse, type.sortMissingLow, type.sortMissingHigh);
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource();
        return new StrFieldSource(field.name);
    }

    public ValueSource getSingleValueSource(MultiValueSelector choice, SchemaField field, QParser parser) {
        if (!field.multiValued()) {
            return this.getValueSource(field, parser);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Selecting a single value from a multivalued field is not supported for this field: " + field.getName() + " (type: " + this.getTypeName() + ")");
    }

    public MultiValueSelector getDefaultMultiValueSelectorForSort(SchemaField field, boolean reverse) {
        return null;
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        if (part1 == null && part2 == null && this.treatUnboundedRangeAsExistence(field)) {
            return this.getExistenceQuery(parser, field);
        }
        return this.getSpecializedRangeQuery(parser, field, part1, part2, minInclusive, maxInclusive);
    }

    protected boolean treatUnboundedRangeAsExistence(SchemaField field) {
        return true;
    }

    protected Query getSpecializedRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        BytesRef maxValue;
        BytesRef miValue = part1 == null ? null : new BytesRef((CharSequence)this.toInternal(part1));
        BytesRef bytesRef = maxValue = part2 == null ? null : new BytesRef((CharSequence)this.toInternal(part2));
        if (field.hasDocValues() && !field.indexed()) {
            return SortedSetDocValuesField.newSlowRangeQuery((String)field.getName(), (BytesRef)miValue, (BytesRef)maxValue, (boolean)minInclusive, (boolean)maxInclusive);
        }
        SolrRangeQuery rangeQuery = new SolrRangeQuery(field.getName(), miValue, maxValue, minInclusive, maxInclusive);
        return rangeQuery;
    }

    public Query getExistenceQuery(QParser parser, SchemaField field) {
        if (field.hasDocValues()) {
            return new DocValuesFieldExistsQuery(field.getName());
        }
        if (!field.omitNorms() && !this.isPointField()) {
            return new NormsFieldExistsQuery(field.getName());
        }
        return this.getSpecializedExistenceQuery(parser, field);
    }

    protected Query getSpecializedExistenceQuery(QParser parser, SchemaField field) {
        return this.getSpecializedRangeQuery(parser, field, null, null, true, true);
    }

    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        if (field.hasDocValues() && !field.indexed()) {
            return this.getRangeQuery(parser, field, externalVal, externalVal, true, true);
        }
        BytesRefBuilder br = new BytesRefBuilder();
        this.readableToIndexed(externalVal, br);
        return new TermQuery(new Term(field.getName(), br));
    }

    public Query getFieldTermQuery(QParser parser, SchemaField field, String externalVal) {
        return this.getFieldQuery(parser, field, externalVal);
    }

    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVals) {
        if (!field.indexed()) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (String externalVal : externalVals) {
                Query subq = this.getFieldQuery(parser, field, externalVal);
                builder.add(subq, BooleanClause.Occur.SHOULD);
            }
            return QueryUtils.build(builder, parser);
        }
        ArrayList<BytesRef> lst = new ArrayList<BytesRef>(externalVals.size());
        BytesRefBuilder br = new BytesRefBuilder();
        for (String externalVal : externalVals) {
            this.readableToIndexed(externalVal, br);
            lst.add(br.toBytesRef());
        }
        return new TermInSetQuery(field.getName(), lst);
    }

    public MultiTermQuery.RewriteMethod getRewriteMethod(QParser parser, SchemaField field) {
        if (!field.indexed() && field.hasDocValues()) {
            return new DocValuesRewriteMethod();
        }
        return MultiTermQuery.CONSTANT_SCORE_REWRITE;
    }

    public void checkSchemaField(SchemaField field) {
        if (field.hasDocValues()) {
            this.checkSupportsDocValues();
        }
        if (field.isLarge() && field.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type " + this + " is 'large'; can't support multiValued");
        }
        if (field.isLarge() && this.getNumberType() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type " + this + " is 'large'; can't support numerics");
        }
    }

    protected void checkSupportsDocValues() {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type " + this + " does not support doc values");
    }

    public SimpleOrderedMap<Object> getNamedPropertyValues(boolean showDefaults) {
        SimpleOrderedMap namedPropertyValues = new SimpleOrderedMap();
        namedPropertyValues.add(TYPE_NAME, (Object)this.getTypeName());
        namedPropertyValues.add(CLASS_NAME, (Object)this.getClassArg());
        if (showDefaults) {
            Map<String, String> fieldTypeArgs = this.getNonFieldPropertyArgs();
            if (null != fieldTypeArgs) {
                for (Map.Entry<String, String> entry : fieldTypeArgs.entrySet()) {
                    String key = entry.getKey();
                    if (CLASS_NAME.equals(key) || TYPE_NAME.equals(key)) continue;
                    namedPropertyValues.add(key, (Object)entry.getValue());
                }
            }
            if (this instanceof TextField) {
                namedPropertyValues.add(AUTO_GENERATE_PHRASE_QUERIES, (Object)((TextField)this).getAutoGeneratePhraseQueries());
                namedPropertyValues.add(ENABLE_GRAPH_QUERIES, (Object)((TextField)this).getEnableGraphQueries());
                namedPropertyValues.add(SYNONYM_QUERY_STYLE, (Object)((TextField)this).getSynonymQueryStyle());
            }
            namedPropertyValues.add(FieldType.getPropertyName(1), (Object)this.hasProperty(1));
            namedPropertyValues.add(FieldType.getPropertyName(4), (Object)this.hasProperty(4));
            namedPropertyValues.add(FieldType.getPropertyName(32768), (Object)this.hasProperty(32768));
            namedPropertyValues.add(FieldType.getPropertyName(64), (Object)this.hasProperty(64));
            namedPropertyValues.add(FieldType.getPropertyName(128), (Object)this.hasProperty(128));
            namedPropertyValues.add(FieldType.getPropertyName(256), (Object)this.hasProperty(256));
            namedPropertyValues.add(FieldType.getPropertyName(16), (Object)this.hasProperty(16));
            namedPropertyValues.add(FieldType.getPropertyName(32), (Object)this.hasProperty(32));
            namedPropertyValues.add(FieldType.getPropertyName(8192), (Object)this.hasProperty(8192));
            namedPropertyValues.add(FieldType.getPropertyName(16384), (Object)this.hasProperty(16384));
            namedPropertyValues.add(FieldType.getPropertyName(512), (Object)this.hasProperty(512));
            namedPropertyValues.add(FieldType.getPropertyName(262144), (Object)this.hasProperty(262144));
            namedPropertyValues.add(FieldType.getPropertyName(524288), (Object)this.hasProperty(524288));
            if (this.hasProperty(1024)) {
                namedPropertyValues.add(FieldType.getPropertyName(1024), (Object)true);
            } else if (this.hasProperty(2048)) {
                namedPropertyValues.add(FieldType.getPropertyName(2048), (Object)true);
            }
            namedPropertyValues.add(FieldType.getPropertyName(2), (Object)this.isTokenized());
            if (null != this.getPostingsFormat()) {
                namedPropertyValues.add("postingsFormat", (Object)this.getPostingsFormat());
            }
            if (null != this.getDocValuesFormat()) {
                namedPropertyValues.add("docValuesFormat", (Object)this.getDocValuesFormat());
            }
        } else {
            HashSet<String> fieldProperties = new HashSet<String>();
            for (String propertyName : FieldProperties.propertyNames) {
                fieldProperties.add(propertyName);
            }
            for (Map.Entry entry : this.args.entrySet()) {
                String key = (String)entry.getKey();
                if (fieldProperties.contains(key)) {
                    namedPropertyValues.add(key, (Object)StrUtils.parseBool((String)((String)entry.getValue())));
                    continue;
                }
                if (CLASS_NAME.equals(key) || TYPE_NAME.equals(key)) continue;
                namedPropertyValues.add(key, entry.getValue());
            }
        }
        if (null != this.getSimilarityFactory()) {
            namedPropertyValues.add(SIMILARITY, this.getSimilarityFactory().getNamedPropertyValues());
        }
        if (this instanceof HasImplicitIndexAnalyzer) {
            if (this.isExplicitQueryAnalyzer()) {
                namedPropertyValues.add(QUERY_ANALYZER, FieldType.getAnalyzerProperties(this.getQueryAnalyzer()));
            }
        } else {
            String analyzerProperty;
            if (this.isExplicitAnalyzer()) {
                analyzerProperty = this.isExplicitQueryAnalyzer() ? INDEX_ANALYZER : ANALYZER;
                namedPropertyValues.add(analyzerProperty, FieldType.getAnalyzerProperties(this.getIndexAnalyzer()));
            }
            if (this.isExplicitQueryAnalyzer()) {
                analyzerProperty = this.isExplicitAnalyzer() ? QUERY_ANALYZER : ANALYZER;
                namedPropertyValues.add(analyzerProperty, FieldType.getAnalyzerProperties(this.getQueryAnalyzer()));
            }
        }
        if (this instanceof TextField && ((TextField)this).isExplicitMultiTermAnalyzer()) {
            namedPropertyValues.add(MULTI_TERM_ANALYZER, FieldType.getAnalyzerProperties(((TextField)this).getMultiTermAnalyzer()));
        }
        return namedPropertyValues;
    }

    protected Map<String, String> getNonFieldPropertyArgs() {
        HashMap<String, String> initArgs = new HashMap<String, String>(this.args);
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        return initArgs;
    }

    protected static SimpleOrderedMap<Object> getAnalyzerProperties(Analyzer analyzer) {
        SimpleOrderedMap analyzerProps = new SimpleOrderedMap();
        if (analyzer instanceof TokenizerChain) {
            Map factoryArgs;
            TokenizerChain tokenizerChain = (TokenizerChain)analyzer;
            CharFilterFactory[] charFilterFactories = tokenizerChain.getCharFilterFactories();
            if (0 < charFilterFactories.length) {
                ArrayList<SimpleOrderedMap> charFilterProps = new ArrayList<SimpleOrderedMap>();
                for (CharFilterFactory charFilterFactory : charFilterFactories) {
                    SimpleOrderedMap props = new SimpleOrderedMap();
                    props.add(CLASS_NAME, (Object)charFilterFactory.getClassArg());
                    factoryArgs = charFilterFactory.getOriginalArgs();
                    if (null != factoryArgs) {
                        for (Map.Entry entry : factoryArgs.entrySet()) {
                            String key = (String)entry.getKey();
                            if (CLASS_NAME.equals(key)) continue;
                            if ("luceneMatchVersion".equals(key)) {
                                if (!charFilterFactory.isExplicitLuceneMatchVersion()) continue;
                                props.add(key, entry.getValue());
                                continue;
                            }
                            props.add(key, entry.getValue());
                        }
                    }
                    charFilterProps.add(props);
                }
                analyzerProps.add(CHAR_FILTERS, charFilterProps);
            }
            SimpleOrderedMap tokenizerProps = new SimpleOrderedMap();
            TokenizerFactory tokenizerFactory = tokenizerChain.getTokenizerFactory();
            tokenizerProps.add(CLASS_NAME, (Object)tokenizerFactory.getClassArg());
            factoryArgs = tokenizerFactory.getOriginalArgs();
            if (null != factoryArgs) {
                for (Map.Entry entry : factoryArgs.entrySet()) {
                    String key = (String)entry.getKey();
                    if (CLASS_NAME.equals(key)) continue;
                    if ("luceneMatchVersion".equals(key)) {
                        if (!tokenizerFactory.isExplicitLuceneMatchVersion()) continue;
                        tokenizerProps.add(key, entry.getValue());
                        continue;
                    }
                    tokenizerProps.add(key, entry.getValue());
                }
            }
            analyzerProps.add(TOKENIZER, (Object)tokenizerProps);
            TokenFilterFactory[] filterFactories = tokenizerChain.getTokenFilterFactories();
            if (0 < filterFactories.length) {
                ArrayList<SimpleOrderedMap> filterProps = new ArrayList<SimpleOrderedMap>();
                for (TokenFilterFactory filterFactory : filterFactories) {
                    SimpleOrderedMap props = new SimpleOrderedMap();
                    props.add(CLASS_NAME, (Object)filterFactory.getClassArg());
                    factoryArgs = filterFactory.getOriginalArgs();
                    if (null != factoryArgs) {
                        for (Map.Entry entry : factoryArgs.entrySet()) {
                            String key = (String)entry.getKey();
                            if (CLASS_NAME.equals(key)) continue;
                            if ("luceneMatchVersion".equals(key)) {
                                if (!filterFactory.isExplicitLuceneMatchVersion()) continue;
                                props.add(key, entry.getValue());
                                continue;
                            }
                            props.add(key, entry.getValue());
                        }
                    }
                    filterProps.add(props);
                }
                analyzerProps.add(FILTERS, filterProps);
            }
        } else {
            analyzerProps.add(CLASS_NAME, (Object)analyzer.getClass().getName());
            if (analyzer.getVersion() != Version.LATEST) {
                analyzerProps.add("luceneMatchVersion", (Object)analyzer.getVersion().toString());
            }
        }
        return analyzerProps;
    }

    public Object toNativeType(Object val) {
        if (val instanceof CharSequence) {
            return ((CharSequence)val).toString();
        }
        return val;
    }

    public Object marshalSortValue(Object value) {
        return value;
    }

    public Object unmarshalSortValue(Object value) {
        return value;
    }

    protected static Object marshalStringSortValue(Object value) {
        if (null == value) {
            return null;
        }
        CharsRefBuilder spare = new CharsRefBuilder();
        spare.copyUTF8Bytes((BytesRef)value);
        return spare.toString();
    }

    protected static Object unmarshalStringSortValue(Object value) {
        if (null == value) {
            return null;
        }
        BytesRefBuilder spare = new BytesRefBuilder();
        String stringVal = (String)value;
        spare.copyChars((CharSequence)stringVal);
        return spare.get();
    }

    protected static Object marshalBase64SortValue(Object value) {
        if (null == value) {
            return null;
        }
        BytesRef val = (BytesRef)value;
        return Base64.byteArrayToBase64((byte[])val.bytes, (int)val.offset, (int)val.length);
    }

    protected static Object unmarshalBase64SortValue(Object value) {
        if (null == value) {
            return null;
        }
        String val = (String)value;
        byte[] bytes = Base64.base64ToByteArray((String)val);
        return new BytesRef(bytes);
    }

    protected final class DefaultAnalyzer
    extends SolrAnalyzer {
        final int maxChars;

        DefaultAnalyzer(int maxChars) {
            this.maxChars = maxChars;
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            Tokenizer ts = new Tokenizer(){
                final char[] cbuf;
                final CharTermAttribute termAtt;
                final BytesTermAttribute bytesAtt;
                final OffsetAttribute offsetAtt;
                {
                    this.cbuf = new char[DefaultAnalyzer.this.maxChars];
                    this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                    this.bytesAtt = FieldType.this.isPointField() ? (BytesTermAttribute)this.addAttribute(BytesTermAttribute.class) : null;
                    this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    int n = this.input.read(this.cbuf, 0, DefaultAnalyzer.this.maxChars);
                    if (n <= 0) {
                        return false;
                    }
                    if (FieldType.this.isPointField()) {
                        BytesRef b = ((PointField)FieldType.this).toInternalByteRef(new String(this.cbuf, 0, n));
                        this.bytesAtt.setBytesRef(b);
                    } else {
                        String s = FieldType.this.toInternal(new String(this.cbuf, 0, n));
                        this.termAtt.setEmpty().append(s);
                    }
                    this.offsetAtt.setOffset(this.correctOffset(0), this.correctOffset(n));
                    return true;
                }
            };
            return new Analyzer.TokenStreamComponents(ts);
        }
    }

    public static enum MultiValueSelector {
        MIN(SortedSetSelector.Type.MIN, SortedNumericSelector.Type.MIN),
        MAX(SortedSetSelector.Type.MAX, SortedNumericSelector.Type.MAX);

        private final SortedSetSelector.Type sType;
        private final SortedNumericSelector.Type nType;

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public SortedSetSelector.Type getSortedSetSelectorType() {
            return this.sType;
        }

        public SortedNumericSelector.Type getSortedNumericSelectorType() {
            return this.nType;
        }

        private MultiValueSelector(SortedSetSelector.Type sType, SortedNumericSelector.Type nType) {
            this.sType = sType;
            this.nType = nType;
        }

        public static MultiValueSelector lookup(String label) {
            if (null == label) {
                throw new NullPointerException("label must not be null when calling MultiValueSelector.lookup");
            }
            try {
                return MultiValueSelector.valueOf(label.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

