/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.BuiltInMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected JdbcToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, traits, input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToEnumerableConverter(this.getCluster(), traitSet, JdbcToEnumerableConverter.sole(inputs));
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        if (cost == null) {
            return null;
        }
        return cost.multiplyBy(0.1);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression enumerable;
        Expression calendar_;
        BlockBuilder builder0 = new BlockBuilder(false);
        JdbcRel child = (JdbcRel)this.getInput();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        JdbcConvention jdbcConvention = (JdbcConvention)Objects.requireNonNull(child.getConvention(), () -> "child.getConvention() is null for " + child);
        SqlString sqlString = this.generateSql(jdbcConvention.dialect);
        String sql = sqlString.getSql();
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println("[" + sql + "]");
        }
        Hook.QUERY_PLAN.run(sql);
        Expression sql_ = builder0.append("sql", (Expression)Expressions.constant((Object)sql));
        int fieldCount = this.getRowType().getFieldCount();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression resultSet_ = Expressions.parameter((int)16, ResultSet.class, (String)builder.newName("resultSet"));
        SqlDialect.CalendarPolicy calendarPolicy = jdbcConvention.dialect.getCalendarPolicy();
        switch (calendarPolicy) {
            case LOCAL: {
                calendar_ = builder0.append("calendar", (Expression)Expressions.call(Calendar.class, (String)"getInstance", (Expression[])new Expression[]{JdbcToEnumerableConverter.getTimeZoneExpression(implementor)}));
                break;
            }
            default: {
                calendar_ = null;
            }
        }
        if (fieldCount == 1) {
            ParameterExpression value_ = Expressions.parameter(Object.class, (String)builder.newName("value"));
            builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)value_, null));
            JdbcToEnumerableConverter.generateGet(implementor, physType, builder, resultSet_, 0, (Expression)value_, calendar_, calendarPolicy);
            builder.add((Statement)Expressions.return_(null, (Expression)value_));
        } else {
            Expression values_ = builder.append("values", (Expression)Expressions.newArrayBounds(Object.class, (int)1, (Expression)Expressions.constant((Object)fieldCount)));
            for (int i = 0; i < fieldCount; ++i) {
                JdbcToEnumerableConverter.generateGet(implementor, physType, builder, resultSet_, i, (Expression)Expressions.arrayIndex((Expression)values_, (Expression)Expressions.constant((Object)i)), calendar_, calendarPolicy);
            }
            builder.add((Statement)Expressions.return_(null, (Expression)values_));
        }
        ParameterExpression e_ = Expressions.parameter(SQLException.class, (String)builder.newName("e"));
        Expression rowBuilderFactory_ = builder0.append("rowBuilderFactory", (Expression)Expressions.lambda((BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.return_(null, (Expression)Expressions.lambda((BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.tryCatch((Statement)builder.toBlock(), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)e_, (Statement)Expressions.throw_((Expression)Expressions.new_(RuntimeException.class, (Expression[])new Expression[]{e_})))})}), (ParameterExpression[])new ParameterExpression[0]))}), (ParameterExpression[])new ParameterExpression[]{resultSet_}));
        if (sqlString.getDynamicParameters() != null && !sqlString.getDynamicParameters().isEmpty()) {
            Expression preparedStatementConsumer_ = builder0.append("preparedStatementConsumer", (Expression)Expressions.call((Method)BuiltInMethod.CREATE_ENRICHER.method, (Expression[])new Expression[]{Expressions.newArrayInit(Integer.class, (int)1, JdbcToEnumerableConverter.toIndexesTableExpression(sqlString)), DataContext.ROOT}));
            enumerable = builder0.append("enumerable", (Expression)Expressions.call((Method)BuiltInMethod.RESULT_SET_ENUMERABLE_OF_PREPARED.method, (Expression[])new Expression[]{Schemas.unwrap(jdbcConvention.expression, DataSource.class), sql_, rowBuilderFactory_, preparedStatementConsumer_}));
        } else {
            enumerable = builder0.append("enumerable", (Expression)Expressions.call((Method)BuiltInMethod.RESULT_SET_ENUMERABLE_OF.method, (Expression[])new Expression[]{Schemas.unwrap(jdbcConvention.expression, DataSource.class), sql_, rowBuilderFactory_}));
        }
        builder0.add(Expressions.statement((Expression)Expressions.call((Expression)enumerable, (Method)BuiltInMethod.RESULT_SET_ENUMERABLE_SET_TIMEOUT.method, (Expression[])new Expression[]{DataContext.ROOT})));
        builder0.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, builder0.toBlock());
    }

    private static List<ConstantExpression> toIndexesTableExpression(SqlString sqlString) {
        return Objects.requireNonNull(sqlString.getDynamicParameters(), () -> "sqlString.getDynamicParameters() is null for " + sqlString).stream().map(Expressions::constant).collect(Collectors.toList());
    }

    private static UnaryExpression getTimeZoneExpression(EnumerableRelImplementor implementor) {
        return Expressions.convert_((Expression)Expressions.call((Expression)implementor.getRootExpression(), (String)"get", (Expression[])new Expression[]{Expressions.constant((Object)"timeZone")}), TimeZone.class);
    }

    private static void generateGet(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression resultSet_, int i, Expression target, @Nullable Expression calendar_, SqlDialect.CalendarPolicy calendarPolicy) {
        MethodCallExpression source;
        Primitive primitive = Primitive.ofBoxOr((Type)physType.fieldClass(i));
        RelDataType fieldType = physType.getRowType().getFieldList().get(i).getType();
        ArrayList<Object> dateTimeArgs = new ArrayList<Object>();
        dateTimeArgs.add(Expressions.constant((Object)(i + 1)));
        SqlTypeName sqlTypeName = fieldType.getSqlTypeName();
        boolean offset = false;
        block0 : switch (calendarPolicy) {
            case LOCAL: {
                assert (calendar_ != null) : "calendar must not be null";
                dateTimeArgs.add(calendar_);
                break;
            }
            case NULL: {
                break;
            }
            case DIRECT: {
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            case SHIFT: {
                switch (sqlTypeName) {
                    case TIMESTAMP: 
                    case DATE: {
                        offset = true;
                        break block0;
                    }
                }
                break;
            }
        }
        switch (sqlTypeName) {
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                source = Expressions.call((Method)JdbcToEnumerableConverter.getMethod(sqlTypeName, fieldType.isNullable(), offset), (Iterable)Expressions.list().append((Object)Expressions.call((Expression)resultSet_, (Method)JdbcToEnumerableConverter.getMethod2(sqlTypeName), dateTimeArgs)).appendIf(offset, (Object)JdbcToEnumerableConverter.getTimeZoneExpression(implementor)));
                break;
            }
            case ARRAY: {
                UnaryExpression x = Expressions.convert_((Expression)Expressions.call((Expression)resultSet_, (String)JdbcToEnumerableConverter.jdbcGetMethod(primitive), (Expression[])new Expression[]{Expressions.constant((Object)(i + 1))}), Array.class);
                source = Expressions.call((Method)BuiltInMethod.JDBC_ARRAY_TO_LIST.method, (Expression[])new Expression[]{x});
                break;
            }
            default: {
                source = Expressions.call((Expression)resultSet_, (String)JdbcToEnumerableConverter.jdbcGetMethod(primitive), (Expression[])new Expression[]{Expressions.constant((Object)(i + 1))});
            }
        }
        builder.add(Expressions.statement((Expression)Expressions.assign((Expression)target, (Expression)source)));
        if (primitive != null) {
            builder.add((Statement)Expressions.ifThen((Expression)Expressions.call((Expression)resultSet_, (String)"wasNull", (Expression[])new Expression[0]), (Node)Expressions.statement((Expression)Expressions.assign((Expression)target, (Expression)Expressions.constant(null)))));
        }
    }

    private static Method getMethod(SqlTypeName sqlTypeName, boolean nullable, boolean offset) {
        switch (sqlTypeName) {
            case DATE: {
                return (nullable ? BuiltInMethod.DATE_TO_INT_OPTIONAL : BuiltInMethod.DATE_TO_INT).method;
            }
            case TIME: {
                return (nullable ? BuiltInMethod.TIME_TO_INT_OPTIONAL : BuiltInMethod.TIME_TO_INT).method;
            }
            case TIMESTAMP: {
                return (nullable ? (offset ? BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL_OFFSET : BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL) : (offset ? BuiltInMethod.TIMESTAMP_TO_LONG_OFFSET : BuiltInMethod.TIMESTAMP_TO_LONG)).method;
            }
        }
        throw new AssertionError((Object)((Object)((Object)sqlTypeName) + ":" + nullable));
    }

    private static Method getMethod2(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case DATE: {
                return BuiltInMethod.RESULT_SET_GET_DATE2.method;
            }
            case TIME: {
                return BuiltInMethod.RESULT_SET_GET_TIME2.method;
            }
            case TIMESTAMP: {
                return BuiltInMethod.RESULT_SET_GET_TIMESTAMP2.method;
            }
        }
        throw new AssertionError((Object)sqlTypeName);
    }

    private static String jdbcGetMethod(@Nullable Primitive primitive) {
        return primitive == null ? "getObject" : "get" + SqlFunctions.initcap((String)Nullness.castNonNull((Object)primitive.primitiveName));
    }

    private SqlString generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitInput(this, 0);
        return result.asStatement().toSqlString(dialect);
    }
}

