/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleNamespaceContext
implements NamespaceContext {
    private final Map<String, String> prefixToNamespaceUri = new HashMap<String, String>();
    private final Map<String, Set<String>> namespaceUriToPrefixes = new HashMap<String, Set<String>>();

    public SimpleNamespaceContext(Map<String, String> bindings) {
        this.bindNamespaceUri("xml", "http://www.w3.org/XML/1998/namespace");
        this.bindNamespaceUri("xmlns", "http://www.w3.org/2000/xmlns/");
        this.bindNamespaceUri("", "");
        bindings.forEach(this::bindNamespaceUri);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.prefixToNamespaceUri.containsKey(prefix)) {
            return this.prefixToNamespaceUri.get(prefix);
        }
        return "";
    }

    @Override
    public @Nullable String getPrefix(String namespaceUri) {
        Set<String> prefixes = this.getPrefixesSet(namespaceUri);
        return !prefixes.isEmpty() ? prefixes.iterator().next() : null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceUri) {
        return this.getPrefixesSet(namespaceUri).iterator();
    }

    private Set<String> getPrefixesSet(String namespaceUri) {
        Set<String> prefixes = this.namespaceUriToPrefixes.get(namespaceUri);
        return prefixes != null ? Collections.unmodifiableSet(prefixes) : Collections.emptySet();
    }

    private void bindNamespaceUri(String prefix, String namespaceUri) {
        this.prefixToNamespaceUri.put(prefix, namespaceUri);
        Set prefixes = this.namespaceUriToPrefixes.computeIfAbsent(namespaceUri, k -> new LinkedHashSet());
        prefixes.add(prefix);
    }
}

