/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceFinder;

public class ZipFileResourceFinder
extends ResourceFinder {
    private final ZipFile zipFile;

    public ZipFileResourceFinder(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public final String toString() {
        return "zip:" + this.zipFile.getName();
    }

    @Override
    @Nullable
    public final Resource findResource(final String resourceName) {
        final ZipEntry ze = this.zipFile.getEntry(resourceName);
        if (ze == null) {
            return null;
        }
        return new Resource(){

            @Override
            public InputStream open() throws IOException {
                return ZipFileResourceFinder.this.zipFile.getInputStream(ze);
            }

            @Override
            public String getFileName() {
                return ZipFileResourceFinder.this.zipFile.getName() + ':' + resourceName;
            }

            @Override
            public long lastModified() {
                long l = ze.getTime();
                return l == -1L ? 0L : l;
            }

            public String toString() {
                return this.getFileName();
            }
        };
    }
}

