/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpResponseException;
import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

class HttpJsonExceptionCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    HttpJsonExceptionCallable(UnaryCallable<RequestT, ResponseT> callable, Set<StatusCode.Code> retryableCodes) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        ApiFuture innerCallFuture = this.callable.futureCall(request, (ApiCallContext)context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback((ApiFuture)innerCallFuture, (ApiFutureCallback)transformingFuture, (Executor)MoreExecutors.directExecutor());
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof HttpResponseException) {
                HttpResponseException e = (HttpResponseException)throwable;
                StatusCode.Code statusCode = HttpJsonStatusCode.httpStatusToStatusCode(e.getStatusCode(), e.getMessage());
                boolean canRetry = HttpJsonExceptionCallable.this.retryableCodes.contains((Object)statusCode);
                String message = e.getStatusMessage();
                ApiException newException = message == null ? ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)HttpJsonStatusCode.of(statusCode), (boolean)canRetry) : ApiExceptionFactory.createException((String)message, (Throwable)throwable, (StatusCode)HttpJsonStatusCode.of(statusCode), (boolean)canRetry);
                super.setException((Throwable)newException);
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                if (throwable instanceof ApiException) {
                    super.setException(throwable);
                } else {
                    this.setException((Throwable)ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)HttpJsonStatusCode.of(StatusCode.Code.UNKNOWN), (boolean)false));
                }
            }
        }
    }
}

