/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Quadrics;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;

public class Cylinder
extends Primitive {
    float radius;
    float height;
    int xdivisions;
    int ydivisions;
    static final int MID_REZ_DIV_X = 15;
    static final int MID_REZ_DIV_Y = 1;
    public static final int BODY = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;

    public Cylinder() {
        this(1.0f, 2.0f, 1, 15, 1, null);
    }

    public Cylinder(float f, float f2) {
        this(f, f2, 1, 15, 1, null);
    }

    public Cylinder(float f, float f2, Appearance appearance) {
        this(f, f2, 1, 15, 1, appearance);
    }

    public Cylinder(float f, float f2, int n, Appearance appearance) {
        this(f, f2, n, 15, 1, appearance);
    }

    @Override
    public Shape3D getShape(int n) {
        if (n > 2 || n < 0) {
            return null;
        }
        return (Shape3D)this.getChild(n);
    }

    @Override
    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
        ((Shape3D)this.getChild(1)).setAppearance(appearance);
        ((Shape3D)this.getChild(2)).setAppearance(appearance);
    }

    @Override
    public Appearance getAppearance(int n) {
        if (n > 2 || n < 0) {
            return null;
        }
        return this.getShape(n).getAppearance();
    }

    public Cylinder(float f, float f2, int n, int n2, int n3, Appearance appearance) {
        this.radius = f;
        this.height = f2;
        this.xdivisions = n2;
        this.ydivisions = n3;
        this.flags = n;
        boolean bl = (this.flags & 4) == 0;
        boolean bl2 = (this.flags & 8) != 0;
        Quadrics quadrics = new Quadrics();
        GeomBuffer geomBuffer = null;
        Shape3D[] shape3DArray = new Shape3D[3];
        GeomBuffer geomBuffer2 = this.getCachedGeometry(2, 0.0f, f, f2, n2, n3, n);
        if (geomBuffer2 != null) {
            shape3DArray[0] = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.cylinder(f2, f, n2, n3, bl, bl2);
            shape3DArray[0] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(2, 0.0f, f, f2, n2, n3, n, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[0].setCapability(14);
            shape3DArray[0].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[0].setCapability(12);
        }
        this.addChild((Node)shape3DArray[0]);
        geomBuffer2 = this.getCachedGeometry(16, f, f, f2 / 2.0f, n2, n2, n);
        if (geomBuffer2 != null) {
            shape3DArray[1] = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.disk(f, n2, (double)f2 / 2.0, bl, bl2);
            shape3DArray[1] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(16, f, f, f2 / 2.0f, n2, n2, n, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[1].setCapability(14);
            shape3DArray[1].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[1].setCapability(12);
        }
        this.addChild((Node)shape3DArray[1]);
        geomBuffer2 = this.getCachedGeometry(32, f, f, -f2 / 2.0f, n2, n2, n);
        if (geomBuffer2 != null) {
            shape3DArray[2] = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.disk(f, n2, (double)(-f2) / 2.0, !bl, bl2);
            shape3DArray[2] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(32, f, f, -f2 / 2.0f, n2, n2, n, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[2].setCapability(14);
            shape3DArray[2].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[2].setCapability(12);
        }
        this.addChild((Node)shape3DArray[2]);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Node cloneNode(boolean bl) {
        Cylinder cylinder = new Cylinder(this.radius, this.height, this.flags, this.xdivisions, this.ydivisions, this.getAppearance());
        cylinder.duplicateNode((Node)this, bl);
        return cylinder;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getXdivisions() {
        return this.xdivisions;
    }

    public int getYdivisions() {
        return this.ydivisions;
    }
}

