/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

import org.sunflow.system.UI;
import org.sunflow.util.FastHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Plugins<T> {
    private final FastHashMap<String, Class<? extends T>> pluginClasses = new FastHashMap();
    private final Class<T> baseClass;

    public Plugins(Class<T> clazz) {
        this.baseClass = clazz;
    }

    public T createObject(String string) {
        if (string == null || string.equals("none")) {
            return null;
        }
        Class<T> clazz = this.pluginClasses.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            UI.printError(UI.Module.API, "Cannot create object of type \"%s\" - %s", string, instantiationException.getLocalizedMessage());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            UI.printError(UI.Module.API, "Cannot create object of type \"%s\" - %s", string, illegalAccessException.getLocalizedMessage());
            return null;
        }
    }

    public boolean hasType(String string) {
        return this.pluginClasses.get(string) != null;
    }

    public String generateUniqueName(String string) {
        String string2;
        int n = 1;
        while (this.hasType(string2 = String.format("%s_%d", string, n))) {
            ++n;
        }
        return string2;
    }

    public boolean registerPlugin(String string, String string2) {
        return false;
    }

    public boolean registerPlugin(String string, Class<? extends T> clazz) {
        try {
            if (clazz.getConstructor(new Class[0]) == null) {
                UI.printError(UI.Module.API, "Plugin \"%s\" could not be declared - default constructor was not found", string);
                return false;
            }
        }
        catch (SecurityException securityException) {
            UI.printError(UI.Module.API, "Plugin \"%s\" could not be declared - default constructor is not visible (%s)", string, securityException.getLocalizedMessage());
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            UI.printError(UI.Module.API, "Plugin \"%s\" could not be declared - default constructor was not found (%s)", string, noSuchMethodException.getLocalizedMessage());
            return false;
        }
        if (this.pluginClasses.get(string) != null) {
            UI.printWarning(UI.Module.API, "Plugin \"%s\" was already defined - overwriting previous definition", string);
        }
        this.pluginClasses.put(string, clazz);
        return true;
    }
}

