function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from "react";
import * as ReactIs from "react-is";
import mergeAllOf from "json-schema-merge-allof";
import fill from "core-js-pure/features/array/fill";
import union from "lodash/union";
import jsonpointer from "jsonpointer";
import fields from "./components/fields";
import widgets from "./components/widgets";
import validateFormData, { isValid } from "./validate";
export var ADDITIONAL_PROPERTY_FLAG = "__additional_property";
var widgetMap = {
  "boolean": {
    checkbox: "CheckboxWidget",
    radio: "RadioWidget",
    select: "SelectWidget",
    hidden: "HiddenWidget"
  },
  string: {
    text: "TextWidget",
    password: "PasswordWidget",
    email: "EmailWidget",
    hostname: "TextWidget",
    ipv4: "TextWidget",
    ipv6: "TextWidget",
    uri: "URLWidget",
    "data-url": "FileWidget",
    radio: "RadioWidget",
    select: "SelectWidget",
    textarea: "TextareaWidget",
    hidden: "HiddenWidget",
    date: "DateWidget",
    datetime: "DateTimeWidget",
    "date-time": "DateTimeWidget",
    "alt-date": "AltDateWidget",
    "alt-datetime": "AltDateTimeWidget",
    color: "ColorWidget",
    file: "FileWidget"
  },
  number: {
    text: "TextWidget",
    select: "SelectWidget",
    updown: "UpDownWidget",
    range: "RangeWidget",
    radio: "RadioWidget",
    hidden: "HiddenWidget"
  },
  integer: {
    text: "TextWidget",
    select: "SelectWidget",
    updown: "UpDownWidget",
    range: "RangeWidget",
    radio: "RadioWidget",
    hidden: "HiddenWidget"
  },
  array: {
    select: "SelectWidget",
    checkboxes: "CheckboxesWidget",
    files: "FileWidget",
    hidden: "HiddenWidget"
  }
};
export function canExpand(schema, uiSchema, formData) {
  if (!schema.additionalProperties) {
    return false;
  }

  var _getUiOptions = getUiOptions(uiSchema),
      expandable = _getUiOptions.expandable;

  if (expandable === false) {
    return expandable;
  } // if ui:options.expandable was not explicitly set to false, we can add
  // another property if we have not exceeded maxProperties yet


  if (schema.maxProperties !== undefined) {
    return Object.keys(formData).length < schema.maxProperties;
  }

  return true;
}
export function getDefaultRegistry() {
  return {
    fields: fields,
    widgets: widgets,
    definitions: {},
    rootSchema: {},
    formContext: {}
  };
}
/* Gets the type of a given schema. */

export function getSchemaType(schema) {
  var type = schema.type;

  if (!type && schema["const"]) {
    return guessType(schema["const"]);
  }

  if (!type && schema["enum"]) {
    return "string";
  }

  if (!type && (schema.properties || schema.additionalProperties)) {
    return "object";
  }

  if (type instanceof Array && type.length === 2 && type.includes("null")) {
    return type.find(function (type) {
      return type !== "null";
    });
  }

  return type;
}
export function getWidget(schema, widget) {
  var registeredWidgets = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var type = getSchemaType(schema);

  function mergeOptions(Widget) {
    // cache return value as property of widget for proper react reconciliation
    if (!Widget.MergedWidget) {
      var defaultOptions = Widget.defaultProps && Widget.defaultProps.options || {};

      Widget.MergedWidget = function (_ref) {
        var _ref$options = _ref.options,
            options = _ref$options === void 0 ? {} : _ref$options,
            props = _objectWithoutProperties(_ref, ["options"]);

        return React.createElement(Widget, _extends({
          options: _objectSpread({}, defaultOptions, options)
        }, props));
      };
    }

    return Widget.MergedWidget;
  }

  if (typeof widget === "function" || ReactIs.isForwardRef(React.createElement(widget)) || ReactIs.isMemo(widget)) {
    return mergeOptions(widget);
  }

  if (typeof widget !== "string") {
    throw new Error("Unsupported widget definition: ".concat(_typeof(widget)));
  }

  if (registeredWidgets.hasOwnProperty(widget)) {
    var registeredWidget = registeredWidgets[widget];
    return getWidget(schema, registeredWidget, registeredWidgets);
  }

  if (!widgetMap.hasOwnProperty(type)) {
    throw new Error("No widget for type \"".concat(type, "\""));
  }

  if (widgetMap[type].hasOwnProperty(widget)) {
    var _registeredWidget = registeredWidgets[widgetMap[type][widget]];
    return getWidget(schema, _registeredWidget, registeredWidgets);
  }

  throw new Error("No widget \"".concat(widget, "\" for type \"").concat(type, "\""));
}
export function hasWidget(schema, widget) {
  var registeredWidgets = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  try {
    getWidget(schema, widget, registeredWidgets);
    return true;
  } catch (e) {
    if (e.message && (e.message.startsWith("No widget") || e.message.startsWith("Unsupported widget"))) {
      return false;
    }

    throw e;
  }
}

function computeDefaults(_schema, parentDefaults, rootSchema) {
  var rawFormData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var includeUndefinedValues = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
  var schema = isObject(_schema) ? _schema : {};
  var formData = isObject(rawFormData) ? rawFormData : {}; // Compute the defaults recursively: give highest priority to deepest nodes.

  var defaults = parentDefaults;

  if (isObject(defaults) && isObject(schema["default"])) {
    // For object defaults, only override parent defaults that are defined in
    // schema.default.
    defaults = mergeObjects(defaults, schema["default"]);
  } else if ("default" in schema) {
    // Use schema defaults for this node.
    defaults = schema["default"];
  } else if ("$ref" in schema) {
    // Use referenced schema defaults for this node.
    var refSchema = findSchemaDefinition(schema.$ref, rootSchema);
    return computeDefaults(refSchema, defaults, rootSchema, formData, includeUndefinedValues);
  } else if ("dependencies" in schema) {
    var resolvedSchema = resolveDependencies(schema, rootSchema, formData);
    return computeDefaults(resolvedSchema, defaults, rootSchema, formData, includeUndefinedValues);
  } else if (isFixedItems(schema)) {
    defaults = schema.items.map(function (itemSchema, idx) {
      return computeDefaults(itemSchema, Array.isArray(parentDefaults) ? parentDefaults[idx] : undefined, rootSchema, formData, includeUndefinedValues);
    });
  } else if ("oneOf" in schema) {
    schema = schema.oneOf[getMatchingOption(undefined, schema.oneOf, rootSchema)];
  } else if ("anyOf" in schema) {
    schema = schema.anyOf[getMatchingOption(undefined, schema.anyOf, rootSchema)];
  } // Not defaults defined for this node, fallback to generic typed ones.


  if (typeof defaults === "undefined") {
    defaults = schema["default"];
  }

  switch (getSchemaType(schema)) {
    // We need to recur for object schema inner default values.
    case "object":
      return Object.keys(schema.properties || {}).reduce(function (acc, key) {
        // Compute the defaults for this node, with the parent defaults we might
        // have from a previous run: defaults[key].
        var computedDefault = computeDefaults(schema.properties[key], (defaults || {})[key], rootSchema, (formData || {})[key], includeUndefinedValues);

        if (includeUndefinedValues || computedDefault !== undefined) {
          acc[key] = computedDefault;
        }

        return acc;
      }, {});

    case "array":
      // Inject defaults into existing array defaults
      if (Array.isArray(defaults)) {
        defaults = defaults.map(function (item, idx) {
          return computeDefaults(schema.items[idx] || schema.additionalItems || {}, item, rootSchema);
        });
      } // Deeply inject defaults into already existing form data


      if (Array.isArray(rawFormData)) {
        defaults = rawFormData.map(function (item, idx) {
          return computeDefaults(schema.items, (defaults || {})[idx], rootSchema, item);
        });
      }

      if (schema.minItems) {
        if (!isMultiSelect(schema, rootSchema)) {
          var defaultsLength = defaults ? defaults.length : 0;

          if (schema.minItems > defaultsLength) {
            var defaultEntries = defaults || []; // populate the array with the defaults

            var fillerSchema = Array.isArray(schema.items) ? schema.additionalItems : schema.items;
            var fillerEntries = fill(new Array(schema.minItems - defaultsLength), computeDefaults(fillerSchema, fillerSchema.defaults, rootSchema)); // then fill up the rest with either the item default or empty, up to minItems

            return defaultEntries.concat(fillerEntries);
          }
        } else {
          return defaults ? defaults : [];
        }
      }

  }

  return defaults;
}

export function getDefaultFormState(_schema, formData) {
  var rootSchema = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var includeUndefinedValues = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  if (!isObject(_schema)) {
    throw new Error("Invalid schema: " + _schema);
  }

  var schema = retrieveSchema(_schema, rootSchema, formData);
  var defaults = computeDefaults(schema, _schema["default"], rootSchema, formData, includeUndefinedValues);

  if (typeof formData === "undefined") {
    // No form data? Use schema defaults.
    return defaults;
  }

  if (isObject(formData) || Array.isArray(formData)) {
    return mergeDefaultsWithFormData(defaults, formData);
  }

  if (formData === 0 || formData === false || formData === "") {
    return formData;
  }

  return formData || defaults;
}
/**
 * When merging defaults and form data, we want to merge in this specific way:
 * - objects are deeply merged
 * - arrays are merged in such a way that:
 *   - when the array is set in form data, only array entries set in form data
 *     are deeply merged; additional entries from the defaults are ignored
 *   - when the array is not set in form data, the default is copied over
 * - scalars are overwritten/set by form data
 */

export function mergeDefaultsWithFormData(defaults, formData) {
  if (Array.isArray(formData)) {
    if (!Array.isArray(defaults)) {
      defaults = [];
    }

    return formData.map(function (value, idx) {
      if (defaults[idx]) {
        return mergeDefaultsWithFormData(defaults[idx], value);
      }

      return value;
    });
  } else if (isObject(formData)) {
    var acc = Object.assign({}, defaults); // Prevent mutation of source object.

    return Object.keys(formData).reduce(function (acc, key) {
      acc[key] = mergeDefaultsWithFormData(defaults ? defaults[key] : {}, formData[key]);
      return acc;
    }, acc);
  } else {
    return formData;
  }
}
export function getUiOptions(uiSchema) {
  // get all passed options from ui:widget, ui:options, and ui:<optionName>
  return Object.keys(uiSchema).filter(function (key) {
    return key.indexOf("ui:") === 0;
  }).reduce(function (options, key) {
    var value = uiSchema[key];

    if (key === "ui:widget" && isObject(value)) {
      console.warn("Setting options via ui:widget object is deprecated, use ui:options instead");
      return _objectSpread({}, options, value.options || {}, {
        widget: value.component
      });
    }

    if (key === "ui:options" && isObject(value)) {
      return _objectSpread({}, options, value);
    }

    return _objectSpread({}, options, _defineProperty({}, key.substring(3), value));
  }, {});
}
export function getSubmitButtonOptions(uiSchema) {
  var uiOptions = getUiOptions(uiSchema);
  var defaultOptions = {
    props: {
      disabled: false
    },
    submitText: "Submit",
    norender: false
  };

  if (uiOptions && uiOptions["submitButtonOptions"]) {
    return Object.assign({}, defaultOptions, uiOptions["submitButtonOptions"]);
  }

  return defaultOptions;
}
export function getDisplayLabel(schema, uiSchema, rootSchema) {
  var uiOptions = getUiOptions(uiSchema);
  var _uiOptions$label = uiOptions.label,
      displayLabel = _uiOptions$label === void 0 ? true : _uiOptions$label;
  var schemaType = getSchemaType(schema);

  if (schemaType === "array") {
    displayLabel = isMultiSelect(schema, rootSchema) || isFilesArray(schema, uiSchema, rootSchema) || isCustomWidget(uiSchema);
  }

  if (schemaType === "object") {
    displayLabel = false;
  }

  if (schemaType === "boolean" && !uiSchema["ui:widget"]) {
    displayLabel = false;
  }

  if (uiSchema["ui:field"]) {
    displayLabel = false;
  }

  return displayLabel;
}
export function isObject(thing) {
  if (typeof File !== "undefined" && thing instanceof File) {
    return false;
  }

  return _typeof(thing) === "object" && thing !== null && !Array.isArray(thing);
}
export function mergeObjects(obj1, obj2) {
  var concatArrays = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  // Recursively merge deeply nested objects.
  var acc = Object.assign({}, obj1); // Prevent mutation of source object.

  return Object.keys(obj2).reduce(function (acc, key) {
    var left = obj1 ? obj1[key] : {},
        right = obj2[key];

    if (obj1 && obj1.hasOwnProperty(key) && isObject(right)) {
      acc[key] = mergeObjects(left, right, concatArrays);
    } else if (concatArrays && Array.isArray(left) && Array.isArray(right)) {
      acc[key] = left.concat(right);
    } else {
      acc[key] = right;
    }

    return acc;
  }, acc);
}
export function asNumber(value) {
  if (value === "") {
    return undefined;
  }

  if (value === null) {
    return null;
  }

  if (/\.$/.test(value)) {
    // "3." can't really be considered a number even if it parses in js. The
    // user is most likely entering a float.
    return value;
  }

  if (/\.0$/.test(value)) {
    // we need to return this as a string here, to allow for input like 3.07
    return value;
  }

  var n = Number(value);
  var valid = typeof n === "number" && !Number.isNaN(n);

  if (/\.\d*0$/.test(value)) {
    // It's a number, that's cool - but we need it as a string so it doesn't screw
    // with the user when entering dollar amounts or other values (such as those with
    // specific precision or number of significant digits)
    return value;
  }

  return valid ? n : value;
}
export function orderProperties(properties, order) {
  if (!Array.isArray(order)) {
    return properties;
  }

  var arrayToHash = function arrayToHash(arr) {
    return arr.reduce(function (prev, curr) {
      prev[curr] = true;
      return prev;
    }, {});
  };

  var errorPropList = function errorPropList(arr) {
    return arr.length > 1 ? "properties '".concat(arr.join("', '"), "'") : "property '".concat(arr[0], "'");
  };

  var propertyHash = arrayToHash(properties);
  var orderFiltered = order.filter(function (prop) {
    return prop === "*" || propertyHash[prop];
  });
  var orderHash = arrayToHash(orderFiltered);
  var rest = properties.filter(function (prop) {
    return !orderHash[prop];
  });
  var restIndex = orderFiltered.indexOf("*");

  if (restIndex === -1) {
    if (rest.length) {
      throw new Error("uiSchema order list does not contain ".concat(errorPropList(rest)));
    }

    return orderFiltered;
  }

  if (restIndex !== orderFiltered.lastIndexOf("*")) {
    throw new Error("uiSchema order list contains more than one wildcard item");
  }

  var complete = _toConsumableArray(orderFiltered);

  complete.splice.apply(complete, [restIndex, 1].concat(_toConsumableArray(rest)));
  return complete;
}
/**
 * This function checks if the given schema matches a single
 * constant value.
 */

export function isConstant(schema) {
  return Array.isArray(schema["enum"]) && schema["enum"].length === 1 || schema.hasOwnProperty("const");
}
export function toConstant(schema) {
  if (Array.isArray(schema["enum"]) && schema["enum"].length === 1) {
    return schema["enum"][0];
  } else if (schema.hasOwnProperty("const")) {
    return schema["const"];
  } else {
    throw new Error("schema cannot be inferred as a constant");
  }
}
export function isSelect(_schema) {
  var rootSchema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var schema = retrieveSchema(_schema, rootSchema);
  var altSchemas = schema.oneOf || schema.anyOf;

  if (Array.isArray(schema["enum"])) {
    return true;
  } else if (Array.isArray(altSchemas)) {
    return altSchemas.every(function (altSchemas) {
      return isConstant(altSchemas);
    });
  }

  return false;
}
export function isMultiSelect(schema) {
  var rootSchema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (!schema.uniqueItems || !schema.items) {
    return false;
  }

  return isSelect(schema.items, rootSchema);
}
export function isFilesArray(schema, uiSchema) {
  var rootSchema = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  if (uiSchema["ui:widget"] === "files") {
    return true;
  } else if (schema.items) {
    var itemsSchema = retrieveSchema(schema.items, rootSchema);
    return itemsSchema.type === "string" && itemsSchema.format === "data-url";
  }

  return false;
}
export function isFixedItems(schema) {
  return Array.isArray(schema.items) && schema.items.length > 0 && schema.items.every(function (item) {
    return isObject(item);
  });
}
export function isCustomWidget(uiSchema) {
  return (// TODO: Remove the `&& uiSchema["ui:widget"] !== "hidden"` once we support hidden widgets for arrays.
    // https://react-jsonschema-form.readthedocs.io/en/latest/usage/widgets/#hidden-widgets
    "widget" in getUiOptions(uiSchema) && getUiOptions(uiSchema)["widget"] !== "hidden"
  );
}
export function allowAdditionalItems(schema) {
  if (schema.additionalItems === true) {
    console.warn("additionalItems=true is currently not supported");
  }

  return isObject(schema.additionalItems);
}
export function optionsList(schema) {
  if (schema["enum"]) {
    return schema["enum"].map(function (value, i) {
      var label = schema.enumNames && schema.enumNames[i] || String(value);
      return {
        label: label,
        value: value
      };
    });
  } else {
    var altSchemas = schema.oneOf || schema.anyOf;
    return altSchemas.map(function (schema) {
      var value = toConstant(schema);
      var label = schema.title || String(value);
      return {
        schema: schema,
        label: label,
        value: value
      };
    });
  }
}
export function findSchemaDefinition($ref) {
  var rootSchema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var origRef = $ref;

  if ($ref.startsWith("#")) {
    // Decode URI fragment representation.
    $ref = decodeURIComponent($ref.substring(1));
  } else {
    throw new Error("Could not find a definition for ".concat(origRef, "."));
  }

  var current = jsonpointer.get(rootSchema, $ref);

  if (current === undefined) {
    throw new Error("Could not find a definition for ".concat(origRef, "."));
  }

  if (current.hasOwnProperty("$ref")) {
    return findSchemaDefinition(current.$ref, rootSchema);
  }

  return current;
} // In the case where we have to implicitly create a schema, it is useful to know what type to use
//  based on the data we are defining

export var guessType = function guessType(value) {
  if (Array.isArray(value)) {
    return "array";
  } else if (typeof value === "string") {
    return "string";
  } else if (value == null) {
    return "null";
  } else if (typeof value === "boolean") {
    return "boolean";
  } else if (!isNaN(value)) {
    return "number";
  } else if (_typeof(value) === "object") {
    return "object";
  } // Default to string if we can't figure it out


  return "string";
}; // This function will create new "properties" items for each key in our formData

export function stubExistingAdditionalProperties(schema) {
  var rootSchema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var formData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  // Clone the schema so we don't ruin the consumer's original
  schema = _objectSpread({}, schema, {
    properties: _objectSpread({}, schema.properties)
  }); // make sure formData is an object

  formData = isObject(formData) ? formData : {};
  Object.keys(formData).forEach(function (key) {
    if (schema.properties.hasOwnProperty(key)) {
      // No need to stub, our schema already has the property
      return;
    }

    var additionalProperties;

    if (schema.additionalProperties.hasOwnProperty("$ref")) {
      additionalProperties = retrieveSchema({
        $ref: schema.additionalProperties["$ref"]
      }, rootSchema, formData);
    } else if (schema.additionalProperties.hasOwnProperty("type")) {
      additionalProperties = _objectSpread({}, schema.additionalProperties);
    } else {
      additionalProperties = {
        type: guessType(formData[key])
      };
    } // The type of our new key should match the additionalProperties value;


    schema.properties[key] = additionalProperties; // Set our additional property flag so we know it was dynamically added

    schema.properties[key][ADDITIONAL_PROPERTY_FLAG] = true;
  });
  return schema;
}
/**
 * Resolves a conditional block (if/else/then) by removing the condition and merging the appropriate conditional branch with the rest of the schema
 */

var resolveCondition = function resolveCondition(schema, rootSchema, formData) {
  var expression = schema["if"],
      then = schema.then,
      otherwise = schema["else"],
      resolvedSchemaLessConditional = _objectWithoutProperties(schema, ["if", "then", "else"]);

  var conditionalSchema = isValid(expression, formData, rootSchema) ? then : otherwise;

  if (conditionalSchema) {
    return retrieveSchema(mergeSchemas(resolvedSchemaLessConditional, retrieveSchema(conditionalSchema, rootSchema, formData)), rootSchema, formData);
  } else {
    return retrieveSchema(resolvedSchemaLessConditional, rootSchema, formData);
  }
};
/**
 * Resolves references and dependencies within a schema and its 'allOf' children.
 *
 * Called internally by retrieveSchema.
 */


export function resolveSchema(schema) {
  var rootSchema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var formData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  if (schema.hasOwnProperty("$ref")) {
    return resolveReference(schema, rootSchema, formData);
  } else if (schema.hasOwnProperty("dependencies")) {
    var resolvedSchema = resolveDependencies(schema, rootSchema, formData);
    return retrieveSchema(resolvedSchema, rootSchema, formData);
  } else if (schema.hasOwnProperty("allOf")) {
    return _objectSpread({}, schema, {
      allOf: schema.allOf.map(function (allOfSubschema) {
        return retrieveSchema(allOfSubschema, rootSchema, formData);
      })
    });
  } else {
    // No $ref or dependencies attribute found, returning the original schema.
    return schema;
  }
}

function resolveReference(schema, rootSchema, formData) {
  // Retrieve the referenced schema definition.
  var $refSchema = findSchemaDefinition(schema.$ref, rootSchema); // Drop the $ref property of the source schema.

  var $ref = schema.$ref,
      localSchema = _objectWithoutProperties(schema, ["$ref"]); // Update referenced schema definition with local schema properties.


  return retrieveSchema(_objectSpread({}, $refSchema, localSchema), rootSchema, formData);
}

export function retrieveSchema(schema) {
  var rootSchema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var formData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  if (!isObject(schema)) {
    return {};
  }

  var resolvedSchema = resolveSchema(schema, rootSchema, formData);

  if (schema.hasOwnProperty("if")) {
    return resolveCondition(schema, rootSchema, formData);
  } // For each level of the dependency, we need to recursively determine the appropriate resolved schema given the current state of formData.
  // Otherwise, nested allOf subschemas will not be correctly displayed.


  if (resolvedSchema.properties) {
    var properties = {};
    Object.entries(resolvedSchema.properties).forEach(function (entries) {
      var propName = entries[0];
      var propSchema = entries[1];
      var rawPropData = formData && formData[propName];
      var propData = isObject(rawPropData) ? rawPropData : {};
      var resolvedPropSchema = retrieveSchema(propSchema, rootSchema, propData);
      properties[propName] = resolvedPropSchema;

      if (propSchema !== resolvedPropSchema && resolvedSchema.properties !== properties) {
        resolvedSchema = _objectSpread({}, resolvedSchema, {
          properties: properties
        });
      }
    });
  }

  if ("allOf" in schema) {
    try {
      resolvedSchema = mergeAllOf(_objectSpread({}, resolvedSchema, {
        allOf: resolvedSchema.allOf
      }));
    } catch (e) {
      console.warn("could not merge subschemas in allOf:\n" + e);

      var _resolvedSchema = resolvedSchema,
          allOf = _resolvedSchema.allOf,
          resolvedSchemaWithoutAllOf = _objectWithoutProperties(_resolvedSchema, ["allOf"]);

      return resolvedSchemaWithoutAllOf;
    }
  }

  var hasAdditionalProperties = resolvedSchema.hasOwnProperty("additionalProperties") && resolvedSchema.additionalProperties !== false;

  if (hasAdditionalProperties) {
    return stubExistingAdditionalProperties(resolvedSchema, rootSchema, formData);
  }

  return resolvedSchema;
}

function resolveDependencies(schema, rootSchema, formData) {
  // Drop the dependencies from the source schema.
  var _schema$dependencies = schema.dependencies,
      dependencies = _schema$dependencies === void 0 ? {} : _schema$dependencies,
      resolvedSchema = _objectWithoutProperties(schema, ["dependencies"]);

  if ("oneOf" in resolvedSchema) {
    resolvedSchema = resolvedSchema.oneOf[getMatchingOption(formData, resolvedSchema.oneOf, rootSchema)];
  } else if ("anyOf" in resolvedSchema) {
    resolvedSchema = resolvedSchema.anyOf[getMatchingOption(formData, resolvedSchema.anyOf, rootSchema)];
  }

  return processDependencies(dependencies, resolvedSchema, rootSchema, formData);
}

function processDependencies(dependencies, resolvedSchema, rootSchema, formData) {
  // Process dependencies updating the local schema properties as appropriate.
  for (var dependencyKey in dependencies) {
    // Skip this dependency if its trigger property is not present.
    if (formData[dependencyKey] === undefined) {
      continue;
    } // Skip this dependency if it is not included in the schema (such as when dependencyKey is itself a hidden dependency.)


    if (resolvedSchema.properties && !(dependencyKey in resolvedSchema.properties)) {
      continue;
    }

    var dependencyValue = dependencies[dependencyKey],
        remainingDependencies = _objectWithoutProperties(dependencies, [dependencyKey].map(_toPropertyKey));

    if (Array.isArray(dependencyValue)) {
      resolvedSchema = withDependentProperties(resolvedSchema, dependencyValue);
    } else if (isObject(dependencyValue)) {
      resolvedSchema = withDependentSchema(resolvedSchema, rootSchema, formData, dependencyKey, dependencyValue);
    }

    return processDependencies(remainingDependencies, resolvedSchema, rootSchema, formData);
  }

  return resolvedSchema;
}

function withDependentProperties(schema, additionallyRequired) {
  if (!additionallyRequired) {
    return schema;
  }

  var required = Array.isArray(schema.required) ? Array.from(new Set([].concat(_toConsumableArray(schema.required), _toConsumableArray(additionallyRequired)))) : additionallyRequired;
  return _objectSpread({}, schema, {
    required: required
  });
}

function withDependentSchema(schema, rootSchema, formData, dependencyKey, dependencyValue) {
  var _retrieveSchema = retrieveSchema(dependencyValue, rootSchema, formData),
      oneOf = _retrieveSchema.oneOf,
      dependentSchema = _objectWithoutProperties(_retrieveSchema, ["oneOf"]);

  schema = mergeSchemas(schema, dependentSchema); // Since it does not contain oneOf, we return the original schema.

  if (oneOf === undefined) {
    return schema;
  } else if (!Array.isArray(oneOf)) {
    throw new Error("invalid: it is some ".concat(_typeof(oneOf), " instead of an array"));
  } // Resolve $refs inside oneOf.


  var resolvedOneOf = oneOf.map(function (subschema) {
    return subschema.hasOwnProperty("$ref") ? resolveReference(subschema, rootSchema, formData) : subschema;
  });
  return withExactlyOneSubschema(schema, rootSchema, formData, dependencyKey, resolvedOneOf);
}

function withExactlyOneSubschema(schema, rootSchema, formData, dependencyKey, oneOf) {
  var validSubschemas = oneOf.filter(function (subschema) {
    if (!subschema.properties) {
      return false;
    }

    var conditionPropertySchema = subschema.properties[dependencyKey];

    if (conditionPropertySchema) {
      var conditionSchema = {
        type: "object",
        properties: _defineProperty({}, dependencyKey, conditionPropertySchema)
      };

      var _validateFormData = validateFormData(formData, conditionSchema),
          errors = _validateFormData.errors;

      return errors.length === 0;
    }
  });

  if (validSubschemas.length !== 1) {
    console.warn("ignoring oneOf in dependencies because there isn't exactly one subschema that is valid");
    return schema;
  }

  var subschema = validSubschemas[0];

  var _subschema$properties = subschema.properties,
      conditionPropertySchema = _subschema$properties[dependencyKey],
      dependentSubschema = _objectWithoutProperties(_subschema$properties, [dependencyKey].map(_toPropertyKey));

  var dependentSchema = _objectSpread({}, subschema, {
    properties: dependentSubschema
  });

  return mergeSchemas(schema, retrieveSchema(dependentSchema, rootSchema, formData));
} // Recursively merge deeply nested schemas.
// The difference between mergeSchemas and mergeObjects
// is that mergeSchemas only concats arrays for
// values under the "required" keyword, and when it does,
// it doesn't include duplicate values.


export function mergeSchemas(obj1, obj2) {
  var acc = Object.assign({}, obj1); // Prevent mutation of source object.

  return Object.keys(obj2).reduce(function (acc, key) {
    var left = obj1 ? obj1[key] : {},
        right = obj2[key];

    if (obj1 && obj1.hasOwnProperty(key) && isObject(right)) {
      acc[key] = mergeSchemas(left, right);
    } else if (obj1 && obj2 && (getSchemaType(obj1) === "object" || getSchemaType(obj2) === "object") && key === "required" && Array.isArray(left) && Array.isArray(right)) {
      // Don't include duplicate values when merging
      // "required" fields.
      acc[key] = union(left, right);
    } else {
      acc[key] = right;
    }

    return acc;
  }, acc);
}

function isArguments(object) {
  return Object.prototype.toString.call(object) === "[object Arguments]";
}

export function deepEquals(a, b) {
  var ca = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var cb = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];

  // Partially extracted from node-deeper and adapted to exclude comparison
  // checks for functions.
  // https://github.com/othiym23/node-deeper
  if (a === b) {
    return true;
  } else if (typeof a === "function" || typeof b === "function") {
    // Assume all functions are equivalent
    // see https://github.com/rjsf-team/react-jsonschema-form/issues/255
    return true;
  } else if (_typeof(a) !== "object" || _typeof(b) !== "object") {
    return false;
  } else if (a === null || b === null) {
    return false;
  } else if (a instanceof Date && b instanceof Date) {
    return a.getTime() === b.getTime();
  } else if (a instanceof RegExp && b instanceof RegExp) {
    return a.source === b.source && a.global === b.global && a.multiline === b.multiline && a.lastIndex === b.lastIndex && a.ignoreCase === b.ignoreCase;
  } else if (isArguments(a) || isArguments(b)) {
    if (!(isArguments(a) && isArguments(b))) {
      return false;
    }

    var slice = Array.prototype.slice;
    return deepEquals(slice.call(a), slice.call(b), ca, cb);
  } else {
    if (a.constructor !== b.constructor) {
      return false;
    }

    var ka = Object.keys(a);
    var kb = Object.keys(b); // don't bother with stack acrobatics if there's nothing there

    if (ka.length === 0 && kb.length === 0) {
      return true;
    }

    if (ka.length !== kb.length) {
      return false;
    }

    var cal = ca.length;

    while (cal--) {
      if (ca[cal] === a) {
        return cb[cal] === b;
      }
    }

    ca.push(a);
    cb.push(b);
    ka.sort();
    kb.sort();

    for (var j = ka.length - 1; j >= 0; j--) {
      if (ka[j] !== kb[j]) {
        return false;
      }
    }

    var _key;

    for (var k = ka.length - 1; k >= 0; k--) {
      _key = ka[k];

      if (!deepEquals(a[_key], b[_key], ca, cb)) {
        return false;
      }
    }

    ca.pop();
    cb.pop();
    return true;
  }
}
export function shouldRender(comp, nextProps, nextState) {
  var props = comp.props,
      state = comp.state;
  return !deepEquals(props, nextProps) || !deepEquals(state, nextState);
}
export function toIdSchema(schema, id, rootSchema) {
  var formData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var idPrefix = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : "root";
  var idSeparator = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "_";
  var idSchema = {
    $id: id || idPrefix
  };

  if ("$ref" in schema || "dependencies" in schema || "allOf" in schema) {
    var _schema = retrieveSchema(schema, rootSchema, formData);

    return toIdSchema(_schema, id, rootSchema, formData, idPrefix, idSeparator);
  }

  if ("items" in schema && !schema.items.$ref) {
    return toIdSchema(schema.items, id, rootSchema, formData, idPrefix, idSeparator);
  }

  if (schema.type !== "object") {
    return idSchema;
  }

  for (var name in schema.properties || {}) {
    var field = schema.properties[name];
    var fieldId = idSchema.$id + idSeparator + name;
    idSchema[name] = toIdSchema(isObject(field) ? field : {}, fieldId, rootSchema, // It's possible that formData is not an object -- this can happen if an
    // array item has just been added, but not populated with data yet
    (formData || {})[name], idPrefix, idSeparator);
  }

  return idSchema;
}
export function toPathSchema(schema) {
  var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
  var rootSchema = arguments.length > 2 ? arguments[2] : undefined;
  var formData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var pathSchema = {
    $name: name.replace(/^\./, "")
  };

  if ("$ref" in schema || "dependencies" in schema || "allOf" in schema) {
    var _schema = retrieveSchema(schema, rootSchema, formData);

    return toPathSchema(_schema, name, rootSchema, formData);
  }

  if (schema.hasOwnProperty("additionalProperties")) {
    pathSchema.__rjsf_additionalProperties = true;
  }

  if (schema.hasOwnProperty("items") && Array.isArray(formData)) {
    formData.forEach(function (element, i) {
      pathSchema[i] = toPathSchema(schema.items, "".concat(name, ".").concat(i), rootSchema, element);
    });
  } else if (schema.hasOwnProperty("properties")) {
    for (var property in schema.properties) {
      pathSchema[property] = toPathSchema(schema.properties[property], "".concat(name, ".").concat(property), rootSchema, // It's possible that formData is not an object -- this can happen if an
      // array item has just been added, but not populated with data yet
      (formData || {})[property]);
    }
  }

  return pathSchema;
}
export function parseDateString(dateString) {
  var includeTime = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

  if (!dateString) {
    return {
      year: -1,
      month: -1,
      day: -1,
      hour: includeTime ? -1 : 0,
      minute: includeTime ? -1 : 0,
      second: includeTime ? -1 : 0
    };
  }

  var date = new Date(dateString);

  if (Number.isNaN(date.getTime())) {
    throw new Error("Unable to parse date " + dateString);
  }

  return {
    year: date.getUTCFullYear(),
    month: date.getUTCMonth() + 1,
    // oh you, javascript.
    day: date.getUTCDate(),
    hour: includeTime ? date.getUTCHours() : 0,
    minute: includeTime ? date.getUTCMinutes() : 0,
    second: includeTime ? date.getUTCSeconds() : 0
  };
}
export function toDateString(_ref2) {
  var year = _ref2.year,
      month = _ref2.month,
      day = _ref2.day,
      _ref2$hour = _ref2.hour,
      hour = _ref2$hour === void 0 ? 0 : _ref2$hour,
      _ref2$minute = _ref2.minute,
      minute = _ref2$minute === void 0 ? 0 : _ref2$minute,
      _ref2$second = _ref2.second,
      second = _ref2$second === void 0 ? 0 : _ref2$second;
  var time = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  var utcTime = Date.UTC(year, month - 1, day, hour, minute, second);
  var datetime = new Date(utcTime).toJSON();
  return time ? datetime : datetime.slice(0, 10);
}
export function utcToLocal(jsonDate) {
  if (!jsonDate) {
    return "";
  } // required format of `"yyyy-MM-ddThh:mm" followed by optional ":ss" or ":ss.SSS"
  // https://html.spec.whatwg.org/multipage/input.html#local-date-and-time-state-(type%3Ddatetime-local)
  // > should be a _valid local date and time string_ (not GMT)
  // Note - date constructor passed local ISO-8601 does not correctly
  // change time to UTC in node pre-8


  var date = new Date(jsonDate);
  var yyyy = pad(date.getFullYear(), 4);
  var MM = pad(date.getMonth() + 1, 2);
  var dd = pad(date.getDate(), 2);
  var hh = pad(date.getHours(), 2);
  var mm = pad(date.getMinutes(), 2);
  var ss = pad(date.getSeconds(), 2);
  var SSS = pad(date.getMilliseconds(), 3);
  return "".concat(yyyy, "-").concat(MM, "-").concat(dd, "T").concat(hh, ":").concat(mm, ":").concat(ss, ".").concat(SSS);
}
export function localToUTC(dateString) {
  if (dateString) {
    return new Date(dateString).toJSON();
  }
}
export function pad(num, size) {
  var s = String(num);

  while (s.length < size) {
    s = "0" + s;
  }

  return s;
}
export function dataURItoBlob(dataURI) {
  // Split metadata from data
  var splitted = dataURI.split(","); // Split params

  var params = splitted[0].split(";"); // Get mime-type from params

  var type = params[0].replace("data:", ""); // Filter the name property from params

  var properties = params.filter(function (param) {
    return param.split("=")[0] === "name";
  }); // Look for the name and use unknown if no name property.

  var name;

  if (properties.length !== 1) {
    name = "unknown";
  } else {
    // Because we filtered out the other property,
    // we only have the name case here.
    name = properties[0].split("=")[1];
  } // Built the Uint8Array Blob parameter from the base64 string.


  var binary = atob(splitted[1]);
  var array = [];

  for (var _i = 0; _i < binary.length; _i++) {
    array.push(binary.charCodeAt(_i));
  } // Create the blob object


  var blob = new window.Blob([new Uint8Array(array)], {
    type: type
  });
  return {
    blob: blob,
    name: name
  };
}
export function rangeSpec(schema) {
  var spec = {};

  if (schema.multipleOf) {
    spec.step = schema.multipleOf;
  }

  if (schema.minimum || schema.minimum === 0) {
    spec.min = schema.minimum;
  }

  if (schema.maximum || schema.maximum === 0) {
    spec.max = schema.maximum;
  }

  return spec;
}
export function getMatchingOption(formData, options, rootSchema) {
  // For performance, skip validating subschemas if formData is undefined. We just
  // want to get the first option in that case.
  if (formData === undefined) {
    return 0;
  }

  for (var _i2 = 0; _i2 < options.length; _i2++) {
    var option = options[_i2]; // If the schema describes an object then we need to add slightly more
    // strict matching to the schema, because unless the schema uses the
    // "requires" keyword, an object will match the schema as long as it
    // doesn't have matching keys with a conflicting type. To do this we use an
    // "anyOf" with an array of requires. This augmentation expresses that the
    // schema should match if any of the keys in the schema are present on the
    // object and pass validation.

    if (option.properties) {
      // Create an "anyOf" schema that requires at least one of the keys in the
      // "properties" object
      var requiresAnyOf = {
        anyOf: Object.keys(option.properties).map(function (key) {
          return {
            required: [key]
          };
        })
      };
      var augmentedSchema = void 0; // If the "anyOf" keyword already exists, wrap the augmentation in an "allOf"

      if (option.anyOf) {
        // Create a shallow clone of the option
        var shallowClone = _extends({}, option);

        if (!shallowClone.allOf) {
          shallowClone.allOf = [];
        } else {
          // If "allOf" already exists, shallow clone the array
          shallowClone.allOf = shallowClone.allOf.slice();
        }

        shallowClone.allOf.push(requiresAnyOf);
        augmentedSchema = shallowClone;
      } else {
        augmentedSchema = Object.assign({}, option, requiresAnyOf);
      } // Remove the "required" field as it's likely that not all fields have
      // been filled in yet, which will mean that the schema is not valid


      delete augmentedSchema.required;

      if (isValid(augmentedSchema, formData, rootSchema)) {
        return _i2;
      }
    } else if (isValid(option, formData, rootSchema)) {
      return _i2;
    }
  }

  return 0;
} // Check to see if a schema specifies that a value must be true

export function schemaRequiresTrueValue(schema) {
  // Check if const is a truthy value
  if (schema["const"]) {
    return true;
  } // Check if an enum has a single value of true


  if (schema["enum"] && schema["enum"].length === 1 && schema["enum"][0] === true) {
    return true;
  } // If anyOf has a single value, evaluate the subschema


  if (schema.anyOf && schema.anyOf.length === 1) {
    return schemaRequiresTrueValue(schema.anyOf[0]);
  } // If oneOf has a single value, evaluate the subschema


  if (schema.oneOf && schema.oneOf.length === 1) {
    return schemaRequiresTrueValue(schema.oneOf[0]);
  } // Evaluate each subschema in allOf, to see if one of them requires a true
  // value


  if (schema.allOf) {
    return schema.allOf.some(schemaRequiresTrueValue);
  }

  return false;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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