function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import AddButton from "../AddButton";
import React, { Component } from "react";
import * as types from "../../types";
import { orderProperties, retrieveSchema, getDefaultRegistry, canExpand, ADDITIONAL_PROPERTY_FLAG } from "../../utils";

function DefaultObjectFieldTemplate(props) {
  var TitleField = props.TitleField,
      DescriptionField = props.DescriptionField;
  return React.createElement("fieldset", {
    id: props.idSchema.$id
  }, (props.uiSchema["ui:title"] || props.title) && React.createElement(TitleField, {
    id: "".concat(props.idSchema.$id, "__title"),
    title: props.title || props.uiSchema["ui:title"],
    required: props.required,
    formContext: props.formContext
  }), props.description && React.createElement(DescriptionField, {
    id: "".concat(props.idSchema.$id, "__description"),
    description: props.description,
    formContext: props.formContext
  }), props.properties.map(function (prop) {
    return prop.content;
  }), canExpand(props.schema, props.uiSchema, props.formData) && React.createElement(AddButton, {
    className: "object-property-expand",
    onClick: props.onAddClick(props.schema),
    disabled: props.disabled || props.readonly
  }));
}

var ObjectField =
/*#__PURE__*/
function (_Component) {
  _inherits(ObjectField, _Component);

  function ObjectField() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, ObjectField);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ObjectField)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      wasPropertyKeyModified: false,
      additionalProperties: {}
    });

    _defineProperty(_assertThisInitialized(_this), "onPropertyChange", function (name) {
      var addedByAdditionalProperties = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      return function (value, errorSchema) {
        if (value === undefined && addedByAdditionalProperties) {
          // Don't set value = undefined for fields added by
          // additionalProperties. Doing so removes them from the
          // formData, which causes them to completely disappear
          // (including the input field for the property name). Unlike
          // fields which are "mandated" by the schema, these fields can
          // be set to undefined by clicking a "delete field" button, so
          // set empty values to the empty string.
          value = "";
        }

        var newFormData = _objectSpread({}, _this.props.formData, _defineProperty({}, name, value));

        _this.props.onChange(newFormData, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, name, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onDropPropertyClick", function (key) {
      return function (event) {
        event.preventDefault();
        var _this$props = _this.props,
            onChange = _this$props.onChange,
            formData = _this$props.formData;

        var copiedFormData = _objectSpread({}, formData);

        delete copiedFormData[key];
        onChange(copiedFormData);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getAvailableKey", function (preferredKey, formData) {
      var index = 0;
      var newKey = preferredKey;

      while (formData.hasOwnProperty(newKey)) {
        newKey = "".concat(preferredKey, "-").concat(++index);
      }

      return newKey;
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyChange", function (oldValue) {
      return function (value, errorSchema) {
        if (oldValue === value) {
          return;
        }

        value = _this.getAvailableKey(value, _this.props.formData);

        var newFormData = _objectSpread({}, _this.props.formData);

        var newKeys = _defineProperty({}, oldValue, value);

        var keyValues = Object.keys(newFormData).map(function (key) {
          var newKey = newKeys[key] || key;
          return _defineProperty({}, newKey, newFormData[key]);
        });
        var renamedObj = Object.assign.apply(Object, [{}].concat(_toConsumableArray(keyValues)));

        _this.setState({
          wasPropertyKeyModified: true
        });

        _this.props.onChange(renamedObj, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, value, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleAddClick", function (schema) {
      return function () {
        var type = schema.additionalProperties.type;

        var newFormData = _objectSpread({}, _this.props.formData);

        if (schema.additionalProperties.hasOwnProperty("$ref")) {
          var _this$props$registry = _this.props.registry,
              registry = _this$props$registry === void 0 ? getDefaultRegistry() : _this$props$registry;
          var refSchema = retrieveSchema({
            $ref: schema.additionalProperties["$ref"]
          }, registry.rootSchema, _this.props.formData);
          type = refSchema.type;
        }

        newFormData[_this.getAvailableKey("newKey", newFormData)] = _this.getDefaultValue(type);

        _this.props.onChange(newFormData);
      };
    });

    return _this;
  }

  _createClass(ObjectField, [{
    key: "isRequired",
    value: function isRequired(name) {
      var schema = this.props.schema;
      return Array.isArray(schema.required) && schema.required.indexOf(name) !== -1;
    }
  }, {
    key: "getDefaultValue",
    value: function getDefaultValue(type) {
      switch (type) {
        case "string":
          return "New Value";

        case "array":
          return [];

        case "boolean":
          return false;

        case "null":
          return null;

        case "number":
          return 0;

        case "object":
          return {};

        default:
          // We don't have a datatype for some reason (perhaps additionalProperties was true)
          return "New Value";
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          uiSchema = _this$props2.uiSchema,
          formData = _this$props2.formData,
          errorSchema = _this$props2.errorSchema,
          idSchema = _this$props2.idSchema,
          name = _this$props2.name,
          required = _this$props2.required,
          disabled = _this$props2.disabled,
          readonly = _this$props2.readonly,
          hideError = _this$props2.hideError,
          idPrefix = _this$props2.idPrefix,
          idSeparator = _this$props2.idSeparator,
          onBlur = _this$props2.onBlur,
          onFocus = _this$props2.onFocus,
          _this$props2$registry = _this$props2.registry,
          registry = _this$props2$registry === void 0 ? getDefaultRegistry() : _this$props2$registry;
      var rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var SchemaField = fields.SchemaField,
          TitleField = fields.TitleField,
          DescriptionField = fields.DescriptionField;
      var schema = retrieveSchema(this.props.schema, rootSchema, formData);
      var title = schema.title === undefined ? name : schema.title;
      var description = uiSchema["ui:description"] || schema.description;
      var orderedProperties;

      try {
        var properties = Object.keys(schema.properties || {});
        orderedProperties = orderProperties(properties, uiSchema["ui:order"]);
      } catch (err) {
        return React.createElement("div", null, React.createElement("p", {
          className: "config-error",
          style: {
            color: "red"
          }
        }, "Invalid ", name || "root", " object field configuration:", React.createElement("em", null, err.message), "."), React.createElement("pre", null, JSON.stringify(schema)));
      }

      var Template = uiSchema["ui:ObjectFieldTemplate"] || registry.ObjectFieldTemplate || DefaultObjectFieldTemplate;
      var templateProps = {
        title: uiSchema["ui:title"] || title,
        description: description,
        TitleField: TitleField,
        DescriptionField: DescriptionField,
        properties: orderedProperties.map(function (name) {
          var addedByAdditionalProperties = schema.properties[name].hasOwnProperty(ADDITIONAL_PROPERTY_FLAG);
          var fieldUiSchema = addedByAdditionalProperties ? uiSchema.additionalProperties : uiSchema[name];
          var hidden = fieldUiSchema && fieldUiSchema["ui:widget"] === "hidden";
          return {
            content: React.createElement(SchemaField, {
              key: name,
              name: name,
              required: _this2.isRequired(name),
              schema: schema.properties[name],
              uiSchema: fieldUiSchema,
              errorSchema: errorSchema[name],
              idSchema: idSchema[name],
              idPrefix: idPrefix,
              idSeparator: idSeparator,
              formData: (formData || {})[name],
              wasPropertyKeyModified: _this2.state.wasPropertyKeyModified,
              onKeyChange: _this2.onKeyChange(name),
              onChange: _this2.onPropertyChange(name, addedByAdditionalProperties),
              onBlur: onBlur,
              onFocus: onFocus,
              registry: registry,
              disabled: disabled,
              readonly: readonly,
              hideError: hideError,
              onDropPropertyClick: _this2.onDropPropertyClick
            }),
            name: name,
            readonly: readonly,
            disabled: disabled,
            required: required,
            hidden: hidden
          };
        }),
        readonly: readonly,
        disabled: disabled,
        required: required,
        idSchema: idSchema,
        uiSchema: uiSchema,
        schema: schema,
        formData: formData,
        formContext: formContext,
        registry: registry
      };
      return React.createElement(Template, _extends({}, templateProps, {
        onAddClick: this.handleAddClick
      }));
    }
  }]);

  return ObjectField;
}(Component);

_defineProperty(ObjectField, "defaultProps", {
  uiSchema: {},
  formData: {},
  errorSchema: {},
  idSchema: {},
  required: false,
  disabled: false,
  readonly: false
});

if (process.env.NODE_ENV !== "production") {
  ObjectField.propTypes = types.fieldProps;
}

export default ObjectField;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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