"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var types = _interopRequireWildcard(require("../../types"));

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var AnyOfField =
/*#__PURE__*/
function (_Component) {
  _inherits(AnyOfField, _Component);

  function AnyOfField(props) {
    var _this;

    _classCallCheck(this, AnyOfField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AnyOfField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "onOptionChange", function (option) {
      var selectedOption = parseInt(option, 10);
      var _this$props = _this.props,
          formData = _this$props.formData,
          onChange = _this$props.onChange,
          options = _this$props.options,
          registry = _this$props.registry;
      var rootSchema = registry.rootSchema;
      var newOption = (0, _utils.retrieveSchema)(options[selectedOption], rootSchema, formData); // If the new option is of type object and the current data is an object,
      // discard properties added using the old option.

      var newFormData = undefined;

      if ((0, _utils.guessType)(formData) === "object" && (newOption.type === "object" || newOption.properties)) {
        newFormData = Object.assign({}, formData);
        var optionsToDiscard = options.slice();
        optionsToDiscard.splice(selectedOption, 1); // Discard any data added using other options

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = optionsToDiscard[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var _option = _step.value;

            if (_option.properties) {
              for (var key in _option.properties) {
                if (newFormData.hasOwnProperty(key)) {
                  delete newFormData[key];
                }
              }
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } // Call getDefaultFormState to make sure defaults are populated on change.


      onChange((0, _utils.getDefaultFormState)(options[selectedOption], newFormData, rootSchema));

      _this.setState({
        selectedOption: parseInt(option, 10)
      });
    });

    var _this$props2 = _this.props,
        _formData = _this$props2.formData,
        _options = _this$props2.options;
    _this.state = {
      selectedOption: _this.getMatchingOption(_formData, _options)
    };
    return _this;
  }

  _createClass(AnyOfField, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (!(0, _utils.deepEquals)(this.props.formData, prevProps.formData) && this.props.idSchema.$id === prevProps.idSchema.$id) {
        var matchingOption = this.getMatchingOption(this.props.formData, this.props.options);

        if (!prevState || matchingOption === this.state.selectedOption) {
          return;
        }

        this.setState({
          selectedOption: matchingOption
        });
      }
    }
  }, {
    key: "getMatchingOption",
    value: function getMatchingOption(formData, options) {
      var rootSchema = this.props.registry.rootSchema;
      var option = (0, _utils.getMatchingOption)(formData, options, rootSchema);

      if (option !== 0) {
        return option;
      } // If the form data matches none of the options, use the currently selected
      // option, assuming it's available; otherwise use the first option


      return this && this.state ? this.state.selectedOption : 0;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          baseType = _this$props3.baseType,
          disabled = _this$props3.disabled,
          readonly = _this$props3.readonly,
          hideError = _this$props3.hideError,
          errorSchema = _this$props3.errorSchema,
          formData = _this$props3.formData,
          idPrefix = _this$props3.idPrefix,
          idSeparator = _this$props3.idSeparator,
          idSchema = _this$props3.idSchema,
          onBlur = _this$props3.onBlur,
          onChange = _this$props3.onChange,
          onFocus = _this$props3.onFocus,
          options = _this$props3.options,
          registry = _this$props3.registry,
          uiSchema = _this$props3.uiSchema,
          schema = _this$props3.schema;
      var _SchemaField = registry.fields.SchemaField;
      var widgets = registry.widgets;
      var selectedOption = this.state.selectedOption;

      var _getUiOptions = (0, _utils.getUiOptions)(uiSchema),
          _getUiOptions$widget = _getUiOptions.widget,
          widget = _getUiOptions$widget === void 0 ? "select" : _getUiOptions$widget,
          uiOptions = _objectWithoutProperties(_getUiOptions, ["widget"]);

      var Widget = (0, _utils.getWidget)({
        type: "number"
      }, widget, widgets);
      var option = options[selectedOption] || null;
      var optionSchema;

      if (option) {
        // If the subschema doesn't declare a type, infer the type from the
        // parent schema
        optionSchema = option.type ? option : Object.assign({}, option, {
          type: baseType
        });
      }

      var enumOptions = options.map(function (option, index) {
        return {
          label: option.title || "Option ".concat(index + 1),
          value: index
        };
      });
      return _react["default"].createElement("div", {
        className: "panel panel-default panel-body"
      }, _react["default"].createElement("div", {
        className: "form-group"
      }, _react["default"].createElement(Widget, _extends({
        id: "".concat(idSchema.$id).concat(schema.oneOf ? "__oneof_select" : "__anyof_select"),
        schema: {
          type: "number",
          "default": 0
        },
        onChange: this.onOptionChange,
        onBlur: onBlur,
        onFocus: onFocus,
        value: selectedOption,
        options: {
          enumOptions: enumOptions
        }
      }, uiOptions))), option !== null && _react["default"].createElement(_SchemaField, {
        schema: optionSchema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        idSeparator: idSeparator,
        formData: formData,
        onChange: onChange,
        onBlur: onBlur,
        onFocus: onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError
      }));
    }
  }]);

  return AnyOfField;
}(_react.Component);

AnyOfField.defaultProps = {
  disabled: false,
  readonly: false,
  hideError: false,
  errorSchema: {},
  idSchema: {},
  uiSchema: {}
};

if (process.env.NODE_ENV !== "production") {
  AnyOfField.propTypes = {
    options: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
    baseType: _propTypes["default"].string,
    uiSchema: _propTypes["default"].object,
    idSchema: _propTypes["default"].object,
    formData: _propTypes["default"].any,
    errorSchema: _propTypes["default"].object,
    registry: types.registry.isRequired
  };
}

var _default = AnyOfField;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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