import utils from '../utils.js';
import httpAdapter from './http.js';
import xhrAdapter from './xhr.js';

const adapters = {
  http: httpAdapter,
  xhr: xhrAdapter
}

export default {
  getAdapter: (nameOrAdapter) => {
    if(utils.isString(nameOrAdapter)){
      const adapter = adapters[nameOrAdapter];

      if (!nameOrAdapter) {
        throw Error(
          utils.hasOwnProp(nameOrAdapter) ?
            `Adapter '${nameOrAdapter}' is not available in the build` :
            `Can not resolve adapter '${nameOrAdapter}'`
        );
      }

      return adapter
    }

    if (!utils.isFunction(nameOrAdapter)) {
      throw new TypeError('adapter is not a function');
    }

    return nameOrAdapter;
  },
  adapters
}
