/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ConversionTask;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.ImportInstanceTaskDetailsStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ImportVolumeTaskDetailsStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ConversionTaskStaxUnmarshaller
implements Unmarshaller<ConversionTask, StaxUnmarshallerContext> {
    private static ConversionTaskStaxUnmarshaller instance;

    public ConversionTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConversionTask conversionTask = new ConversionTask();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return conversionTask;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("conversionTaskId", targetDepth)) {
                    conversionTask.setConversionTaskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("expirationTime", targetDepth)) {
                    conversionTask.setExpirationTime(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("importInstance", targetDepth)) {
                    conversionTask.setImportInstance(ImportInstanceTaskDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("importVolume", targetDepth)) {
                    conversionTask.setImportVolume(ImportVolumeTaskDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    conversionTask.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("statusMessage", targetDepth)) {
                    conversionTask.setStatusMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    conversionTask.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                conversionTask.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return conversionTask;
    }

    public static ConversionTaskStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConversionTaskStaxUnmarshaller();
        }
        return instance;
    }
}

