/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddPrefixListEntry;
import com.amazonaws.services.ec2.model.CreateManagedPrefixListRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateManagedPrefixListRequestMarshaller
implements Marshaller<Request<CreateManagedPrefixListRequest>, CreateManagedPrefixListRequest> {
    public Request<CreateManagedPrefixListRequest> marshall(CreateManagedPrefixListRequest createManagedPrefixListRequest) {
        SdkInternalList createManagedPrefixListRequestTagSpecificationsList;
        SdkInternalList createManagedPrefixListRequestEntriesList;
        if (createManagedPrefixListRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createManagedPrefixListRequest, "AmazonEC2");
        request.addParameter("Action", "CreateManagedPrefixList");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createManagedPrefixListRequest.getPrefixListName() != null) {
            request.addParameter("PrefixListName", StringUtils.fromString((String)createManagedPrefixListRequest.getPrefixListName()));
        }
        if (!(createManagedPrefixListRequestEntriesList = (SdkInternalList)createManagedPrefixListRequest.getEntries()).isEmpty() || !createManagedPrefixListRequestEntriesList.isAutoConstruct()) {
            int entriesListIndex = 1;
            for (AddPrefixListEntry createManagedPrefixListRequestEntriesListValue : createManagedPrefixListRequestEntriesList) {
                if (createManagedPrefixListRequestEntriesListValue.getCidr() != null) {
                    request.addParameter("Entry." + entriesListIndex + ".Cidr", StringUtils.fromString((String)createManagedPrefixListRequestEntriesListValue.getCidr()));
                }
                if (createManagedPrefixListRequestEntriesListValue.getDescription() != null) {
                    request.addParameter("Entry." + entriesListIndex + ".Description", StringUtils.fromString((String)createManagedPrefixListRequestEntriesListValue.getDescription()));
                }
                ++entriesListIndex;
            }
        }
        if (createManagedPrefixListRequest.getMaxEntries() != null) {
            request.addParameter("MaxEntries", StringUtils.fromInteger((Integer)createManagedPrefixListRequest.getMaxEntries()));
        }
        if (!(createManagedPrefixListRequestTagSpecificationsList = (SdkInternalList)createManagedPrefixListRequest.getTagSpecifications()).isEmpty() || !createManagedPrefixListRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createManagedPrefixListRequestTagSpecificationsListValue : createManagedPrefixListRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createManagedPrefixListRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createManagedPrefixListRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createManagedPrefixListRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createManagedPrefixListRequest.getAddressFamily() != null) {
            request.addParameter("AddressFamily", StringUtils.fromString((String)createManagedPrefixListRequest.getAddressFamily()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createManagedPrefixListRequest.getClientToken()));
        return request;
    }
}

