/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.spi.schedule;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

public class ScheduleParser {
    public static Schedule parse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        if (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "cron": {
                    String expression = null;
                    ZoneId timezone = null;
                    Long cronDelay = null;
                    block30: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
                        String cronField = parser.currentName();
                        parser.nextToken();
                        switch (cronField) {
                            case "expression": {
                                expression = parser.text();
                                continue block30;
                            }
                            case "timezone": {
                                timezone = ZoneId.of(parser.text());
                                continue block30;
                            }
                            case "schedule_delay": {
                                cronDelay = parser.longValue();
                                continue block30;
                            }
                        }
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown cron field %s", cronField));
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    parser.nextToken();
                    return cronDelay == null ? new CronSchedule(expression, timezone) : new CronSchedule(expression, timezone, cronDelay);
                }
                case "interval": {
                    Instant startTime = null;
                    int period = 0;
                    ChronoUnit unit = null;
                    Long intervalDelay = null;
                    block31: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
                        String intervalField = parser.currentName();
                        parser.nextToken();
                        switch (intervalField) {
                            case "start_time": {
                                startTime = Instant.ofEpochMilli(parser.longValue());
                                continue block31;
                            }
                            case "period": {
                                period = parser.intValue();
                                continue block31;
                            }
                            case "unit": {
                                unit = ChronoUnit.valueOf(parser.text().toUpperCase(Locale.ROOT));
                                continue block31;
                            }
                            case "schedule_delay": {
                                intervalDelay = parser.longValue();
                                continue block31;
                            }
                        }
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown interval field %s", intervalField));
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    parser.nextToken();
                    return intervalDelay == null ? new IntervalSchedule(startTime, period, unit) : new IntervalSchedule(startTime, period, unit, intervalDelay);
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown schedule type %s", fieldName));
        }
        throw new IllegalArgumentException("Invalid schedule document object.");
    }
}

