/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.svek.GraphvizCrash;

public class PSystemDitaa
extends AbstractPSystem {
    private Object processingOptions;
    private final boolean dropShadows;
    private final String data;
    private final float scale;
    private final boolean transparentBackground;
    private final Font font;
    private final boolean forceFontSize;
    private final boolean performSeparationOfCommonEdges;
    private final boolean allCornersAreRound;

    public PSystemDitaa(UmlSource source, String data, boolean performSeparationOfCommonEdges, boolean dropShadows, boolean allCornersAreRound, boolean transparentBackground, float scale, Font font, boolean forceFontSize) {
        super(source);
        this.data = data;
        this.dropShadows = dropShadows;
        this.performSeparationOfCommonEdges = performSeparationOfCommonEdges;
        this.allCornersAreRound = allCornersAreRound;
        try {
            this.processingOptions = Class.forName("org.stathissideris.ascii2image.core.ProcessingOptions").newInstance();
            this.processingOptions.getClass().getMethod("setPerformSeparationOfCommonEdges", Boolean.TYPE).invoke(this.processingOptions, performSeparationOfCommonEdges);
            this.processingOptions.getClass().getMethod("setAllCornersAreRound", Boolean.TYPE).invoke(this.processingOptions, allCornersAreRound);
        }
        catch (Exception e) {
            Logme.error(e);
            this.processingOptions = null;
        }
        this.transparentBackground = transparentBackground;
        this.scale = scale;
        this.font = font;
        this.forceFontSize = forceFontSize;
    }

    PSystemDitaa add(String line) {
        return new PSystemDitaa(this.getSource(), this.data + line + "\n", this.performSeparationOfCommonEdges, this.dropShadows, this.allCornersAreRound, this.transparentBackground, this.scale, this.font, this.forceFontSize);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Ditaa)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT) {
            os.write(this.getSource().getPlainString().getBytes());
            return ImageDataSimple.ok();
        }
        try {
            Object options = Class.forName("org.stathissideris.ascii2image.core.ConversionOptions").newInstance();
            Field f_renderingOptions = options.getClass().getField("renderingOptions");
            Object renderingOptions = f_renderingOptions.get(options);
            Method setBackgroundColor = renderingOptions.getClass().getMethod("setBackgroundColor", Color.class);
            setBackgroundColor.invoke(renderingOptions, this.transparentBackground ? new Color(0, 0, 0, 0) : Color.WHITE);
            Method setFont = renderingOptions.getClass().getMethod("setFont", Font.class);
            setFont.invoke(renderingOptions, this.font);
            Method setForceFontSize = renderingOptions.getClass().getMethod("setForceFontSize", Boolean.TYPE);
            setForceFontSize.invoke(renderingOptions, this.forceFontSize);
            Method setScale = renderingOptions.getClass().getMethod("setScale", Float.TYPE);
            setScale.invoke(renderingOptions, Float.valueOf(this.scale));
            Method setDropShadows = options.getClass().getMethod("setDropShadows", Boolean.TYPE);
            setDropShadows.invoke(options, this.dropShadows);
            Object grid = Class.forName("org.stathissideris.ascii2image.text.TextGrid").newInstance();
            Method initialiseWithText = grid.getClass().getMethod("initialiseWithText", String.class, Class.forName("org.stathissideris.ascii2image.core.ProcessingOptions"));
            initialiseWithText.invoke(grid, this.data, null);
            Class<?> clDiagram = Class.forName("org.stathissideris.ascii2image.graphics.Diagram");
            clDiagram.getConstructor(grid.getClass(), options.getClass(), this.processingOptions.getClass()).newInstance(grid, options, this.processingOptions);
            Object diagram = clDiagram.getConstructor(grid.getClass(), options.getClass(), this.processingOptions.getClass()).newInstance(grid, options, this.processingOptions);
            Object bitmapRenderer = Class.forName("org.stathissideris.ascii2image.graphics.BitmapRenderer").newInstance();
            Method renderToImage = bitmapRenderer.getClass().getMethod("renderToImage", diagram.getClass(), renderingOptions.getClass());
            BufferedImage image = (BufferedImage)renderToImage.invoke(bitmapRenderer, diagram, renderingOptions);
            SImageIO.write((RenderedImage)image, "png", os);
            int width = image.getWidth();
            int height = image.getHeight();
            return new ImageDataSimple(width, height);
        }
        catch (Throwable e) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add("DITAA has crashed");
            strings.add(" ");
            GraphvizCrash.youShouldSendThisDiagram(strings);
            strings.add(" ");
            UmlDiagram.exportDiagramError(os, e, new FileFormatOption(FileFormat.PNG), this.seed(), null, null, strings);
            return ImageDataSimple.error();
        }
    }
}

