/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UGraphicWithScale {
    private final UGraphic ug;
    private final AffineTransform at;

    public UGraphicWithScale(UGraphic ug, double scale) {
        this(ug, AffineTransform.getScaleInstance(scale, scale));
    }

    private UGraphicWithScale(UGraphic ug, AffineTransform at) {
        this.ug = ug;
        this.at = at;
    }

    public UGraphic getUg() {
        return this.ug;
    }

    public UGraphicWithScale apply(UChange change) {
        return new UGraphicWithScale(this.ug.apply(change), this.at);
    }

    public UGraphicWithScale applyScale(double changex, double changey) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.scale(changex, changey);
        return new UGraphicWithScale(this.ug, copy);
    }

    public void draw(UShape shape) {
        this.ug.draw(shape);
    }

    public UGraphicWithScale applyRotate(double angle, double x, double y) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.rotate(angle * Math.PI / 180.0, x, y);
        return new UGraphicWithScale(this.ug, copy);
    }

    public UGraphicWithScale applyTranslate(double x, double y) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.translate(x, y);
        return new UGraphicWithScale(this.ug, copy);
    }

    public AffineTransform getAffineTransform() {
        return this.at;
    }

    public UGraphicWithScale applyMatrix(double v1, double v2, double v3, double v4, double v5, double v6) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.concatenate(new AffineTransform(new double[]{v1, v2, v3, v4, v5, v6}));
        return new UGraphicWithScale(this.ug, copy);
    }
}

