/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontPosition;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.SvgAttributes;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class FontConfiguration {
    private final EnumSet<FontStyle> styles;
    private final UFont currentFont;
    private final UFont motherFont;
    private final HColor motherColor;
    private final HColor hyperlinkColor;
    private final HColor currentColor;
    private final HColor extendedColor;
    private final FontPosition fontPosition;
    private final SvgAttributes svgAttributes;
    private final boolean hyperlink;
    private final boolean useUnderlineForHyperlink;
    private final int tabSize;

    public String toStringDebug() {
        return this.getFont().toStringDebug() + " " + this.styles.toString();
    }

    public static FontConfiguration create(UFont font, HColor color, HColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        return FontConfiguration.create(font, color, hyperlinkColor, useUnderlineForHyperlink, 8);
    }

    public static FontConfiguration create(UFont font, HColor color, HColor hyperlinkColor, boolean useUnderlineForHyperlink, int tabSize) {
        return new FontConfiguration(FontConfiguration.getStyles(font), font, color, font, color, null, FontPosition.NORMAL, new SvgAttributes(), false, hyperlinkColor, useUnderlineForHyperlink, tabSize);
    }

    public static FontConfiguration blackBlueTrue(UFont font) {
        return FontConfiguration.create(font, HColors.BLACK.withDark(HColors.WHITE), HColors.BLUE, true, 8);
    }

    public static FontConfiguration create(ISkinParam skinParam, FontParam fontParam, Stereotype stereo) {
        return FontConfiguration.create(SkinParamUtils.getFont(skinParam, fontParam, stereo), SkinParamUtils.getFontColor(skinParam, fontParam, stereo), skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink(), skinParam.getTabSize());
    }

    public static FontConfiguration create(ISkinParam skinParam, Style style) {
        return FontConfiguration.create(skinParam, style, null);
    }

    public static FontConfiguration create(ISkinParam skinParam, Style style, Colors colors) {
        HColor color;
        HColor hyperlinkColor = style.value(PName.HyperLinkColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        boolean useUnderlineForHyperlink = skinParam.useUnderlineForHyperlink();
        HColor hColor = color = colors == null ? null : colors.getColor(ColorType.TEXT);
        if (color == null) {
            color = style.value(PName.FontColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        }
        return FontConfiguration.create(style.getUFont(), color, hyperlinkColor, useUnderlineForHyperlink, skinParam.getTabSize());
    }

    public final boolean useUnderlineForHyperlink() {
        return this.useUnderlineForHyperlink;
    }

    private static EnumSet<FontStyle> getStyles(UFont font) {
        boolean bold = font.isBold();
        boolean italic = font.isItalic();
        if (bold && italic) {
            return EnumSet.of(FontStyle.ITALIC, FontStyle.BOLD);
        }
        if (bold) {
            return EnumSet.of(FontStyle.BOLD);
        }
        if (italic) {
            return EnumSet.of(FontStyle.ITALIC);
        }
        return EnumSet.noneOf(FontStyle.class);
    }

    public String toString() {
        return this.styles.toString() + " " + this.currentColor;
    }

    private FontConfiguration(EnumSet<FontStyle> styles, UFont motherFont, HColor motherColor, UFont currentFont, HColor currentColor, HColor extendedColor, FontPosition fontPosition, SvgAttributes svgAttributes, boolean hyperlink, HColor hyperlinkColor, boolean useUnderlineForHyperlink, int tabSize) {
        this.styles = styles;
        this.currentFont = currentFont;
        this.motherFont = motherFont;
        this.currentColor = currentColor;
        this.motherColor = motherColor;
        this.extendedColor = extendedColor;
        this.fontPosition = fontPosition;
        this.svgAttributes = svgAttributes;
        this.hyperlink = hyperlink;
        this.hyperlinkColor = hyperlinkColor;
        this.useUnderlineForHyperlink = useUnderlineForHyperlink;
        this.tabSize = tabSize;
    }

    public FontConfiguration forceFont(UFont newFont, HColor htmlColorForStereotype) {
        if (newFont == null) {
            return this.add(FontStyle.ITALIC);
        }
        FontConfiguration result = new FontConfiguration(this.styles, newFont, this.motherColor, newFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
        if (htmlColorForStereotype != null) {
            result = result.changeColor(htmlColorForStereotype);
        }
        return result;
    }

    public FontConfiguration changeAttributes(SvgAttributes toBeAdded) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes.add(toBeAdded), this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    private FontConfiguration withHyperlink() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, true, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration changeColor(HColor newHtmlColor) {
        if (this.hyperlink) {
            return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, newHtmlColor, this.useUnderlineForHyperlink, this.tabSize);
        }
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, newHtmlColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration mute(Colors colors) {
        HColor color = Objects.requireNonNull(colors).getColor(ColorType.TEXT);
        if (color == null) {
            return this;
        }
        return this.changeColor(color);
    }

    FontConfiguration changeExtendedColor(HColor newExtendedColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, newExtendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration changeSize(float size) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont.withSize(size), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration bigger(double delta) {
        return this.changeSize((float)((double)this.currentFont.getSize() + delta));
    }

    public FontConfiguration changeFontPosition(FontPosition fontPosition) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration changeFamily(String family) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, new UFont(family, this.currentFont.getStyle(), this.currentFont.getSize()), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration resetFont() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.motherFont, this.motherColor, null, FontPosition.NORMAL, new SvgAttributes(), this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration add(FontStyle style) {
        Object r = this.styles.clone();
        if (style == FontStyle.PLAIN) {
            ((AbstractCollection)r).clear();
        }
        ((AbstractCollection)r).add(style);
        return new FontConfiguration((EnumSet<FontStyle>)r, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration italic() {
        return this.add(FontStyle.ITALIC);
    }

    public FontConfiguration bold() {
        return this.add(FontStyle.BOLD);
    }

    public FontConfiguration unbold() {
        return this.remove(FontStyle.BOLD);
    }

    public FontConfiguration unitalic() {
        return this.remove(FontStyle.ITALIC);
    }

    public FontConfiguration underline() {
        return this.add(FontStyle.UNDERLINE);
    }

    public FontConfiguration wave(HColor color) {
        return this.add(FontStyle.WAVE).changeExtendedColor(color);
    }

    public FontConfiguration hyperlink() {
        if (this.useUnderlineForHyperlink) {
            return this.add(FontStyle.UNDERLINE).withHyperlink();
        }
        return this.withHyperlink();
    }

    public FontConfiguration remove(FontStyle style) {
        Object r = this.styles.clone();
        ((AbstractCollection)r).remove((Object)style);
        return new FontConfiguration((EnumSet<FontStyle>)r, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public UFont getFont() {
        UFont result = this.currentFont;
        for (FontStyle style : this.styles) {
            result = style.mutateFont(result);
        }
        return this.fontPosition.mute(result);
    }

    public HColor getColor() {
        if (this.hyperlink) {
            return this.hyperlinkColor;
        }
        return this.currentColor;
    }

    public HColor getExtendedColor() {
        return this.extendedColor;
    }

    public boolean containsStyle(FontStyle style) {
        return this.styles.contains((Object)style);
    }

    public int getSpace() {
        return this.fontPosition.getSpace();
    }

    public Map<String, String> getAttributes() {
        return this.svgAttributes.attributes();
    }

    public double getSize2D() {
        return this.currentFont.getSize2D();
    }

    public int getTabSize() {
        return this.tabSize;
    }
}

