/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class SpriteColor
implements Sprite {
    private final int width;
    private final int height;
    private final int[][] gray;
    private final int[][] color;

    public SpriteColor(int width, int height) {
        this.width = width;
        this.height = height;
        this.gray = new int[height][width];
        this.color = new int[height][width];
    }

    public void setGray(int x, int y, int level) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        if (level < 0 || level >= 16) {
            throw new IllegalArgumentException();
        }
        this.gray[y][x] = level;
        this.color[y][x] = -1;
    }

    public void setColor(int x, int y, int col) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        this.gray[y][x] = -1;
        this.color[y][x] = col;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public UImage toUImage(ColorMapper colorMapper, HColor backcolor, HColor forecolor) {
        BufferedImage im = new BufferedImage(this.width, this.height, 1);
        if (backcolor == null) {
            backcolor = HColors.WHITE;
        }
        if (forecolor == null) {
            forecolor = HColors.BLACK;
        }
        HColorGradient gradient = HColors.gradient(backcolor, forecolor, '\u0000');
        for (int col = 0; col < this.width; ++col) {
            for (int line = 0; line < this.height; ++line) {
                int localColor = this.color[line][col];
                if (localColor == -1) {
                    double coef = 1.0 * (double)this.gray[line][col] / 15.0;
                    Color c = gradient.getColor(colorMapper, coef);
                    im.setRGB(col, line, c.getRGB());
                    continue;
                }
                im.setRGB(col, line, localColor);
            }
        }
        return new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale, ColorMapper colorMapper) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                UImage image = SpriteColor.this.toUImage(ug.getColorMapper(), ug.getParam().getBackcolor(), color);
                ug.draw(image.scale(scale));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble((double)SpriteColor.this.getWidth() * scale, (double)SpriteColor.this.getHeight() * scale);
            }
        };
    }
}

