/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.Set;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SvgCharSizeHack;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.braille.UGraphicBraille;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.svg.LengthAdjust;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColors;
import net.sourceforge.plantuml.ugraphic.debug.UGraphicDebug;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private Animation animation;
    private boolean annotations;
    private HColor backcolor = ImageBuilder.getDefaultHBackColor();
    private ColorMapper colorMapper = new ColorMapperIdentity();
    private Dimension2D dimension;
    private final FileFormatOption fileFormatOption;
    private UDrawable udrawable;
    private ClockwiseTopRightBottomLeft margin = ClockwiseTopRightBottomLeft.none();
    private String metadata;
    private long seed = 42L;
    private ISkinParam skinParam;
    private StringBounder stringBounder;
    private int status = 0;
    private TitledDiagram titledDiagram;
    private boolean randomPixel;
    private String warningOrError;

    public static ImageBuilder imageBuilder(FileFormatOption fileFormatOption) {
        return new ImageBuilder(fileFormatOption);
    }

    public static ImageBuilder plainImageBuilder(UDrawable drawable, FileFormatOption fileFormatOption) {
        return ImageBuilder.imageBuilder(fileFormatOption).drawable(drawable);
    }

    public static ImageBuilder plainPngBuilder(UDrawable drawable) {
        return ImageBuilder.imageBuilder(new FileFormatOption(FileFormat.PNG)).drawable(drawable);
    }

    private ImageBuilder(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
        this.stringBounder = fileFormatOption.getDefaultStringBounder(SvgCharSizeHack.NO_HACK);
    }

    public ImageBuilder annotations(boolean annotations) {
        this.annotations = annotations;
        return this;
    }

    public ImageBuilder backcolor(HColor backcolor) {
        this.backcolor = backcolor;
        return this;
    }

    public ImageBuilder blackBackcolor() {
        return this.backcolor(HColors.BLACK);
    }

    public ImageBuilder dimension(Dimension2D dimension) {
        this.dimension = dimension;
        return this;
    }

    private int getDpi() {
        return this.skinParam == null ? 96 : this.skinParam.getDpi();
    }

    public ImageBuilder drawable(UDrawable drawable) {
        this.udrawable = drawable;
        if (this.backcolor == null && drawable instanceof TextBlockBackcolored) {
            this.backcolor = ((TextBlockBackcolored)drawable).getBackcolor();
        }
        return this;
    }

    public ImageBuilder margin(ClockwiseTopRightBottomLeft margin) {
        this.margin = margin;
        return this;
    }

    public ImageBuilder metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public ImageBuilder randomPixel() {
        this.randomPixel = true;
        return this;
    }

    public ImageBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public ImageBuilder status(int status) {
        this.status = status;
        return this;
    }

    private String getSvgLinkTarget() {
        if (this.fileFormatOption.getSvgLinkTarget() != null) {
            return this.fileFormatOption.getSvgLinkTarget();
        }
        if (this.skinParam != null) {
            return this.skinParam.getSvgLinkTarget();
        }
        return null;
    }

    public ImageBuilder warningOrError(String warningOrError) {
        this.warningOrError = warningOrError;
        return this;
    }

    public ImageBuilder styled(TitledDiagram diagram) {
        this.skinParam = diagram.getSkinParam();
        this.stringBounder = this.fileFormatOption.getDefaultStringBounder(this.skinParam);
        this.animation = diagram.getAnimation();
        this.annotations = true;
        this.backcolor = diagram.calculateBackColor();
        this.colorMapper = this.skinParam.getColorMapper();
        this.margin = ImageBuilder.calculateMargin(diagram);
        this.metadata = this.fileFormatOption.isWithMetadata() ? diagram.getMetadata() : null;
        this.seed = diagram.seed();
        this.titledDiagram = diagram;
        this.warningOrError = diagram.getWarningOrError();
        return this;
    }

    public ImageData write(OutputStream os) throws IOException {
        if (this.annotations && this.titledDiagram != null) {
            if (!(this.udrawable instanceof TextBlock)) {
                throw new IllegalStateException("udrawable is not a TextBlock");
            }
            AnnotatedWorker annotatedWorker = new AnnotatedWorker(this.titledDiagram, this.skinParam, this.stringBounder);
            this.udrawable = annotatedWorker.addAdd((TextBlock)this.udrawable);
        }
        switch (this.fileFormatOption.getFileFormat()) {
            case MJPEG: {
                return this.writeImageMjpeg(os);
            }
            case ANIMATED_GIF: {
                return this.writeImageAnimatedGif(os);
            }
        }
        return this.writeImageInternal(this.fileFormatOption, os, this.animation);
    }

    public byte[] writeByteArray() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.write(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private ImageData writeImageInternal(FileFormatOption fileFormatOption, OutputStream os, Animation animationArg) throws IOException {
        Set<Url> urls;
        Scale scale;
        double scaleFactor;
        Dimension2D dim = this.getFinalDimension();
        double dx = 0.0;
        double dy = 0.0;
        if (animationArg != null) {
            MinMax minmax = animationArg.getMinMax(dim);
            animationArg.setDimension(dim);
            dim = minmax.getDimension();
            dx = -minmax.getMinX();
            dy = -minmax.getMinY();
        }
        if ((scaleFactor = ((scale = this.titledDiagram == null ? null : this.titledDiagram.getScale()) == null ? 1.0 : scale.getScale(dim.getWidth(), dim.getHeight())) * (double)this.getDpi() / 96.0) <= 0.0) {
            throw new IllegalStateException("Bad scaleFactor");
        }
        UGraphic ug = this.createUGraphic(fileFormatOption, dim, animationArg, dx, dy, scaleFactor, this.titledDiagram == null ? new Pragma() : this.titledDiagram.getPragma());
        this.maybeDrawBorder(ug, dim);
        if (this.randomPixel) {
            this.drawRandomPoint(ug);
        }
        ug = this.handwritten(ug.apply(new UTranslate(this.margin.getLeft(), this.margin.getTop())));
        this.udrawable.drawU(ug);
        ug.flushUg();
        ug.writeToStream(os, this.metadata, 96);
        os.flush();
        if (ug instanceof UGraphicG2d && (urls = ((UGraphicG2d)ug).getAllUrlsEncountered()).size() > 0) {
            CMapData cmap = CMapData.cmapString(urls, scaleFactor);
            return new ImageDataComplex(dim, cmap, this.warningOrError, this.status);
        }
        return this.createImageData(dim);
    }

    private void maybeDrawBorder(UGraphic ug, Dimension2D dim) {
        if (this.skinParam == null) {
            return;
        }
        HColor color = new Rose().getHtmlColor(this.skinParam, ColorParam.diagramBorder);
        UStroke stroke = this.skinParam.getThickness(LineParam.diagramBorder, null);
        if (stroke == null && color != null) {
            stroke = new UStroke();
        }
        if (stroke == null) {
            return;
        }
        URectangle rectangle = new URectangle(dim.getWidth() - stroke.getThickness(), dim.getHeight() - stroke.getThickness()).rounded(this.skinParam.getRoundCorner(CornerParam.diagramBorder, null));
        ug.apply(color == null ? HColors.BLACK : color).apply(stroke).draw(rectangle);
    }

    private void drawRandomPoint(UGraphic ug2) {
        Random rnd = new Random();
        int red = rnd.nextInt(40);
        int green = rnd.nextInt(40);
        int blue = rnd.nextInt(40);
        Color c = new Color(red, green, blue);
        HColor color = HColors.simple(c);
        ug2.apply(color).apply(color.bg()).draw(new URectangle(1.0, 1.0));
    }

    private Dimension2D getFinalDimension() {
        if (this.dimension == null) {
            LimitFinder limitFinder = LimitFinder.create(this.stringBounder, true);
            this.udrawable.drawU(limitFinder);
            this.dimension = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin.getLeft() + this.margin.getRight(), limitFinder.getMaxY() + 1.0 + this.margin.getTop() + this.margin.getBottom());
        }
        return this.dimension;
    }

    private UGraphic handwritten(UGraphic ug) {
        if (this.skinParam != null && this.skinParam.handwritten()) {
            return new UGraphicHandwritten(ug);
        }
        return ug;
    }

    private ImageData writeImageMjpeg(OutputStream os) throws IOException {
        Dimension2D dim = this.getFinalDimension();
        SFile f = new SFile("c:/tmp.avi");
        int nbframe = 100;
        MJPEGGenerator m = new MJPEGGenerator(f, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int i = 0;
        if (i < 100) {
            AffineTransform at = AffineTransform.getTranslateInstance(dim.getWidth() / 2.0, dim.getHeight() / 2.0);
            at.rotate(1.5707963267948966 * (double)i / 100.0);
            at.translate(-dim.getWidth() / 2.0, -dim.getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        m.finishAVI();
        FileUtils.copyToStream(f, os);
        return this.createImageData(dim);
    }

    private ImageData writeImageAnimatedGif(OutputStream os) throws IOException {
        Dimension2D dim = this.getFinalDimension();
        MinMax minmax = this.animation.getMinMax(dim);
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.setRepeat(0);
        e.start(os);
        e.setDelay(60);
        for (AffineTransformation at : this.animation.getAll()) {
            ImageIcon ii = new ImageIcon(this.getAviImage(at));
            e.addFrame((BufferedImage)ii.getImage());
        }
        e.finish();
        return this.createImageData(dim);
    }

    private Image getAviImage(AffineTransformation affineTransform) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeImageInternal(new FileFormatOption(FileFormat.PNG), baos, Animation.singleton(affineTransform));
        baos.close();
        return SImageIO.read(baos.toByteArray());
    }

    private UGraphic createUGraphic(FileFormatOption option, Dimension2D dim, Animation animationArg, double dx, double dy, double scaleFactor, Pragma pragma) {
        switch (option.getFileFormat()) {
            case PNG: {
                return this.createUGraphicPNG(scaleFactor, dim, animationArg, dx, dy, option.getWatermark());
            }
            case SVG: {
                boolean interactive = "true".equalsIgnoreCase(pragma.getValue("svginteractive"));
                return this.createUGraphicSVG(scaleFactor, dim, interactive);
            }
            case EPS: {
                return new UGraphicEps(this.backcolor, this.colorMapper, this.stringBounder, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.backcolor, this.colorMapper, this.stringBounder, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.backcolor, this.colorMapper, this.stringBounder);
            }
            case VDX: {
                return new UGraphicVdx(this.backcolor, this.colorMapper, this.stringBounder);
            }
            case LATEX: {
                return new UGraphicTikz(this.backcolor, this.colorMapper, this.stringBounder, scaleFactor, true);
            }
            case LATEX_NO_PREAMBLE: {
                return new UGraphicTikz(this.backcolor, this.colorMapper, this.stringBounder, scaleFactor, false);
            }
            case BRAILLE_PNG: {
                return new UGraphicBraille(this.backcolor, this.colorMapper, this.stringBounder);
            }
            case UTXT: 
            case ATXT: {
                return new UGraphicTxt();
            }
            case DEBUG: {
                return new UGraphicDebug(scaleFactor, dim, this.getSvgLinkTarget(), this.getHoverPathColorRGB(), this.seed, this.getPreserveAspectRatio());
            }
        }
        throw new UnsupportedOperationException(option.getFileFormat().toString());
    }

    private UGraphic createUGraphicSVG(double scaleFactor, Dimension2D dim, boolean interactive) {
        String hoverPathColorRGB = this.getHoverPathColorRGB();
        LengthAdjust lengthAdjust = this.skinParam == null ? LengthAdjust.defaultValue() : this.skinParam.getlengthAdjust();
        String preserveAspectRatio = this.getPreserveAspectRatio();
        boolean svgDimensionStyle = this.skinParam == null || this.skinParam.svgDimensionStyle();
        String svgLinkTarget = this.getSvgLinkTarget();
        UGraphicSvg ug = new UGraphicSvg(this.backcolor, svgDimensionStyle, dim, this.colorMapper, false, scaleFactor, svgLinkTarget, hoverPathColorRGB, this.seed, preserveAspectRatio, this.stringBounder, lengthAdjust, interactive);
        return ug;
    }

    private UGraphic createUGraphicPNG(double scaleFactor, Dimension2D dim, Animation affineTransforms, double dx, double dy, String watermark) {
        Color backColor = ImageBuilder.getDefaultBackColor();
        if (this.backcolor instanceof HColorSimple) {
            backColor = this.colorMapper.toColor(this.backcolor);
        } else if (this.backcolor instanceof HColorNone) {
            backColor = null;
        }
        if (OptionFlags.getInstance().isReplaceWhiteBackgroundByTransparent() && backColor != null && backColor.equals(Color.WHITE)) {
            backColor = new Color(0, 0, 0, 0);
        }
        EmptyImageBuilder builder = new EmptyImageBuilder(watermark, (int)(dim.getWidth() * scaleFactor), (int)(dim.getHeight() * scaleFactor), backColor, this.stringBounder);
        Graphics2D graphics2D = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(this.backcolor, this.colorMapper, this.stringBounder, graphics2D, scaleFactor, affineTransforms == null ? null : affineTransforms.getFirst(), dx, dy);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (this.backcolor instanceof HColorGradient) {
            ug.apply(this.backcolor.bg()).draw(new URectangle((double)im.getWidth() / scaleFactor, (double)im.getHeight() / scaleFactor));
        }
        return ug;
    }

    private static Color getDefaultBackColor() {
        return Color.WHITE;
    }

    private static HColor getDefaultHBackColor() {
        return HColors.WHITE;
    }

    private String getHoverPathColorRGB() {
        HColor color;
        if (this.fileFormatOption.getHoverColor() != null) {
            return this.fileFormatOption.getHoverColor();
        }
        if (this.skinParam != null && (color = this.skinParam.hoverPathColor()) != null) {
            return this.colorMapper.toRGB(color);
        }
        return null;
    }

    private static ClockwiseTopRightBottomLeft calculateMargin(TitledDiagram diagram) {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(diagram.getSkinParam().getCurrentStyleBuilder());
        if (style.hasValue(PName.Margin)) {
            return style.getMargin();
        }
        return diagram.getDefaultMargins();
    }

    public String getPreserveAspectRatio() {
        if (this.fileFormatOption.getPreserveAspectRatio() != null) {
            return this.fileFormatOption.getPreserveAspectRatio();
        }
        if (this.skinParam != null) {
            return this.skinParam.getPreserveAspectRatio();
        }
        return "none";
    }

    private ImageDataSimple createImageData(Dimension2D dim) {
        return new ImageDataSimple(dim, this.status);
    }
}

