/* cheese-countdown.c generated by valac 0.56.3, the Vala compiler
 * generated from cheese-countdown.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef void (*CheeseCountdownCountdownCallback) (gpointer user_data);
enum  {
	CHEESE_COUNTDOWN_0_PROPERTY,
	CHEESE_COUNTDOWN_NUM_PROPERTIES
};
static GParamSpec* cheese_countdown_properties[CHEESE_COUNTDOWN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseCountdownPrivate {
	ClutterText* countdown_actor;
	CheeseCountdownCountdownCallback completed_callback;
	gpointer completed_callback_target;
	ClutterPropertyTransition* pulse_in;
	ClutterPropertyTransition* pulse_out;
	gint current_value;
	GSettings* settings;
};

static gint CheeseCountdown_private_offset;
static gpointer cheese_countdown_parent_class = NULL;

VALA_EXTERN GType cheese_countdown_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheeseCountdown, g_object_unref)
VALA_EXTERN void cheese_countdown_stop (CheeseCountdown* self);
VALA_EXTERN CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
VALA_EXTERN CheeseCountdown* cheese_countdown_construct (GType object_type,
                                             ClutterText* countdown_actor);
static void cheese_countdown_fade_out (CheeseCountdown* self);
static void cheese_countdown_fade_in (CheeseCountdown* self);
static void _cheese_countdown_fade_in_clutter_timeline_completed (ClutterTimeline* _sender,
                                                           gpointer self);
static void _cheese_countdown_fade_out_clutter_timeline_completed (ClutterTimeline* _sender,
                                                            gpointer self);
VALA_EXTERN void cheese_countdown_start (CheeseCountdown* self,
                             CheeseCountdownCountdownCallback completed_callback,
                             gpointer completed_callback_target);
static void cheese_countdown_finalize (GObject * obj);
static GType cheese_countdown_get_type_once (void);

static inline gpointer
cheese_countdown_get_instance_private (CheeseCountdown* self)
{
	return G_STRUCT_MEMBER_P (self, CheeseCountdown_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CheeseCountdown*
cheese_countdown_construct (GType object_type,
                            ClutterText* countdown_actor)
{
	CheeseCountdown * self = NULL;
	ClutterText* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (countdown_actor != NULL, NULL);
	self = (CheeseCountdown*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (countdown_actor);
	_g_object_unref0 (self->priv->countdown_actor);
	self->priv->countdown_actor = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	return self;
}

CheeseCountdown*
cheese_countdown_new (ClutterText* countdown_actor)
{
	return cheese_countdown_construct (CHEESE_TYPE_COUNTDOWN, countdown_actor);
}

/**
   * Fade the countdown text out, over 500 milliseconds.
   *
   * Once the fade-out is complete, this method calls fade_in().
   */
static void
_cheese_countdown_fade_in_clutter_timeline_completed (ClutterTimeline* _sender,
                                                      gpointer self)
{
	cheese_countdown_fade_in ((CheeseCountdown*) self);
}

static void
cheese_countdown_fade_out (CheeseCountdown* self)
{
	ClutterPropertyTransition* _tmp0_;
	ClutterPropertyTransition* _tmp1_;
	ClutterPropertyTransition* _tmp2_;
	GValue _tmp3_ = {0};
	ClutterPropertyTransition* _tmp4_;
	GValue _tmp5_ = {0};
	ClutterPropertyTransition* _tmp6_;
	ClutterPropertyTransition* _tmp7_;
	ClutterText* _tmp8_;
	ClutterPropertyTransition* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	_g_object_unref0 (self->priv->pulse_out);
	self->priv->pulse_out = _tmp0_;
	_tmp1_ = self->priv->pulse_out;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp1_, (guint) 500);
	_tmp2_ = self->priv->pulse_out;
	g_value_init (&_tmp3_, G_TYPE_INT);
	g_value_set_int (&_tmp3_, 255);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp2_, &_tmp3_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	_tmp4_ = self->priv->pulse_out;
	g_value_init (&_tmp5_, G_TYPE_INT);
	g_value_set_int (&_tmp5_, 0);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp4_, &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
	_tmp6_ = self->priv->pulse_out;
	g_signal_connect_object ((ClutterTimeline*) _tmp6_, "completed", (GCallback) _cheese_countdown_fade_in_clutter_timeline_completed, self, 0);
	_tmp7_ = self->priv->pulse_out;
	_tmp8_ = self->priv->countdown_actor;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp7_, (ClutterAnimatable*) _tmp8_);
	_tmp9_ = self->priv->pulse_out;
	clutter_timeline_start ((ClutterTimeline*) _tmp9_);
}

/**
   * Decrement the countdown text and fade it in, over 500 milliseconds.
   *
   * Once the fade-in is complete, this method calls fade_out().
   */
static void
_cheese_countdown_fade_out_clutter_timeline_completed (ClutterTimeline* _sender,
                                                       gpointer self)
{
	cheese_countdown_fade_out ((CheeseCountdown*) self);
}

static void
cheese_countdown_fade_in (CheeseCountdown* self)
{
	ClutterText* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	ClutterPropertyTransition* _tmp5_;
	ClutterPropertyTransition* _tmp6_;
	ClutterPropertyTransition* _tmp7_;
	GValue _tmp8_ = {0};
	ClutterPropertyTransition* _tmp9_;
	GValue _tmp10_ = {0};
	ClutterPropertyTransition* _tmp11_;
	ClutterPropertyTransition* _tmp12_;
	ClutterText* _tmp13_;
	ClutterPropertyTransition* _tmp14_;
	g_return_if_fail (self != NULL);
	if (self->priv->current_value <= 0) {
		CheeseCountdownCountdownCallback _tmp0_;
		gpointer _tmp0__target;
		_tmp0_ = self->priv->completed_callback;
		_tmp0__target = self->priv->completed_callback_target;
		_tmp0_ (_tmp0__target);
		self->running = FALSE;
		return;
	}
	_tmp1_ = self->priv->countdown_actor;
	_tmp2_ = g_strdup_printf ("%i", self->priv->current_value);
	_tmp3_ = _tmp2_;
	clutter_text_set_text (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->current_value;
	self->priv->current_value = _tmp4_ - 1;
	_tmp5_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	_g_object_unref0 (self->priv->pulse_in);
	self->priv->pulse_in = _tmp5_;
	_tmp6_ = self->priv->pulse_in;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp6_, (guint) 500);
	_tmp7_ = self->priv->pulse_in;
	g_value_init (&_tmp8_, G_TYPE_INT);
	g_value_set_int (&_tmp8_, 0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp7_, &_tmp8_);
	G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
	_tmp9_ = self->priv->pulse_in;
	g_value_init (&_tmp10_, G_TYPE_INT);
	g_value_set_int (&_tmp10_, 255);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp9_, &_tmp10_);
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	_tmp11_ = self->priv->pulse_in;
	g_signal_connect_object ((ClutterTimeline*) _tmp11_, "completed", (GCallback) _cheese_countdown_fade_out_clutter_timeline_completed, self, 0);
	_tmp12_ = self->priv->pulse_in;
	_tmp13_ = self->priv->countdown_actor;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp12_, (ClutterAnimatable*) _tmp13_);
	_tmp14_ = self->priv->pulse_in;
	clutter_timeline_start ((ClutterTimeline*) _tmp14_);
}

/**
   * Start the countdown, using the countdown-duration GSetting for the time.
   *
   * @param completed_callback the callback to call upon countdown completion
   */
void
cheese_countdown_start (CheeseCountdown* self,
                        CheeseCountdownCountdownCallback completed_callback,
                        gpointer completed_callback_target)
{
	GSettings* _tmp0_;
	ClutterText* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->completed_callback = completed_callback;
	self->priv->completed_callback_target = completed_callback_target;
	_tmp0_ = self->priv->settings;
	self->priv->current_value = g_settings_get_int (_tmp0_, "countdown-duration");
	self->running = TRUE;
	_tmp1_ = self->priv->countdown_actor;
	clutter_actor_show ((ClutterActor*) _tmp1_);
	cheese_countdown_fade_in (self);
}

/**
   * Stop the countdown, for example if it was interrupted by the user.
   */
void
cheese_countdown_stop (CheeseCountdown* self)
{
	ClutterText* _tmp0_;
	ClutterText* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_actor;
	clutter_actor_hide ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->countdown_actor;
	clutter_actor_remove_all_transitions ((ClutterActor*) _tmp1_);
	self->running = FALSE;
}

static void
cheese_countdown_class_init (CheeseCountdownClass * klass,
                             gpointer klass_data)
{
	cheese_countdown_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheeseCountdown_private_offset);
	G_OBJECT_CLASS (klass)->finalize = cheese_countdown_finalize;
}

static void
cheese_countdown_instance_init (CheeseCountdown * self,
                                gpointer klass)
{
	self->priv = cheese_countdown_get_instance_private (self);
	self->priv->current_value = 0;
}

static void
cheese_countdown_finalize (GObject * obj)
{
	CheeseCountdown * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_COUNTDOWN, CheeseCountdown);
	cheese_countdown_stop (self);
	_g_object_unref0 (self->priv->countdown_actor);
	_g_object_unref0 (self->priv->pulse_in);
	_g_object_unref0 (self->priv->pulse_out);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (cheese_countdown_parent_class)->finalize (obj);
}

static GType
cheese_countdown_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheeseCountdownClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_countdown_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseCountdown), 0, (GInstanceInitFunc) cheese_countdown_instance_init, NULL };
	GType cheese_countdown_type_id;
	cheese_countdown_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseCountdown", &g_define_type_info, 0);
	CheeseCountdown_private_offset = g_type_add_instance_private (cheese_countdown_type_id, sizeof (CheeseCountdownPrivate));
	return cheese_countdown_type_id;
}

GType
cheese_countdown_get_type (void)
{
	static volatile gsize cheese_countdown_type_id__once = 0;
	if (g_once_init_enter (&cheese_countdown_type_id__once)) {
		GType cheese_countdown_type_id;
		cheese_countdown_type_id = cheese_countdown_get_type_once ();
		g_once_init_leave (&cheese_countdown_type_id__once, cheese_countdown_type_id);
	}
	return cheese_countdown_type_id__once;
}

