/* chess-engine-cecp.c generated by valac 0.56.3, the Vala compiler
 * generated from chess-engine-cecp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "libengine.h"
#include <glib.h>
#include "libchess.h"
#include <string.h>
#include <stdlib.h>

enum  {
	CHESS_ENGINE_CECP_0_PROPERTY,
	CHESS_ENGINE_CECP_NUM_PROPERTIES
};
static GParamSpec* chess_engine_cecp_properties[CHESS_ENGINE_CECP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngineCECPPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gboolean moving;
	gchar** options;
	gint options_length1;
	gint _options_size_;
};

static gint ChessEngineCECP_private_offset;
static gpointer chess_engine_cecp_parent_class = NULL;

static gchar** _vala_array_dup10 (gchar** self,
                           gssize length);
static void chess_engine_cecp_start_cb (ChessEngineCECP* self);
static void _chess_engine_cecp_start_cb_chess_engine_starting (ChessEngine* _sender,
                                                        gpointer self);
static void chess_engine_cecp_real_process_input (ChessEngine* base,
                                           gchar* data,
                                           gint data_length1);
static gchar* _vala_array_dup11 (gchar* self,
                          gssize length);
static void chess_engine_cecp_real_start_game (ChessEngine* base);
static void chess_engine_cecp_real_request_move (ChessEngine* base);
static void chess_engine_cecp_real_report_move (ChessEngine* base,
                                         ChessMove* move);
static void chess_engine_cecp_real_do_undo (ChessEngine* base);
static void chess_engine_cecp_finalize (GObject * obj);
static GType chess_engine_cecp_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
chess_engine_cecp_get_instance_private (ChessEngineCECP* self)
{
	return G_STRUCT_MEMBER_P (self, ChessEngineCECP_private_offset);
}

static gchar**
_vala_array_dup10 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_chess_engine_cecp_start_cb_chess_engine_starting (ChessEngine* _sender,
                                                   gpointer self)
{
	chess_engine_cecp_start_cb ((ChessEngineCECP*) self);
}

ChessEngineCECP*
chess_engine_cecp_construct (GType object_type,
                             const gchar* binary,
                             gchar** args,
                             gint args_length1,
                             guint delay_seconds,
                             gchar** options,
                             gint options_length1)
{
	ChessEngineCECP * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (binary != NULL, NULL);
	self = (ChessEngineCECP*) chess_engine_construct (object_type, binary, args, (gint) args_length1, delay_seconds);
	_tmp0_ = (options != NULL) ? _vala_array_dup10 (options, options_length1) : options;
	_tmp0__length1 = options_length1;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options = _tmp0_;
	self->priv->options_length1 = _tmp0__length1;
	self->priv->_options_size_ = self->priv->options_length1;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_cecp_start_cb_chess_engine_starting, self, 0);
	return self;
}

ChessEngineCECP*
chess_engine_cecp_new (const gchar* binary,
                       gchar** args,
                       gint args_length1,
                       guint delay_seconds,
                       gchar** options,
                       gint options_length1)
{
	return chess_engine_cecp_construct (TYPE_CHESS_ENGINE_CECP, binary, args, args_length1, delay_seconds, options, options_length1);
}

static void
chess_engine_cecp_start_cb (ChessEngineCECP* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "xboard");
	chess_engine_write_line ((ChessEngine*) self, "random");
	_tmp0_ = self->priv->options;
	_tmp0__length1 = self->priv->options_length1;
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < o_collection_length1; o_it = o_it + 1) {
			gchar* _tmp1_;
			gchar* o = NULL;
			_tmp1_ = g_strdup (o_collection[o_it]);
			o = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = o;
				chess_engine_write_line ((ChessEngine*) self, _tmp2_);
				_g_free0 (o);
			}
		}
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
_vala_array_dup11 (gchar* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static void
chess_engine_cecp_real_process_input (ChessEngine* base,
                                      gchar* data,
                                      gint data_length1)
{
	ChessEngineCECP * self;
	gint current = 0;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	self = (ChessEngineCECP*) base;
	_tmp0_ = self->priv->buffer;
	_tmp0__length1 = self->priv->buffer_length1;
	current = _tmp0__length1;
	_tmp1_ = self->priv->buffer;
	_tmp1__length1 = self->priv->buffer_length1;
	_tmp2_ = (gint) (_tmp1__length1 + data_length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + data_length1));
	(_tmp2_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp2_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp2_;
	self->priv->_buffer_size_ = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* _tmp5_;
				gint _tmp5__length1;
				gchar _tmp6_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < data_length1)) {
					break;
				}
				_tmp5_ = self->priv->buffer;
				_tmp5__length1 = self->priv->buffer_length1;
				_tmp6_ = data[i];
				_tmp5_[current + i] = _tmp6_;
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gchar* _tmp13_;
		gint _tmp13__length1;
		gchar* _tmp14_;
		gint _tmp14__length1;
		gchar* line = NULL;
		gchar* _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar** move_prefixes = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		gint move_prefixes_length1;
		gint _move_prefixes_size_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		gboolean _tmp41_ = FALSE;
		const gchar* _tmp42_;
		gchar* _tmp59_;
		gint _tmp59__length1;
		gchar* _tmp60_;
		gint _tmp60__length1;
		gchar* _tmp61_;
		gint _tmp61__length1;
		{
			gboolean _tmp7_ = FALSE;
			offset = 0;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_ = FALSE;
				gchar* _tmp10_;
				gint _tmp10__length1;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = offset;
					offset = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = self->priv->buffer;
				_tmp10__length1 = self->priv->buffer_length1;
				if (offset < _tmp10__length1) {
					gchar* _tmp11_;
					gint _tmp11__length1;
					gchar _tmp12_;
					_tmp11_ = self->priv->buffer;
					_tmp11__length1 = self->priv->buffer_length1;
					_tmp12_ = _tmp11_[offset];
					_tmp9_ = _tmp12_ != '\n';
				} else {
					_tmp9_ = FALSE;
				}
				if (!_tmp9_) {
					break;
				}
			}
		}
		_tmp13_ = self->priv->buffer;
		_tmp13__length1 = self->priv->buffer_length1;
		if (offset >= _tmp13__length1) {
			return;
		}
		_tmp14_ = self->priv->buffer;
		_tmp14__length1 = self->priv->buffer_length1;
		_tmp14_[offset] = '\0';
		_tmp15_ = self->priv->buffer;
		_tmp15__length1 = self->priv->buffer_length1;
		_tmp16_ = g_strdup ((const gchar*) _tmp15_);
		line = _tmp16_;
		_tmp17_ = line;
		g_debug ("chess-engine-cecp.vala:55: Read from engine: '%s'", _tmp17_);
		_tmp18_ = g_strdup ("My move is: ");
		_tmp19_ = g_strdup ("My move is : ");
		_tmp20_ = g_strdup ("my move is ");
		_tmp21_ = g_strdup ("move ");
		_tmp22_ = g_new0 (gchar*, 4 + 1);
		_tmp22_[0] = _tmp18_;
		_tmp22_[1] = _tmp19_;
		_tmp22_[2] = _tmp20_;
		_tmp22_[3] = _tmp21_;
		move_prefixes = _tmp22_;
		move_prefixes_length1 = 4;
		_move_prefixes_size_ = move_prefixes_length1;
		_tmp23_ = move_prefixes;
		_tmp23__length1 = move_prefixes_length1;
		{
			gchar** prefix_collection = NULL;
			gint prefix_collection_length1 = 0;
			gint _prefix_collection_size_ = 0;
			gint prefix_it = 0;
			prefix_collection = _tmp23_;
			prefix_collection_length1 = _tmp23__length1;
			for (prefix_it = 0; prefix_it < prefix_collection_length1; prefix_it = prefix_it + 1) {
				gchar* _tmp24_;
				gchar* prefix = NULL;
				_tmp24_ = g_strdup (prefix_collection[prefix_it]);
				prefix = _tmp24_;
				{
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					_tmp25_ = line;
					_tmp26_ = prefix;
					if (g_str_has_prefix (_tmp25_, _tmp26_)) {
						gchar* move = NULL;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						const gchar* _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						gchar* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp27_ = line;
						_tmp28_ = prefix;
						_tmp29_ = strlen (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = line;
						_tmp32_ = strlen (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = string_slice (_tmp27_, (glong) _tmp30_, (glong) _tmp33_);
						move = _tmp34_;
						_tmp35_ = move;
						g_debug ("chess-engine-cecp.vala:63: Engine moves %s", _tmp35_);
						self->priv->moving = TRUE;
						_tmp36_ = move;
						_tmp37_ = string_strip (_tmp36_);
						_tmp38_ = _tmp37_;
						g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp38_);
						_g_free0 (_tmp38_);
						_g_free0 (move);
					}
					_g_free0 (prefix);
				}
			}
		}
		_tmp42_ = line;
		if (g_strcmp0 (_tmp42_, "resign") == 0) {
			_tmp41_ = TRUE;
		} else {
			const gchar* _tmp43_;
			_tmp43_ = line;
			_tmp41_ = g_strcmp0 (_tmp43_, "tellics resign") == 0;
		}
		if (_tmp41_) {
			_tmp40_ = TRUE;
		} else {
			gboolean _tmp44_ = FALSE;
			const gchar* _tmp45_;
			_tmp45_ = line;
			if (g_str_has_prefix (_tmp45_, "1-0 {")) {
				const gchar* _tmp46_;
				_tmp46_ = line;
				_tmp44_ = string_contains (_tmp46_, "resign");
			} else {
				_tmp44_ = FALSE;
			}
			_tmp40_ = _tmp44_;
		}
		if (_tmp40_) {
			_tmp39_ = TRUE;
		} else {
			gboolean _tmp47_ = FALSE;
			const gchar* _tmp48_;
			_tmp48_ = line;
			if (g_str_has_prefix (_tmp48_, "0-1 {")) {
				const gchar* _tmp49_;
				_tmp49_ = line;
				_tmp47_ = string_contains (_tmp49_, "resign");
			} else {
				_tmp47_ = FALSE;
			}
			_tmp39_ = _tmp47_;
		}
		if (_tmp39_) {
			g_signal_emit_by_name ((ChessEngine*) self, "resigned");
		} else {
			const gchar* _tmp50_;
			_tmp50_ = line;
			if (g_str_has_prefix (_tmp50_, "Illegal move: ")) {
				chess_engine_stop ((ChessEngine*) self, TRUE);
				g_signal_emit_by_name ((ChessEngine*) self, "error");
			} else {
				gboolean _tmp51_ = FALSE;
				gboolean _tmp52_ = FALSE;
				gboolean _tmp53_ = FALSE;
				const gchar* _tmp54_;
				_tmp54_ = line;
				if (g_strcmp0 (_tmp54_, "game is a draw") == 0) {
					_tmp53_ = TRUE;
				} else {
					const gchar* _tmp55_;
					_tmp55_ = line;
					_tmp53_ = g_strcmp0 (_tmp55_, "draw") == 0;
				}
				if (_tmp53_) {
					_tmp52_ = TRUE;
				} else {
					const gchar* _tmp56_;
					_tmp56_ = line;
					_tmp52_ = g_strcmp0 (_tmp56_, "Draw") == 0;
				}
				if (_tmp52_) {
					_tmp51_ = TRUE;
				} else {
					const gchar* _tmp57_;
					_tmp57_ = line;
					_tmp51_ = g_str_has_prefix (_tmp57_, "1/2-1/2");
				}
				if (_tmp51_) {
					g_signal_emit_by_name ((ChessEngine*) self, "claim-draw");
				} else {
					const gchar* _tmp58_;
					_tmp58_ = line;
					if (g_strcmp0 (_tmp58_, "offer draw") == 0) {
						g_signal_emit_by_name ((ChessEngine*) self, "offer-draw");
					}
				}
			}
		}
		_tmp59_ = self->priv->buffer;
		_tmp59__length1 = self->priv->buffer_length1;
		_tmp60_ = self->priv->buffer;
		_tmp60__length1 = self->priv->buffer_length1;
		_tmp61_ = (_tmp59_ != NULL) ? _vala_array_dup11 (_tmp59_ + (offset + 1), _tmp60__length1 - (offset + 1)) : _tmp59_;
		_tmp61__length1 = _tmp60__length1 - (offset + 1);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp61_;
		self->priv->buffer_length1 = _tmp61__length1;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		move_prefixes = (_vala_array_free (move_prefixes, move_prefixes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}

static void
chess_engine_cecp_real_start_game (ChessEngine* base)
{
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
}

static void
chess_engine_cecp_real_request_move (ChessEngine* base)
{
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	chess_engine_write_line ((ChessEngine*) self, "go");
}

static void
chess_engine_cecp_real_report_move (ChessEngine* base,
                                    ChessMove* move)
{
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	g_return_if_fail (move != NULL);
	if (!self->priv->moving) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		chess_engine_write_line ((ChessEngine*) self, "force");
		_tmp0_ = chess_move_get_engine (move);
		_tmp1_ = _tmp0_;
		chess_engine_write_line ((ChessEngine*) self, _tmp1_);
		_g_free0 (_tmp1_);
	}
	self->priv->moving = FALSE;
}

static void
chess_engine_cecp_real_do_undo (ChessEngine* base)
{
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	chess_engine_write_line ((ChessEngine*) self, "force");
	chess_engine_write_line ((ChessEngine*) self, "undo");
}

static void
chess_engine_cecp_class_init (ChessEngineCECPClass * klass,
                              gpointer klass_data)
{
	chess_engine_cecp_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessEngineCECP_private_offset);
	((ChessEngineClass *) klass)->process_input = (void (*) (ChessEngine*, gchar*, gint)) chess_engine_cecp_real_process_input;
	((ChessEngineClass *) klass)->start_game = (void (*) (ChessEngine*)) chess_engine_cecp_real_start_game;
	((ChessEngineClass *) klass)->request_move = (void (*) (ChessEngine*)) chess_engine_cecp_real_request_move;
	((ChessEngineClass *) klass)->report_move = (void (*) (ChessEngine*, ChessMove*)) chess_engine_cecp_real_report_move;
	((ChessEngineClass *) klass)->do_undo = (void (*) (ChessEngine*)) chess_engine_cecp_real_do_undo;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_cecp_finalize;
}

static void
chess_engine_cecp_instance_init (ChessEngineCECP * self,
                                 gpointer klass)
{
	self->priv = chess_engine_cecp_get_instance_private (self);
	self->priv->moving = FALSE;
}

static void
chess_engine_cecp_finalize (GObject * obj)
{
	ChessEngineCECP * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_CECP, ChessEngineCECP);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (chess_engine_cecp_parent_class)->finalize (obj);
}

static GType
chess_engine_cecp_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessEngineCECPClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_cecp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineCECP), 0, (GInstanceInitFunc) chess_engine_cecp_instance_init, NULL };
	GType chess_engine_cecp_type_id;
	chess_engine_cecp_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineCECP", &g_define_type_info, 0);
	ChessEngineCECP_private_offset = g_type_add_instance_private (chess_engine_cecp_type_id, sizeof (ChessEngineCECPPrivate));
	return chess_engine_cecp_type_id;
}

GType
chess_engine_cecp_get_type (void)
{
	static volatile gsize chess_engine_cecp_type_id__once = 0;
	if (g_once_init_enter (&chess_engine_cecp_type_id__once)) {
		GType chess_engine_cecp_type_id;
		chess_engine_cecp_type_id = chess_engine_cecp_get_type_once ();
		g_once_init_leave (&chess_engine_cecp_type_id__once, chess_engine_cecp_type_id);
	}
	return chess_engine_cecp_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

