/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredModuleReference;

public class RecoveredExport
extends RecoveredElement {
    public ExportsStatement exportReference;
    RecoveredModuleReference[] targets;
    int targetCount = 0;

    public RecoveredExport(ExportsStatement exportsStatement, RecoveredElement recoveredElement, int n) {
        super(recoveredElement, n);
        this.exportReference = exportsStatement;
    }

    public RecoveredElement add(ModuleReference moduleReference, int n) {
        if (this.targets == null) {
            this.targets = new RecoveredModuleReference[5];
            this.targetCount = 0;
        } else if (this.targetCount == this.targets.length) {
            this.targets = new RecoveredModuleReference[2 * this.targetCount];
            System.arraycopy(this.targets, 0, this.targets, 0, this.targetCount);
        }
        RecoveredModuleReference recoveredModuleReference = new RecoveredModuleReference(moduleReference, this, n);
        this.targets[this.targetCount++] = recoveredModuleReference;
        if (moduleReference.sourceEnd == 0) {
            return recoveredModuleReference;
        }
        return this;
    }

    @Override
    public ASTNode parseTree() {
        return this.exportReference;
    }

    @Override
    public int sourceEnd() {
        return this.exportReference.declarationSourceEnd;
    }

    @Override
    public String toString(int n) {
        return this.tabString(n) + "Recovered export: " + this.exportReference.toString();
    }

    public ExportsStatement updatedExportReference() {
        if (this.targetCount > 0) {
            int n = this.exportReference.targets != null ? this.exportReference.targets.length : 0;
            int n2 = 0;
            ModuleReference[] moduleReferenceArray = new ModuleReference[n + this.targetCount];
            if (n > 0) {
                System.arraycopy(this.exportReference.targets, 0, moduleReferenceArray, 0, n);
                n2 = n;
            }
            int n3 = this.targetCount;
            for (int i = 0; i < n3; ++i) {
                moduleReferenceArray[n2++] = this.targets[i].updatedModuleReference();
            }
            this.exportReference.targets = moduleReferenceArray;
        }
        return this.exportReference;
    }

    @Override
    public void updateParseTree() {
        this.updatedExportReference();
    }

    @Override
    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.exportReference.declarationSourceEnd == 0) {
            this.exportReference.declarationSourceEnd = n2;
            this.exportReference.declarationEnd = n2;
        }
    }
}

