/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class ChannelInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel".
 */
class TP_QT_EXPORT ChannelInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel");
    }

    /**
     * Creates a ChannelInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c ChannelType of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The channel's type. This cannot change once the channel has
     *   been created.</p>
     * 
     * <p>For compatibility between older connection managers and newer
     *   clients, if this is unavailable or is an empty string,
     *   clients MUST use the result of calling
     *    \endhtmlonly GetChannelType() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   The GetAll method lets clients retrieve all properties in one
     *   round-trip, which is desirable.
     * </div>
     * 
     * <p>When requesting a channel, the request MUST specify a channel
     *   type, and the request MUST fail if the specified channel type
     *   cannot be supplied.</p>
     * 
     * <div class="rationale">
     *   Common sense.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyChannelType() const
    {
        return internalRequestProperty(QLatin1String("ChannelType"));
    }

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>Extra interfaces provided by this channel. This SHOULD NOT include
     *   the channel type and the Channel interface itself, and cannot
     *   change once the channel has been created.</p>
     * 
     * <p>For compatibility between older connection managers and newer
     *   clients, if this is unavailable, or if this is an empty list and
     *    \endhtmlonly \link requestPropertyChannelType() ChannelType \endlink \htmlonly  is an empty string,
     *   clients MUST use the result of calling
     *    \endhtmlonly GetInterfaces() \htmlonly  instead. If this is an
     *   empty list but ChannelType is non-empty, clients SHOULD NOT call
     *   GetInterfaces; this implies that connection managers that implement
     *   the ChannelType property MUST also implement the Interfaces property
     *   correctly.</p>
     * 
     * <div class="rationale">
     *   The GetAll method lets clients retrieve all properties in one
     *   round-trip, which is desirable.
     * </div>
     * 
     * <p>When requesting a channel with a particular value for this
     *   property, the request must fail without side-effects unless the
     *   connection manager expects to be able to provide a channel whose
     *   interfaces include at least the interfaces requested.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c TargetHandle of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The handle (a representation for the identifier) of the contact,
     *   chatroom, etc. with which this handle communicates. Its type
     *   is given by the  \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly 
     *   property.</p>
     * 
     * <p>This is fixed for the lifetime of the channel, so channels which
     *   could potentially be used to communicate with multiple contacts,
     *   and do not have an identity of their own (such as a Handle_Type_Room
     *   handle), must have TargetHandleType set to Handle_Type_None and
     *   TargetHandle set to 0.</p>
     * 
     * <p>Unlike in the telepathy-spec 0.16 API, there is no particular
     *   uniqueness guarantee - there can be many channels with the same
     *   (channel type, handle type, handle) tuple. This is necessary
     *   to support conversation threads in XMPP and SIP, for example.</p>
     * 
     * <p>If this is present in a channel request, it must be nonzero,
     *    \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly 
     *   MUST be present and not Handle_Type_None, and
     *    \endhtmlonly \link requestPropertyTargetID() TargetID \endlink \htmlonly  MUST NOT be
     *   present. Properties from
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly 
     *   MUST NOT be present.</p>
     * 
     * <p>The channel that satisfies the request MUST either:</p>
     * 
     * <ul>
     *   <li>have the specified TargetHandle property; or</li>
     *   <li>have  \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly  =
     *     Handle_Type_None, TargetHandle = 0, and be configured such that
     *     it could communicate with the specified handle in some other way
     *     (e.g. have the requested contact handle in its Group
     *     interface)</li>
     * </ul>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTargetHandle() const
    {
        return internalRequestProperty(QLatin1String("TargetHandle"));
    }

    /**
     * Asynchronous getter for the remote object property \c TargetID of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The string that would result from inspecting the
     *    \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly 
     *   property (i.e. the identifier in the IM protocol of the contact,
     *   room, etc. with which this channel communicates), or the empty
     *   string if the TargetHandle is 0.</p>
     * 
     * <div class="rationale">
     *   <p>The presence of this property avoids the following race
     *     condition:</p>
     * 
     *   <ul>
     *     <li>New channel C is signalled with target handle T</li>
     *     <li>Client calls  \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [T])</li>
     *     <li>Channel C closes, removing the last reference to handle T</li>
     *     <li> \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [T]) returns an error</li>
     *   </ul>
     * </div>
     * 
     * <p>If this is present in a channel request,
     *    \endhtmlonly \link requestPropertyTargetHandleType() TargetHandleType \endlink \htmlonly 
     *   MUST be present and not Handle_Type_None, and
     *    \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly  MUST NOT be
     *   present. Properties from
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly 
     *   MUST NOT be present.The request MUST fail with error InvalidHandle,
     *   without side-effects, if the requested TargetID would not be
     *   accepted by
     *    \endhtmlonly ConnectionInterface::RequestHandles() \htmlonly .</p>
     * 
     * <p>The returned channel must be related to the handle corresponding
     *   to the given identifier, in the same way as if TargetHandle
     *   had been part of the request instead.</p>
     * 
     * <div class="rationale">
     *   <p>Requesting channels with a string identifier saves a round-trip
     *     (the call to RequestHandles). It also allows the channel
     *     dispatcher to accept a channel request for an account that is not
     *     yet connected (and thus has no valid handles), bring the account
     *     online, and pass on the same parameters to the new connection's
     *     CreateChannel method.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTargetID() const
    {
        return internalRequestProperty(QLatin1String("TargetID"));
    }

    /**
     * Asynchronous getter for the remote object property \c TargetHandleType of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The type of  \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly .</p>
     * 
     * <p>If this is omitted from a channel request, connection managers
     *   SHOULD treat this as equivalent to Handle_Type_None.</p>
     * 
     * <p>If this is omitted or is Handle_Type_None,
     *    \endhtmlonly \link requestPropertyTargetHandle() TargetHandle \endlink \htmlonly  and
     *    \endhtmlonly \link requestPropertyTargetID() TargetID \endlink \htmlonly  MUST be omitted from the
     *   request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTargetHandleType() const
    {
        return internalRequestProperty(QLatin1String("TargetHandleType"));
    }

    /**
     * Asynchronous getter for the remote object property \c Requested of type \c bool.
     *
     * 
     * \htmlonly
     * <p>True if this channel was created in response to a local request,
     *   such as a call to
     *    \endhtmlonly ConnectionInterface::RequestChannel() \htmlonly 
     *   or
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   <p>The idea of this property is to distinguish between &quot;incoming&quot;
     *     and &quot;outgoing&quot; channels, in a way that doesn't break down when
     *     considering special cases like contact lists that are automatically
     *     created on connection to the server, or chatrooms that an
     *     IRC proxy/bouncer like irssi-proxy or bip was already in.</p>
     * 
     *   <p>The reason we want to make that distinction is that UIs for
     *     things that the user explicitly requested should start up
     *     automatically, whereas for incoming messages and VoIP calls we
     *     should first ask the user whether they want to open the messaging
     *     UI or accept the call.</p>
     * </div>
     * 
     * <p>If the channel was not explicitly requested (even if it was
     *   created as a side-effect of a call to one of those functions,
     *   e.g. because joining a Tube in a MUC context on XMPP implies
     *   joining that MUC), then this property is false.</p>
     * 
     * <p>For compatibility with older connection managers, clients SHOULD
     *   assume that this property is true if they see a channel announced
     *   by the
     *    \endhtmlonly ConnectionInterface::NewChannel() \htmlonly 
     *   signal with the suppress_handler parameter set to true.</p>
     * 
     * <div class="rationale">
     *   <p>In a correct connection manager, the only way to get such a
     *     channel is to request it.</p>
     * </div>
     * 
     * <p>Clients MAY additionally assume that this property is false
     *   if they see a channel announced by the NewChannel signal with the
     *   suppress_handler parameter set to false.</p>
     * 
     * <div class="rationale">
     *   <p>This is more controversial, since it's possible to get that
     *     parameter set to false by requesting a channel. However, there's
     *     no good reason to do so, and we've deprecated this practice.</p>
     * 
     *   <p>In the particular case of the channel dispatcher, the only
     *     side-effect of wrongly thinking a channel is unrequested
     *     is likely to be that the user has to confirm that they want to
     *     use it, so it seems fairly harmless to assume in the channel
     *     dispatcher that channels with suppress_handler false are
     *     indeed unrequested.</p>
     * </div>
     * 
     * <p>It does not make sense for this property to be in channel
     *   requests—it will always be true for channels returned by
     *   CreateChannel, and callers of EnsureChannel cannot control whether an
     *   existing channel was originally requested locally—so it MUST NOT
     *   be accepted.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequested() const
    {
        return internalRequestProperty(QLatin1String("Requested"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitiatorHandle of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The contact who initiated the channel; for instance, the contact
     *   who invited the local user to a chatroom, or the contact who
     *   initiated a call.</p>
     * 
     * <p>This does <em>not</em> necessarily represent the contact who
     *   created the underlying protocol-level construct. For instance, if
     *   Rob creates a chatroom, Will joins that chatroom, and Will invites Simon
     *   to join it, then Simon will see Will as the InitiatorHandle of the
     *   channel representing the chatroom.</p>
     * 
     * <div class="rationale">
     *   <p>The room creator is generally a less useful piece of information
     *     than the inviter, is less likely to be available at invitation
     *     time (i.e. can't necessarily be an immutable property), and is
     *     less likely to be available at all. The creator of a chatroom
     *     is not currently available via Telepathy; if added in future, it
     *     is likely to be made available as a property on the Chatroom
     *     interface (<a href="http://bugs.freedesktop.org/show_bug.cgi?id=23151">bug 23151</a>).</p>
     * </div>
     * 
     * <p>For channels requested by the
     *   local user, this MUST be the value of
     *    \endhtmlonly \link ConnectionInterface::requestPropertySelfHandle() ConnectionInterface::SelfHandle \endlink \htmlonly 
     *   at the time the channel was created (i.e. not a channel-specific
     *   handle).</p>
     * 
     * <div class="rationale">
     *   <p>On some protocols, the SelfHandle may change (as signalled by
     *      \endhtmlonly ConnectionInterface::SelfContactChanged() \htmlonly ),
     *     but this property is immutable. Hence, locally-requested channels'
     *     InitiatorHandle and InitiatorID may not match the current
     *     SelfHandle;  \endhtmlonly \link requestPropertyRequested() Requested \endlink \htmlonly  can be used to
     *     determine whether the channel was created locally.</p>
     * </div>
     * 
     * <p>For channels requested by a remote user, this MUST be their handle.
     *   If unavailable or not applicable, this MUST be 0 (for instance,
     *   contact lists are not really initiated by anyone in particular, and
     *   it's easy to imagine a protocol where chatroom invitations can be
     *   anonymous).</p>
     * 
     * <p>For channels with the  \endhtmlonly ChannelInterfaceGroupInterface \htmlonly 
     *   interface, this SHOULD be the same
     *   contact who is signalled as the &quot;Actor&quot; causing the self-handle
     *   to be placed in the local-pending set.</p>
     * 
     * <p>This SHOULD NOT be a channel-specific handle, if possible.</p>
     * 
     * <p>It does not make sense for this property to be in channel
     *   requests - the initiator will always be the local user - so it
     *   MUST NOT be accepted.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitiatorHandle() const
    {
        return internalRequestProperty(QLatin1String("InitiatorHandle"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitiatorID of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The string that would result from inspecting the
     *    \endhtmlonly \link requestPropertyInitiatorHandle() InitiatorHandle \endlink \htmlonly 
     *   property (i.e. the initiator's identifier in the IM protocol).</p>
     * 
     * <div class="rationale">
     *   <p>The presence of this property avoids the following race
     *     condition:</p>
     * 
     *   <ul>
     *     <li>New StreamedMedia channel C is signalled with initiator
     *       handle I</li>
     *     <li>Client calls  \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [I])</li>
     *     <li>Channel C closes, removing the last reference to handle I</li>
     *     <li> \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly (CONTACT,
     *       [I]) returns an error</li>
     *     <li>Client can indicate that a call was missed, but not who
     *       called!</li>
     *   </ul>
     * </div>
     * 
     * <p>It does not make sense for this property to be in channel
     *   requests - the initiator will always be the local user - so it
     *   MUST NOT be accepted.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitiatorID() const
    {
        return internalRequestProperty(QLatin1String("InitiatorID"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Close on the remote object.
     * 
     * Request that the channel be closed. This is not the case until the 
     * Closed signal has been emitted, and depending on the connection manager 
     * this may simply remove you from the channel on the server, rather than 
     * causing it to stop existing entirely. Some channels such as contact 
     * list channels may not be closed.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Close(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Close"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetChannelType on the remote object.
     * 
     * Returns the interface name for the type of this channel. Clients SHOULD 
     * use the ChannelType property instead, falling back to this method only 
     * if necessary. The GetAll method lets clients retrieve all properties in 
     * one round-trip.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The interface name
     */
    inline QDBusPendingReply<QString> GetChannelType(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetChannelType"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetHandle on the remote object.
     * 
     * Returns the handle type and number if this channel represents a 
     * communication with a particular contact, room or server-stored list, or 
     * zero if it is transient and defined only by its contents. Clients 
     * SHOULD use the TargetHandle and TargetHandleType properties instead, 
     * falling back to this method only if necessary. The GetAll method lets 
     * clients retrieve all properties in one round-trip.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The same as TargetHandleType.
     *
     * \return
     *     
     *     The same as TargetHandle.
     */
    inline QDBusPendingReply<uint, uint> GetHandle(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint, uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetHandle"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetInterfaces on the remote object.
     * 
     * Get the optional interfaces implemented by the channel. Clients SHOULD 
     * use the Interfaces property instead, falling back to this method only 
     * if necessary. The GetAll method lets clients retrieve all properties in 
     * one round-trip.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of the D-Bus interface names
     */
    inline QDBusPendingReply<QStringList> GetInterfaces(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QStringList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetInterfaces"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c Closed on the remote object.
     * 
     * Emitted when the channel has been closed. Method calls on the channel 
     * are no longer valid after this signal has been emitted, and the 
     * connection manager may then remove the object from the bus at any point.
     */
    void Closed();

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceAnonymityInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Anonymity".
 */
class TP_QT_EXPORT ChannelInterfaceAnonymityInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Anonymity", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Anonymity");
    }

    /**
     * Creates a ChannelInterfaceAnonymityInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceAnonymityInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceAnonymityInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceAnonymityInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceAnonymityInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceAnonymityInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceAnonymityInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceAnonymityInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceAnonymityInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceAnonymityInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c AnonymityModes of type \c uint.
     *
     * 
     * \htmlonly
     * The list of initially requested anonymity modes on the channel.  This
     * MUST NOT change, and is Requestable.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAnonymityModes() const
    {
        return internalRequestProperty(QLatin1String("AnonymityModes"));
    }

    /**
     * Asynchronous getter for the remote object property \c AnonymityMandatory of type \c bool.
     *
     * 
     * Whether or not the anonymity settings are required for this channel. 
     * This MUST NOT change, and is Requestable.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAnonymityMandatory() const
    {
        return internalRequestProperty(QLatin1String("AnonymityMandatory"));
    }

    /**
     * Asynchronous getter for the remote object property \c AnonymousID of type \c QString.
     *
     * 
     * \htmlonly
     * <p>This is the ID that the remote user of the channel MAY see
     * (assuming there's a single ID).  For example, for SIP connections
     * where the From address has been scrambled by the CM, the scrambled
     * address would be available here for the client to see.  This is
     * completely optional, and MAY be an empty string (&quot;&quot;) in
     * cases where anonymity modes are not set, or the CM doesn't know
     * what the remote contact will see, or any other case where this
     * doesn't make sense.</p>
     * 
     * <p>This MAY change over the lifetime of the channel, and SHOULD NOT
     * be used with the Request interface.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAnonymousID() const
    {
        return internalRequestProperty(QLatin1String("AnonymousID"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceCallStateInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.CallState".
 */
class TP_QT_EXPORT ChannelInterfaceCallStateInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.CallState", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.CallState");
    }

    /**
     * Creates a ChannelInterfaceCallStateInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceCallStateInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceCallStateInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceCallStateInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceCallStateInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceCallStateInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceCallStateInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceCallStateInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceCallStateInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceCallStateInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetCallStates on the remote object.
     * 
     * Get the current call states for all contacts involved in this call.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The current call states. Participants where the call state flags 
     *     would be 0 (all unset) may be omitted from this mapping.
     */
    inline QDBusPendingReply<Tp::ChannelCallStateMap> GetCallStates(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ChannelCallStateMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetCallStates"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c CallStateChanged on the remote object.
     * 
     * Emitted when the state of a member of the channel has changed.
     *
     * \param contact
     *     
     *     An integer handle for the contact.
     *
     * \param state
     *     
     *     The new state for this contact.
     */
    void CallStateChanged(uint contact, uint state);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceCaptchaAuthenticationInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1".
 */
class TP_QT_EXPORT ChannelInterfaceCaptchaAuthenticationInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1");
    }

    /**
     * Creates a ChannelInterfaceCaptchaAuthenticationInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceCaptchaAuthenticationInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceCaptchaAuthenticationInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceCaptchaAuthenticationInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceCaptchaAuthenticationInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceCaptchaAuthenticationInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceCaptchaAuthenticationInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceCaptchaAuthenticationInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceCaptchaAuthenticationInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceCaptchaAuthenticationInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c CanRetryCaptcha of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true,  \endhtmlonly GetCaptchas() \htmlonly 
     *   can be expected to return new captcha information when
     *   in the Local_Pending state. If false,
     *    \endhtmlonly GetCaptchas() \htmlonly  will return
     *   NotAvailable on subsequent calls.</p>
     * 
     * <div class="rationale">
     *   <p>Refreshing the captcha isn't required to work, although
     *     some protocols and implementations allow it. This is usually
     *     done in case a given captcha is unintelligible.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCanRetryCaptcha() const
    {
        return internalRequestProperty(QLatin1String("CanRetryCaptcha"));
    }

    /**
     * Asynchronous getter for the remote object property \c CaptchaStatus of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The current status of this channel.</p>
     * 
     * <p>Because only the Handler should call methods on this interface,
     *   the Handler MAY reduce round-trips by not fetching the initial
     *   value of this property, and instead assume that is initially
     *   Local_Pending.</p>
     * 
     * <div class="rationale">
     *   <p>This assumption normally avoids the need to call GetAll(),
     *     since the values of  \endhtmlonly \link requestPropertyCaptchaError() CaptchaError \endlink \htmlonly 
     *     and  \endhtmlonly \link requestPropertyCaptchaErrorDetails() CaptchaErrorDetails \endlink \htmlonly 
     *     are also implied by this assumption, and the only other
     *     property is  \endhtmlonly \link requestPropertyCanRetryCaptcha() CanRetryCaptcha \endlink \htmlonly ,
     *     which is immutable.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCaptchaStatus() const
    {
        return internalRequestProperty(QLatin1String("CaptchaStatus"));
    }

    /**
     * Asynchronous getter for the remote object property \c CaptchaError of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The reason for the  \endhtmlonly \link requestPropertyCaptchaStatus() CaptchaStatus \endlink \htmlonly , or
     *   an empty string if the state is neither Try_Again nor Failed.</p>
     * 
     * <p>Typical values: &quot;&quot;, Cancelled, AuthenticationFailed,
     *   CaptchaNotSupported</p>
     * 
     * <p>In particular, an ordinary authentication failure (as would
     *   be produced for an incorrect answer) SHOULD be represented by
     *   <tp:error-ref>AuthenticationFailed</tp:error-ref>,
     *   cancellation by the user's request SHOULD be represented
     *   by <tp:error-ref>Cancelled</tp:error-ref>, cancellation due
     *   to the inability to display the captcha to the user or otherwise
     *   answer it SHOULD be represented by
     *   <tp:error-ref>CaptchaNotSupported</tp:error-ref>, and
     *   cancellation by a local process due to inconsistent or invalid
     *   challenges from the server SHOULD be represented by
     *   <tp:error-ref>ServiceConfused</tp:error-ref>.</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, this error code SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCaptchaError() const
    {
        return internalRequestProperty(QLatin1String("CaptchaError"));
    }

    /**
     * Asynchronous getter for the remote object property \c CaptchaErrorDetails of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyCaptchaError() CaptchaError \endlink \htmlonly  is non-empty,
     *   any additional information about the last
     *   disconnection; otherwise, the empty map. The keys and values are
     *   the same as for the second argument of
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly .</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, these details SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCaptchaErrorDetails() const
    {
        return internalRequestProperty(QLatin1String("CaptchaErrorDetails"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetCaptchas on the remote object.
     * 
     * \htmlonly
     * <p>Gets information regarding each of the captcha methods
     *   available and which and how many need to be successfully answered</p>
     * 
     * <p>To call this method successfully, the state must be Local_Pending
     *   or Try_Again. If it is Local_Pending, it remains Local_Pending. If
     *   called more than once while in Local_Pending state, or if the state
     *   is Try_Again, this method fetches a new set of captcha challenges,
     *   if possible, and the state returns to Local_Pending.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, you could call GetCaptchas again from Local_Pending
     *     state if the user indicates that they can't understand the
     *     initially-offered captcha.</p>
     * 
     *   <p>This is a method, not a property, so that it can be used to
     *     fetch more than one set of captcha challenges, and so that
     *     change notification is not required. Only the Handler should
     *     call this method and calling GetAll would not reduce round-trips,
     *     so the usual reasons to prefer a property do not apply here.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     Information about each of the available captcha methods.
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     The number of captcha methods required to be answered
     *     in order to successfully complete this captcha challenge
     *     (most frequently 1, but XMPP allows servers to demand that
     *     more than one captcha is answered).
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     The language of each Label in Captcha_Info if available,
     *     for instance en_US, or &quot;&quot; if unknown.
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::CaptchaInfoList, uint, QString> GetCaptchas(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::CaptchaInfoList, uint, QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetCaptchas"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetCaptchaData on the remote object.
     * 
     * \htmlonly
     * <p>Fetch and return the captcha data. In protocols
     *   where captchas are downloaded out-of-band (for instance via HTTP),
     *   the connection manager is expected to do so.</p>
     * <p>Returns an empty array if the type was &quot;qa&quot;</p>
     * <div class="rationale">
     *   <p>If audio-based and image-based captchas are both available,
     *     we don't want to waste time downloading the audio until/unless
     *     the user asks to hear it. The extra D-Bus round-trips are not
     *     a problem, since they are expected to be quick compared with
     *     the time taken for the user to solve the captcha.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the captcha of which to retrieve data.
     *
     * \param mimeType
     *     
     *     MIME type picked by the Handler, chosen from the list of MIME types 
     *     received in GetCaptchas. XEP-0158 allows the same captcha to be 
     *     made available in multiple formats, for instance the same spoken 
     *     question as audio/x-wav, application/ogg and audio/speex.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     Captcha data as requested.
     */
    inline QDBusPendingReply<QByteArray> GetCaptchaData(uint ID, const QString& mimeType, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QByteArray>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetCaptchaData"));
        callMessage << QVariant::fromValue(ID) << QVariant::fromValue(mimeType);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AnswerCaptchas on the remote object.
     * 
     * \htmlonly
     * <p>Answer as many captchas as desired and/or required.</p>
     * <p>Callable in state Local_Pending only. State changes to
     *   Remote_Pending.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param answers
     *     
     *     The mapping of captcha IDs to answer strings.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AnswerCaptchas(const Tp::CaptchaAnswers& answers, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AnswerCaptchas"));
        callMessage << QVariant::fromValue(answers);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c CancelCaptcha on the remote object.
     * 
     * \htmlonly
     * <p>Cancel. State changes to Failed with error NotAvailable or
     *   Cancelled if it isn't already Failed. All you can do now is
     *   to close the channel.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param reason
     *     
     *     Reason for cancelling. This MAY be used to choose an error response 
     *     to the remote server, and SHOULD also be reflected in the 
     *     CaptchaError.
     *
     * \param debugMessage
     *     
     *     A textual description of the reason for cancelling, supplied by the 
     *     Handler. This message SHOULD NOT be sent to the remote server, but 
     *     SHOULD be copied into the &apos;debug-message&apos; field of the 
     *     CaptchaErrorDetails and ConnectionError.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> CancelCaptcha(uint reason, const QString& debugMessage, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CancelCaptcha"));
        callMessage << QVariant::fromValue(reason) << QVariant::fromValue(debugMessage);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceChatStateInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.ChatState".
 */
class TP_QT_EXPORT ChannelInterfaceChatStateInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.ChatState", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.ChatState");
    }

    /**
     * Creates a ChannelInterfaceChatStateInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceChatStateInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceChatStateInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceChatStateInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceChatStateInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceChatStateInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceChatStateInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceChatStateInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceChatStateInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceChatStateInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ChatStates of type \c Tp::ChatStateMap.
     *
     * 
     * \htmlonly
     * <p>A map containing the chat states of all contacts in this
     *   channel whose chat state is not Inactive.</p>
     * 
     * <p>Contacts in this channel, but who are not listed in this map,
     *   may be assumed to be in the Inactive state.</p>
     * 
     * <p>In implementations that do not have this property, its value may be
     *   assumed to be empty until a
     *    \endhtmlonly ChatStateChanged() \htmlonly  signal indicates
     *   otherwise.</p>
     * 
     * <div class="rationale">
     *   <p>This property was not present in older versions of telepathy-spec,
     *     because chat states in XMPP are not state-recoverable (if you
     *     miss the change notification signal, there's no way to know the
     *     state). However, this property still allows clients to recover
     *     state changes that were seen by the CM before the client started
     *     to deal with the channel.</p>
     * 
     *   <p>In CMs that follow older spec versions, assuming Inactive will
     *     mean that initial chat states will always be assumed to be
     *     Inactive, which is the best we can do. XEP 0085 specifies
     *     Inactive as the &quot;neutral&quot; state to be assumed unless told
     *     otherwise.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyChatStates() const
    {
        return internalRequestProperty(QLatin1String("ChatStates"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetChatState on the remote object.
     * 
     * Set the local state and notify other members of the channel that it has 
     * changed.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param state
     *     
     *     The new state.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetChatState(uint state, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetChatState"));
        callMessage << QVariant::fromValue(state);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ChatStateChanged on the remote object.
     * 
     * Emitted when the state of a member of the channel has changed. This 
     * includes local state.
     *
     * \param contact
     *     
     *     An integer handle for the contact.
     *
     * \param state
     *     
     *     The new state of this contact.
     */
    void ChatStateChanged(uint contact, uint state);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceConferenceInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Conference".
 */
class TP_QT_EXPORT ChannelInterfaceConferenceInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Conference", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Conference");
    }

    /**
     * Creates a ChannelInterfaceConferenceInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceConferenceInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceConferenceInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceConferenceInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceConferenceInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceConferenceInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceConferenceInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceConferenceInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceConferenceInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceConferenceInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Channels of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     *  <p>The individual  \endhtmlonly ChannelInterface \htmlonly s that
     *    are continued by this conference, which have the same  \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly  as this one, but with  \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly  = CONTACT.</p>
     * 
     *  <p>This property MUST NOT be requestable; instead, the
     *     \endhtmlonly \link requestPropertyInitialChannels() InitialChannels \endlink \htmlonly  property may be
     *    specified when requesting a channel.</p>
     * 
     *  <div class="rationale">
     *    <p>This is consistent with requesting
     *       \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  and
     *       \endhtmlonly \link requestPropertyInitialInviteeIDs() InitialInviteeIDs \endlink \htmlonly , rather than
     *      requesting  \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyMembers() ChannelInterfaceGroupInterface::Members \endlink \htmlonly 
     *      and some hypothetical ID version of that property.</p>
     * </div>
     * 
     *  <p>Change notification is via the
     *     \endhtmlonly ChannelMerged() \htmlonly  and
     *     \endhtmlonly ChannelRemoved() \htmlonly  signals.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyChannels() const
    {
        return internalRequestProperty(QLatin1String("Channels"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialChannels of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>The initial value of  \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly .</p>
     * 
     * <p>This property SHOULD be requestable. Omitting it from a request is
     *   equivalent to providing it with an empty list as value. Requests
     *   where its value has at least two channel paths SHOULD be expected to
     *   succeed on any implementation of this interface. If
     *    \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  and
     *    \endhtmlonly \link requestPropertyInitialInviteeIDs() InitialInviteeIDs \endlink \htmlonly  are
     *   <var>Allowed_Properties</var> in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly , then requests with zero
     *   or one channel paths SHOULD also succeed; otherwise, clients SHOULD
     *   NOT make requests with zero or one paths for this property.</p>
     * 
     * <div class="rationale">
     *   <p>In GSM, a pair of calls can be merged into a conference, but you
     *     can't start a conference call from zero or one existing calls. In
     *     XMPP and MSN, you can create a new chatroom, or upgrade one 1-1
     *     channel into a chatroom; however, on these protocols, it is also
     *     possible to fake GSM-style merging by upgrading the first channel,
     *     then inviting the targets of all the other channels into it.</p>
     * </div>
     * 
     * <p>If possible, the  \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly ' states SHOULD
     *   NOT be altered by merging them into a conference. However, depending on
     *   the protocol, the Channels MAY be placed in a &quot;frozen&quot; state by placing
     *   them in this property's value or by calling
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT.Merge \htmlonly  on them.</p>
     * 
     * <div class="rationale">
     *   <p>In Jingle, nothing special will happen to merged calls. UIs MAY
     *     automatically place calls on hold before merging them, if that is
     *     the desired behaviour; this SHOULD always work. Not doing
     *     an implicit hold/unhold seems to preserve least-astonishment.</p>
     * 
     *   <p>In GSM, the calls that are merged go into a state similar to
     *     Hold, but they cannot be unheld, only split from the conference
     *     call using  \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT.Split \htmlonly .</p>
     * </div>
     * 
     * <p>Depending on the protocol, it might be signalled to remote users
     *   that this channel is a continuation of all the requested channels,
     *   or that it is only a continuation of the first channel in the
     *   list.</p>
     * 
     * <div class="rationale">
     *   <p>In MSN, the conference steals the underlying switchboard (protocol
     *     construct) from one of its component channels, so the conference
     *     appears to remote users to be a continuation of that channel and no
     *     other. The connection manager has to make some arbitrary choice, so
     *     we arbitrarily mandate that it SHOULD choose the first channel in
     *     the list as the one to continue.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialChannels() const
    {
        return internalRequestProperty(QLatin1String("InitialChannels"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialInviteeHandles of type \c Tp::UIntList.
     *
     * 
     * \htmlonly
     * <p>A list of additional contacts invited to this conference when it
     *   was created.</p>
     * 
     * <p>If it is possible to invite new contacts when creating a conference
     *   (as opposed to merging several channels into one new conference
     *   channel), this property SHOULD be requestable, and appear in the allowed
     *   properties in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly . Otherwise, this property
     *   SHOULD NOT be requestable, and its value SHOULD always be the empty
     *   list.</p>
     * 
     * <div class="rationale">
     *   <p>On GSM you have to place a 1-1 call before you can merge it into a
     *     conference; on the other hand, you can invite new contacts to XMPP
     *     Muji calls and XMPP/MSN/Skype ad-hoc chat rooms without starting a
     *     1-1 channel with them first.</p>
     * </div>
     * 
     * <p>If included in a request, the given contacts are automatically
     *   invited into the new channel, as if they had been added with
     *    \endhtmlonly ChannelInterfaceGroupInterface::AddMembers() \htmlonly (InitialInviteeHandles,
     *    \endhtmlonly \link requestPropertyInvitationMessage() InvitationMessage \endlink \htmlonly ) immediately after
     *   the channel was created.</p>
     * 
     * <div class="rationale">
     *   <p>This is a simple convenience API for the common case that a UI
     *     upgrades a 1-1 chat to a multi-user chat solely in order to invite
     *     someone else to participate.</p>
     * </div>
     * 
     * <p>If the local user was not the initiator of this channel, the
     *    \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertySelfHandle() ChannelInterfaceGroupInterface::SelfHandle \endlink \htmlonly  SHOULD appear in the value of this
     *   property, together with any other contacts invited at the same time
     *   (if that information is known).</p>
     * 
     * <p>InitialInviteeHandles, InitialInviteeIDs and InitialChannels MAY be
     *   combined in a single request.</p>
     * 
     * <div class="rationale">
     *   <p>For example, if you have a 1-1 channel C1 with Rob, and you want
     *     to invite Sjoerd to join the discussion, you can do so by
     *     requesting a channel with InitialChannels=[C1] and
     *     InitialInviteeHandles=[sjoerd],
     *     or InitialChannels=[C1] and
     *     InitialInviteeIDs=[&quot;sjoerd@example.com&quot;].</p>
     * </div>
     * 
     * <p>If a request includes some combination of InitialInviteeHandles,
     *   InitialInviteeIDs and InitialChannels, then the value of
     *   InitialInviteeHandles on the resulting channel SHOULD be the union of
     *   the handles from InitialInviteeHandles, the handles corresponding
     *   to the InitialInviteeIDs, and the target handles of the
     *   InitialChannels, with any duplicate handles removed. Because this
     *   property is immutable, its value SHOULD be computed before the
     *   channel is announced via the NewChannels signal.</p>
     * 
     * <div class="rationale">
     *   <p>This simplifies identification of new channels in clients - they
     *     only have to look at one of the properties, not both. For example,
     *     after either of the requests mentioned above, the NewChannels
     *     signal would announce the channel with InitialChannels=[C1],
     *     InitialInviteeHandles=[rob, sjoerd], and
     *     InitialInviteeIDs=[&quot;rob@example.net&quot;, &quot;sjoerd.example.com&quot;].</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialInviteeHandles() const
    {
        return internalRequestProperty(QLatin1String("InitialInviteeHandles"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialInviteeIDs of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of additional contacts invited to this conference when it
     *   was created.</p>
     * 
     * <p>This property SHOULD be requestable if and only if
     *    \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  is requestable.
     *   Its semantics are the same, except that it takes a list of the
     *   string representations of contact handles; invitations are sent to
     *   any contact present in either or both of these properties.</p>
     * 
     * <p>When a channel is created, the values of InitialInviteeHandles and
     *   InitialInviteeIDs MUST correspond to each other. In particular, this
     *   means that the value of InitialInviteeIDs will include the TargetID
     *   of each channel in InitialChannels, and the ID corresponding to each
     *   handle in InitialInviteeHandles.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialInviteeIDs() const
    {
        return internalRequestProperty(QLatin1String("InitialInviteeIDs"));
    }

    /**
     * Asynchronous getter for the remote object property \c InvitationMessage of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The message that was sent to the
     *    \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  when they were
     *   invited.</p>
     * 
     * <p>This property SHOULD be requestable, and appear in the allowed
     *   properties in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly , in protocols where
     *   invitations can have an accompanying text message.</p>
     * 
     * <div class="rationale">
     *   <p>This allows invitations with a message to be sent when using
     *      \endhtmlonly \link requestPropertyInitialInviteeHandles() InitialInviteeHandles \endlink \htmlonly  or
     *      \endhtmlonly \link requestPropertyInitialInviteeIDs() InitialInviteeIDs \endlink \htmlonly .</p>
     * </div>
     * 
     * <p>If the local user was not the initiator of this channel, the
     *   message with which they were invited (if any) SHOULD appear in the
     *   value of this property.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInvitationMessage() const
    {
        return internalRequestProperty(QLatin1String("InvitationMessage"));
    }

    /**
     * Asynchronous getter for the remote object property \c OriginalChannels of type \c Tp::ChannelOriginatorMap.
     *
     * 
     * \htmlonly
     * <p>On GSM conference calls, it is possible to have the same phone
     *   number in a conference twice; for instance, it could be the number of
     *   a corporate switchboard. This is represented using channel-specific
     *   handles; whether or not a channel uses channel-specific handles is
     *   reported in  \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyGroupFlags() ChannelInterfaceGroupInterface::GroupFlags \endlink \htmlonly .
     *   The  \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyHandleOwners() ChannelInterfaceGroupInterface::HandleOwners \endlink \htmlonly 
     *   property specifies the mapping from opaque channel-specific handles
     *   to actual numbers; this property specifies the original 1-1 channel
     *   corresponding to each channel-specific handle in the conference.</p>
     * 
     * <p>In protocols where this situation cannot arise, such as XMPP,
     *   this property MAY remain empty.</p>
     * 
     * <p>For example, consider this situation:</p>
     * 
     * <ol>
     *   <li>Place a call (with path <tt>/call/to/simon</tt>) to the contact
     *     <tt>+441234567890</tt> (which is assigned the handle <var>h</var>,
     *     say), and ask to be put through to Simon McVittie;</li>
     *   <li>Put that call on hold;</li>
     *   <li>Place another call (with path <tt>/call/to/jonny</tt>) to
     *     <tt>+441234567890</tt>, and ask to be put
     *     through to Jonny Lamb;</li>
     *   <li>Request a new channel with
     *      \endhtmlonly \link requestPropertyInitialChannels() InitialChannels \endlink \htmlonly :
     *     <tt>['/call/to/simon', '/call/to/jonny']</tt>.</li>
     * </ol>
     * 
     * <p>The new channel will have the following properties, for some handles
     *   <var>s</var> and <var>j</var>:</p>
     * 
     * <blockquote>
     *   <code>{<br/>
     *     ... \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyGroupFlags() ChannelInterfaceGroupInterface::GroupFlags \endlink \htmlonly :
     *         Channel_Specific_Handles | (other flags),<br/>
     *     ... \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyMembers() ChannelInterfaceGroupInterface::Members \endlink \htmlonly :
     *         [self_handle, s, j],<br/>
     *     ... \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertyHandleOwners() ChannelInterfaceGroupInterface::HandleOwners \endlink \htmlonly :
     *         { s: h, j: h },<br/>
     *     ... \endhtmlonly \link requestPropertyInitialChannels() InitialChannels \endlink \htmlonly :
     *         ['/call/to/simon', '/call/to/jonny'],<br/>
     *     ... \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly :
     *         ['/call/to/simon', '/call/to/jonny'],<br/>
     *     ... \endhtmlonly \link requestPropertyOriginalChannels() OriginalChannels \endlink \htmlonly :
     *         { s: '/call/to/simon', j: '/call/to/jonny' },<br/>
     *     # ...standard properties like ChannelType: Group elided...<br/>
     *   }</code>
     * </blockquote>
     * 
     * <p>Change notification is via the
     *    \endhtmlonly ChannelMerged() \htmlonly  and
     *    \endhtmlonly ChannelRemoved() \htmlonly  signals: if
     *   <var>Channel_Specific_Handle</var> in the former is non-zero, this
     *   property SHOULD be updated to map that handle to the merged channel's
     *   path.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyOriginalChannels() const
    {
        return internalRequestProperty(QLatin1String("OriginalChannels"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ChannelMerged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a new channel is added to the value of
     *    \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly .</p>
     * \endhtmlonly
     *
     * \param channel
     *     
     *     The channel that was added to Channels.
     *
     * \param channelSpecificHandle
     *     
     *     A new channel-specific handle for the TargetHandle of Channel, as 
     *     will appear in OriginalChannels, or 0 if a global handle is used 
     *     for Channel&apos;s TargetHandle on the Group interface of this 
     *     channel.
     *
     * \param properties
     *     
     *     Channel&apos;s immutable properties.
     */
    void ChannelMerged(const QDBusObjectPath& channel, uint channelSpecificHandle, const QVariantMap& properties);

    /**
     * Represents the signal \c ChannelRemoved on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a channel is removed from the value of
     *    \endhtmlonly \link requestPropertyChannels() Channels \endlink \htmlonly , either because it closed
     *   or because it was split using the  \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT.Split \htmlonly  method.</p>
     * 
     * <p>If a channel is removed because it was closed,  \endhtmlonly ChannelInterface::Closed() \htmlonly  should be emitted
     *   before this signal.</p>
     * \endhtmlonly
     *
     * \param channel
     *     
     *     The channel that was removed from Channels.
     *
     * \param details
     *     
     *     \htmlonly
     *     Additional information about the removal, which may include
     *     the same well-known keys as the Details argument of
     *      \endhtmlonly ChannelInterfaceGroupInterface::MembersChangedDetailed() \htmlonly , with the same semantics.
     *     \endhtmlonly
     */
    void ChannelRemoved(const QDBusObjectPath& channel, const QVariantMap& details);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceDTMFInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.DTMF".
 */
class TP_QT_EXPORT ChannelInterfaceDTMFInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.DTMF", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.DTMF");
    }

    /**
     * Creates a ChannelInterfaceDTMFInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceDTMFInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceDTMFInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceDTMFInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceDTMFInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceDTMFInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceDTMFInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceDTMFInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceDTMFInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceDTMFInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c CurrentlySendingTones of type \c bool.
     *
     * 
     * Indicates whether there are DTMF tones currently being sent in the 
     * channel. If so, the client should wait for StoppedTones signal before 
     * trying to send more tones.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCurrentlySendingTones() const
    {
        return internalRequestProperty(QLatin1String("CurrentlySendingTones"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialTones of type \c QString.
     *
     * 
     * If non-empty in a channel request that will create a new channel, the 
     * connection manager should send the tones immediately after at least one 
     * eligible audio stream has been created in the channel. This should only 
     * be used with InitialAudio=true. This property is immutable (cannot 
     * change).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialTones() const
    {
        return internalRequestProperty(QLatin1String("InitialTones"));
    }

    /**
     * Asynchronous getter for the remote object property \c DeferredTones of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The tones waiting for the user to continue, if any.</p>
     * 
     * <p>When this property is set to a non-empty value,
     *    \endhtmlonly TonesDeferred() \htmlonly  is emitted.
     *   When any tones are played (i.e. whenever
     *    \endhtmlonly SendingTones() \htmlonly  is emitted),
     *   this property is reset to the empty string.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDeferredTones() const
    {
        return internalRequestProperty(QLatin1String("DeferredTones"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c StartTone on the remote object.
     * 
     * Start sending a DTMF tone to all eligible streams in the channel. Where 
     * possible, the tone will continue until StopTone is called. On certain 
     * protocols, it may only be possible to send events with a predetermined 
     * length. In this case, the implementation MAY emit a fixed-length tone, 
     * and the StopTone method call SHOULD return NotAvailable. The client may 
     * wish to control the exact duration and timing of the tones sent as a 
     * result of user&apos;s interaction with the dialpad, thus starting and 
     * stopping the tone sending explicitly. Tone overlaping or queueing is 
     * not supported, so this method can only be called if no DTMF tones are 
     * already being played.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param streamID
     *     
     *     A stream ID as defined in the StreamedMedia channel type. This 
     *     argument is included for backwards compatibility and MUST be 
     *     ignored by the implementations - the tone SHOULD be sent to all 
     *     eligible streams in the channel.
     *
     * \param event
     *     
     *     A numeric event code from the DTMF_Event enum.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StartTone(uint streamID, uchar event, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StartTone"));
        callMessage << QVariant::fromValue(streamID) << QVariant::fromValue(event);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c StopTone on the remote object.
     * 
     * Stop sending any DTMF tones which have been started using the StartTone 
     * or MultipleTones methods. If there is no current tone, this method will 
     * do nothing. If MultipleTones was used, the client should not assume the 
     * sending has stopped immediately; instead, the client should wait for 
     * the StoppedTones signal. On some protocols it might be impossible to 
     * cancel queued tones immediately.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param streamID
     *     
     *     A stream ID as defined in the StreamedMedia channel type. This 
     *     argument is included for backwards compatibility and MUST be 
     *     ignored by the implementations - the sending SHOULD be stoped in 
     *     all eligible streams in the channel.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StopTone(uint streamID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StopTone"));
        callMessage << QVariant::fromValue(streamID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c MultipleTones on the remote object.
     * 
     * Send multiple DTMF events to all eligible streams in the channel. Each 
     * tone will be played for an implementation-defined number of 
     * milliseconds (typically 250ms), followed by a gap before the next tone 
     * is played (typically 100ms). The duration and gap are defined by the 
     * protocol or connection manager. In cases where the client knows in 
     * advance the tone sequence it wants to send, it&apos;s easier to use 
     * this method than manually start and stop each tone in the sequence. The 
     * tone and gap lengths may need to vary for interoperability, according 
     * to the protocol and other implementations&apos; ability to recognise 
     * tones. At the time of writing, GStreamer uses a minimum of 250ms tones 
     * and 100ms gaps when playing in-band DTMF in the normal audio stream, or 
     * 70ms tones and 50ms gaps when encoding DTMF as audio/telephone-event. 
     * Tone overlaping or queueing is not supported, so this method can only 
     * be called if no DTMF tones are already being played.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param tones
     *     
     *     \htmlonly
     *     <p>A string representation of one or more DTMF
     *       events. Implementations of this method MUST support all of the
     *       following characters in this string:</p>
     *     
     *     <ul>
     *       <li>the digits 0-9, letters A-D and a-d, and symbols '*' and '#'
     *         correspond to the members of <tp:type>DTMF_Event</tp:type></li>
     *     
     *       <li>any of 'p', 'P', 'x', 'X' or ',' (comma) results in an
     *         implementation-defined pause, typically for 3 seconds</li>
     *     
     *       <li>'w' or 'W' waits for the user to continue, by stopping
     *         interpretation of the string, and if there is more to be played,
     *         emitting the  \endhtmlonly TonesDeferred() \htmlonly  signal
     *         with the rest of the string as its argument: see that signal
     *         for details</li>
     *     </ul>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> MultipleTones(const QString& tones, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("MultipleTones"));
        callMessage << QVariant::fromValue(tones);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c TonesDeferred on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when 'w' or 'W', indicating &quot;wait for the user to continue&quot;,
     *   is encountered while playing a DTMF string queued by
     *    \endhtmlonly MultipleTones() \htmlonly  or
     *    \endhtmlonly \link requestPropertyInitialTones() InitialTones \endlink \htmlonly . Any queued DTMF events
     *   after the 'w', which have not yet been played, are placed in the
     *    \endhtmlonly \link requestPropertyDeferredTones() DeferredTones \endlink \htmlonly  property and copied
     *   into this signal's argument.</p>
     * 
     * <p>When the channel handler is ready to continue, it MAY pass the
     *   value of  \endhtmlonly \link requestPropertyDeferredTones() DeferredTones \endlink \htmlonly  to
     *    \endhtmlonly MultipleTones() \htmlonly , to resume sending.
     *   Alternatively, it MAY ignore the deferred tones, or even play
     *   different tones instead. Any deferred tones are discarded the next
     *   time a tone is played.</p>
     * 
     * <p>This signal SHOULD NOT be emitted if there is nothing left to play,
     *   i.e. if the 'w' was the last character in the DTMF string.</p>
     * \endhtmlonly
     *
     * \param tones
     *     
     *     The new non-empty value of DeferredTones.
     */
    void TonesDeferred(const QString& tones);

    /**
     * Represents the signal \c SendingTones on the remote object.
     * 
     * \htmlonly
     * <p>DTMF tone(s)are being sent to all eligible streams in the channel.
     * The signal is provided to indicating the fact that the streams are
     * currently being used to send one or more DTMF tones, so any other
     * media input is not getting through to the audio stream. It also
     * serves as a cue for the
     *  \endhtmlonly StopTone() \htmlonly  method.</p>
     * \endhtmlonly
     *
     * \param tones
     *     
     *     DTMF string (one or more events) that is to be played.
     */
    void SendingTones(const QString& tones);

    /**
     * Represents the signal \c StoppedTones on the remote object.
     * 
     * \htmlonly
     * <p>DTMF tones have finished playing on streams in this channel.</p>
     * \endhtmlonly
     *
     * \param cancelled
     *     
     *     True if the DTMF tones were actively cancelled via StopTone.
     */
    void StoppedTones(bool cancelled);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceDestroyableInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Destroyable".
 */
class TP_QT_EXPORT ChannelInterfaceDestroyableInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Destroyable", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Destroyable");
    }

    /**
     * Creates a ChannelInterfaceDestroyableInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceDestroyableInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceDestroyableInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceDestroyableInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceDestroyableInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceDestroyableInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceDestroyableInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceDestroyableInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceDestroyableInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceDestroyableInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Destroy on the remote object.
     * 
     * \htmlonly
     * <p>Close the channel abruptly, possibly with loss of data. The
     *   connection manager MUST NOT re-create the channel unless/until
     *   more events occur.</p>
     * 
     * <div class="rationale">
     *   <p>The main motivating situation for this method is that when a Text
     *     channel with pending messages is closed with Close, it comes back
     *     as an incoming channel (to avoid a race between Close and an
     *     incoming message). If Destroy is called on a Text channel, the CM
     *     should delete all pending messages and close the channel, and
     *     the channel shouldn't be re-created until/unless another message
     *     arrives.</p>
     * </div>
     * 
     * <p>Most clients SHOULD call
     *    \endhtmlonly ChannelInterface::Close() \htmlonly 
     *   instead. However, if a client explicitly intends to destroy the
     *   channel with possible loss of data, it SHOULD call this method
     *   if this interface is supported (according to the
     *    \endhtmlonly \link ChannelInterface::requestPropertyInterfaces() ChannelInterface::Interfaces \endlink \htmlonly 
     *   property), falling back to Close if not.</p>
     * 
     * <p>In particular, channel dispatchers SHOULD use this method if
     *   available when terminating channels that cannot be handled
     *   correctly (for instance, if no handler has been installed for
     *   a channel type, or if the handler crashes repeatedly).</p>
     * 
     * <p>Connection managers do not need to implement this interface on
     *   channels where Close and Destroy would be equivalent.</p>
     * 
     * <div class="rationale">
     *   <p>Callers need to be able to fall back to Close in any case.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Destroy(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Destroy"));
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceFileTransferMetadataInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata".
 */
class TP_QT_EXPORT ChannelInterfaceFileTransferMetadataInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata");
    }

    /**
     * Creates a ChannelInterfaceFileTransferMetadataInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceFileTransferMetadataInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceFileTransferMetadataInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceFileTransferMetadataInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceFileTransferMetadataInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceFileTransferMetadataInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceFileTransferMetadataInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceFileTransferMetadataInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceFileTransferMetadataInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceFileTransferMetadataInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ServiceName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>A string representing the service name that will be used
     *   over the file transfer channel. This property is equivalent
     *   to the  \endhtmlonly \link ChannelTypeDBusTubeInterface::requestPropertyServiceName() ChannelTypeDBusTubeInterface::ServiceName \endlink \htmlonly 
     *   and  \endhtmlonly \link ChannelTypeStreamTubeInterface::requestPropertyService() ChannelTypeStreamTubeInterface::Service \endlink \htmlonly 
     *   properties. If no service name is given then this property
     *   will be the empty string.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyServiceName() const
    {
        return internalRequestProperty(QLatin1String("ServiceName"));
    }

    /**
     * Asynchronous setter for the remote object property \c ServiceName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>A string representing the service name that will be used
     *   over the file transfer channel. This property is equivalent
     *   to the  \endhtmlonly \link ChannelTypeDBusTubeInterface::requestPropertyServiceName() ChannelTypeDBusTubeInterface::ServiceName \endlink \htmlonly 
     *   and  \endhtmlonly \link ChannelTypeStreamTubeInterface::requestPropertyService() ChannelTypeStreamTubeInterface::Service \endlink \htmlonly 
     *   properties. If no service name is given then this property
     *   will be the empty string.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyServiceName(QString newValue)
    {
        return internalSetProperty(QLatin1String("ServiceName"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c Metadata of type \c Tp::Metadata.
     *
     * 
     * \htmlonly
     * <p>Additional information about the file transfer set by the
     *   channel initiator. If no additional information is given then
     *   this property will be empty.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMetadata() const
    {
        return internalRequestProperty(QLatin1String("Metadata"));
    }

    /**
     * Asynchronous setter for the remote object property \c Metadata of type \c Tp::Metadata.
     *
     * 
     * \htmlonly
     * <p>Additional information about the file transfer set by the
     *   channel initiator. If no additional information is given then
     *   this property will be empty.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyMetadata(Tp::Metadata newValue)
    {
        return internalSetProperty(QLatin1String("Metadata"), QVariant::fromValue(newValue));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceGroupInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Group".
 */
class TP_QT_EXPORT ChannelInterfaceGroupInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Group", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Group");
    }

    /**
     * Creates a ChannelInterfaceGroupInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceGroupInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceGroupInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceGroupInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceGroupInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceGroupInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceGroupInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceGroupInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceGroupInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceGroupInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c GroupFlags of type \c uint.
     *
     * 
     * An integer representing the bitwise-OR of flags on this channel. The 
     * user interface can use this to present information about which 
     * operations are currently valid. Change notification is via the 
     * GroupFlagsChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyGroupFlags() const
    {
        return internalRequestProperty(QLatin1String("GroupFlags"));
    }

    /**
     * Asynchronous getter for the remote object property \c HandleOwners of type \c Tp::HandleOwnerMap.
     *
     * 
     * A map from channel-specific handles to their owners, including at least 
     * all of the channel-specific handles in this channel&apos;s members, 
     * local-pending or remote-pending sets as keys. Any handle not in the 
     * keys of this mapping is not channel-specific in this channel. Handles 
     * which are channel-specific, but for which the owner is unknown, MUST 
     * appear in this mapping with 0 as owner. Change notification is via the 
     * HandleOwnersChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHandleOwners() const
    {
        return internalRequestProperty(QLatin1String("HandleOwners"));
    }

    /**
     * Asynchronous getter for the remote object property \c LocalPendingMembers of type \c Tp::LocalPendingInfoList.
     *
     * 
     * An array of structs containing handles representing contacts requesting 
     * channel membership and awaiting local approval with AddMembers.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocalPendingMembers() const
    {
        return internalRequestProperty(QLatin1String("LocalPendingMembers"));
    }

    /**
     * Asynchronous getter for the remote object property \c Members of type \c Tp::UIntList.
     *
     * 
     * The members of this channel.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMembers() const
    {
        return internalRequestProperty(QLatin1String("Members"));
    }

    /**
     * Asynchronous getter for the remote object property \c RemotePendingMembers of type \c Tp::UIntList.
     *
     * 
     * An array of handles representing contacts who have been invited to the 
     * channel and are awaiting remote approval.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemotePendingMembers() const
    {
        return internalRequestProperty(QLatin1String("RemotePendingMembers"));
    }

    /**
     * Asynchronous getter for the remote object property \c SelfHandle of type \c uint.
     *
     * 
     * The handle for the user on this channel (which can also be a local or 
     * remote pending member), or 0 if the user is not a member at all (which 
     * is likely to be the case, for instance, on ContactList channels). Note 
     * that this is different from the result of Connection.GetSelfHandle on 
     * some protocols, so the value of this handle should always be used with 
     * the methods of this interface.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySelfHandle() const
    {
        return internalRequestProperty(QLatin1String("SelfHandle"));
    }

    /**
     * Asynchronous getter for the remote object property \c MemberIdentifiers of type \c Tp::HandleIdentifierMap.
     *
     * 
     * The string identifiers for handles mentioned in this channel, to give 
     * clients the minimal information necessary to create contacts without 
     * waiting for round-trips. Connection managers MUST include at least the 
     * identifiers for SelfHandle, Members, LocalPendingMembers (and their 
     * actors if any), RemotePendingMembers and HandleOwners.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMemberIdentifiers() const
    {
        return internalRequestProperty(QLatin1String("MemberIdentifiers"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AddMembers on the remote object.
     * 
     * \htmlonly
     * <p>Invite all the given contacts into the channel, or accept requests for
     *   channel membership for contacts on the pending local list.</p>
     * 
     * <p>A message may be provided along with the request, which will be sent
     * to the server if supported. See the CHANNEL_GROUP_FLAG_MESSAGE_ADD and
     * CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT
     *  \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly  to see in which cases this
     * message should be provided.</p>
     * 
     * <p>Attempting to add contacts who are already members is allowed;
     *   connection managers must silently accept this, without error.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of contact handles to invite to the channel
     *
     * \param message
     *     
     *     A string message, which can be blank if desired
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddMembers(const Tp::UIntList& contacts, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddMembers"));
        callMessage << QVariant::fromValue(contacts) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetAllMembers on the remote object.
     * 
     * Returns arrays of all current, local and remote pending channel members.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     array of handles of current members
     *
     * \return
     *     
     *     array of handles of local pending members
     *
     * \return
     *     
     *     array of handles of remote pending members
     */
    inline QDBusPendingReply<Tp::UIntList, Tp::UIntList, Tp::UIntList> GetAllMembers(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList, Tp::UIntList, Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAllMembers"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetGroupFlags on the remote object.
     * 
     * Returns the value of the GroupFlags property.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The value of the GroupFlags property
     */
    inline QDBusPendingReply<uint> GetGroupFlags(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetGroupFlags"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetHandleOwners on the remote object.
     * 
     * If the CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES flag is set on the 
     * channel, then the handles of the group members are specific to this 
     * channel, and are not meaningful in a connection-wide context such as 
     * contact lists. This method allows you to find the owner of the handle 
     * if it can be discovered in this channel, or 0 if the owner is not 
     * available.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param handles
     *     
     *     A list of integer handles representing members of the channel
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of integer handles representing the owner handles of the 
     *     given room members, in the same order, or 0 if the owner is not 
     *     available
     */
    inline QDBusPendingReply<Tp::UIntList> GetHandleOwners(const Tp::UIntList& handles, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetHandleOwners"));
        callMessage << QVariant::fromValue(handles);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetLocalPendingMembers on the remote object.
     * 
     * Returns the To_Be_Added handle (only) for each structure in the 
     * LocalPendingMembers property.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<Tp::UIntList> GetLocalPendingMembers(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetLocalPendingMembers"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetLocalPendingMembersWithInfo on the remote object.
     * 
     * Returns the LocalPendingMembers property.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of structs containing: A handle representing the contact 
     *     requesting channel membership A handle representing the contact 
     *     making the request, or 0 if unknown The reason for the request: one 
     *     of the values of Channel_Group_Change_Reason A string message 
     *     containing the reason for the request if any (or blank if none)
     */
    inline QDBusPendingReply<Tp::LocalPendingInfoList> GetLocalPendingMembersWithInfo(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::LocalPendingInfoList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetLocalPendingMembersWithInfo"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetMembers on the remote object.
     * 
     * Returns the Members property.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<Tp::UIntList> GetMembers(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetMembers"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetRemotePendingMembers on the remote object.
     * 
     * Returns an array of handles representing contacts who have been invited 
     * to the channel and are awaiting remote approval.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<Tp::UIntList> GetRemotePendingMembers(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetRemotePendingMembers"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetSelfHandle on the remote object.
     * 
     * Returns the value of the SelfHandle property.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<uint> GetSelfHandle(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetSelfHandle"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveMembers on the remote object.
     * 
     * \htmlonly
     * <p>Requests the removal of contacts from a channel, reject their
     *   request for channel membership on the pending local list, or
     *   rescind their invitation on the pending remote list.</p>
     * 
     * <p>If the  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  is in a Group,
     *   it can be removed via this method, in order to leave the group
     *   gracefully. This is the recommended way to leave a chatroom, close
     *   or reject a  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   call, and so on.</p>
     * 
     * <p>Accordingly, connection managers SHOULD support
     *   doing this, regardless of the value of
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly .
     *   If doing so fails with PermissionDenied, this is considered to a bug
     *   in the connection manager, but clients MUST recover by falling back
     *   to closing the channel with the  \endhtmlonly ChannelInterface::Close() \htmlonly 
     *   method.</p>
     * 
     * <p>Removing any contact from the local pending list is always
     *   allowed. Removing contacts other than the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  from the channel's members
     *   is allowed if and only if Channel_Group_Flag_Can_Remove is in the
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly ,
     *   while removing contacts other than the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  from the remote pending list
     *   is allowed if and only if Channel_Group_Flag_Can_Rescind is in the
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly .</p>
     * 
     * <p>A message may be provided along with the request, which will be
     *   sent to the server if supported. See the
     *   Channel_Group_Flag_Message_Remove,
     *   Channel_Group_Flag_Message_Depart,
     *   Channel_Group_Flag_Message_Reject and
     *   Channel_Group_Flag_Message_Rescind
     *    \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly  to see in which cases this
     *   message should be provided.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of contact handles to remove from the channel
     *
     * \param message
     *     
     *     A string message, which can be blank if desired
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveMembers(const Tp::UIntList& contacts, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveMembers"));
        callMessage << QVariant::fromValue(contacts) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveMembersWithReason on the remote object.
     * 
     * As RemoveMembers, but a reason code may be provided where appropriate. 
     * The reason code may be ignored if the underlying protocol is unable to 
     * represent the given reason.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contacts
     *     
     *     An array of contact handles to remove from the channel
     *
     * \param message
     *     
     *     A string message, which can be blank if desired
     *
     * \param reason
     *     
     *     A reason for the change
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveMembersWithReason(const Tp::UIntList& contacts, const QString& message, uint reason, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveMembersWithReason"));
        callMessage << QVariant::fromValue(contacts) << QVariant::fromValue(message) << QVariant::fromValue(reason);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c HandleOwnersChanged on the remote object.
     * 
     * Emitted whenever the HandleOwners property changes.
     *
     * \param added
     *     
     *     A map from channel-specific handles to their owners, in which the 
     *     keys include all the handles that were added to the keys of the 
     *     HandleOwners property, and all the handles in that property whose 
     *     owner has changed
     *
     * \param removed
     *     
     *     The channel-specific handles that were removed from the keys of the 
     *     HandleOwners property, as a result of the contact leaving this 
     *     group in a previous MembersChanged signal
     */
    void HandleOwnersChanged(const Tp::HandleOwnerMap& added, const Tp::UIntList& removed);

    /**
     * Represents the signal \c HandleOwnersChangedDetailed on the remote object.
     * 
     * Emitted whenever the HandleOwners property changes. Clients can assume 
     * this signal is emitted by the Connection Manager if the 
     * MemberIdentifiers property exists
     *
     * \param added
     *     
     *     A map from channel-specific handles to their owners, in which the 
     *     keys include all the handles that were added to the keys of the 
     *     HandleOwners property, and all the handles in that property whose 
     *     owner has changed
     *
     * \param removed
     *     
     *     The channel-specific handles that were removed from the keys of the 
     *     HandleOwners property, as a result of the contact leaving this 
     *     group in a previous MembersChanged signal
     *
     * \param identifiers
     *     
     *     The string identifiers for handles mentioned in this signal, to 
     *     give clients the minimal information necessary to create contacts 
     *     without waiting for round-trips. Connection managers MUST include 
     *     at least the identifiers for all handles in the Added map, and MAY 
     *     include those from Removed array.
     */
    void HandleOwnersChangedDetailed(const Tp::HandleOwnerMap& added, const Tp::UIntList& removed, const Tp::HandleIdentifierMap& identifiers);

    /**
     * Represents the signal \c SelfHandleChanged on the remote object.
     * 
     * Emitted whenever the SelfHandle property changes.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     */
    void SelfHandleChanged(uint selfHandle);

    /**
     * Represents the signal \c SelfContactChanged on the remote object.
     * 
     * Emitted whenever the SelfHandle property changes. Clients can assume 
     * this signal is emitted by the Connection Manager if the 
     * MemberIdentifiers property exists.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     *
     * \param selfID
     *     
     *     The new value of the SelfHandle property&apos;s identifier.
     */
    void SelfContactChanged(uint selfHandle, const QString& selfID);

    /**
     * Represents the signal \c GroupFlagsChanged on the remote object.
     * 
     * Emitted when the flags as returned by GetGroupFlags are changed. The 
     * user interface should be updated as appropriate.
     *
     * \param added
     *     
     *     A bitwise OR of the flags which have been set
     *
     * \param removed
     *     
     *     A bitwise OR of the flags which have been cleared
     */
    void GroupFlagsChanged(uint added, uint removed);

    /**
     * Represents the signal \c MembersChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when contacts join any of the three lists (members, local
     *   pending or remote pending) or when they leave any of the three lists.
     *   There may also be a message from the server regarding this change,
     *   which may be displayed to the user if desired.</p>
     * 
     * <p>All channel-specific handles that are mentioned in this signal
     *   MUST be represented in the value of the
     *    \endhtmlonly \link requestPropertyHandleOwners() HandleOwners \endlink \htmlonly  property.
     *   In practice, this will mean that
     *    \endhtmlonly HandleOwnersChanged() \htmlonly  is
     *   emitted <em>before</em> emitting a MembersChanged signal in which
     *   channel-specific handles are added, but that it is emitted
     *   <em>after</em> emitting a MembersChanged signal in which
     *   channel-specific handles are removed.</p>
     * 
     * <p>See  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   for an overview of how group state changes are used to indicate the
     *   progress of a call.</p>
     * \endhtmlonly
     *
     * \param message
     *     
     *     A string message from the server, or blank if not
     *
     * \param added
     *     
     *     A list of members added to the channel
     *
     * \param removed
     *     
     *     A list of members removed from the channel
     *
     * \param localPending
     *     
     *     A list of members who are pending local approval
     *
     * \param remotePending
     *     
     *     A list of members who are pending remote approval
     *
     * \param actor
     *     
     *     The contact handle of the person who made the change, or 0 if not 
     *     known
     *
     * \param reason
     *     
     *     A reason for the change
     */
    void MembersChanged(const QString& message, const Tp::UIntList& added, const Tp::UIntList& removed, const Tp::UIntList& localPending, const Tp::UIntList& remotePending, uint actor, uint reason);

    /**
     * Represents the signal \c MembersChangedDetailed on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when contacts join any of the three lists (members, local
     *   pending or remote pending) or when they leave any of the three
     *   lists. This signal provides a superset of the information provided by
     *    \endhtmlonly MembersChanged() \htmlonly ;
     *   if the channel's  \endhtmlonly \link requestPropertyGroupFlags() GroupFlags \endlink \htmlonly 
     *   contains Members_Changed_Detailed, then clients may listen exclusively
     *   to this signal in preference to that signal.</p>
     * 
     * <p>All channel-specific handles that are mentioned in this signal
     *   MUST be represented in the value of the
     *    \endhtmlonly \link requestPropertyHandleOwners() HandleOwners \endlink \htmlonly  property.  In practice,
     *   this will mean that
     *    \endhtmlonly HandleOwnersChanged() \htmlonly  is emitted
     *   <em>before</em> emitting a MembersChangedDetailed signal in which
     *   channel-specific handles are added, but that it is emitted
     *   <em>after</em> emitting a MembersChangedDetailed signal in which
     *   channel-specific handles are removed.</p>
     * 
     * <p>See  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   for an overview of how group state changes are used to indicate the
     *   progress of a call.</p>
     * \endhtmlonly
     *
     * \param added
     *     
     *     A list of members added to the channel
     *
     * \param removed
     *     
     *     A list of members removed from the channel
     *
     * \param localPending
     *     
     *     A list of members who are pending local approval
     *
     * \param remotePending
     *     
     *     A list of members who are pending remote approval
     *
     * \param details
     *     
     *     \htmlonly
     *     <p>Information about the change, which may include the following
     *       well-known keys:</p>
     *     
     *     <dl>
     *       <dt>actor (u — <tp:type>Contact_Handle</tp:type>)</dt>
     *       <dd>The contact handle of the person who made the change; 0 or
     *         omitted if unknown or not applicable.</dd>
     *     
     *       <dt>change-reason (u — <tp:type>Channel_Group_Change_Reason</tp:type>)</dt>
     *       <dd>A reason for the change.</dd>
     *     
     *       <dt>contact-ids (a{us} — <tp:type>Handle_Identifier_Map</tp:type>)</dt>
     *       <dd>
     *         <p>The string identifiers for handles mentioned in this signal, to
     *         give clients the minimal information necessary to react to the
     *         event without waiting for round-trips.  Connection managers
     *         SHOULD include the identifiers for members added to the group and
     *         for the actor (if any); they MAY omit the identifiers for handles
     *         which have been removed from the group.</p>
     *     
     *         <div class="rationale">
     *           <p>On IRC, an event such as a netsplit could cause the vast
     *           majority of a channel to leave.  Given that clients should
     *           already know the identifiers of a channel's members, including
     *           potentially hundreds of strings in the netsplit signal is
     *           unnecessary.</p>
     *         </div>
     *     
     *         <p>Clients MUST NOT assume that the presence or absence of a
     *           handle in this mapping is meaningful. This mapping is merely
     *           an optimization for round-trip reduction, and connection
     *           managers MAY add additional handles, omit some handles, or
     *           omit the mapping completely.</p>
     *       </dd>
     *     
     *       <dt>message (s)</dt>
     *       <dd>A string message from the server regarding the change</dd>
     *     
     *       <dt>error (s — <tp:type>DBus_Error_Name</tp:type>)</dt>
     *       <dd>A (possibly implementation-specific) DBus error describing the
     *         change, providing more specific information than the
     *         <tp:type>Channel_Group_Change_Reason</tp:type> enum allows. This
     *         MUST only be present if it is strictly more informative than
     *         'change-reason'; if present, 'change-reason' MUST be set to the
     *         closest available reason.
     *     
     *         <div class="rationale">
     *           A SIP connection manager might want to signal &quot;402 Payment
     *           required&quot; as something more specific than Error or
     *           Permission_Denied so that a SIP-aware UI could handle it
     *           specially; including a namespaced error permits this to be done
     *           without <tp:type>Channel_Group_Change_Reason</tp:type> being
     *           extended to encompass every error any CM ever wants to report.
     *         </div>
     *       </dd>
     *     
     *       <dt>debug-message (s)</dt>
     *       <dd>Debugging information on the change. SHOULD NOT be shown to
     *         users in normal circumstances.</dd>
     *     </dl>
     *     \endhtmlonly
     */
    void MembersChangedDetailed(const Tp::UIntList& added, const Tp::UIntList& removed, const Tp::UIntList& localPending, const Tp::UIntList& remotePending, const QVariantMap& details);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceHoldInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Hold".
 */
class TP_QT_EXPORT ChannelInterfaceHoldInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Hold", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Hold");
    }

    /**
     * Creates a ChannelInterfaceHoldInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceHoldInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceHoldInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceHoldInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceHoldInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceHoldInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceHoldInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceHoldInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceHoldInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceHoldInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetHoldState on the remote object.
     * 
     * Return whether the local user has placed the channel on hold.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The state of the channel
     *
     * \return
     *     
     *     The reason why the channel is in that state
     */
    inline QDBusPendingReply<uint, uint> GetHoldState(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint, uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetHoldState"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestHold on the remote object.
     * 
     * \htmlonly
     * <p>Request that the channel be put on hold (be instructed not to send
     *   any media streams to you) or be taken off hold.</p>
     * 
     * <p>If the connection manager can immediately tell that the requested
     *   state change could not possibly succeed, this method SHOULD
     *   return the NotAvailable error. If the requested state is the
     *   same as the current state, this method SHOULD return successfully
     *   without doing anything.</p>
     * 
     * <p>Otherwise, this method SHOULD immediately set the hold state to
     *   Local_Hold_State_Pending_Hold or Local_Hold_State_Pending_Unhold
     *   (as appropriate), emitting
     *    \endhtmlonly HoldStateChanged() \htmlonly  if this is a change,
     *   and return successfully.</p>
     * 
     * <p>The eventual success or failure of the request is indicated by a
     *   subsequent HoldStateChanged signal, changing the hold state to
     *   Local_Hold_State_Held or Local_Hold_State_Unheld.</p>
     * 
     * <p>If the channel has multiple streams, and the connection manager
     *   succeeds in changing the hold state of one stream but fails to
     *   change the hold state of another, it SHOULD attempt to revert
     *   all streams to their previous hold states.</p>
     * 
     * <p>The following state transitions SHOULD be used, where
     *   appropriate:</p>
     * 
     * <ul>
     *   <li>Successful hold:
     *     (Unheld, any reason) → (Pending_Hold, Requested) →
     *     (Held, Requested)
     *   </li>
     *   <li>Successful unhold:
     *     (Held, any reason) → (Pending_Unhold, Requested) →
     *     (Unheld, Requested)
     *   </li>
     *   <li>Attempting to unhold fails at the first attempt to acquire a
     *     resource:
     *     (Held, any reason) → (Pending_Unhold, Requested) →
     *     (Held, Resource_Not_Available)
     *   </li>
     *   <li>Attempting to unhold acquires one resource, but fails to acquire
     *     a second, and takes time to release the first:
     *     (Held, any reason) → (Pending_Unhold, Requested) →
     *     (Pending_Hold, Resource_Not_Available) →
     *     (Held, Resource_Not_Available)
     *   </li>
     * </ul>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param hold
     *     
     *     A boolean indicating whether or not the channel should be on hold
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RequestHold(bool hold, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestHold"));
        callMessage << QVariant::fromValue(hold);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c HoldStateChanged on the remote object.
     * 
     * Emitted to indicate that the hold state has changed for this channel. 
     * This may occur as a consequence of you requesting a change with 
     * RequestHold, or the state changing as a result of a request from 
     * another process.
     *
     * \param holdState
     *     
     *     The state of the channel
     *
     * \param reason
     *     
     *     The reason for the state change
     */
    void HoldStateChanged(uint holdState, uint reason);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceMediaSignallingInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.MediaSignalling".
 */
class TP_QT_EXPORT ChannelInterfaceMediaSignallingInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.MediaSignalling", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.MediaSignalling");
    }

    /**
     * Creates a ChannelInterfaceMediaSignallingInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMediaSignallingInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceMediaSignallingInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMediaSignallingInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceMediaSignallingInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceMediaSignallingInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceMediaSignallingInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceMediaSignallingInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceMediaSignallingInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMediaSignallingInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetSessionHandlers on the remote object.
     * 
     * Returns all currently active session handlers on this channel as a list 
     * of (session_handler_path, type).
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<Tp::MediaSessionHandlerInfoList> GetSessionHandlers(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::MediaSessionHandlerInfoList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetSessionHandlers"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c NewSessionHandler on the remote object.
     * 
     * Signal that a session handler object has been created. The client 
     * should create a session object and create streams for the streams 
     * within.
     *
     * \param sessionHandler
     *     
     *     Object path of the new Media.SessionHandler object
     *
     * \param sessionType
     *     
     *     String indicating type of session, eg &quot;rtp&quot;
     */
    void NewSessionHandler(const QDBusObjectPath& sessionHandler, const QString& sessionType);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceMessagesInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Messages".
 */
class TP_QT_EXPORT ChannelInterfaceMessagesInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Messages", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Messages");
    }

    /**
     * Creates a ChannelInterfaceMessagesInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMessagesInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceMessagesInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMessagesInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceMessagesInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceMessagesInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceMessagesInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceMessagesInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceMessagesInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMessagesInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c SupportedContentTypes of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of MIME types supported by this channel, with more preferred
     *   MIME types appearing earlier in the list. The list MAY include &quot;&#42;&#47;*&quot;
     *   to indicate that attachments with arbitrary MIME types can be sent.
     *   This list MUST NOT be empty, since all Messages implementations
     *   MUST accept messages containing a single &quot;text/plain&quot; part.</p>
     * 
     * <p>Items in this list MUST be normalized to lower-case.</p>
     * 
     * <p>Some examples of how this property interacts with the
     *    \endhtmlonly \link requestPropertyMessagePartSupportFlags() MessagePartSupportFlags \endlink \htmlonly :</p>
     * 
     * <dl>
     *   <dt>A simple IM implementation: only plain text messages are
     *     allowed</dt>
     *   <dd>SupportedContentTypes = ['text/plain'],
     *     MessagePartSupportFlags = 0</dd>
     * 
     *   <dt>Formatted text with a plain text alternative is allowed (see the
     *     HTML interface draft)</dt>
     *   <dd>SupportedContentTypes = ['text/html', 'text/plain'],
     *     MessagePartSupportFlags = 0</dd>
     * 
     *   <dt>JPEG or PNG images may be sent, but without any attached
     *     text</dt>
     *   <dd>SupportedContentTypes = ['text/plain', 'image/jpeg',
     *     'image/png'], MessagePartSupportFlags = 0</dd>
     * 
     *   <dt>Unformatted text to which an optional JPEG or PNG image may be
     *     attached</dt>
     *   <dd>SupportedContentTypes = ['text/plain', 'image/jpeg',
     *     'image/png'], MessagePartSupportFlags = One_Attachment</dd>
     * 
     *   <dt>Formatted text to which arbitrarily many images may be
     *     attached</dt>
     *   <dd>SupportedContentTypes = ['text/html', 'text/plain', 'image/jpeg',
     *     'image/png', 'image/x-ms-bmp'], MessagePartSupportFlags =
     *     One_Attachment | Multiple_Attachments</dd>
     * 
     *   <dt>A full SIP implementation: arbitrary MIME messages are
     *     allowed</dt>
     *   <dd>SupportedContentTypes = ['&#42;&#47;*'], MessagePartSupportFlags =
     *     One_Attachment | Multiple_Attachments</dd>
     * </dl>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedContentTypes() const
    {
        return internalRequestProperty(QLatin1String("SupportedContentTypes"));
    }

    /**
     * Asynchronous getter for the remote object property \c MessageTypes of type \c Tp::UIntList.
     *
     * 
     * \htmlonly
     * <p>A list of message types which may be sent on this channel.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMessageTypes() const
    {
        return internalRequestProperty(QLatin1String("MessageTypes"));
    }

    /**
     * Asynchronous getter for the remote object property \c MessagePartSupportFlags of type \c uint.
     *
     * 
     * Flags indicating the level of support for message parts on this channel.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMessagePartSupportFlags() const
    {
        return internalRequestProperty(QLatin1String("MessagePartSupportFlags"));
    }

    /**
     * Asynchronous getter for the remote object property \c PendingMessages of type \c Tp::MessagePartListList.
     *
     * 
     * \htmlonly
     * <p>A list of incoming messages that have neither been acknowledged nor
     *   rejected. This list is a more detailed version of the one returned
     *   by  \endhtmlonly ChannelTypeTextInterface::ListPendingMessages() \htmlonly ,
     *   and contains the same messages, uniquely identified by the same
     *   pending message IDs. Its items can be removed using
     *    \endhtmlonly ChannelTypeTextInterface::AcknowledgePendingMessages() \htmlonly .</p>
     * 
     * <p>Change notification is via
     *    \endhtmlonly MessageReceived() \htmlonly  and
     *    \endhtmlonly PendingMessagesRemoved() \htmlonly .</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPendingMessages() const
    {
        return internalRequestProperty(QLatin1String("PendingMessages"));
    }

    /**
     * Asynchronous getter for the remote object property \c DeliveryReportingSupport of type \c uint.
     *
     * 
     * A bitfield indicating features supported by this channel.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDeliveryReportingSupport() const
    {
        return internalRequestProperty(QLatin1String("DeliveryReportingSupport"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SendMessage on the remote object.
     * 
     * \htmlonly
     * <p>Submit a message to the server for sending.
     *   If this method returns successfully, the message has been submitted
     *   to the server and the  \endhtmlonly MessageSent() \htmlonly 
     *   signal is emitted. A corresponding
     *    \endhtmlonly ChannelTypeTextInterface::Sent() \htmlonly 
     *   signal on the Text interface MUST also be emitted.</p>
     * 
     * <p>This method MUST return before the MessageSent signal is
     *   emitted.</p>
     * 
     * <div class="rationale">
     *   <p>This means that the process sending the message is the first
     *     to see the <tp:type>Protocol_Message_Token</tp:type>, and can
     *     relate the message to the corresponding
     *      \endhtmlonly MessageSent() \htmlonly  signal by comparing
     *     message tokens (if supported by the protocol).</p>
     * </div>
     * 
     * <p>If this method fails, message submission to the server has failed
     *   and no signal on this interface (or the Text interface) is
     *   emitted.</p>
     * 
     * <p>If this method succeeds, message submission to the server has
     *   succeeded, but the message has not necessarily reached its intended
     *   recipient. If a delivery failure is detected later, this is
     *   signalled by receiving a message whose <code>message-type</code>
     *   header maps to
     *   <tp:value-ref type="Channel_Text_Message_Type">Delivery_Report</tp:value-ref>.
     *   Similarly, if delivery is detected to have been successful
     *   (which is not possible in all protocols), a successful delivery
     *   report will be signalled.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param message
     *     
     *     The message content, including any attachments or alternatives. 
     *     This MUST NOT include the following headers, or any others that do 
     *     not make sense for a client to specify: message-sender, 
     *     message-sender-id, message-sent, message-received, 
     *     pending-message-id.
     *
     * \param flags
     *     
     *     Flags affecting how the message is sent. The channel MAY ignore 
     *     some or all flags, depending on DeliveryReportingSupport; the flags 
     *     that were handled by the CM are provided in MessageSent.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An opaque token used to match any incoming delivery or failure 
     *     reports against this message, or an empty string if the message is 
     *     not readily identifiable.
     */
    inline QDBusPendingReply<QString> SendMessage(const Tp::MessagePartList& message, uint flags, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SendMessage"));
        callMessage << QVariant::fromValue(message) << QVariant::fromValue(flags);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetPendingMessageContent on the remote object.
     * 
     * Retrieve the content of one or more parts of a pending message. Note 
     * that this function may take a considerable amount of time to return if 
     * the part&apos;s &apos;needs-retrieval&apos; flag is true; consider 
     * extending the default D-Bus method call timeout. Additional API is 
     * likely to be added in future, to stream large message parts.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param messageID
     *     
     *     The ID of a pending message
     *
     * \param parts
     *     
     *     The desired entries in the array of message parts, identified by 
     *     their position. The &quot;headers&quot; part (which is not a valid 
     *     argument to this method) is considered to be part 0, so the valid 
     *     part numbers start at 1 (for the second Message_Part).
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The content of the requested parts. The keys in this mapping
     *       are positions in the array of message parts; the values are
     *       either of type 's' or 'ay' (UTF-8 text string, or byte array),
     *       following the same rules as for the value of the 'content' key in
     *       the <tp:type>Message_Part</tp:type> mappings.</p>
     *     
     *     <p>If the one of the requested part numbers was greater than zero
     *       but referred to a part that had no content (i.e. it had no
     *       'content-type' key or no 'content' key), it is simply omitted from
     *       this mapping; this is not considered to be an error condition.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::MessagePartContentMap> GetPendingMessageContent(uint messageID, const Tp::UIntList& parts, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::MessagePartContentMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetPendingMessageContent"));
        callMessage << QVariant::fromValue(messageID) << QVariant::fromValue(parts);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c MessageSent on the remote object.
     * 
     * \htmlonly
     * <p>Signals that a message has been submitted for sending. This
     *   MUST be emitted exactly once per emission of the  \endhtmlonly ChannelTypeTextInterface::Sent() \htmlonly 
     *   signal on the Text interface, for backwards-compatibility; clients
     *   SHOULD ignore the latter if this interface is present, as mentioned
     *   in the introduction.</p>
     * 
     * <p>This SHOULD be emitted as soon as the CM determines it's
     *   theoretically possible to send the message (e.g. the parameters are
     *   supported and correct).</p>
     * 
     * <div class="rationale">
     *   <p>This signal allows a process that is not the caller of
     *     SendMessage to log sent messages.</p>
     * </div>
     * \endhtmlonly
     *
     * \param content
     *     
     *     \htmlonly
     *     <p>The message content (see <tp:type>Message_Part</tp:type> for full
     *       details). If the message that was passed to
     *        \endhtmlonly SendMessage() \htmlonly  has a formatted text
     *       part that the connection manager recognises, but no
     *       <tt>text/plain</tt> alternative, the CM MUST use the formatted text
     *       part to generate a <tt>text/plain</tt> alternative which is also
     *       included in this signal argument.</p>
     *     
     *     <p>The connection manager SHOULD include the
     *       <code>message-sender</code>, <code>message-sender-id</code> and
     *       <code>message-sent</code> headers in the representation of the
     *       message that is signalled here. If the channel has
     *       channel-specific handles, the <code>message-sender</code> and
     *       <code>message-sender-id</code> SHOULD reflect the sender that
     *       other contacts will see.</p>
     *     
     *     <p>If the connection manager can predict that the message will be
     *       altered during transmission, this argument SHOULD reflect what
     *       other contacts will receive, rather than being a copy of the
     *       argument to SendMessage (if the message is truncated,
     *       formatting or alternatives are dropped, etc., then the edited
     *       version SHOULD appear in this signal).</p>
     *     \endhtmlonly
     *
     * \param flags
     *     
     *     Flags affecting how the message was sent. The flags might be a 
     *     subset of those passed to SendMessage if the caller requested 
     *     unsupported flags.
     *
     * \param messageToken
     *     
     *     An opaque token used to match any incoming delivery or failure 
     *     reports against this message, or an empty string if the message is 
     *     not readily identifiable.
     */
    void MessageSent(const Tp::MessagePartList& content, uint flags, const QString& messageToken);

    /**
     * Represents the signal \c PendingMessagesRemoved on the remote object.
     * 
     * The messages with the given IDs have been removed from the 
     * PendingMessages list. Clients SHOULD NOT attempt to acknowledge those 
     * messages. This completes change notification for the PendingMessages 
     * property (previously, there was change notification when pending 
     * messages were added, but not when they were removed).
     *
     * \param messageIDs
     *     
     *     The messages that have been removed from the pending message list.
     */
    void PendingMessagesRemoved(const Tp::UIntList& messageIDs);

    /**
     * Represents the signal \c MessageReceived on the remote object.
     * 
     * Signals that a message has been received and added to the pending 
     * messages queue. This MUST be emitted exactly once per emission of the 
     * Received signal on the Text interface, for backwards-compatibility; 
     * clients SHOULD ignore the latter in favour of this signal if this 
     * interface is present, as mentioned in the introduction.
     *
     * \param message
     *     
     *     \htmlonly
     *     <p>The message content, including any attachments or alternatives. If
     *       the incoming message contains formatted text without a plain text
     *       alternative, the connection manager MUST generate a
     *       <tt>text/plain</tt> alternative from the formatted text, and
     *       include it in this message (both here, and in the
     *        \endhtmlonly \link requestPropertyPendingMessages() PendingMessages \endlink \htmlonly  property).</p>
     *     \endhtmlonly
     */
    void MessageReceived(const Tp::MessagePartList& message);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfacePasswordInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Password".
 */
class TP_QT_EXPORT ChannelInterfacePasswordInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Password", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Password");
    }

    /**
     * Creates a ChannelInterfacePasswordInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfacePasswordInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfacePasswordInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfacePasswordInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfacePasswordInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfacePasswordInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfacePasswordInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfacePasswordInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfacePasswordInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfacePasswordInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetPasswordFlags on the remote object.
     * 
     * Returns the bitwise-OR of the flags relevant to the password on this 
     * channel. The user interface can use this to present information about 
     * which operations are currently valid.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An integer with the logical OR of all the flags set (values of 
     *     ChannelPasswordFlags)
     */
    inline QDBusPendingReply<uint> GetPasswordFlags(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetPasswordFlags"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ProvidePassword on the remote object.
     * 
     * Provide the password so that the channel can be joined. Must be called 
     * with the correct password in order for channel joining to proceed if 
     * the &apos;provide&apos; password flag is set.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param password
     *     
     *     The password
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A boolean indicating whether or not the password was correct
     */
    inline QDBusPendingReply<bool> ProvidePassword(const QString& password, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<bool>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ProvidePassword"));
        callMessage << QVariant::fromValue(password);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c PasswordFlagsChanged on the remote object.
     * 
     * Emitted when the flags as returned by GetPasswordFlags are changed. The 
     * user interface should be updated as appropriate.
     *
     * \param added
     *     
     *     A bitwise OR of the flags which have been set
     *
     * \param removed
     *     
     *     A bitwise OR of the flags which have been cleared
     */
    void PasswordFlagsChanged(uint added, uint removed);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceRoomConfigInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.RoomConfig1".
 */
class TP_QT_EXPORT ChannelInterfaceRoomConfigInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.RoomConfig1", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.RoomConfig1");
    }

    /**
     * Creates a ChannelInterfaceRoomConfigInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceRoomConfigInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceRoomConfigInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceRoomConfigInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceRoomConfigInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceRoomConfigInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceRoomConfigInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceRoomConfigInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceRoomConfigInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceRoomConfigInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Anonymous of type \c bool.
     *
     * 
     * True if people may join the channel without other members being made 
     * aware of their identity.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAnonymous() const
    {
        return internalRequestProperty(QLatin1String("Anonymous"));
    }

    /**
     * Asynchronous getter for the remote object property \c InviteOnly of type \c bool.
     *
     * 
     * True if people may not join the channel until they have been invited.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInviteOnly() const
    {
        return internalRequestProperty(QLatin1String("InviteOnly"));
    }

    /**
     * Asynchronous getter for the remote object property \c Limit of type \c uint.
     *
     * 
     * The limit to the number of members; or 0 if there is no limit.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLimit() const
    {
        return internalRequestProperty(QLatin1String("Limit"));
    }

    /**
     * Asynchronous getter for the remote object property \c Moderated of type \c bool.
     *
     * 
     * True if channel membership is not sufficient to allow participation.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyModerated() const
    {
        return internalRequestProperty(QLatin1String("Moderated"));
    }

    /**
     * Asynchronous getter for the remote object property \c Title of type \c QString.
     *
     * 
     * \htmlonly
     * A human-visible name for the channel, if it differs from  \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyRoomName() ChannelInterfaceRoomInterface::RoomName \endlink \htmlonly ; the
     * empty string, otherwise.
     * 
     * <div class="rationale">
     *   <p>On XMPP, this represents the <code>muc#roomconfig_roomname</code>
     *   field of the <a href="http://xmpp.org/extensions/xep-0045.html#registrar-formtype-owner"><code>muc#roomconfig</code></a>
     *   form. So for <code>jdev@conference.jabber.org</code>, for example:</p>
     * 
     *   <ul>
     *     <li> \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyRoomName() ChannelInterfaceRoomInterface::RoomName \endlink \htmlonly 
     *       = <code>&quot;jdev&quot;</code>;</li>
     *     <li> \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyServer() ChannelInterfaceRoomInterface::Server \endlink \htmlonly 
     *       = <code>&quot;conference.jabber.org&quot;</code>;</li>
     *     <li> \endhtmlonly \link requestPropertyTitle() Title \endlink \htmlonly  = <code>&quot;General Jabber
     *       development discussion&quot;</code>.</li>
     *   </ul>
     * 
     *   <p>XEP-0045 is awful.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTitle() const
    {
        return internalRequestProperty(QLatin1String("Title"));
    }

    /**
     * Asynchronous getter for the remote object property \c Description of type \c QString.
     *
     * 
     * A human-readable description of the channel&apos;s overall purpose; if 
     * any.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDescription() const
    {
        return internalRequestProperty(QLatin1String("Description"));
    }

    /**
     * Asynchronous getter for the remote object property \c Persistent of type \c bool.
     *
     * 
     * \htmlonly
     * <code>True</code> if the channel will remain in existence on the server after all
     * members have left it.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPersistent() const
    {
        return internalRequestProperty(QLatin1String("Persistent"));
    }

    /**
     * Asynchronous getter for the remote object property \c Private of type \c bool.
     *
     * 
     * \htmlonly
     * <code>True</code> if the channel is not visible to non-members.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPrivate() const
    {
        return internalRequestProperty(QLatin1String("Private"));
    }

    /**
     * Asynchronous getter for the remote object property \c PasswordProtected of type \c bool.
     *
     * 
     * \htmlonly
     * <code>True</code> if contacts joining this channel must provide a
     * password to be granted entry.  Note that this property does not
     * indicate that a password is required <em>right now</em>; see the
     *  \endhtmlonly ChannelInterfacePasswordInterface \htmlonly 
     * interface for the API used to provide a password while joining a room.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPasswordProtected() const
    {
        return internalRequestProperty(QLatin1String("PasswordProtected"));
    }

    /**
     * Asynchronous getter for the remote object property \c Password of type \c QString.
     *
     * 
     * \htmlonly
     * If  \endhtmlonly \link requestPropertyPasswordProtected() PasswordProtected \endlink \htmlonly  is
     * <code>True</code>, the password required to enter the channel, if
     * known. If the password is unknown, or
     *  \endhtmlonly \link requestPropertyPasswordProtected() PasswordProtected \endlink \htmlonly  is
     * <code>False</code>, the empty string.
     * 
     * <div class="rationale">
     *   On XMPP—bless its cotton socks!—non-owners of a MUC cannot see its
     *   current password, even if they just provided the password in order to
     *   join the room…
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPassword() const
    {
        return internalRequestProperty(QLatin1String("Password"));
    }

    /**
     * Asynchronous getter for the remote object property \c PasswordHint of type \c QString.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyPasswordProtected() PasswordProtected \endlink \htmlonly  is
     *   <code>True</code>, an optional hint for the password.</p>
     * 
     * <p>On protocols supporting PasswordHint (indicated by its presence
     *   in  \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly ),
     *    \endhtmlonly \link requestPropertyPassword() Password \endlink \htmlonly  and PasswordHint MUST be
     *   set in a single call to
     *    \endhtmlonly UpdateConfiguration() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   Skype requires that the password and its hint be supplied together.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPasswordHint() const
    {
        return internalRequestProperty(QLatin1String("PasswordHint"));
    }

    /**
     * Asynchronous getter for the remote object property \c CanUpdateConfiguration of type \c bool.
     *
     * 
     * \htmlonly
     * If <code>True</code>, the user may call
     *  \endhtmlonly UpdateConfiguration() \htmlonly  to change the values
     * of the properties listed in
     *  \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly .
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCanUpdateConfiguration() const
    {
        return internalRequestProperty(QLatin1String("CanUpdateConfiguration"));
    }

    /**
     * Asynchronous getter for the remote object property \c MutableProperties of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of (unqualified) property names on this interface which may
     *   be modified using  \endhtmlonly UpdateConfiguration() \htmlonly 
     *   (if  \endhtmlonly \link requestPropertyCanUpdateConfiguration() CanUpdateConfiguration \endlink \htmlonly  is
     *   <code>True</code>). Properties not listed here cannot be
     *   modified.</p>
     * 
     * <p>For example, IRC does not have the concept of joining a room without
     *   other participants knowing your true identity; so on IRC the
     *    \endhtmlonly \link requestPropertyAnonymous() Anonymous \endlink \htmlonly  property will always be
     *   <code>False</code>, and
     *    \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly  will not include
     *   <code>&quot;Anonymous&quot;</code>.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMutableProperties() const
    {
        return internalRequestProperty(QLatin1String("MutableProperties"));
    }

    /**
     * Asynchronous getter for the remote object property \c ConfigurationRetrieved of type \c bool.
     *
     * 
     * \htmlonly
     * <p><code>True</code> once the initial room configuration has been
     *   retrieved, or <code>False</code> otherwise. On some services, this
     *   may take some time after you've joined a room to fetch the
     *   configuration. Once this property changes to <code>True</code>, the
     *   other properties on this interface can be assumed to be accurate;
     *   this property MUST not change to <code>False</code> after it becomes
     *   <code>True</code>.</p>
     * 
     * <div class="rationale">
     *   <p>An application's “configure this room” dialog might choose to
     *     display a spinner while this property is <code>False</code>, rather
     *     than allowing the user to edit probably-inaccurate
     *     configuration.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyConfigurationRetrieved() const
    {
        return internalRequestProperty(QLatin1String("ConfigurationRetrieved"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c UpdateConfiguration on the remote object.
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyCanUpdateConfiguration() CanUpdateConfiguration \endlink \htmlonly  is
     *   <code>True</code>, modifies the current values of one or more
     *   room properties. This method SHOULD NOT return until the change has
     *   been accepted or declined by the server.</p>
     * 
     * <p>Note that the server may ostensibly accept the changes (thus
     *   allowing this method to return success) but signal different values;
     *   for example, the server might truncate
     *    \endhtmlonly \link requestPropertyTitle() Title \endlink \htmlonly  to some maximum length. Callers
     *   SHOULD continue to listen for the <code>PropertiesChanged</code>
     *   signal, and trust the values it signals over those provided to this
     *   method.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param properties
     *     
     *     \htmlonly
     *               <p>
     *                 The new values of one or more properties on this interface, which
     *                 must be listed in
     *                  \endhtmlonly \link requestPropertyMutableProperties() MutableProperties \endlink \htmlonly . For
     *                 instance, to set up a channel for discussing top-secret corporate
     *                 merge plans, this parameter might be:
     *               </p>
     *     
     *               <blockquote>
     *                 <pre>{
     *       'Private': True,
     *       'InviteOnly': True,
     *       'Description': &quot;The first rule of #inteltakeover is: do not talk about #inteltakeover&quot;,
     *     }</pre></blockquote>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> UpdateConfiguration(const QVariantMap& properties, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("UpdateConfiguration"));
        callMessage << QVariant::fromValue(properties);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceRoomInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Room2".
 */
class TP_QT_EXPORT ChannelInterfaceRoomInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Room2", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Room2");
    }

    /**
     * Creates a ChannelInterfaceRoomInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceRoomInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceRoomInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceRoomInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceRoomInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceRoomInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceRoomInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceRoomInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceRoomInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceRoomInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c RoomName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The human-readable identifier of a chat room. Note that if
     *   non-empty, this property (and perhaps also
     *    \endhtmlonly \link requestPropertyServer() Server \endlink \htmlonly ) should be sufficient in
     *   a channel request to join the room. XMPP MUCs have a room name
     *   concept which is more like a topic, except more
     *   persistent. This D-Bus property is <strong>not</strong> this
     *   XMPP room name, but the bit before the @ in the room jid; see
     *    \endhtmlonly \link ChannelInterfaceRoomConfigInterface::requestPropertyTitle() ChannelInterfaceRoomConfigInterface::Title \endlink \htmlonly 
     *   for that concept.</p>
     * 
     * <p>This property cannot change during the lifetime of the channel. It
     *   should appear in the <var>Allowed_Properties</var> of a
     *   <tp:type>Requestable_Channel_Class</tp:type> for the connection if
     *   rooms on this connection have human-readable names, and can be joined
     *   by name.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRoomName() const
    {
        return internalRequestProperty(QLatin1String("RoomName"));
    }

    /**
     * Asynchronous getter for the remote object property \c Server of type \c QString.
     *
     * 
     * \htmlonly
     * <p>For protocols with a concept of chatrooms on multiple servers with
     *   different DNS names (like XMPP), the DNS name of the server hosting
     *   this channel (for example, <tt>&quot;conference.jabber.org&quot;</tt> or
     *   <tt>&quot;groupchat.google.com&quot;</tt>). For other protocols, the empty
     *   string.</p>
     * 
     * <p>This property cannot change during the lifetime of the channel. It
     *   should appear in the <var>Allowed_Properties</var> of a
     *   <tp:type>Requestable_Channel_Class</tp:type> for the connection if
     *   and only if non-empty values are supported.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyServer() const
    {
        return internalRequestProperty(QLatin1String("Server"));
    }

    /**
     * Asynchronous getter for the remote object property \c Creator of type \c QString.
     *
     * 
     * \htmlonly
     * The normalized contact ID representing who created the room; or
     * the empty string if unknown.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCreator() const
    {
        return internalRequestProperty(QLatin1String("Creator"));
    }

    /**
     * Asynchronous getter for the remote object property \c CreatorHandle of type \c uint.
     *
     * 
     * \htmlonly
     * The handle corresponding to  \endhtmlonly \link requestPropertyCreator() Creator \endlink \htmlonly ;
     * or 0 if  \endhtmlonly \link requestPropertyCreator() Creator \endlink \htmlonly  is unknown.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCreatorHandle() const
    {
        return internalRequestProperty(QLatin1String("CreatorHandle"));
    }

    /**
     * Asynchronous getter for the remote object property \c CreationTimestamp of type \c qlonglong.
     *
     * 
     * \htmlonly
     * A unix timestamp indicating when the room was created; or
     * <code>INT_MAX64</code> if unknown.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCreationTimestamp() const
    {
        return internalRequestProperty(QLatin1String("CreationTimestamp"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceSASLAuthenticationInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication".
 */
class TP_QT_EXPORT ChannelInterfaceSASLAuthenticationInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication");
    }

    /**
     * Creates a ChannelInterfaceSASLAuthenticationInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSASLAuthenticationInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSASLAuthenticationInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSASLAuthenticationInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSASLAuthenticationInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceSASLAuthenticationInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceSASLAuthenticationInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceSASLAuthenticationInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceSASLAuthenticationInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSASLAuthenticationInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c AvailableMechanisms of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>The SASL mechanisms as offered by the server, plus any
     *   pseudo-SASL mechanisms supported by the connection manager for
     *   credentials transfer. For instance, in a protocol that
     *   natively uses SASL (like XMPP), this might be
     *   <code>[ &quot;X-TELEPATHY-PASSWORD&quot;, &quot;PLAIN&quot;, &quot;DIGEST-MD5&quot;,
     *     &quot;SCRAM-SHA-1&quot; ]</code>.</p>
     * 
     * <p>To make it possible to implement a very simple password-querying
     *   user interface without knowledge of any particular SASL mechanism,
     *   implementations of this interface MUST implement the
     *   pseudo-mechanism <code>X-TELEPATHY-PASSWORD</code>, unless each
     *   of the available mechanisms either requires additional information
     *   beyond the password (such as a username), or does not use a
     *   password.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAvailableMechanisms() const
    {
        return internalRequestProperty(QLatin1String("AvailableMechanisms"));
    }

    /**
     * Asynchronous getter for the remote object property \c HasInitialData of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true,  \endhtmlonly StartMechanismWithData() \htmlonly 
     *   can be expected to work for SASL mechanisms not starting with
     *   <code>X-TELEPATHY-</code> (this is the case in most, but not all,
     *   protocols). If false,  \endhtmlonly StartMechanism() \htmlonly 
     *   must be used instead.</p>
     * 
     * <p>This property does not affect the <code>X-TELEPATHY-</code>
     *   pseudo-mechanisms such as <code>X-TELEPATHY-PASSWORD</code>,
     *   which can use
     *    \endhtmlonly StartMechanismWithData() \htmlonly  regardless
     *   of the value of this property.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHasInitialData() const
    {
        return internalRequestProperty(QLatin1String("HasInitialData"));
    }

    /**
     * Asynchronous getter for the remote object property \c CanTryAgain of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true,  \endhtmlonly StartMechanism() \htmlonly  and (if
     *   supported)  \endhtmlonly StartMechanismWithData() \htmlonly 
     *   can be expected to work when in one of the Failed states. If
     *   false, the only thing you can do after failure is to close the
     *   channel.</p>
     * 
     * <div class="rationale">
     *   <p>Retrying isn't required to work, although some protocols and
     *     implementations allow it.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCanTryAgain() const
    {
        return internalRequestProperty(QLatin1String("CanTryAgain"));
    }

    /**
     * Asynchronous getter for the remote object property \c SASLStatus of type \c uint.
     *
     * 
     * \htmlonly
     * The current status of this channel.
     * Change notification is via the
     *  \endhtmlonly SASLStatusChanged() \htmlonly  signal.
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySASLStatus() const
    {
        return internalRequestProperty(QLatin1String("SASLStatus"));
    }

    /**
     * Asynchronous getter for the remote object property \c SASLError of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The reason for the  \endhtmlonly \link requestPropertySASLStatus() SASLStatus \endlink \htmlonly , or
     *   an empty string if the state is neither
     *   Server_Failed nor Client_Failed.</p>
     * 
     * <p>In particular, an ordinary authentication failure (as would
     *   be produced for an incorrect password) SHOULD be represented by
     *   <tp:error-ref>AuthenticationFailed</tp:error-ref>,
     *   cancellation by the user's request SHOULD be represented
     *   by <tp:error-ref>Cancelled</tp:error-ref>, and
     *   cancellation by a local process due to inconsistent or invalid
     *   challenges from the server SHOULD be represented by
     *   <tp:error-ref>ServiceConfused</tp:error-ref>.</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, this error code SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySASLError() const
    {
        return internalRequestProperty(QLatin1String("SASLError"));
    }

    /**
     * Asynchronous getter for the remote object property \c SASLErrorDetails of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertySASLError() SASLError \endlink \htmlonly  is non-empty,
     *   any additional information about the last
     *   disconnection; otherwise, the empty map. The keys and values are
     *   the same as for the second argument of
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly .</p>
     * 
     * <p>If this interface appears on a  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channel, and connection to the server fails with an authentication
     *   failure, these details SHOULD be copied into the
     *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
     *   signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySASLErrorDetails() const
    {
        return internalRequestProperty(QLatin1String("SASLErrorDetails"));
    }

    /**
     * Asynchronous getter for the remote object property \c AuthorizationIdentity of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The identity for which authorization is being attempted,
     *   typically the 'account' from the  \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly 
     *   parameters, normalized and formatted according to the
     *   conventions used for SASL in this protocol.</p>
     * 
     * <div class="rationale">
     *   <p>The normalization used for SASL might not be the same
     *     normalization used elsewhere: for instance, in a protocol
     *     with email-like identifiers such as XMPP or SIP, the user
     *     &quot;juliet@example.com&quot; might have to authenticate to the
     *     example.com server via SASL PLAIN as &quot;juliet&quot;.</p>
     * </div>
     * 
     * <p>This is usually achieved by using the authorization identity for
     *   authentication, but an advanced Handler could offer the option
     *   to authenticate under a different identity.</p>
     * 
     * <p>The terminology used here is that the authorization identity
     *   is who you want to act as, and the authentication identity is
     *   used to prove that you may do so. For instance, if Juliet is
     *   authorized to access a role account, &quot;sysadmin@example.com&quot;,
     *   and act on its behalf, it might be possible to authenticate
     *   as &quot;juliet@example.com&quot; with her own password, but request to
     *   be authorized as &quot;sysadmin@example.com&quot; instead of her own
     *   account. See
     *   <a href="http://tools.ietf.org/html/rfc4422#section-3.4.1">RFC
     *     4422 §3.4.1</a> for more details.</p>
     * 
     * <div class="rationale">
     *   <p>In SASL the authorization identity is normally guessed from
     *     the authentication identity, but the information available
     *     to the connection manager is the identity for which
     *     authorization is required, such as the desired JID in XMPP,
     *     so that's what we signal to UIs; it's up to the UI to
     *     choose whether to authenticate as the authorization identity
     *     or some other identity.</p>
     * 
     *   <p>As a concrete example, the &quot;sysadmin&quot; XMPP account mentioned
     *     above would have <code>{ 'account': 'sysadmin@example.com' }</code>
     *     in its Parameters, and this property would also be
     *     'sysadmin@example.com'. A simple Handler would
     *     merely prompt for sysadmin@example.com's password,
     *     and use that JID as both the authorization and authentication
     *     identity, which might result in SASL PLAIN authentication with the
     *     initial response
     *     '\\000sysadmin@example.com\\000root'.</p>
     * 
     *   <p>A more advanced Handler might also ask for an authentication
     *     identity, defaulting to 'sysadmin@example.com'; if Juliet
     *     provided authentication identity 'juliet@example.com' and
     *     password 'romeo', the Handler might perform SASL PLAIN
     *     authentication using the initial response
     *     'sysadmin@example.com\\000juliet@example.com\\000romeo'.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAuthorizationIdentity() const
    {
        return internalRequestProperty(QLatin1String("AuthorizationIdentity"));
    }

    /**
     * Asynchronous getter for the remote object property \c DefaultUsername of type \c QString.
     *
     * 
     * \htmlonly
     *         <p>The default username for use with SASL mechanisms that deal
     *           with a &quot;simple username&quot; (as defined in <a href="http://tools.ietf.org/html/rfc4422">RFC 4422</a>). If
     *           such a SASL mechanism is in use, clients SHOULD default to
     *           using the DefaultUsername; also, if the client uses
     *           the DefaultUsername, it SHOULD assume that the authorization
     *           identity  \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly 
     *           will be derived from it by the server.</p>
     * 
     *         <div class="rationale">
     *           <p>In XMPP, <a href="http://trac.tools.ietf.org/wg/xmpp/trac/ticket/49">
     *             servers typically expect</a> &quot;user@example.com&quot; to
     *             authenticate with username &quot;user&quot;; this was a SHOULD in <a href="http://tools.ietf.org/html/rfc3920">RFC 3920</a>.</p>
     * 
     *           <p><a href="http://tools.ietf.org/html/draft-ietf-xmpp-3920bis-19">3920bis</a>
     *             weakens that SHOULD to &quot;in the absence of local information
     *             provided by the server, an XMPP client SHOULD assume that
     *             the authentication identity for such a SASL mechanism is the
     *             combination of a user name and password, where the simple
     *             user name is the localpart of the user's JID&quot;.</p>
     *         </div>
     * 
     *         <p>For example, in the simple case, if the user connects with
     *          \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly ({
     *         account: &quot;<tt>user@example.com</tt>&quot; }) and use PLAIN with
     *         password &quot;password&quot;, he or she should authenticate like so:
     *         &quot;<tt>\\0user\\0password</tt>&quot; and the channel will look like
     *         this:</p>
     * 
     * <blockquote><pre>{ &quot;... \endhtmlonly \link requestPropertyDefaultUsername() DefaultUsername \endlink \htmlonly &quot;: &quot;user&quot;,
     *   &quot;... \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly &quot;: &quot;user@example.com }
     * </pre></blockquote>
     * 
     *         <p>In the complex case, if the same user is using his or her
     *           sysadmin powers to log in as the &quot;announcements&quot; role address,
     *           he or she would connect with  \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly ({
     *           account: &quot;<tt>announcements@example.com</tt>&quot; }) and the SASL
     *           channel would look like this:</p>
     * 
     * <blockquote><pre>{ &quot;... \endhtmlonly \link requestPropertyDefaultUsername() DefaultUsername \endlink \htmlonly &quot;: &quot;announcements&quot;,
     *   &quot;... \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly &quot;: &quot;announcements@example.com }
     * </pre></blockquote>
     * 
     *         <p>A sufficiently elaborate UI could give the opportunity
     *           to override the username from &quot;announcements&quot; to &quot;user&quot;.
     *           The user's simple username is still &quot;user&quot;, and the password is
     *           still &quot;password&quot;, but this time he or she is trying to authorize
     *           to act as <tt>announcements@example.com</tt>, so the UI would
     *           have to perform SASL PLAIN with this string:
     *           &quot;<tt>announcements@example.com\\0user\\0password</tt>&quot;, where
     *           &quot;announcements@example.com&quot; is the
     *            \endhtmlonly \link requestPropertyAuthorizationIdentity() AuthorizationIdentity \endlink \htmlonly .</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDefaultUsername() const
    {
        return internalRequestProperty(QLatin1String("DefaultUsername"));
    }

    /**
     * Asynchronous getter for the remote object property \c DefaultRealm of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The default realm (as defined in
     *   <a href="http://tools.ietf.org/html/rfc2831#section-2.1.1">RFC
     *     2831</a>) to use for authentication, if the server does not
     *   supply one.</p>
     * 
     * <div class="rationale">
     *   <p>The server is not required to provide a realm; if it doesn't,
     *     the client is expected to ask the user or provide a sensible
     *     default, typically the requested DNS name of the server.
     *     In some implementations of <code>DIGEST-MD5</code>, the
     *     server does not specify a realm, but expects that the client
     *     will choose a particular default, and authentication will
     *     fail if the client's default is different. Connection
     *     managers for protocols where this occurs are more easily able
     *     to work around these implementations than a generic client
     *     would be.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDefaultRealm() const
    {
        return internalRequestProperty(QLatin1String("DefaultRealm"));
    }

    /**
     * Asynchronous getter for the remote object property \c MaySaveResponse of type \c bool.
     *
     * 
     * \htmlonly
     * <p>Whether or not the client can save the authentication response and
     *   re-use it to automate future authentication challenges.</p>
     * 
     * <p>If this property is <code>False</code>, the client SHOULD NOT attempt
     *   to cache the authentication response in its own keyring.</p>
     * 
     * <p>If this property is not specified, it should be treated as if it were
     *   <code>True</code>.</p>
     * 
     * <div class="rationale">Some protocols or services may have terms and conditions
     *   that prohibit caching a user's credentials.</div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMaySaveResponse() const
    {
        return internalRequestProperty(QLatin1String("MaySaveResponse"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c StartMechanism on the remote object.
     * 
     * \htmlonly
     * <p>Start an authentication try using <var>Mechanism</var>, without
     *   sending initial data (an &quot;initial response&quot; as defined in RFC
     *   4422).</p>
     * 
     * <div class="rationale">
     *   <p>This method is appropriate for mechanisms where the client
     *     cannot send anything until it receives a challenge from the
     *     server, such as
     *     <code><a href="http://tools.ietf.org/html/rfc2831">DIGEST-MD5</a></code>
     *     in &quot;initial authentication&quot; mode.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param mechanism
     *     
     *     The chosen mechanism.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StartMechanism(const QString& mechanism, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StartMechanism"));
        callMessage << QVariant::fromValue(mechanism);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c StartMechanismWithData on the remote object.
     * 
     * \htmlonly
     * <p>Start an authentication try using <var>Mechanism</var>, and send
     *   <var>Initial_Data</var> as the &quot;initial response&quot; defined in
     *   <a href="http://tools.ietf.org/html/rfc4422#section-3.3">RFC 4422
     *     §3.3</a>.</p>
     * 
     * <div class="rationale">
     *   <p>This method is appropriate for mechanisms where the client may
     *     send data first, such as <code>PLAIN</code>, or must send data
     *     first, such as
     *     <code><a href="http://tools.ietf.org/html/rfc2831">DIGEST-MD5</a></code>
     *     in &quot;subsequent authentication&quot; mode.</p>
     * 
     *   <p>Having two methods allows any mechanism where it makes a difference
     *     to distinguish between the absence of an initial response
     *     ( \endhtmlonly StartMechanism() \htmlonly ) and a zero-byte
     *     initial response (StartMechanismWithData, with Initial_Data
     *     empty).</p>
     * </div>
     * 
     * <p>If the  \endhtmlonly \link requestPropertyHasInitialData() HasInitialData \endlink \htmlonly 
     *   property is false, this indicates that the underlying protocol
     *   does not make it possible to send initial data. In such protocols,
     *   this method may only be used for the <code>X-TELEPATHY-</code>
     *   pseudo-mechanisms (such as <code>X-TELEPATHY-PASSWORD</code>),
     *   and will fail if used with an ordinary SASL mechanism.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, the IRC SASL extension implemented in Charybdis and
     *     Atheme does not support initial data - the first message in the
     *     exchange only carries the mechanism. This is significant if using
     *     <code><a href="http://tools.ietf.org/html/rfc2831">DIGEST-MD5</a></code>,
     *     which cannot be used in the faster &quot;subsequent authentication&quot;
     *     mode on a protocol not supporting initial data.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param mechanism
     *     
     *     The chosen mechanism.
     *
     * \param initialData
     *     
     *     Initial data (an &quot;initial response&quot; in RFC 4422&apos;s 
     *     terminology) to send with the mechanism.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StartMechanismWithData(const QString& mechanism, const QByteArray& initialData, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StartMechanismWithData"));
        callMessage << QVariant::fromValue(mechanism) << QVariant::fromValue(initialData);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Respond on the remote object.
     * 
     * \htmlonly
     * <p>Send a response to the the last challenge received via
     *    \endhtmlonly NewChallenge() \htmlonly .</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param responseData
     *     
     *     The response data.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Respond(const QByteArray& responseData, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Respond"));
        callMessage << QVariant::fromValue(responseData);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AcceptSASL on the remote object.
     * 
     * \htmlonly
     * <p>If the channel's status is SASL_Status_Server_Succeeded,
     *   this method confirms successful authentication and advances
     *   the status of the channel to SASL_Status_Succeeded.</p>
     * 
     * <p>If the channel's status is SASL_Status_In_Progress, calling this
     *   method indicates that the last
     *    \endhtmlonly NewChallenge() \htmlonly  signal was in fact
     *   additional data sent after a successful SASL negotiation, and
     *   declares that from the client's point of view, authentication
     *   was successful. This advances the state of the channel to
     *   SASL_Status_Client_Accepted.</p>
     * 
     * <p>In mechanisms where the server authenticates itself to the client,
     *   calling this method indicates that the client considers this to have
     *   been successful. In the case of  \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *   channels, this means that the connection manager MAY continue to
     *   connect, and MAY advance the  \endhtmlonly \link ConnectionInterface::requestPropertyStatus() ConnectionInterface::Status \endlink \htmlonly  to Connected.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AcceptSASL(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcceptSASL"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AbortSASL on the remote object.
     * 
     * \htmlonly
     * <p>Abort the current authentication try.</p>
     * 
     * <p>If the current status is SASL_Status_Server_Failed or
     *   SASL_Status_Client_Failed, this method returns successfully, but has
     *   no further effect. If the current status is SASL_Status_Succeeded
     *   or SASL_Status_Client_Accepted then NotAvailable is raised.
     *   Otherwise, it changes the channel's state to
     *   SASL_Status_Client_Failed, with an appropriate error name and
     *   reason code.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param reason
     *     
     *     Reason for abort.
     *
     * \param debugMessage
     *     
     *     Debug message for abort.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AbortSASL(uint reason, const QString& debugMessage, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AbortSASL"));
        callMessage << QVariant::fromValue(reason) << QVariant::fromValue(debugMessage);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c SASLStatusChanged on the remote object.
     * 
     * Emitted when the status of the channel changes.
     *
     * \param status
     *     
     *     The new value of SASLStatus.
     *
     * \param reason
     *     
     *     The new value of SASLError.
     *
     * \param details
     *     
     *     The new value of SASLErrorDetails.
     */
    void SASLStatusChanged(uint status, const QString& reason, const QVariantMap& details);

    /**
     * Represents the signal \c NewChallenge on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a new challenge is received from the server, or when
     *   a message indicating successful authentication and containing
     *   additional data is received from the server.</p>
     * 
     * <p>When the channel's handler is ready to proceed, it should respond
     *   to the challenge by calling  \endhtmlonly Respond() \htmlonly ,
     *   or respond to the additional data by calling
     *    \endhtmlonly AcceptSASL() \htmlonly . Alternatively, it may call
     *    \endhtmlonly AbortSASL() \htmlonly  to abort authentication.</p>
     * \endhtmlonly
     *
     * \param challengeData
     *     
     *     The challenge data or additional data from the server.
     */
    void NewChallenge(const QByteArray& challengeData);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceSMSInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.SMS".
 */
class TP_QT_EXPORT ChannelInterfaceSMSInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.SMS", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.SMS");
    }

    /**
     * Creates a ChannelInterfaceSMSInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSMSInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSMSInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSMSInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSMSInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceSMSInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceSMSInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceSMSInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceSMSInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSMSInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Flash of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If <code>True</code>, then this channel is exclusively for
     *   receiving class 0 SMSes (and no SMSes can be sent using  \endhtmlonly ChannelInterfaceMessagesInterface::SendMessage() \htmlonly 
     *   on this channel). If <code>False</code>, no incoming class 0 SMSes
     *   will appear on this channel.</p>
     * 
     * <p>This property is immutable (cannot change), and therefore SHOULD
     *   appear wherever immutable properties are reported, e.g.  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly  signals.</p>
     * 
     * <div class="rationale">
     *   <p>Class 0 SMSes should be displayed immediately to the user, and
     *     need not be saved to the device memory unless the user explicitly
     *     chooses to do so. This is unlike “normal”, class 1 SMSes, which
     *     must be stored, but need not be shown immediately in their entirity
     *     to the user.</p>
     * 
     *   <p>Separating class 0 SMSes into their own channel with this
     *     immutable property allows them to be dispatched to a different
     *      \endhtmlonly ClientHandlerInterface \htmlonly —which
     *     would include this property in its  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly —avoiding the normal Text
     *     channel handler having to decide for each message whether it should
     *     be displayed to the user immediately or handled normally.</p>
     * 
     *   <p>Currently, no mechanism is defined for <em>sending</em> class 0
     *     SMSes. It seems reasonable to support specifying the class of an
     *     outgoing SMS in its header <tp:type>Message_Part</tp:type>, rather
     *     than requiring the UI to request a special channel for such SMSes;
     *     hence, we define here that channels with Flash set to
     *     <code>True</code> are read-only.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyFlash() const
    {
        return internalRequestProperty(QLatin1String("Flash"));
    }

    /**
     * Asynchronous getter for the remote object property \c SMSChannel of type \c bool.
     *
     * 
     * \htmlonly
     *         <p>If TRUE, messages sent and received on this channel are transmitted
     *           via SMS.</p>
     * 
     *         <p>If this property is included in the channel request, the
     *           Connection Manager MUST return an appropriate channel (i.e. if TRUE
     *           the channel must be for SMSes, if FALSE it must not), or else fail
     *           to provide the requested channel with the
     *           <tp:error-ref>NotCapable</tp:error-ref>
     *           error.</p>
     * 
     *         <p>For example, to explicitly request an SMS channel to a contact.
     *           You might construct a channel request like:</p>
     * 
     *         <blockquote><pre>{
     *   Channel.Type: Channel.Type.Text,
     *   Channel.TargetHandleType: Handle_Type_Contact,
     *   Channel.TargetID: escher.cat,
     *   Channel.Interface.SMS.SMSChannel: True,
     * }</pre></blockquote>
     * 
     *         <div class="rationale">
     *           Some protocols allow us to send SMSes to a remote contact, without
     *           knowing the phone number to which those SMSes will be sent. This
     *           provides a mechanism to request such channels.
     *         </div>
     * 
     *         <p>If this property is not included in the channel request, the
     *           Connection Manager MAY return an SMS channel if that is the most
     *           appropriate medium (i.e. if the channel target is a phone
     *           number).</p>
     * 
     *         <div class="rationale">
     *           To some types of identifiers (i.e. phone numbers) it only makes
     *           sense to return an SMS channel, this is what happens currently with
     *           telepathy-ring. We don't want to break this behaviour when we are
     *           not explicit about the type of channel we want. Alternatively, for
     *           protocols where there is an SMS fallback for IM messages, it's
     *           possible that we don't care what sort of channel we get, and simply
     *           want notification of the transport.
     *         </div>
     * 
     *         <p>Some protocols have a fallback to deliver IM messages via SMS.
     *           On these protocols, the Connection Manager SHOULD set the property
     *           value as appropriate, and notify its change with
     *            \endhtmlonly SMSChannelChanged() \htmlonly .</p>
     * 
     *         <div class="rationale">
     *           Protocols such as MSN can fall back to delivering IM messages via
     *           SMS. Where possible we want clients to be able to inform the user
     *           that their messages are going to be redirected to the remote
     *           contact's phone.
     *         </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySMSChannel() const
    {
        return internalRequestProperty(QLatin1String("SMSChannel"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetSMSLength on the remote object.
     * 
     * \htmlonly
     * <p>Returns the number of 140 octet chunks required to send a message
     *   via SMS, as well as the number of remaining characters available in
     *   the final chunk and, if possible, an estimate of the cost.</p>
     * 
     * <div class="rationale">
     *   <p>There are a number of different SMS encoding mechanisms, and the
     *     client doesn't know which mechanisms an individual CM might support.
     *     This method allows the client, without any knowledge of the
     *     encoding mechanism, to provide length details to the user.</p>
     * </div>
     * 
     * <p>Clients SHOULD limit the frequency with which this method is called
     * and SHOULD NOT call it for every keystroke. Clients MAY estimate the
     * remaining size between single keystrokes.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param message
     *     
     *     The message the user wishes to send.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The number of 140 octet chunks required to send this message.</p>
     *     
     *     <p>For example, in the GSM standard 7-bit encoding, a 162 character
     *       message would require 2 chunks.</p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The number of further characters that can be fit in the final
     *       chunk. A negative value indicates that the message will be
     *       truncated by <code>abs(Remaining_Characters)</code>. The value
     *       <code>MIN_INT32</code> (<code>-2<sup>31</sup></code>)
     *       indicates the message will be truncated by an unknown amount.</p>
     *     
     *     <p>For example, in the GSM standard 7-bit encoding, a 162 character
     *       message would return 144 remaining characters (because of the
     *       space required for the multipart SMS header).</p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The estimated cost of sending this message. The currency and
     *       scale of this value are the same as the
     *        \endhtmlonly \link ConnectionInterfaceBalanceInterface::requestPropertyAccountBalance() ConnectionInterfaceBalanceInterface::AccountBalance \endlink \htmlonly 
     *       property.</p>
     *     
     *     <p>A value of <code>-1</code> indicates the cost could not be
     *       estimated.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<uint, int, int> GetSMSLength(const Tp::MessagePartList& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint, int, int>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetSMSLength"));
        callMessage << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c SMSChannelChanged on the remote object.
     * 
     * This signal indicates a change in the SMSChannel property.
     *
     * \param SMSChannel
     *     
     *     The new value for SMSChannel.
     */
    void SMSChannelChanged(bool SMSChannel);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceSecurableInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Securable".
 */
class TP_QT_EXPORT ChannelInterfaceSecurableInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Securable", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Securable");
    }

    /**
     * Creates a ChannelInterfaceSecurableInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSecurableInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSecurableInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSecurableInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSecurableInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceSecurableInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceSecurableInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceSecurableInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceSecurableInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSecurableInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Encrypted of type \c bool.
     *
     * 
     * \htmlonly
     * <p>True if this channel occurs over an encrypted
     *   connection. This <strong>does not</strong> imply that steps
     *   have been taken to avoid man-in-the-middle attacks.</p>
     * 
     * <div class="rationale">
     *   <p>For future support for <a href="http://tools.ietf.org/html/rfc5056">RFC 5056 Channel
     *       Binding</a> it is desirable to be able to use some SASL
     *     mechanisms over an encrypted connection to an unverified peer,
     *     which can prove that it is the desired destination during
     *     the SASL negotiation.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyEncrypted() const
    {
        return internalRequestProperty(QLatin1String("Encrypted"));
    }

    /**
     * Asynchronous getter for the remote object property \c Verified of type \c bool.
     *
     * 
     * \htmlonly
     * <p>True if this channel occurs over a connection that is
     *   protected against tampering, and has been verified to be with
     *   the desired destination: for instance, one where TLS was
     *   previously negotiated, and the TLS certificate has been
     *   verified against a configured certificate authority or
     *   accepted by the user.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyVerified() const
    {
        return internalRequestProperty(QLatin1String("Verified"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceServicePointInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.ServicePoint".
 */
class TP_QT_EXPORT ChannelInterfaceServicePointInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.ServicePoint", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.ServicePoint");
    }

    /**
     * Creates a ChannelInterfaceServicePointInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceServicePointInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceServicePointInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceServicePointInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceServicePointInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceServicePointInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceServicePointInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceServicePointInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceServicePointInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceServicePointInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c InitialServicePoint of type \c Tp::ServicePoint.
     *
     * 
     * \htmlonly
     * <p>This property is used to indicate that the channel target is a
     * well-known service point.  Please note that the CM (or lower layers
     * of the stack or network) may forward the connection to other other
     * service points, which the CM SHOULD indicate via
     *  \endhtmlonly ServicePointChanged() \htmlonly 
     * signal.</p>
     * 
     * <p>This property SHOULD be set for channel requests that are
     * specifically targeting service points.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialServicePoint() const
    {
        return internalRequestProperty(QLatin1String("InitialServicePoint"));
    }

    /**
     * Asynchronous getter for the remote object property \c CurrentServicePoint of type \c Tp::ServicePoint.
     *
     * 
     * The service point that the channel is connected to. If the channel is 
     * not connected to a service point, the CM MUST set the 
     * Service_Point_Type field to None; for instance, this will be the case 
     * for ordinary calls.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCurrentServicePoint() const
    {
        return internalRequestProperty(QLatin1String("CurrentServicePoint"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ServicePointChanged on the remote object.
     * 
     * Emitted when a channel changes the service point that it&apos;s 
     * connected to. This might be a new call being connected to a service, a 
     * call connected to a service being routed to a different service (ie, an 
     * emergency call being routed from a generic emergency PSAP to a poison 
     * control PSAP), or any number of other things. Note that this should be 
     * emitted as soon as the CM has been notified of the switch, and has 
     * updated its internal state. The CM MAY still be in the process of 
     * connecting to the new service point.
     *
     * \param servicePoint
     *     
     *     The new service point that is being used.
     */
    void ServicePointChanged(const Tp::ServicePoint& servicePoint);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceSubjectInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Subject2".
 */
class TP_QT_EXPORT ChannelInterfaceSubjectInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Subject2", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Subject2");
    }

    /**
     * Creates a ChannelInterfaceSubjectInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSubjectInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSubjectInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSubjectInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSubjectInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceSubjectInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceSubjectInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceSubjectInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceSubjectInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSubjectInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Subject of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The human-readable subject on the channel such as the topic
     *   in an IRC channel, or the room name in XMPP MUCs.</p>
     * 
     * <div class="rationale">This property replaces the subject Telepathy
     *   property of Text channels, as Telepathy properties are soon to
     *   be deprecated completely.</div>
     * 
     * <p>This property may change during the lifetime of the channel and
     *   MUST not be included in a channel request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySubject() const
    {
        return internalRequestProperty(QLatin1String("Subject"));
    }

    /**
     * Asynchronous getter for the remote object property \c Actor of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The normalized contact ID representing who last modified
     *   the subject, or the empty string if it is not known.</p>
     * 
     * <div class="rationale">This property replaces the subject-contact
     *   Telepathy property of Text channels, as Telepathy properties
     *   are soon to be deprecated completely.</div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyActor() const
    {
        return internalRequestProperty(QLatin1String("Actor"));
    }

    /**
     * Asynchronous getter for the remote object property \c ActorHandle of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The handle corresponding to  \endhtmlonly \link requestPropertyActor() Actor \endlink \htmlonly ,
     * or 0 if the  \endhtmlonly \link requestPropertyActor() Actor \endlink \htmlonly  is unknown.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyActorHandle() const
    {
        return internalRequestProperty(QLatin1String("ActorHandle"));
    }

    /**
     * Asynchronous getter for the remote object property \c Timestamp of type \c qlonglong.
     *
     * 
     * \htmlonly
     * <p>A unix timestamp indicating when the subject was last
     *  modified, or <code>INT_MAX64</code> if unknown.</p>
     * 
     * <div class="rationale">This property replaces the subject-timestamp
     *   Telepathy property of Text channels, as Telepathy properties
     *   are soon to be deprecated completely.</div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTimestamp() const
    {
        return internalRequestProperty(QLatin1String("Timestamp"));
    }

    /**
     * Asynchronous getter for the remote object property \c CanSet of type \c bool.
     *
     * 
     * \htmlonly
     * <p>TRUE if the  \endhtmlonly \link requestPropertySubject() Subject \endlink \htmlonly  property
     *   can be set by the user by calling
     *    \endhtmlonly SetSubject() \htmlonly , otherwise
     *   FALSE.</p>
     * 
     * <p>If implementations are unsure of what this value should be
     *   it SHOULD still be set to what it believes the value
     *   is. As a result, clients should be aware that
     *    \endhtmlonly SetSubject() \htmlonly  can still fail
     *   even with this property set to TRUE.</p>
     * 
     * <div class="rationale">In XMPP it is impossible to know whether an
     *   occupant can set the subject as XMPP server implementations
     *   are wildly inconsistent.</div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCanSet() const
    {
        return internalRequestProperty(QLatin1String("CanSet"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetSubject on the remote object.
     * 
     * \htmlonly
     * <p>Set the room's subject. Clients SHOULD look at the subject
     *   flags before calling this method as the user might not have
     *   permission to set the subject.</p>
     * 
     * <p>A successful return of this method indicates a successful
     *   change in subject, but clients should still listen for changes
     *   to the  \endhtmlonly \link requestPropertySubject() Subject \endlink \htmlonly  property for
     *   further changes by other users or the server.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param subject
     *     
     *     The new subject.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetSubject(const QString& subject, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetSubject"));
        callMessage << QVariant::fromValue(subject);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceTubeInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Tube".
 */
class TP_QT_EXPORT ChannelInterfaceTubeInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Tube", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Tube");
    }

    /**
     * Creates a ChannelInterfaceTubeInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceTubeInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceTubeInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceTubeInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceTubeInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceTubeInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceTubeInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceTubeInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceTubeInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceTubeInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Parameters of type \c QVariantMap.
     *
     * 
     * \htmlonly
     *         <p>Each tube has a dictionary of arbitrary parameters. Parameters are
     *           commonly used to bootstrap legacy protocols where you can't
     *           negotiate parameters in-band. The allowable keys,
     *           types and values are defined by the service, but connection managers
     *           must support the value being a string (D-Bus type <tt>'s'</tt>),
     *           array of bytes (D-Bus type <tt>'ay'</tt>), unsigned integer (D-Bus
     *           type <tt>'u'</tt>), integer (D-Bus type <tt>'i'</tt>) and boolean
     *           (D-Bus type <tt>'b'</tt>).</p>
     * 
     *         <p>When the tube is offered, the parameters are transmitted with the
     *           offer and appear as a property of the incoming tube for other
     *           participants.</p>
     * 
     *         <p>For example, a stream tube for  \endhtmlonly \link ChannelTypeStreamTubeInterface::requestPropertyService() ChannelTypeStreamTubeInterface::Service \endlink \htmlonly 
     *           <tt>&quot;smb&quot;</tt> (<cite>Server Message Block over TCP/IP</cite>) might
     *           use the following properties, as defined in <a href="http://www.dns-sd.org/ServiceTypes.html">DNS SRV (RFC 2782)
     *           Service Types</a>:</p>
     * 
     *         <pre>
     * { 'u': 'some-username',
     *   'p': 'top-secret-password',
     *   'path': '/etc/passwd',
     * }</pre>
     * 
     *         <p>When requesting a tube with
     *            \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *           this property MUST NOT be included in the request; instead, it is set
     *           when  \endhtmlonly ChannelTypeStreamTubeInterface::Offer() \htmlonly 
     *           or  \endhtmlonly ChannelTypeDBusTubeInterface::Offer() \htmlonly 
     *           (as appropriate) is called. Its value is undefined until the tube is
     *           offered; once set, its value MUST NOT change.</p>
     * 
     *         <p>When receiving an incoming tube, this property is immutable and so advertised in the
     *            \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly 
     *           signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyParameters() const
    {
        return internalRequestProperty(QLatin1String("Parameters"));
    }

    /**
     * Asynchronous getter for the remote object property \c State of type \c uint.
     *
     * 
     * \htmlonly
     * <p>State of the tube in this channel.</p>
     * 
     * <p>When requesting a tube with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST NOT be included in the request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyState() const
    {
        return internalRequestProperty(QLatin1String("State"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c TubeChannelStateChanged on the remote object.
     * 
     * Emitted when the state of the tube channel changes. Valid state 
     * transitions are documented with Tube_Channel_State.
     *
     * \param state
     *     
     *     The new state of the tube.
     */
    void TubeChannelStateChanged(uint state);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeCallInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.Call1".
 */
class TP_QT_EXPORT ChannelTypeCallInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.Call1", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.Call1");
    }

    /**
     * Creates a ChannelTypeCallInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeCallInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeCallInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeCallInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeCallInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeCallInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeCallInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeCallInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeCallInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeCallInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Contents of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>The list of  \endhtmlonly CallContentInterface \htmlonly  objects that
     *   are part of this call. Change notification is via the
     *    \endhtmlonly ContentAdded() \htmlonly  and
     *    \endhtmlonly ContentRemoved() \htmlonly  signals.
     * </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContents() const
    {
        return internalRequestProperty(QLatin1String("Contents"));
    }

    /**
     * Asynchronous getter for the remote object property \c CallStateDetails of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>A map used to provide optional extensible details for the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly ,
     *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly  and/or
     *    \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly .</p>
     * 
     * <p>Well-known keys and their corresponding value types include:</p>
     * 
     * <dl>
     *   <dt>hangup-message - s</dt>
     *   <dd>An optional human-readable message sent when the call was ended,
     *     corresponding to the Message argument to the
     *      \endhtmlonly Hangup() \htmlonly  method. This is only
     *     applicable when the call state is <tp:value-ref type="Call_State">Ended</tp:value-ref>.
     *     <div class="rationale">
     *       XMPP Jingle can send such messages.
     *     </div>
     *   </dd>
     * 
     *   <dt>queue-message - s</dt>
     *   <dd>An optional human-readable message sent when the local contact
     *     is being held in a queue. This is only applicable when
     *     <tp:value-ref type="Call_Flags">Locally_Queued</tp:value-ref> is in the call flags.
     *     <div class="rationale">
     *       SIP 182 notifications can have human-readable messages attached.
     *     </div>
     *   </dd>
     * 
     *   <dt>debug-message - s</dt>
     *   <dd>A message giving further details of any error indicated by the
     *      \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly . This will not
     *     normally be localized or suitable for display to users, and is only
     *     applicable when the call state is
     *     <tp:value-ref type="Call_State">Ended</tp:value-ref>.</dd>
     * 
     *   <dt>balance-required - i</dt>
     *   <dd>Optionally included when a call cannot be connected because
     *     there is <tp:error-ref>InsufficientBalance</tp:error-ref>,
     *     indicating what the required balance would be to place this call.
     *     The value of this key has the same units and scale as
     *      \endhtmlonly \link ConnectionInterfaceBalanceInterface::requestPropertyAccountBalance() ConnectionInterfaceBalanceInterface::AccountBalance \endlink \htmlonly .
     *     </dd>
     * 
     *   <dt>forwarded-to - u</dt>
     *   <dd>Optionally included when the
     *      \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly  is
     *     Forwarded. It indicates the handle to whom the Call was
     *     forwarded.</dd>
     * 
     *   <dt>forwarded-to-id - s</dt>
     *   <dd>The string that would result from inspecting the
     *     <code>forwarded-to</code> key
     *     (i.e. the contact's identifier in the IM protocol).</dd>
     * </dl>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCallStateDetails() const
    {
        return internalRequestProperty(QLatin1String("CallStateDetails"));
    }

    /**
     * Asynchronous getter for the remote object property \c CallState of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The current high-level state of this call. The
     *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly  provide additional
     *   information, and the  \endhtmlonly \link requestPropertyCallStateReason() CallStateReason \endlink \htmlonly 
     *   and  \endhtmlonly \link requestPropertyCallStateDetails() CallStateDetails \endlink \htmlonly  explain the
     *   reason for the current values for those properties.</p>
     * 
     * <p>Note that when in a conference call, this property is
     *   purely to show your state in joining the call. The receiver
     *   (or remote contact) in this context is the conference server
     *   itself. The property does not change when other call members'
     *   states change.</p>
     * 
     * <p>Clients MAY consider unknown values in this property to be an
     *   error.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCallState() const
    {
        return internalRequestProperty(QLatin1String("CallState"));
    }

    /**
     * Asynchronous getter for the remote object property \c CallFlags of type \c uint.
     *
     * 
     * \htmlonly
     * <p>Flags representing the status of the call as a whole,
     *   providing more specific information than the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly .</p>
     * 
     * <p>Clients are expected to ignore unknown flags in this property,
     *   without error.</p>
     * 
     * <p>When an ongoing call is active and not on hold or has any
     *   other problems, this property will be 0.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCallFlags() const
    {
        return internalRequestProperty(QLatin1String("CallFlags"));
    }

    /**
     * Asynchronous getter for the remote object property \c CallStateReason of type \c Tp::CallStateReason.
     *
     * 
     * \htmlonly
     * <p>The reason for the last change to the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  and/or
     *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly . The
     *    \endhtmlonly \link requestPropertyCallStateDetails() CallStateDetails \endlink \htmlonly  MAY provide additional
     *   information.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCallStateReason() const
    {
        return internalRequestProperty(QLatin1String("CallStateReason"));
    }

    /**
     * Asynchronous getter for the remote object property \c HardwareStreaming of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If this property is True, all of the media streaming is done by some
     *   mechanism outside the scope of Telepathy.</p>
     * 
     * <div class="rationale">
     *   <p>A connection manager might be intended for a specialized hardware
     *     device, which will take care of the audio streaming (e.g.
     *     telepathy-ring, which uses GSM hardware which does the actual
     *     audio streaming for the call).</p>
     * </div>
     * 
     * <p>If this is False, the handler is responsible for doing the actual
     *   media streaming for at least some contents itself. Those contents
     *   will have the  \endhtmlonly CallContentInterfaceMediaInterface \htmlonly  interface, to communicate the necessary
     *   information to a streaming implementation. Connection managers SHOULD
     *   operate like this, if possible.</p>
     * 
     * <div class="rationale">
     *   <p>Many connection managers (such as telepathy-gabble) only do the
     *     call signalling, and expect the client to do the actual streaming
     *     using something like
     *     <a href="http://farsight.freedesktop.org/">Farsight</a>, to improve
     *     latency and allow better UI integration.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHardwareStreaming() const
    {
        return internalRequestProperty(QLatin1String("HardwareStreaming"));
    }

    /**
     * Asynchronous getter for the remote object property \c CallMembers of type \c Tp::CallMemberMap.
     *
     * 
     * \htmlonly
     * <p>A mapping from the remote contacts that are part of this call to flags
     *   describing their status. This mapping never has the local user's handle
     *   as a key.</p>
     * 
     * <p>When the call ends, this property should be an empty list,
     *   and notified with
     *    \endhtmlonly CallMembersChanged() \htmlonly </p>
     * 
     * <p>If the Call implements
     *    \endhtmlonly ChannelInterfaceGroupInterface \htmlonly  and the Group members are
     *   channel-specific handles, then this call SHOULD also use
     *   channel-specific handles.</p>
     * 
     * <p>Anonymous members are exposed as channel-specific handles
     *   with no owner.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCallMembers() const
    {
        return internalRequestProperty(QLatin1String("CallMembers"));
    }

    /**
     * Asynchronous getter for the remote object property \c MemberIdentifiers of type \c Tp::HandleIdentifierMap.
     *
     * 
     * The string identifiers for handles mentioned in CallMembers, to give 
     * clients the minimal information necessary to create contacts without 
     * waiting for round-trips.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMemberIdentifiers() const
    {
        return internalRequestProperty(QLatin1String("MemberIdentifiers"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialTransport of type \c uint.
     *
     * 
     * \htmlonly
     * <p>If set on a requested channel, this indicates the transport that
     *   should be used for this call. Where not applicable, this property
     *   is defined to be <tp:value-ref type="Stream_Transport_Type">Unknown</tp:value-ref>,
     *   in particular, on CMs with hardware streaming.</p>
     * 
     * <div class="rationale">
     *   When implementing a voip gateway one wants the outgoing leg of the
     *   gatewayed to have the same transport as the incoming leg. This
     *   property allows the gateway to request a Call with the right
     *   transport from the CM.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialTransport() const
    {
        return internalRequestProperty(QLatin1String("InitialTransport"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialAudio of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If set to True in a channel request that will create a new channel,
     *   the connection manager should immediately attempt to establish an
     *   audio stream to the remote contact, making it unnecessary for the
     *   client to call  \endhtmlonly ChannelTypeCallInterface::AddContent() \htmlonly .</p>
     * 
     * <p>If this property, or InitialVideo, is passed to EnsureChannel
     *   (as opposed to CreateChannel), the connection manager SHOULD ignore
     *   these properties when checking whether it can return an existing
     *   channel as suitable; these properties only become significant when
     *   the connection manager has decided to create a new channel.</p>
     * 
     * <p>If True on a requested channel, this indicates that the audio
     *   stream has already been requested and the client does not need to
     *   call RequestStreams, although it MAY still do so.</p>
     * 
     * <p>If True on an unrequested (incoming) channel, this indicates that
     *   the remote contact initially requested an audio stream; this does
     *   not imply that that audio stream is still active (as indicated by
     *    \endhtmlonly \link ChannelTypeCallInterface::requestPropertyContents() ChannelTypeCallInterface::Contents \endlink \htmlonly ).</p>
     * 
     * <p>The name of this new content can be decided by using the
     *    \endhtmlonly \link requestPropertyInitialAudioName() InitialAudioName \endlink \htmlonly  property.</p>
     * 
     * <p>Connection managers that support the  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface \htmlonly 
     *   interface SHOULD represent the capabilities of receiving audio
     *   and/or video calls by including a channel class in
     *   a contact's capabilities with ChannelType = Call
     *   in the fixed properties dictionary, and InitialAudio and/or
     *   InitialVideo in the allowed properties list. Clients wishing to
     *   discover whether a particular contact is likely to be able to
     *   receive audio and/or video calls SHOULD use this information.</p>
     * 
     * <div class="rationale">
     *   <p>Not all clients support video calls, and it would also be
     *     possible (although unlikely) to have a client which could only
     *     stream video, not audio.</p>
     * </div>
     * 
     * <p>Clients that are willing to receive audio and/or video calls
     *   SHOULD include the following among their channel classes if
     *   calling  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface::UpdateCapabilities() \htmlonly 
     *   (clients of a  \endhtmlonly ChannelDispatcherInterface \htmlonly 
     *   SHOULD instead arrange for the ChannelDispatcher to do this,
     *   by including the filters in their  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly 
     *   properties):</p>
     * 
     * <ul>
     *   <li>{ ChannelType = Call }</li>
     *   <li>{ ChannelType = Call, InitialAudio = True }
     *     if receiving calls with audio is supported</li>
     *   <li>{ ChannelType = Call, InitialVideo = True }
     *     if receiving calls with video is supported</li>
     * </ul>
     * 
     * <div class="rationale">
     *   <p>Connection managers for protocols with capability discovery,
     *     like XMPP, need this information to advertise the appropriate
     *     capabilities for their protocol.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialAudio() const
    {
        return internalRequestProperty(QLatin1String("InitialAudio"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialVideo of type \c bool.
     *
     * 
     * \htmlonly
     * <p>The same as  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly , but for
     *   a video stream. This property is immutable (cannot change).</p>
     * 
     * <p>In particular, note that if this property is False, this does not
     *   imply that an active video stream has not been added, only that no
     *   video stream was active at the time the channel appeared.</p>
     * 
     * <p>This property is the correct way to discover whether connection
     *   managers, contacts etc. support video calls; it appears in
     *   capabilities structures in the same way as InitialAudio.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialVideo() const
    {
        return internalRequestProperty(QLatin1String("InitialVideo"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialAudioName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly  is set to
     *   True, then this property will name the intial audio content
     *   with the value of this property.</p>
     * 
     * <div class="rationale">
     *   <p>Content names are meant to be significant, but if no name
     *     can be given to initial audio content, then its name cannot
     *     be meaningful or even localized.</p>
     * </div>
     * 
     * <p>If this property is empty or missing from the channel
     *   request and InitialAudio is True, then the CM must come up
     *   with a sensible for the content, such as &quot;audio&quot;.</p>
     * 
     * <p>If the protocol has no concept of stream names then this
     *   property will not show up in the allowed properties list of
     *   the Requestable Channel Classes for call channels.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialAudioName() const
    {
        return internalRequestProperty(QLatin1String("InitialAudioName"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialVideoName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The same as
     *    \endhtmlonly \link requestPropertyInitialAudioName() InitialAudioName \endlink \htmlonly , but for a
     *   video stream created by setting
     *    \endhtmlonly \link requestPropertyInitialVideo() InitialVideo \endlink \htmlonly  to True. This
     *   property is immutable and so cannot change.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialVideoName() const
    {
        return internalRequestProperty(QLatin1String("InitialVideoName"));
    }

    /**
     * Asynchronous getter for the remote object property \c MutableContents of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If True, a stream of a different content type can be added
     * after the Channel has been requested </p>
     * 
     * <p>If this property is missing, clients SHOULD assume that it is False,
     *   and thus that the channel's streams cannot be changed once the call
     *   has started.</p>
     * 
     * <p>If this property isn't present in the &quot;allowed&quot; set in any of the
     *   Call entries contact capabilities, then user interfaces MAY choose to
     *   show a separate &quot;call&quot; option for each class of call.</p>
     * 
     *   <div class="rationale">
     *     <p>For example, once an audio-only Google Talk call has started,
     *       it is not possible to add a video stream; both audio and video
     *       must be requested at the start of the call if video is desired.
     *       User interfaces may use this pseudo-capability as a hint to
     *       display separate &quot;Audio call&quot; and &quot;Video call&quot; buttons, rather
     *       than a single &quot;Call1&quot; button with the option to add and remove
     *       video once the call has started for contacts without this flag.
     *     </p>
     *   </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMutableContents() const
    {
        return internalRequestProperty(QLatin1String("MutableContents"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetRinging on the remote object.
     * 
     * \htmlonly
     * <p>Indicate that the local user has been alerted about the incoming
     *   call.</p>
     * 
     * <p>This method is only useful if the
     *   channel's  \endhtmlonly \link ChannelInterface::requestPropertyRequested() ChannelInterface::Requested \endlink \htmlonly 
     *   property is False, and
     *   the  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  is
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref> (an incoming
     *   call is ready and waiting for the user to be notified). Calling this method
     *   SHOULD set  \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly ' bit
     *   <tp:value-ref type="Call_Flags">Locally_Ringing</tp:value-ref>, and notify the
     *   remote contact that the local user has been alerted (if the
     *   protocol supports this); repeated calls to this method
     *   SHOULD succeed, but have no further effect.</p>
     * 
     * <p>In all other states, this method SHOULD fail with the error
     *   NotAvailable.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetRinging(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetRinging"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetQueued on the remote object.
     * 
     * \htmlonly
     * <p>Notifies the CM that the local user is already in a call, so this
     *   call has been put in a call-waiting style queue.</p>
     * 
     * <p>This method is only useful if the
     *   channel's  \endhtmlonly \link ChannelInterface::requestPropertyRequested() ChannelInterface::Requested \endlink \htmlonly 
     *   property is False, and
     *   the  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  is
     *   <tp:value-ref type="Call_State">Initialising</tp:value-ref> or
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref>. Calling this method
     *   SHOULD set  \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly ' bit
     *   <tp:value-ref type="Call_Flags">Locally_Queued</tp:value-ref>, and notify the
     *   remote contact that the call is in a queue (if the
     *   protocol supports this); repeated calls to this method
     *   SHOULD succeed, but have no further effect.</p>
     * 
     * <p>Locally_Queued is a little like Locally_Held, but applies to calls that have not
     *   been Accepted (the Locally_Queued flag should be unset by the CM when Accept
     *   is called). It should also be set in response to the state of the
     *   world, rather than in response to user action.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetQueued(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetQueued"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Accept on the remote object.
     * 
     * \htmlonly
     * <p>For incoming calls in state
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref>, accept the incoming call.
     *   This changes the  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  to
     *   <tp:value-ref type="Call_State">Accepted</tp:value-ref>.</p>
     * 
     * <p>For outgoing calls in state
     *   <tp:value-ref type="Call_State">Pending_Initiator</tp:value-ref>, actually
     *   call the remote contact; this changes the
     *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  to
     *   <tp:value-ref type="Call_State">Initialising</tp:value-ref>.</p>
     * 
     * <p>Otherwise, this method SHOULD fail with the error NotAvailable.</p>
     * 
     * <p>This method should be called exactly once per Call, by whatever
     *   client (user interface) is handling the channel.</p>
     * 
     * <p>When this method is called, for each  \endhtmlonly CallContentInterface \htmlonly  whose
     *    \endhtmlonly \link CallContentInterface::requestPropertyDisposition() CallContentInterface::Disposition \endlink \htmlonly  is
     *   <tp:value-ref type="Call_Content_Disposition">Initial</tp:value-ref>, any
     *   streams where the  \endhtmlonly \link CallStreamInterface::requestPropertyLocalSendingState() CallStreamInterface::LocalSendingState \endlink \htmlonly 
     *   is <tp:value-ref type="Sending_State">Pending_Send</tp:value-ref> will be
     *   moved to <tp:value-ref type="Sending_State">Sending</tp:value-ref> as if
     *    \endhtmlonly CallStreamInterface::SetSending() \htmlonly (True) had been called.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Accept(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Accept"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Hangup on the remote object.
     * 
     * Request that the call is ended. All contents will be removed from the 
     * Call so that the Contents property will be the empty list.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param reason
     *     
     *     A generic hangup reason.
     *
     * \param detailedHangupReason
     *     
     *     A more specific reason for the call hangup, if one is available, or 
     *     an empty string otherwise.
     *
     * \param message
     *     
     *     A human-readable message to be sent to the remote contact(s). XMPP 
     *     Jingle allows calls to be terminated with a human-readable message.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Hangup(uint reason, const QString& detailedHangupReason, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Hangup"));
        callMessage << QVariant::fromValue(reason) << QVariant::fromValue(detailedHangupReason) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AddContent on the remote object.
     * 
     * Request that a new Content of type Content_Type is added to the Call1. 
     * Handlers should check the value of the MutableContents property before 
     * trying to add another content as it might not be allowed.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contentName
     *     
     *     The suggested name of the content to add. The content name property 
     *     should be meaningful, so should be given a name which is 
     *     significant to the user. The name could be a localized 
     *     &quot;audio&quot;, &quot;video&quot; or perhaps include some string 
     *     identifying the source, such as a webcam identifier. If there is 
     *     already a content with the same name as this property then a 
     *     sensible suffix should be added. For example, if this argument is 
     *     &quot;audio&quot; but a content of the same name already exists, a 
     *     sensible suffix such as &quot; (1)&quot; is appended to name the 
     *     new content &quot;audio (1)&quot;. A further content with the name 
     *     &quot;audio&quot; would then be named &quot;audio (2)&quot;.
     *
     * \param contentType
     *     
     *     The media stream type of the content to be added to the call.
     *
     * \param initialDirection
     *     
     *     The requested initial direction of the new content.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     Path to the newly-created Call1.Content object.
     */
    inline QDBusPendingReply<QDBusObjectPath> AddContent(const QString& contentName, uint contentType, uint initialDirection, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddContent"));
        callMessage << QVariant::fromValue(contentName) << QVariant::fromValue(contentType) << QVariant::fromValue(initialDirection);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c ContentAdded on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a new  \endhtmlonly CallContentInterface \htmlonly  is added to the call.</p>
     * \endhtmlonly
     *
     * \param content
     *     
     *     Path to the newly-created Content object.
     */
    void ContentAdded(const QDBusObjectPath& content);

    /**
     * Represents the signal \c ContentRemoved on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a  \endhtmlonly CallContentInterface \htmlonly  is removed from the call.</p>
     * \endhtmlonly
     *
     * \param content
     *     
     *     The Content which was removed.
     *
     * \param reason
     *     
     *     Why the content was removed.
     */
    void ContentRemoved(const QDBusObjectPath& content, const Tp::CallStateReason& reason);

    /**
     * Represents the signal \c CallStateChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the state of the call as a whole changes.</p>
     * 
     * <p>This signal is emitted for any change in the properties
     *   corresponding to its arguments, even if the other properties
     *   referenced remain unchanged.</p>
     * \endhtmlonly
     *
     * \param callState
     *     
     *     The new value of the CallState property.
     *
     * \param callFlags
     *     
     *     The new value of the CallFlags property.
     *
     * \param callStateReason
     *     
     *     The new value of the CallStateReason property.
     *
     * \param callStateDetails
     *     
     *     The new value of the CallStateDetails property.
     */
    void CallStateChanged(uint callState, uint callFlags, const Tp::CallStateReason& callStateReason, const QVariantMap& callStateDetails);

    /**
     * Represents the signal \c CallMembersChanged on the remote object.
     * 
     * Emitted when the CallMembers property changes in any way, either 
     * because contacts have been added to the call, contacts have been 
     * removed from the call, or contacts&apos; flags have changed.
     *
     * \param flagsChanged
     *     
     *     A map from members of the call to their new call member flags, 
     *     including at least the members who have been added to CallMembers, 
     *     and the members whose flags have changed.
     *
     * \param identifiers
     *     
     *     \htmlonly
     *     The identifiers of the contacts in the <var>Flags_Changed</var> map.
     *     \endhtmlonly
     *
     * \param removed
     *     
     *     A list of members who have left the call, i.e. keys to be removed 
     *     from CallMembers.
     *
     * \param reason
     *     
     *     A structured reason for the change.
     */
    void CallMembersChanged(const Tp::CallMemberMap& flagsChanged, const Tp::HandleIdentifierMap& identifiers, const Tp::UIntList& removed, const Tp::CallStateReason& reason);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeContactListInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ContactList".
 */
class TP_QT_EXPORT ChannelTypeContactListInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.ContactList", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.ContactList");
    }

    /**
     * Creates a ChannelTypeContactListInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeContactListInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeContactListInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeContactListInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeContactListInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeContactListInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeContactListInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeContactListInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeContactListInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeContactListInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeContactSearchInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ContactSearch".
 */
class TP_QT_EXPORT ChannelTypeContactSearchInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.ContactSearch", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.ContactSearch");
    }

    /**
     * Creates a ChannelTypeContactSearchInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeContactSearchInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeContactSearchInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeContactSearchInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeContactSearchInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeContactSearchInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeContactSearchInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeContactSearchInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeContactSearchInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeContactSearchInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c SearchState of type \c uint.
     *
     * 
     * The current state of this search channel object. Change notification is 
     * via SearchStateChanged.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySearchState() const
    {
        return internalRequestProperty(QLatin1String("SearchState"));
    }

    /**
     * Asynchronous getter for the remote object property \c Limit of type \c uint.
     *
     * 
     * \htmlonly
     * <p>If supported by the protocol, the maximum number of results that
     *   should be returned, where <code>0</code> represents no limit. If the
     *   protocol does not support limiting results, this should be
     *   <code>0</code>.</p>
     * 
     * <p>For example, if the terms passed to
     *    \endhtmlonly Search() \htmlonly  match <i>Antonius</i>,
     *   <i>Bridget</i> and <i>Charles</i> and this property is
     *   <code>2</code>, the search service SHOULD only return <i>Antonius</i>
     *   and <i>Bridget</i>.</p>
     * 
     * <p>This property SHOULD be requestable if and only if the protocol
     *   supports specifying a limit; implementations SHOULD use
     *   <code>0</code> as the default if possible, or a protocol-specific
     *   sensible default otherwise.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLimit() const
    {
        return internalRequestProperty(QLatin1String("Limit"));
    }

    /**
     * Asynchronous getter for the remote object property \c AvailableSearchKeys of type \c QStringList.
     *
     * 
     * The set of search keys supported by this channel. Example values 
     * include [&quot;&quot;] (for protocols where several address fields are 
     * implicitly searched) or [&quot;x-n-given&quot;, &quot;x-n-family&quot;, 
     * &quot;nickname&quot;, &quot;email&quot;] (for XMPP XEP-0055, without 
     * extensibility via Data Forms). It can be in the NewChannels signal for 
     * round-trip reduction.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAvailableSearchKeys() const
    {
        return internalRequestProperty(QLatin1String("AvailableSearchKeys"));
    }

    /**
     * Asynchronous getter for the remote object property \c Server of type \c QString.
     *
     * 
     * For protocols which support searching for contacts on multiple servers 
     * with different DNS names (like XMPP), the DNS name of the server being 
     * searched by this channel, e.g. &quot;characters.shakespeare.lit&quot;. 
     * Otherwise, the empty string. XEP 0055 defines a mechanism for XMPP 
     * clients to search services of their choice for contacts, such as 
     * users.jabber.org (the &quot;Jabber User Directory&quot;). This property 
     * SHOULD be requestable if and only if the protocol supports querying 
     * multiple different servers; implementations SHOULD use a sensible 
     * default if possible if this property is not specified in a channel 
     * request. This allows a client to perform searches on a protocol it 
     * knows nothing about without requiring the user to guess a valid 
     * server&apos;s hostname.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyServer() const
    {
        return internalRequestProperty(QLatin1String("Server"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Search on the remote object.
     * 
     * Send a request to start a search for contacts on this connection. This 
     * may only be called while the SearchState is Not_Started; a valid search 
     * request will cause the SearchStateChanged signal to be emitted with the 
     * state In_Progress.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param terms
     *     
     *     A dictionary mapping search key names to the desired values
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Search(const Tp::ContactSearchMap& terms, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Search"));
        callMessage << QVariant::fromValue(terms);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c More on the remote object.
     * 
     * \htmlonly
     * Request that a search in  \endhtmlonly \link requestPropertySearchState() SearchState \endlink \htmlonly 
     * <code>More_Available</code> move back to state <code>In_Progress</code>
     * and continue listing up to  \endhtmlonly \link requestPropertyLimit() Limit \endlink \htmlonly  more results.
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> More(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("More"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Stop on the remote object.
     * 
     * \htmlonly
     * <p>Stop the current search. This may not be called while the
     *    \endhtmlonly \link requestPropertySearchState() SearchState \endlink \htmlonly  is Not_Started. If called
     *   while the SearchState is In_Progress,
     *    \endhtmlonly SearchStateChanged() \htmlonly  will be emitted,
     *   with the state Failed and the error
     *   <code>org.freedesktop.Telepathy.Error.<tp:error-ref>Cancelled</tp:error-ref></code>.</p>
     * 
     * <p>Calling this method on a search in state Completed or Failed
     *   succeeds, but has no effect.</p>
     * 
     * <div class="rationale">
     *   <p>Specifying Stop to succeed when the search has finished means that
     *     clients who call Stop just before receiving
     *      \endhtmlonly SearchStateChanged() \htmlonly  don't have to
     *     handle a useless error.</p>
     * </div>
     * 
     * <p>Depending on the protocol, the connection manager may not be
     *   able to prevent the server from sending further results after this
     *   method returns; if this is the case, it MUST ignore any further
     *   results.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Stop(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Stop"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c SearchStateChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the  \endhtmlonly \link requestPropertySearchState() SearchState \endlink \htmlonly  property
     *   changes. The implementation MUST NOT make transitions other than the
     *   following:</p>
     * 
     * <ul>
     *   <li><code>Not_Started</code> → <code>In_Progress</code></li>
     *   <li><code>In_Progress</code> → <code>More_Available</code></li>
     *   <li><code>More_Available</code> → <code>In_Progress</code></li>
     *   <li><code>In_Progress</code> → <code>Completed</code></li>
     *   <li><code>In_Progress</code> → <code>Failed</code></li>
     * </ul>
     * \endhtmlonly
     *
     * \param state
     *     
     *     The new search state
     *
     * \param error
     *     
     *     \htmlonly
     *     If the new state is <code>Failed</code>, the name of a D-Bus error
     *     describing what went wrong. Otherwise, the empty string.
     *     \endhtmlonly
     *
     * \param details
     *     
     *     \htmlonly
     *     <p>Additional information about the state transition, which may
     *       include the following well-known keys:</p>
     *     
     *     <dl>
     *       <dt>debug-message (s)</dt>
     *       <dd>Debugging information on the change, corresponding to the
     *         message part of a D-Bus error message, which SHOULD NOT be
     *         displayed to users under normal circumstances</dd>
     *     </dl>
     *     
     *     <div class="rationale">
     *       <p>This argument allows for future extensions. For instance,
     *         if moving to state <code>Failed</code> because the server
     *         rejected one of our search terms, we could define a key
     *         that indicates which terms were invalid.</p>
     *     </div>
     *     \endhtmlonly
     */
    void SearchStateChanged(uint state, const QString& error, const QVariantMap& details);

    /**
     * Represents the signal \c SearchResultReceived on the remote object.
     * 
     * Emitted when a some search results are received from the server. This 
     * signal can be fired arbitrarily many times so clients MUST NOT assume 
     * they&apos;ll get only one signal.
     *
     * \param result
     *     
     *     A mapping from contact identifier to an array of fields 
     *     representing information about this contact.
     */
    void SearchResultReceived(const Tp::ContactSearchResultMap& result);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeDBusTubeInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.DBusTube".
 */
class TP_QT_EXPORT ChannelTypeDBusTubeInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.DBusTube", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.DBusTube");
    }

    /**
     * Creates a ChannelTypeDBusTubeInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeDBusTubeInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeDBusTubeInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeDBusTubeInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeDBusTubeInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeDBusTubeInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeDBusTubeInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeDBusTubeInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeDBusTubeInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeDBusTubeInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ServiceName of type \c QString.
     *
     * 
     * \htmlonly
     * <p>A string representing the service name that will be used over the
     *   tube. It SHOULD be a well-known D-Bus service name, of the form
     *   <tt>com.example.ServiceName</tt>.</p>
     * <p>When the tube is offered, the service name is transmitted to the
     *   other end.</p>
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST be included in the request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyServiceName() const
    {
        return internalRequestProperty(QLatin1String("ServiceName"));
    }

    /**
     * Asynchronous getter for the remote object property \c DBusNames of type \c Tp::DBusTubeParticipants.
     *
     * 
     * For a multi-user (i.e. Handle_Type_Room) D-Bus tube, a mapping between 
     * contact handles and their unique bus names on this tube. For a 
     * peer-to-peer (i.e. Handle_Type_Contact) D-Bus tube, the empty 
     * dictionary. Change notification is via DBusNamesChanged.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDBusNames() const
    {
        return internalRequestProperty(QLatin1String("DBusNames"));
    }

    /**
     * Asynchronous getter for the remote object property \c SupportedAccessControls of type \c Tp::UIntList.
     *
     * 
     * \htmlonly
     * <p>A list of the access control types that are supported with this channel.
     * Note that only Socket_Access_Control_Localhost and
     * Socket_Access_Control_Credentials can be used with D-Bus tubes.
     * Using Socket_Access_Control_Credentials is recommended.</p>
     * 
     * <div class="rationale">
     *   <p>Socket_Access_Control_Credentials is easy to implement for a
     *     D-Bus tube, because typical D-Bus library implementations like
     *     libdbus and GDBus already have to support it to be able to
     *     connect to the system or session bus, and usually enable it
     *     by default; so there's typically no good reason to relax
     *     access control to Localhost.</p>
     * </div>
     * 
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST NOT be included in the request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedAccessControls() const
    {
        return internalRequestProperty(QLatin1String("SupportedAccessControls"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Offer on the remote object.
     * 
     * Offers a D-Bus tube providing the service specified.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param parameters
     *     
     *     The dictionary of arbitrary Parameters to send with the tube offer.
     *
     * \param accesscontrol
     *     
     *     The access control the connection manager applies to the D-Bus 
     *     socket.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The string describing the address of the private bus. The client 
     *     SHOULD NOT attempt to connect to the address until the tube is open.
     */
    inline QDBusPendingReply<QString> Offer(const QVariantMap& parameters, uint accesscontrol, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Offer"));
        callMessage << QVariant::fromValue(parameters) << QVariant::fromValue(accesscontrol);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Accept on the remote object.
     * 
     * Accept a D-Bus tube that&apos;s in the &quot;local pending&quot; state. 
     * The connection manager will attempt to open the tube. The tube remains 
     * in the &quot;local pending&quot; state until the 
     * TubeChannelStateChanged signal is emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param accesscontrol
     *     
     *     The access control the connection manager applies to the D-Bus 
     *     socket.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The string describing the address of the private bus. The client 
     *     SHOULD NOT attempt to connect to the address until the tube is open.
     */
    inline QDBusPendingReply<QString> Accept(uint accesscontrol, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Accept"));
        callMessage << QVariant::fromValue(accesscontrol);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c DBusNamesChanged on the remote object.
     * 
     * Emitted on a multi-user (i.e. Handle_Type_Room) D-Bus tube when a 
     * participant opens or closes the tube. This provides change notification 
     * for the DBusNames property.
     *
     * \param added
     *     
     *     Array of handles and D-Bus names of new participants.
     *
     * \param removed
     *     
     *     Array of handles of former participants.
     */
    void DBusNamesChanged(const Tp::DBusTubeParticipants& added, const Tp::UIntList& removed);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeFileTransferInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.FileTransfer".
 */
class TP_QT_EXPORT ChannelTypeFileTransferInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.FileTransfer", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.FileTransfer");
    }

    /**
     * Creates a ChannelTypeFileTransferInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeFileTransferInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeFileTransferInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeFileTransferInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeFileTransferInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeFileTransferInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeFileTransferInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeFileTransferInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeFileTransferInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeFileTransferInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c State of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The state of the file transfer as described by the
     * File_Transfer_State enum.</p>
     * 
     * <p>Change notification is via
     *    \endhtmlonly FileTransferStateChanged() \htmlonly  signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyState() const
    {
        return internalRequestProperty(QLatin1String("State"));
    }

    /**
     * Asynchronous getter for the remote object property \c ContentType of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The file's MIME type. This cannot change once the channel has
     * been created.</p>
     * 
     * <p>This property is mandatory when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. Protocols which do not have a content-type property with file
     * transfers should set this value to application/octet-stream.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContentType() const
    {
        return internalRequestProperty(QLatin1String("ContentType"));
    }

    /**
     * Asynchronous getter for the remote object property \c Filename of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The name of the file on the sender's side. This is therefore given
     * as a suggested filename for the receiver. This cannot change
     * once the channel has been created.</p>
     * 
     * <p>This property should be the basename of the file being sent. For example,
     * if the sender sends the file /home/user/monkey.pdf then this property should
     * be set to monkey.pdf.</p>
     * 
     * <p>This property is mandatory when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. This property cannot be empty and MUST be set to a sensible value.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyFilename() const
    {
        return internalRequestProperty(QLatin1String("Filename"));
    }

    /**
     * Asynchronous getter for the remote object property \c Size of type \c qulonglong.
     *
     * 
     * \htmlonly
     * <p>The size of the file. If this property is set, then the file
     * transfer is guaranteed to be this size. This cannot change once
     * the channel has been created.</p>
     * 
     * <p>When you are creating a channel with this property, its value
     * MUST be accurate and in bytes. However, when receiving a file, this
     * property still MUST be in bytes but might not be entirely accurate
     * to the byte.</p>
     * 
     * <p>This property is mandatory when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. If this information isn't provided in the protocol, connection managers MUST set it
     * to UINT64_MAX.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySize() const
    {
        return internalRequestProperty(QLatin1String("Size"));
    }

    /**
     * Asynchronous getter for the remote object property \c ContentHashType of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The type of the  \endhtmlonly \link requestPropertyContentHash() ContentHash \endlink \htmlonly  property.</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. However, if you wish to include the  \endhtmlonly \link requestPropertyContentHash() ContentHash \endlink \htmlonly 
     * property you MUST also include this property. If you omit this property from a
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method call then its value will be assumed to be File_Hash_Type_None.</p>
     * 
     * <p>For each supported hash type, implementations SHOULD include an entry
     *   in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly 
     *   with this property fixed to that hash type. If the protocol supports
     *   offering a file without a content hash, implementations SHOULD list
     *   this property in Allowed in a requestable channel class, mapping hash
     *   types they don't understand to None.
     * </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContentHashType() const
    {
        return internalRequestProperty(QLatin1String("ContentHashType"));
    }

    /**
     * Asynchronous getter for the remote object property \c ContentHash of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Hash of the contents of the file transfer, of type described
     * in the value of the  \endhtmlonly \link requestPropertyContentHashType() ContentHashType \endlink \htmlonly 
     * property.</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. Its value MUST correspond to the appropriate type of the
     *  \endhtmlonly \link requestPropertyContentHashType() ContentHashType \endlink \htmlonly  property. If the
     * ContentHashType property is not set, or set to File_Hash_Type_None,
     * then this property will not even be looked at.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyContentHash() const
    {
        return internalRequestProperty(QLatin1String("ContentHash"));
    }

    /**
     * Asynchronous getter for the remote object property \c Description of type \c QString.
     *
     * 
     * \htmlonly
     * <p>Description of the file transfer. This cannot change once the
     * channel has been created.</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method. If this property was not provided by the remote party, connection managers MUST set it to
     * the empty string.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDescription() const
    {
        return internalRequestProperty(QLatin1String("Description"));
    }

    /**
     * Asynchronous getter for the remote object property \c Date of type \c qlonglong.
     *
     * 
     * \htmlonly
     * <p>The last modification time of the file being transferred. This
     * cannot change once the channel has been created</p>
     * 
     * <p>This property is optional when requesting the channel with the
     *  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     * method.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDate() const
    {
        return internalRequestProperty(QLatin1String("Date"));
    }

    /**
     * Asynchronous getter for the remote object property \c AvailableSocketTypes of type \c Tp::SupportedSocketMap.
     *
     * 
     * \htmlonly
     * <p>A mapping from address types (members of Socket_Address_Type) to
     * arrays of access-control type (members of Socket_Access_Control)
     * that the connection manager supports for sockets with that
     * address type. For simplicity, if a CM supports offering a
     * particular type of file transfer, it is assumed to support accepting
     * it. Connection Managers MUST support at least Socket_Address_Type_IPv4.</p>
     * 
     * <p>A typical value for a host without IPv6 support:</p>
     * 
     * <pre>
     *   {
     *     Socket_Address_Type_IPv4:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Port,
     *        Socket_Access_Control_Netmask],
     *     Socket_Address_Type_Unix:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]
     *   }
     * </pre>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAvailableSocketTypes() const
    {
        return internalRequestProperty(QLatin1String("AvailableSocketTypes"));
    }

    /**
     * Asynchronous getter for the remote object property \c TransferredBytes of type \c qulonglong.
     *
     * 
     * \htmlonly
     * <p>The number of bytes that have been transferred at the time of
     * requesting the property. This will be updated as the file transfer
     * continues.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTransferredBytes() const
    {
        return internalRequestProperty(QLatin1String("TransferredBytes"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialOffset of type \c qulonglong.
     *
     * 
     * \htmlonly
     * <p>The offset in bytes from where the file should be sent. This MUST
     * be respected by both the receiver and the sender after the state
     * becomes Open, but before any data is sent or received. Until the
     *  \endhtmlonly InitialOffsetDefined() \htmlonly  signal
     * is emitted, this property is undefined.</p>
     * 
     * <p>Before setting the  \endhtmlonly \link requestPropertyState() State \endlink \htmlonly  property to
     * Open, the connection manager MUST set the InitialOffset property,
     * possibly to 0.</p>
     * 
     * <p>This property MUST NOT change after the state of the transfer has
     * changed to Open.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialOffset() const
    {
        return internalRequestProperty(QLatin1String("InitialOffset"));
    }

    /**
     * Asynchronous getter for the remote object property \c URI of type \c QString.
     *
     * 
     * \htmlonly
     * <p>For outgoing file transfers, this requestable property allows the channel
     * requester to inform observers (and the handler, if it is not the requester
     * itself) of the URI of the file being transferred. Note that the
     * connection manager SHOULD NOT read this file directly; the handler
     * streams the file into the CM through the socket negotiated using
     *  \endhtmlonly ProvideFile() \htmlonly .</p>
     * 
     * <p>On outgoing file transfers, this property MUST NOT change after the channel
     * is requested.</p>
     * 
     * <p>For incoming file transfers, this property MAY be set by the channel
     * handler before calling  \endhtmlonly AcceptFile() \htmlonly  to
     * inform observers where the incoming file will be saved. If set by an
     * approver, the handler MUST save the file to that location.
     * Setting this property once  \endhtmlonly AcceptFile() \htmlonly 
     * has been called MUST fail. Once this property has been set
     *  \endhtmlonly URIDefined() \htmlonly  is emitted.</p>
     * 
     * <p>If set, this URI SHOULD generally point to a file on the local system, as
     * defined by <a href="http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.10">
     * RFC 1738 §3.10</a>; that is, it should be of the form
     * <tt>file:///path/to/file</tt> or <tt>file://localhost/path/to/file</tt>.
     * For outgoing files, this URI MAY use a different scheme, such as
     * <tt>http:</tt>, if a remote resource is being transferred
     * to a contact.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyURI() const
    {
        return internalRequestProperty(QLatin1String("URI"));
    }

    /**
     * Asynchronous setter for the remote object property \c URI of type \c QString.
     *
     * 
     * \htmlonly
     * <p>For outgoing file transfers, this requestable property allows the channel
     * requester to inform observers (and the handler, if it is not the requester
     * itself) of the URI of the file being transferred. Note that the
     * connection manager SHOULD NOT read this file directly; the handler
     * streams the file into the CM through the socket negotiated using
     *  \endhtmlonly ProvideFile() \htmlonly .</p>
     * 
     * <p>On outgoing file transfers, this property MUST NOT change after the channel
     * is requested.</p>
     * 
     * <p>For incoming file transfers, this property MAY be set by the channel
     * handler before calling  \endhtmlonly AcceptFile() \htmlonly  to
     * inform observers where the incoming file will be saved. If set by an
     * approver, the handler MUST save the file to that location.
     * Setting this property once  \endhtmlonly AcceptFile() \htmlonly 
     * has been called MUST fail. Once this property has been set
     *  \endhtmlonly URIDefined() \htmlonly  is emitted.</p>
     * 
     * <p>If set, this URI SHOULD generally point to a file on the local system, as
     * defined by <a href="http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.10">
     * RFC 1738 §3.10</a>; that is, it should be of the form
     * <tt>file:///path/to/file</tt> or <tt>file://localhost/path/to/file</tt>.
     * For outgoing files, this URI MAY use a different scheme, such as
     * <tt>http:</tt>, if a remote resource is being transferred
     * to a contact.</p>
     * \endhtmlonly
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyURI(QString newValue)
    {
        return internalSetProperty(QLatin1String("URI"), QVariant::fromValue(newValue));
    }

    /**
     * Asynchronous getter for the remote object property \c FileCollection of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The collection of files to which this channel belongs,
     *   or the empty string if this channel does not belong to
     *   a collection of files.</p>
     * 
     * <p>A channel's FileCollection property can never change.</p>
     * 
     * <p>At least on GTalk and apparently also on iChat the user can
     *   send a set of files to a contact and that contact can then
     *   pick and choose which files to actually receive.</p>
     * 
     * <p> The CM should emit all new FT channels belonging to one collection
     *   at the same time. UIs supporting this feature can then
     *   bundle all these channels together in some way, and show a
     *   nice UI. UIs not supporting it will treat them as separate
     *   transfers, which is not great but a reasonable fallback.</p>
     * 
     * <p>No mechanism is currently defined to indicate whether the UI
     *   should expect any more files in the same collection. UIs
     *   SHOULD assume that more file transfers may be added to a
     *   collection. It is possible that a &quot;no more channels in this
     *   collection&quot; indication will be added in a future version of
     *   this specification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyFileCollection() const
    {
        return internalRequestProperty(QLatin1String("FileCollection"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AcceptFile on the remote object.
     * 
     * Accept a file transfer that&apos;s in the Pending state. The file 
     * transfer&apos;s state becomes Accepted after this method is called. At 
     * this point the client can connect to the socket. CM MUST emit 
     * InitialOffsetDefined and change the state to Open before writing to the 
     * socket. Then InitialOffset should be respected in case its value 
     * differs from the offset that was specified as an argument to AcceptFile.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param addressType
     *     
     *     The type of address the connection manager should listen on.
     *
     * \param accessControl
     *     
     *     The type of access control the connection manager should apply to 
     *     the socket.
     *
     * \param accessControlParam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     *
     * \param offset
     *     
     *     The desired offset in bytes where the file transfer should start. 
     *     The offset is taken from the beginning of the file. Specifying an 
     *     offset of zero will start the transfer from the beginning of the 
     *     file. The offset that is actually given in the InitialOffset 
     *     property can differ from this argument where the requested offset 
     *     is not supported. (For example, some protocols do not support 
     *     offsets at all so the InitialOffset property will always be 0.)
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections for this file transfer.
     */
    inline QDBusPendingReply<QDBusVariant> AcceptFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, qulonglong offset, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusVariant>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcceptFile"));
        callMessage << QVariant::fromValue(addressType) << QVariant::fromValue(accessControl) << QVariant::fromValue(accessControlParam) << QVariant::fromValue(offset);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ProvideFile on the remote object.
     * 
     * Provide the file for an outgoing file transfer which has been offered. 
     * Opens a socket that the client can use to provide a file to the 
     * connection manager. The channel MUST have been requested, and will 
     * change state to Open when this method is called if its state was 
     * Accepted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param addressType
     *     
     *     The type of address the connection manager should listen on.
     *
     * \param accessControl
     *     
     *     The type of access control the connection manager should apply to 
     *     the socket.
     *
     * \param accessControlParam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections for this file transfer.
     */
    inline QDBusPendingReply<QDBusVariant> ProvideFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusVariant>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ProvideFile"));
        callMessage << QVariant::fromValue(addressType) << QVariant::fromValue(accessControl) << QVariant::fromValue(accessControlParam);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c FileTransferStateChanged on the remote object.
     * 
     * Emitted when the state of a file transfer changes.
     *
     * \param state
     *     
     *     The new state of the file transfer; see the File_Transfer_State 
     *     enumeration.
     *
     * \param reason
     *     
     *     The reason for the state change; see the 
     *     File_Transfer_State_Change_Reason enumeration. The value will 
     *     always be File_Transfer_State_Change_Reason_None, except when 
     *     changing state to cancelled.
     */
    void FileTransferStateChanged(uint state, uint reason);

    /**
     * Represents the signal \c TransferredBytesChanged on the remote object.
     * 
     * Emitted when the number of transferred bytes changes. This will not be 
     * signalled with every single byte change. Instead, the most frequent 
     * this signal will be emitted is once a second. This should be 
     * sufficient, and the TransferredBytes property SHOULD NOT be polled.
     *
     * \param count
     *     
     *     The number of already transferred bytes.
     */
    void TransferredBytesChanged(qulonglong count);

    /**
     * Represents the signal \c InitialOffsetDefined on the remote object.
     * 
     * Emitted when the value of the InitialOffset property has been 
     * negotiated. This signal MUST be emitted before the channel becomes Open 
     * and clients have to use this offset when transferring the file.
     *
     * \param initialOffset
     *     
     *     The value of the InitialOffset property.
     */
    void InitialOffsetDefined(qulonglong initialOffset);

    /**
     * Represents the signal \c URIDefined on the remote object.
     * 
     * Emitted when the value of the URI property has been set. This signal 
     * MUST only be emitted on incoming file transfers, and only if the 
     * handler sets the URI property before accepting the file.
     *
     * \param URI
     *     
     *     The value of the URI property.
     */
    void URIDefined(const QString& URI);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeRoomListInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.RoomList".
 */
class TP_QT_EXPORT ChannelTypeRoomListInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.RoomList", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.RoomList");
    }

    /**
     * Creates a ChannelTypeRoomListInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeRoomListInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeRoomListInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeRoomListInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeRoomListInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeRoomListInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeRoomListInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeRoomListInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeRoomListInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeRoomListInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Server of type \c QString.
     *
     * 
     * For protocols with a concept of chatrooms on multiple servers with 
     * different DNS names (like XMPP), the DNS name of the server whose rooms 
     * are listed by this channel, e.g. &quot;conference.jabber.org&quot;. 
     * Otherwise, the empty string. This property cannot change during the 
     * lifetime of the channel.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyServer() const
    {
        return internalRequestProperty(QLatin1String("Server"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetListingRooms on the remote object.
     * 
     * Check to see if there is already a room list request in progress on 
     * this channel.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A boolean indicating if room listing is in progress
     */
    inline QDBusPendingReply<bool> GetListingRooms(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<bool>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetListingRooms"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ListRooms on the remote object.
     * 
     * Request the list of rooms from the server. The ListingRooms (True) 
     * signal should be emitted when this request is being processed, GotRooms 
     * when any room information is received, and ListingRooms (False) when 
     * the request is complete.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ListRooms(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ListRooms"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c StopListing on the remote object.
     * 
     * Stop the room listing if it&apos;s in progress, but don&apos;t close 
     * the channel. The ListingRooms (False) signal should be emitted when the 
     * listing stops.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StopListing(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StopListing"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c GotRooms on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when information about rooms on the server becomes available.
     * The array contains the room handle (as can be passed to the
     *  \endhtmlonly ConnectionInterface::RequestChannel() \htmlonly 
     * method with HANDLE_TYPE_ROOM), the channel
     * type, and a dictionary containing further information about the
     * room as available. The following well-known keys and types are
     * recommended for use where appropriate:</p>
     * 
     * <dl>
     *   <dt>handle-name (s)</dt>
     *   <dd>The identifier of the room (as would be returned by
     *      \endhtmlonly ConnectionInterface::InspectHandles() \htmlonly ).
     *     This property is mandatory.</dd>
     * 
     *   <dt>name (s)</dt>
     *   <dd>The human-readable name of the room if different from the handle</dd>
     * 
     *   <dt>description (s)</dt>
     *   <dd>A description of the room's overall purpose</dd>
     * 
     *   <dt>subject (s)</dt>
     *   <dd>The current subject of conversation in the room (as would
     *     be returned by getting the string part of the  \endhtmlonly \link ChannelInterfaceSubjectInterface::requestPropertySubject() ChannelInterfaceSubjectInterface::Subject \endlink \htmlonly  property)</dd>
     * 
     *   <dt>members (u)</dt>
     *   <dd>The number of members in the room</dd>
     * 
     *   <dt>password (b)</dt>
     *   <dd>True if the room requires a password to enter</dd>
     * 
     *   <dt>invite-only (b)</dt>
     *   <dd>True if you cannot join the room, but must be invited</dd>
     * 
     *   <dt>room-id (s)</dt>
     *   <dd>The human-readable identifier of a chat room (as would be
     *     returned by getting the  \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyRoomName() ChannelInterfaceRoomInterface::RoomName \endlink \htmlonly  property)</dd>
     * 
     *   <dt>server (s)</dt>
     *   <dd>The DNS name of the server hosting these channels (as would be
     *     returned by getting the  \endhtmlonly \link ChannelInterfaceRoomInterface::requestPropertyServer() ChannelInterfaceRoomInterface::Server \endlink \htmlonly  property)</dd>
     * </dl>
     * \endhtmlonly
     *
     * \param rooms
     *     
     *     \htmlonly
     *     An array of structs containing:
     *     <ul>
     *       <li>an integer room handle</li>
     *       <li>a string representing the D-Bus interface name of the channel type</li>
     *       <li>a dictionary mapping string keys to variant boxed information</li>
     *     </ul>
     *     \endhtmlonly
     */
    void GotRooms(const Tp::RoomInfoList& rooms);

    /**
     * Represents the signal \c ListingRooms on the remote object.
     * 
     * Emitted to indicate whether or not room listing request is currently in 
     * progress.
     *
     * \param listing
     *     
     *     A boolean indicating if room listing is in progress
     */
    void ListingRooms(bool listing);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeServerAuthenticationInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ServerAuthentication".
 */
class TP_QT_EXPORT ChannelTypeServerAuthenticationInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.ServerAuthentication", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.ServerAuthentication");
    }

    /**
     * Creates a ChannelTypeServerAuthenticationInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeServerAuthenticationInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeServerAuthenticationInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeServerAuthenticationInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeServerAuthenticationInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeServerAuthenticationInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeServerAuthenticationInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeServerAuthenticationInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeServerAuthenticationInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeServerAuthenticationInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c AuthenticationMethod of type \c QString.
     *
     * 
     * \htmlonly
     * <p>This property defines the method used for the authentication step
     *   represented by this channel, which MUST be one of this channel's
     *    \endhtmlonly \link ChannelInterface::requestPropertyInterfaces() ChannelInterface::Interfaces \endlink \htmlonly .</p>
     * 
     * <p>The initially-defined interface that can be used here is
     *    \endhtmlonly ChannelInterfaceSASLAuthenticationInterface \htmlonly .</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAuthenticationMethod() const
    {
        return internalRequestProperty(QLatin1String("AuthenticationMethod"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeServerTLSConnectionInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection".
 */
class TP_QT_EXPORT ChannelTypeServerTLSConnectionInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection");
    }

    /**
     * Creates a ChannelTypeServerTLSConnectionInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeServerTLSConnectionInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeServerTLSConnectionInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeServerTLSConnectionInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeServerTLSConnectionInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeServerTLSConnectionInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeServerTLSConnectionInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeServerTLSConnectionInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeServerTLSConnectionInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeServerTLSConnectionInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ServerCertificate of type \c QDBusObjectPath.
     *
     * 
     * A TLSCertificate containing the certificate chain as sent by the 
     * server, and other relevant information.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyServerCertificate() const
    {
        return internalRequestProperty(QLatin1String("ServerCertificate"));
    }

    /**
     * Asynchronous getter for the remote object property \c Hostname of type \c QString.
     *
     * 
     * The hostname or domain that the user expects to connect to. Clients 
     * SHOULD use the ReferenceIdentities property to verify the identity of 
     * the certificate. Clients MAY display this hostname to the user as the 
     * expected identity. Clients SHOULD use this property to lookup pinned 
     * certificates or other user preferences for the connection.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHostname() const
    {
        return internalRequestProperty(QLatin1String("Hostname"));
    }

    /**
     * Asynchronous getter for the remote object property \c ReferenceIdentities of type \c QStringList.
     *
     * 
     * The identities of the server we expect ServerCertificate to certify; 
     * clients SHOULD verify that ServerCertificate matches one of these 
     * identities when checking its validity. This property MUST NOT be the 
     * empty list; it MUST contain the value of the Hostname property. All 
     * other identities included in this property MUST be derived from 
     * explicit user input or choices, such as Parameters passed to 
     * RequestConnection. The primary use for this property is for XMPP 
     * services hosted by Google Apps. When connecting to Google Talk using an 
     * @gmail.com JID, the server correctly presents a certificate for 
     * gmail.com; however, for domains hosted via Google Apps, a certificate 
     * for talk.google.com is offered, due to unresolved technical 
     * limitations. If the user has explicitly chosen to create a Google Talk 
     * account, then trusting a certificate for talk.google.com is reasonable. 
     * To handle this case, the connection manager may add the values of any 
     * or all of the server, fallback-server and extra-identities parameters; 
     * the Google Talk account creation user interface may set these 
     * parameters appropriately, or the user may set them for accounts with 
     * other services.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyReferenceIdentities() const
    {
        return internalRequestProperty(QLatin1String("ReferenceIdentities"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeStreamTubeInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.StreamTube".
 */
class TP_QT_EXPORT ChannelTypeStreamTubeInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.StreamTube", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.StreamTube");
    }

    /**
     * Creates a ChannelTypeStreamTubeInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeStreamTubeInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeStreamTubeInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeStreamTubeInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeStreamTubeInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeStreamTubeInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeStreamTubeInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeStreamTubeInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeStreamTubeInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeStreamTubeInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c Service of type \c QString.
     *
     * 
     * \htmlonly
     * <p> A string representing the service name that will be used over the
     *   tube.  It should be a well-known TCP service name as defined by
     *   <a href="http://www.iana.org/assignments/port-numbers">
     *     http://www.iana.org/assignments/port-numbers</a> or
     *   <a href="http://www.dns-sd.org/ServiceTypes.html">
     *     http://www.dns-sd.org/ServiceTypes.html</a>, for instance
     *   &quot;rsync&quot; or &quot;daap&quot;.</p>
     * <p>When the tube is offered, the service name is transmitted to the
     *   other end.</p>
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST be included in the request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyService() const
    {
        return internalRequestProperty(QLatin1String("Service"));
    }

    /**
     * Asynchronous getter for the remote object property \c SupportedSocketTypes of type \c Tp::SupportedSocketMap.
     *
     * 
     * \htmlonly
     * <p>A mapping from address types (members of Socket_Address_Type) to
     * arrays of access-control type (members of Socket_Access_Control)
     * that the connection manager supports for stream tubes with that
     * address type. For simplicity, if a CM supports offering a
     * particular type of tube, it is assumed to support accepting it.</p>
     * 
     * <p>A typical value for a host without IPv6 support:</p>
     * 
     * <pre>
     *   {
     *     Socket_Address_Type_IPv4:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Port,
     *        Socket_Access_Control_Netmask],
     *     Socket_Address_Type_Unix:
     *       [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]
     *   }
     * </pre>
     * 
     * <p>Connection Managers MUST support at least IPv4 with the localhost
     *   access control.</p>
     * 
     * <p>When requesting a channel with
     *    \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *   this property MUST NOT be included in the request.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedSocketTypes() const
    {
        return internalRequestProperty(QLatin1String("SupportedSocketTypes"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Offer on the remote object.
     * 
     * Offer a stream tube exporting the local socket specified.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param addresstype
     *     
     *     The type of the listening address of the local service, as a member 
     *     of Socket_Address_Type.
     *
     * \param address
     *     
     *     The listening address of the local service, as indicated by the 
     *     address_type.
     *
     * \param accesscontrol
     *     
     *     The access control the local service applies to the local socket, 
     *     specified so the connection manager can behave appropriately when 
     *     it connects.
     *
     * \param parameters
     *     
     *     The dictionary of arbitrary Parameters to send with the tube offer.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Offer(uint addresstype, const QDBusVariant& address, uint accesscontrol, const QVariantMap& parameters, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Offer"));
        callMessage << QVariant::fromValue(addresstype) << QVariant::fromValue(address) << QVariant::fromValue(accesscontrol) << QVariant::fromValue(parameters);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Accept on the remote object.
     * 
     * Accept a stream tube that&apos;s in the &quot;local pending&quot; 
     * state. The connection manager will attempt to open the tube. The tube 
     * remains in the &quot;local pending&quot; state until the 
     * TubeChannelStateChanged signal is emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param addresstype
     *     
     *     The type of address the connection manager should listen on.
     *
     * \param accesscontrol
     *     
     *     \htmlonly
     *     <p>The type of access control the connection manager should apply to
     *     the socket.</p>
     *     
     *     <p>Note that if you plan to establish more than one connection
     *     through the tube, the Socket_Access_Control_Port access control
     *     can't be used as you can't connect more than once from the same
     *     port.</p>
     *     \endhtmlonly
     *
     * \param accesscontrolparam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections to this tube. The client should not attempt to connect 
     *     to the address until the tube is open.
     */
    inline QDBusPendingReply<QDBusVariant> Accept(uint addresstype, uint accesscontrol, const QDBusVariant& accesscontrolparam, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusVariant>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Accept"));
        callMessage << QVariant::fromValue(addresstype) << QVariant::fromValue(accesscontrol) << QVariant::fromValue(accesscontrolparam);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c NewRemoteConnection on the remote object.
     * 
     * \htmlonly
     * <p>Emitted each time a participant opens a new connection to its
     * socket.</p>
     * 
     * <p>This signal is only fired on the offering side.</p>
     * \endhtmlonly
     *
     * \param handle
     *     
     *     The handle of the participant who opened the new connection
     *
     * \param connectionParam
     *     
     *     \htmlonly
     *     <p>A parameter which can be used by the listening process to identify
     *     the connection. Note that this parameter has a meaningful value
     *     only in the Socket_Access_Control_Port and
     *     Socket_Access_Control_Credentials cases. If a different
     *     Socket_Access_Control has been chosen when offering the tube, this
     *     parameter should be ignored.</p>
     *     
     *     <p>In the Socket_Access_Control_Port case, the variant
     *     contains a struct Socket_Address_IPv4 (or Socket_Address_IPv6)
     *     containing the address from which the CM is connected to the client
     *     application.</p>
     *     
     *     <p>In the Socket_Access_Control_Credentials case, the variant
     *     contains the byte (D-Bus signature 'y') that has been sent with
     *     the credentials.</p>
     *     \endhtmlonly
     *
     * \param connectionID
     *     
     *     The unique ID associated with this connection. This ID will be used 
     *     to identifiy the connection when reporting errors with 
     *     ConnectionClosed.
     */
    void NewRemoteConnection(uint handle, const QDBusVariant& connectionParam, uint connectionID);

    /**
     * Represents the signal \c NewLocalConnection on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the tube application connects to the CM's socket.</p>
     * 
     * <p>This signal is only fired on the accepting side.</p>
     * \endhtmlonly
     *
     * \param connectionID
     *     
     *     The unique ID associated with this connection. This ID will be used 
     *     to identifiy the connection when reporting errors with 
     *     ConnectionClosed.
     */
    void NewLocalConnection(uint connectionID);

    /**
     * Represents the signal \c ConnectionClosed on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a connection has been closed.</p>
     * \endhtmlonly
     *
     * \param connectionID
     *     
     *     The ID of the connection.
     *
     * \param error
     *     
     *     \htmlonly
     *     <p>The name of a D-Bus error describing the error that occurred.</p>
     *     
     *     <p>The following errors can be used:</p>
     *     <ul>
     *       <li><code>org.freedesktop.Telepathy.Error.Cancelled</code>:
     *          user closed the socket or the tube.</li>
     *       <li><code>org.freedesktop.Telepathy.Error.ConnectionLost</code>:
     *          the bytestream relaying connection's data has been broken.</li>
     *       <li><code>org.freedesktop.Telepathy.Error.ConnectionRefused</code>:
     *          the tube offer refused the connection.</li>
     *     </ul>
     *     \endhtmlonly
     *
     * \param message
     *     
     *     A debug message.
     */
    void ConnectionClosed(uint connectionID, const QString& error, const QString& message);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeStreamedMediaInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.StreamedMedia".
 */
class TP_QT_EXPORT ChannelTypeStreamedMediaInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.StreamedMedia", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.StreamedMedia");
    }

    /**
     * Creates a ChannelTypeStreamedMediaInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeStreamedMediaInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeStreamedMediaInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeStreamedMediaInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeStreamedMediaInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeStreamedMediaInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeStreamedMediaInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeStreamedMediaInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeStreamedMediaInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeStreamedMediaInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c InitialAudio of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If set to true in a channel request that will create a new channel,
     *   the connection manager should immediately attempt to establish an
     *   audio stream to the remote contact, making it unnecessary for the
     *   client to call  \endhtmlonly ChannelTypeStreamedMediaInterface::RequestStreams() \htmlonly .</p>
     * 
     * <p>If this property, or InitialVideo, is passed to EnsureChannel
     *   (as opposed to CreateChannel), the connection manager SHOULD ignore
     *   these properties when checking whether it can return an existing
     *   channel as suitable; these properties only become significant when
     *   the connection manager has decided to create a new channel.</p>
     * 
     * <p>If true on a requested channel, this indicates that the audio
     *   stream has already been requested and the client does not need to
     *   call RequestStreams, although it MAY still do so.</p>
     * 
     * <p>If true on an unrequested (incoming) channel, this indicates that
     *   the remote contact initially requested an audio stream; this does
     *   not imply that that audio stream is still active (as indicated by
     *    \endhtmlonly ChannelTypeStreamedMediaInterface::ListStreams() \htmlonly ).</p>
     * 
     * <p>This property is immutable (cannot change), and therefore SHOULD
     *   appear wherever immutable properties are reported, e.g.  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly 
     *   signals.</p>
     * 
     * <div class="rationale"><p>This reduces D-Bus round trips.</p></div>
     * 
     * <p>Connection managers capable of signalling audio calls to contacts
     *   SHOULD include a channel class in  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly 
     *   with  \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly 
     *   =  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   and  \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly 
     *   = Contact in the fixed properties dictionary, and InitialAudio
     *   (and also InitialVideo, if applicable) in the allowed properties
     *   list. Clients wishing to discover whether a connection manager
     *   can signal audio and/or video calls SHOULD use this information.</p>
     * 
     * <div class="rationale">
     *   <p>Not all protocols support signalling video calls, and it would be
     *     possible (although unlikely) to have a protocol where only video,
     *     and not audio, could be signalled.</p>
     * </div>
     * 
     * <p>Connection managers that support the  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface \htmlonly 
     *   interface SHOULD represent the capabilities of receiving audio
     *   and/or video calls by including a channel class in
     *   a contact's capabilities with ChannelType = StreamedMedia
     *   in the fixed properties dictionary, and InitialAudio and/or
     *   InitialVideo in the allowed properties list. Clients wishing to
     *   discover whether a particular contact is likely to be able to
     *   receive audio and/or video calls SHOULD use this information.</p>
     * 
     * <div class="rationale">
     *   <p>Not all clients support video calls, and it would also be
     *     possible (although unlikely) to have a client which could only
     *     stream video, not audio.</p>
     * </div>
     * 
     * <p>Clients that are willing to receive audio and/or video calls
     *   SHOULD include the following among their channel classes if
     *   calling  \endhtmlonly ConnectionInterfaceContactCapabilitiesInterface::UpdateCapabilities() \htmlonly 
     *   (clients of a  \endhtmlonly ChannelDispatcherInterface \htmlonly 
     *   SHOULD instead arrange for the ChannelDispatcher to do this,
     *   by including the filters in their  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly 
     *   properties):</p>
     * 
     * <ul>
     *   <li>{ ChannelType = StreamedMedia }</li>
     *   <li>{ ChannelType = StreamedMedia, InitialAudio = true }
     *     if receiving calls with audio is supported</li>
     *   <li>{ ChannelType = StreamedMedia, InitialVideo = true }
     *     if receiving calls with video is supported</li>
     * </ul>
     * 
     * <div class="rationale">
     *   <p>Connection managers for protocols with capability discovery,
     *     like XMPP, need this information to advertise the appropriate
     *     capabilities for their protocol.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialAudio() const
    {
        return internalRequestProperty(QLatin1String("InitialAudio"));
    }

    /**
     * Asynchronous getter for the remote object property \c InitialVideo of type \c bool.
     *
     * 
     * \htmlonly
     * <p>The same as  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly , but for
     *   a video stream. This property is immutable (cannot change).</p>
     * 
     * <p>In particular, note that if this property is false, this does not
     *   imply that an active video stream has not been added, only that no
     *   video stream was active at the time the channel appeared.</p>
     * 
     * <p>This property is the correct way to discover whether connection
     *   managers, contacts etc. support video calls; it appears in
     *   capabilities structures in the same way as InitialAudio.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInitialVideo() const
    {
        return internalRequestProperty(QLatin1String("InitialVideo"));
    }

    /**
     * Asynchronous getter for the remote object property \c ImmutableStreams of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If <tt>True</tt>, once streams have been requested for this channel
     *   (either by setting  \endhtmlonly \link requestPropertyInitialAudio() InitialAudio \endlink \htmlonly  or
     *    \endhtmlonly \link requestPropertyInitialVideo() InitialVideo \endlink \htmlonly  when the channel is
     *   requested, or by calling
     *    \endhtmlonly RequestStreams() \htmlonly  on a channel with no
     *   streams), a stream of a different content type cannot be added;
     *   subsequent calls to  \endhtmlonly RequestStreams() \htmlonly 
     *   that attempt to do so will fail.</p>
     * 
     * <p>If this property is missing, clients SHOULD assume that it is false,
     *   and thus that the channel's streams can be changed once the call has
     *   started.</p>
     * 
     * <p>If this property is present in the &quot;allowed&quot; set in all of the
     *   StreamedMedia entries in a contact's capabilities, then user
     *   interfaces MAY choose to show a separate &quot;call&quot; option for each
     *   class of call.</p>
     * 
     *   <div class="rationale">
     *     <p>For example, once an audio-only Google Talk call has started,
     *       it is not possible to add a video stream; both audio and video
     *       must be requested at the start of the call if video is desired.
     *       User interfaces may use this pseudo-capability as a hint to
     *       display separate &quot;Audio call&quot; and &quot;Video call&quot; buttons, rather
     *       than a single &quot;Call&quot; button with the option to add and remove
     *       video once the call has started for contacts without this flag.
     *     </p>
     *   </div>
     * 
     * <p>This property is immutable, and therefore SHOULD be announced
     *   in  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly ,
     *   etc.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyImmutableStreams() const
    {
        return internalRequestProperty(QLatin1String("ImmutableStreams"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c ListStreams on the remote object.
     * 
     * Returns an array of structs representing the streams currently active 
     * within this channel. Each stream is identified by an unsigned integer 
     * which is unique for each stream within the channel.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     An array of structs containing:
     *     <ul>
     *     <li>the stream identifier</li>
     *     <li>the contact handle who the stream is with (or 0 if the stream
     *       represents more than a single member)</li>
     *     <li>the type of the stream</li>
     *     <li>the current stream state</li>
     *     <li>the current direction of the stream</li>
     *     <li>the current pending send flags</li>
     *     </ul>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::MediaStreamInfoList> ListStreams(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::MediaStreamInfoList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ListStreams"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveStreams on the remote object.
     * 
     * \htmlonly
     * <p>Request that the given streams are removed. If all streams are
     *   removed, the channel MAY close.</p>
     * 
     * <p>Clients SHOULD NOT attempt to terminate calls by removing all the
     *   streams; instead, clients SHOULD terminate calls by removing the
     *    \endhtmlonly \link ChannelInterfaceGroupInterface::requestPropertySelfHandle() ChannelInterfaceGroupInterface::SelfHandle \endlink \htmlonly 
     *   from the channel, using either
     *    \endhtmlonly ChannelInterfaceGroupInterface::RemoveMembers() \htmlonly 
     *   or
     *    \endhtmlonly ChannelInterfaceGroupInterface::RemoveMembersWithReason() \htmlonly .
     *   </p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param streams
     *     
     *     An array of stream identifiers (as defined in ListStreams)
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveStreams(const Tp::UIntList& streams, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveStreams"));
        callMessage << QVariant::fromValue(streams);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestStreamDirection on the remote object.
     * 
     * \htmlonly
     * <p>Request a change in the direction of an existing stream. In particular,
     * this might be useful to stop sending media of a particular type,
     * or inform the peer that you are no longer using media that is being
     * sent to you.</p>
     * 
     * <p>Depending on the protocol, streams which are no longer sending in
     * either direction should be removed and a
     *  \endhtmlonly StreamRemoved() \htmlonly  signal emitted.
     * Some direction changes can be enforced locally (for example,
     * BIDIRECTIONAL -&gt; RECEIVE can be achieved by merely stopping sending),
     * others may not be possible on some protocols, and some need agreement
     * from the remote end. In this case, the MEDIA_STREAM_PENDING_REMOTE_SEND
     * flag will be set in the
     *  \endhtmlonly StreamDirectionChanged() \htmlonly  signal, and the
     * signal
     * emitted again without the flag to indicate the resulting direction when
     * the remote end has accepted or rejected the change.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     *
     * \param streamDirection
     *     
     *     The desired stream direction (a value of MediaStreamDirection)
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RequestStreamDirection(uint streamID, uint streamDirection, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestStreamDirection"));
        callMessage << QVariant::fromValue(streamID) << QVariant::fromValue(streamDirection);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestStreams on the remote object.
     * 
     * \htmlonly
     * <p>Request that streams be established to exchange the given types of
     * media with the given member. In general this will try and establish a
     * bidirectional stream, but on some protocols it may not be possible to
     * indicate to the peer that you would like to receive media, so a
     * send-only stream will be created initially. In the cases where the
     * stream requires remote agreement (eg you wish to receive media from
     * them), the  \endhtmlonly StreamDirectionChanged() \htmlonly  signal
     * will be emitted with the
     * MEDIA_STREAM_PENDING_REMOTE_SEND flag set, and the signal emitted again
     * with the flag cleared when the remote end has replied.</p>
     * 
     * <p>If streams of the requested types already exist, calling this
     *   method results in the creation of additional streams. Accordingly,
     *   clients wishing to have exactly one audio stream or exactly one
     *   video stream SHOULD check for the current streams using
     *    \endhtmlonly ListStreams() \htmlonly  before calling this
     *   method.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contactHandle
     *     
     *     A contact handle with whom to establish the streams
     *
     * \param types
     *     
     *     An array of stream types (values of MediaStreamType)
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     An array of structs (in the same order as the given stream types)
     *     containing:
     *     <ul>
     *       <li>the stream identifier</li>
     *       <li>the contact handle who the stream is with (or 0 if the stream
     *         represents more than a single member)</li>
     *       <li>the type of the stream</li>
     *       <li>the current stream state</li>
     *       <li>the current direction of the stream</li>
     *       <li>the current pending send flags</li>
     *     </ul>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::MediaStreamInfoList> RequestStreams(uint contactHandle, const Tp::UIntList& types, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::MediaStreamInfoList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestStreams"));
        callMessage << QVariant::fromValue(contactHandle) << QVariant::fromValue(types);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c StreamAdded on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a new stream has been added to this channel.
     *   Clients SHOULD assume that the stream's
     *   <tp:type>Media_Stream_State</tp:type> is initially Disconnected.</p>
     * 
     * <p>If a connection manager needs to represent the addition of a stream
     *   whose state is already Connecting or Connected, it MUST do this
     *   by emitting StreamAdded, closely followed by
     *    \endhtmlonly StreamStateChanged() \htmlonly  indicating a
     *   change to the appropriate state.</p>
     * 
     * <div class="rationale">
     *   <p>Historically, it was not clear from the StreamAdded signal what
     *     the state of the stream was. telepathy-spec 0.17.22
     *     clarified this.</p>
     * </div>
     * 
     * <p>Similarly, clients SHOULD assume that the initial
     *   <tp:type>Media_Stream_Direction</tp:type> of a newly added stream
     *   is Receive, and that the initial
     *   <tp:type>Media_Stream_Pending_Send</tp:type> is
     *   Pending_Local_Send.</p>
     * 
     * <p>If a connection manager needs to represent the addition of a stream
     *   whose direction or pending-send differs from those initial values,
     *   it MUST do so by emitting StreamAdded, closely followed by
     *    \endhtmlonly StreamDirectionChanged() \htmlonly  indicating a
     *   change to the appropriate direction and pending-send state.</p>
     * 
     * <div class="rationale">
     *   <p>StreamAdded doesn't itself indicate the stream's direction; this
     *     is unfortunate, but is preserved for compatibility.</p>
     * 
     *   <p>This is the appropriate direction for streams added by a remote
     *     contact on existing connection managers, and does not violate
     *     user privacy by automatically sending audio or video (audio streams
     *     start off muted, video streams start off not sending). For
     *     streams added by the local user using the client receiving the
     *     signal, the true direction can also be determined from the return
     *     value of the  \endhtmlonly RequestStreams() \htmlonly 
     *     method.</p>
     * 
     *   <p>Existing clients typically operate by maintaining a separate
     *     idea of the directions that they would like the streams to have,
     *     and enforcing these intended directions by calling
     *      \endhtmlonly RequestStreamDirection() \htmlonly  whenever
     *     needed.</p>
     * </div>
     * \endhtmlonly
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     *
     * \param contactHandle
     *     
     *     The contact handle who the stream is with (or 0 if it represents 
     *     more than a single member)
     *
     * \param streamType
     *     
     *     The stream type (a value from MediaStreamType)
     */
    void StreamAdded(uint streamID, uint contactHandle, uint streamType);

    /**
     * Represents the signal \c StreamDirectionChanged on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the direction or pending flags of a stream are
     *   changed.</p>
     * 
     * <p>If the MEDIA_STREAM_PENDING_LOCAL_SEND flag is set, the remote user
     *   has requested that we begin sending on this stream.
     *    \endhtmlonly RequestStreamDirection() \htmlonly 
     *   should be called to indicate whether or not this change is
     *   acceptable.</p>
     * 
     * <div class="rationale">
     *   <p>This allows for a MSN-style user interface, &quot;Fred has asked you
     *     to enable your webcam. (Accept | Reject)&quot;, if desired.</p>
     * </div>
     * \endhtmlonly
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     *
     * \param streamDirection
     *     
     *     The new stream direction (as defined in ListStreams)
     *
     * \param pendingFlags
     *     
     *     The new pending send flags (as defined in ListStreams)
     */
    void StreamDirectionChanged(uint streamID, uint streamDirection, uint pendingFlags);

    /**
     * Represents the signal \c StreamError on the remote object.
     * 
     * Emitted when a stream encounters an error.
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     *
     * \param errorCode
     *     
     *     A stream error number, one of the values of MediaStreamError
     *
     * \param message
     *     
     *     A string describing the error (for debugging purposes only)
     */
    void StreamError(uint streamID, uint errorCode, const QString& message);

    /**
     * Represents the signal \c StreamRemoved on the remote object.
     * 
     * Emitted when a stream has been removed from this channel.
     *
     * \param streamID
     *     
     *     stream_id - the stream identifier (as defined in ListStreams)
     */
    void StreamRemoved(uint streamID);

    /**
     * Represents the signal \c StreamStateChanged on the remote object.
     * 
     * Emitted when a member&apos;s stream&apos;s state changes.
     *
     * \param streamID
     *     
     *     The stream identifier (as defined in ListStreams)
     *
     * \param streamState
     *     
     *     The new stream state (as defined in ListStreams)
     */
    void StreamStateChanged(uint streamID, uint streamState);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeTextInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.Text".
 */
class TP_QT_EXPORT ChannelTypeTextInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.Text", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.Text");
    }

    /**
     * Creates a ChannelTypeTextInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeTextInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeTextInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeTextInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeTextInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeTextInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeTextInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeTextInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeTextInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeTextInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AcknowledgePendingMessages on the remote object.
     * 
     * Inform the channel that you have handled messages by displaying them to 
     * the user (or equivalent), so they can be removed from the pending queue.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param IDs
     *     
     *     The IDs of the messages to acknowledge
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AcknowledgePendingMessages(const Tp::UIntList& IDs, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcknowledgePendingMessages"));
        callMessage << QVariant::fromValue(IDs);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetMessageTypes on the remote object.
     * 
     * Return an array indicating which types of message may be sent on this 
     * channel.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of integer message types (ChannelTextMessageType)
     */
    inline QDBusPendingReply<Tp::UIntList> GetMessageTypes(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetMessageTypes"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ListPendingMessages on the remote object.
     * 
     * List the messages currently in the pending queue, and optionally remove 
     * then all.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param clear
     *     
     *     If true, behave as if AcknowledgePendingMessages had also been 
     *     called.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     An array of structs representing the pending queue. Each contains:
     *     <ul>
     *       <li>a numeric identifier</li>
     *       <li>a Unix timestamp indicating when the message was received</li>
     *       <li>the contact handle for the contact who sent the message</li>
     *       <li>the message type, taken from ChannelTextMessageType</li>
     *       <li>the bitwise-OR of the message flags from ChannelTextMessageFlags</li>
     *       <li>the text of the message</li>
     *     </ul>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::PendingTextMessageList> ListPendingMessages(bool clear, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::PendingTextMessageList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ListPendingMessages"));
        callMessage << QVariant::fromValue(clear);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Send on the remote object.
     * 
     * \htmlonly
     * <p>Request that a message be sent on this channel. When the message has
     *   been submitted for delivery, this method will return and the
     *    \endhtmlonly Sent() \htmlonly  signal will be emitted. If the
     *   message cannot be submitted for delivery, the method returns an error
     *   and no signal is emitted.</p>
     * 
     * <p>This method SHOULD return before the Sent signal is
     *   emitted.</p>
     * 
     * <div class="rationale">
     *   <p>When a Text channel implements the  \endhtmlonly ChannelInterfaceMessagesInterface \htmlonly 
     *     interface, that &quot;SHOULD&quot; becomes a &quot;MUST&quot;.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param type
     *     
     *     An integer indicating the type of the message
     *
     * \param text
     *     
     *     The message to send
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Send(uint type, const QString& text, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Send"));
        callMessage << QVariant::fromValue(type) << QVariant::fromValue(text);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c LostMessage on the remote object.
     * 
     * This signal is emitted to indicate that an incoming message was not 
     * able to be stored and forwarded by the connection manager due to lack 
     * of memory.
     */
    void LostMessage();

    /**
     * Represents the signal \c Received on the remote object.
     * 
     * Signals that a message with the given id, timestamp, sender, type and 
     * text has been received on this channel. Applications that catch this 
     * signal and reliably inform the user of the message should acknowledge 
     * that they have dealt with the message with the 
     * AcknowledgePendingMessages method.
     *
     * \param ID
     *     
     *     A numeric identifier for acknowledging the message
     *
     * \param timestamp
     *     
     *     A Unix timestamp indicating when the message was received
     *
     * \param sender
     *     
     *     The handle of the contact who sent the message
     *
     * \param type
     *     
     *     The type of the message (normal, action, notice, etc.)
     *
     * \param flags
     *     
     *     A bitwise OR of the message flags
     *
     * \param text
     *     
     *     The text of the message
     */
    void Received(uint ID, uint timestamp, uint sender, uint type, uint flags, const QString& text);

    /**
     * Represents the signal \c SendError on the remote object.
     * 
     * \htmlonly
     * <p>Signals that an outgoing message has failed to send. The error
     *   will be one of the values from ChannelTextSendError.</p>
     * 
     * <p>This signal should only be emitted for messages for which
     *    \endhtmlonly Sent() \htmlonly  has already been emitted and
     *    \endhtmlonly Send() \htmlonly  has already returned success.</p>
     * \endhtmlonly
     *
     * \param error
     *     
     *     The error that occurred
     *
     * \param timestamp
     *     
     *     The Unix timestamp indicating when the message was sent
     *
     * \param type
     *     
     *     The message type
     *
     * \param text
     *     
     *     The text of the message
     */
    void SendError(uint error, uint timestamp, uint type, const QString& text);

    /**
     * Represents the signal \c Sent on the remote object.
     * 
     * \htmlonly
     * <p>Signals that a message has been submitted for sending.</p>
     * \endhtmlonly
     *
     * \param timestamp
     *     
     *     Unix timestamp indicating when the message was sent
     *
     * \param type
     *     
     *     The message type (normal, action, notice, etc) from 
     *     ChannelTextMessageType
     *
     * \param text
     *     
     *     The text of the message. If the message was, or will be, altered 
     *     during transmission, this argument SHOULD reflect what other 
     *     contacts will receive rather than being a copy of the argument to 
     *     Send.
     */
    void Sent(uint timestamp, uint type, const QString& text);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelTypeTubesInterface
 * \headerfile TelepathyQt/channel.h <TelepathyQt/Channel>
 * \ingroup clientchannel
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Type.Tubes".
 */
class TP_QT_EXPORT ChannelTypeTubesInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Type.Tubes", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Type.Tubes");
    }

    /**
     * Creates a ChannelTypeTubesInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeTubesInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeTubesInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeTubesInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelTypeTubesInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelTypeTubesInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelTypeTubesInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelTypeTubesInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelTypeTubesInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelTypeTubesInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetAvailableStreamTubeTypes on the remote object.
     * 
     * List the available address types and access-control types for stream 
     * tubes.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>A mapping from address types (members of Socket_Address_Type) to
     *     arrays of access-control type (members of Socket_Access_Control)
     *     that the connection manager supports for stream tubes with that
     *     address type. For simplicity, if a CM supports offering a
     *     particular type of tube, it is assumed to support accepting it.</p>
     *     
     *     <p>A typical value for a host without IPv6 support:</p>
     *     
     *     <pre>
     *       {
     *         Socket_Address_Type_IPv4:
     *           [Socket_Access_Control_Localhost, Socket_Access_Control_Port,
     *            Socket_Access_Control_Netmask],
     *         Socket_Address_Type_Unix:
     *           [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]
     *       }
     *     </pre>
     *     
     *     <p>If stream tubes are not supported, this will be an empty
     *       dictionary.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::SupportedSocketMap> GetAvailableStreamTubeTypes(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::SupportedSocketMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAvailableStreamTubeTypes"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetAvailableTubeTypes on the remote object.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of the available tube types, as defined by the Tube_Type 
     *     enum.
     */
    inline QDBusPendingReply<Tp::UIntList> GetAvailableTubeTypes(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::UIntList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetAvailableTubeTypes"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ListTubes on the remote object.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     Return an array of tuples, each representing a tube, with the 
     *     following members: the tube&apos;s ID the tube&apos;s initiator the 
     *     tube&apos;s type the tube&apos;s service the tube&apos;s parameters 
     *     the tube&apos;s state
     */
    inline QDBusPendingReply<Tp::TubeInfoList> ListTubes(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::TubeInfoList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ListTubes"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c OfferDBusTube on the remote object.
     * 
     * Offers a D-Bus tube providing the service specified.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param service
     *     
     *     A string representing the service name that will be used over the 
     *     tube. It should be a well-known D-Bus service name, of the form 
     *     com.example.ServiceName.
     *
     * \param parameters
     *     
     *     A dictionary of properties for the new tube; the allowable keys, 
     *     types and values are defined by the service. Connection managers 
     *     must support the value being any primitive (non-container) D-Bus 
     *     type, or a byte array &apos;ay&apos;.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The ID of the new tube.
     */
    inline QDBusPendingReply<uint> OfferDBusTube(const QString& service, const QVariantMap& parameters, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("OfferDBusTube"));
        callMessage << QVariant::fromValue(service) << QVariant::fromValue(parameters);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c OfferStreamTube on the remote object.
     * 
     * Offer a stream tube exporting the local socket specified.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param service
     *     
     *     \htmlonly
     *     A string representing the service name that will be used over the
     *     tube.
     *     It should be a well-known TCP service name as defined by
     *     <a href="http://www.iana.org/assignments/port-numbers">
     *       http://www.iana.org/assignments/port-numbers</a> or
     *     <a href="http://www.dns-sd.org/ServiceTypes.html">
     *       http://www.dns-sd.org/ServiceTypes.html</a>, for instance
     *     &quot;rsync&quot; or &quot;daap&quot;.
     *     \endhtmlonly
     *
     * \param parameters
     *     
     *     \htmlonly
     *     <p>A dictionary of properties for the new tube; the allowable keys,
     *     types and values are defined by the service. Connection managers
     *     must support the value being any primitive (non-container)
     *     D-Bus type, or a byte array 'ay'.</p>
     *     <p>These should usually be the same key-value pairs specified for
     *     use in the DNS-SD TXT record for that service.</p>
     *     \endhtmlonly
     *
     * \param addressType
     *     
     *     The type of the listening address of the local service, as a member 
     *     of Socket_Address_Type.
     *
     * \param address
     *     
     *     The listening address of the local service, as indicated by the 
     *     address_type.
     *
     * \param accessControl
     *     
     *     The access control the local service applies to the local socket, 
     *     specified so the connection manager can behave appropriately when 
     *     it connects.
     *
     * \param accessControlParam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The ID of the new tube.
     */
    inline QDBusPendingReply<uint> OfferStreamTube(const QString& service, const QVariantMap& parameters, uint addressType, const QDBusVariant& address, uint accessControl, const QDBusVariant& accessControlParam, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("OfferStreamTube"));
        callMessage << QVariant::fromValue(service) << QVariant::fromValue(parameters) << QVariant::fromValue(addressType) << QVariant::fromValue(address) << QVariant::fromValue(accessControl) << QVariant::fromValue(accessControlParam);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AcceptDBusTube on the remote object.
     * 
     * Accept a D-Bus tube that&apos;s in the &quot;local pending&quot; state. 
     * The connection manager will attempt to open the tube. The tube remains 
     * in the &quot;local pending&quot; state until the TubeStateChanged 
     * signal is emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the tube to accept.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The string describing the address of the private bus. The client 
     *     should not attempt to connect to the address until the tube is open.
     */
    inline QDBusPendingReply<QString> AcceptDBusTube(uint ID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcceptDBusTube"));
        callMessage << QVariant::fromValue(ID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AcceptStreamTube on the remote object.
     * 
     * Accept a stream tube that&apos;s in the &quot;local pending&quot; 
     * state. The connection manager will attempt to open the tube. The tube 
     * remains in the &quot;local pending&quot; state until the 
     * TubeStateChanged signal is emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the tube to accept.
     *
     * \param addressType
     *     
     *     The type of address the connection manager should listen on.
     *
     * \param accessControl
     *     
     *     The type of access control the connection manager should apply to 
     *     the socket.
     *
     * \param accessControlParam
     *     
     *     A parameter for the access control type, to be interpreted as 
     *     specified in the documentation for the Socket_Access_Control enum.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The address on which the connection manager will listen for 
     *     connections to this tube. The client should not attempt to connect 
     *     to the address until the tube is open.
     */
    inline QDBusPendingReply<QDBusVariant> AcceptStreamTube(uint ID, uint addressType, uint accessControl, const QDBusVariant& accessControlParam, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusVariant>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcceptStreamTube"));
        callMessage << QVariant::fromValue(ID) << QVariant::fromValue(addressType) << QVariant::fromValue(accessControl) << QVariant::fromValue(accessControlParam);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c CloseTube on the remote object.
     * 
     * Close a tube.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the tube to close.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> CloseTube(uint ID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CloseTube"));
        callMessage << QVariant::fromValue(ID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetDBusTubeAddress on the remote object.
     * 
     * For a D-Bus tube, return a string describing the address of the private 
     * bus.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the tube to get an address for.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The bus address.
     */
    inline QDBusPendingReply<QString> GetDBusTubeAddress(uint ID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QString>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetDBusTubeAddress"));
        callMessage << QVariant::fromValue(ID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetDBusNames on the remote object.
     * 
     * For a multi-user (i.e. Handle_Type_Room) D-Bus tube, obtain a mapping 
     * between contact handles and their unique bus names on this tube.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the tube to get names for.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of structures, each containing a contact handle and a 
     *     D-Bus bus name.
     */
    inline QDBusPendingReply<Tp::DBusTubeMemberList> GetDBusNames(uint ID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::DBusTubeMemberList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetDBusNames"));
        callMessage << QVariant::fromValue(ID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c GetStreamTubeSocketAddress on the remote object.
     * 
     * For a stream tube, obtain the address of the socket used to communicate 
     * over this tube.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param ID
     *     
     *     The ID of the stream tube to get the socket for.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The type of the listening address of the socket, as a member of 
     *     Socket_Address_Type.
     *
     * \return
     *     
     *     The listening address of the socket, as indicated by the 
     *     address_type.
     */
    inline QDBusPendingReply<uint, QDBusVariant> GetStreamTubeSocketAddress(uint ID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<uint, QDBusVariant>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetStreamTubeSocketAddress"));
        callMessage << QVariant::fromValue(ID);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c NewTube on the remote object.
     * 
     * Emitted when a tube is created.
     *
     * \param ID
     *     
     *     The ID of the new tube.
     *
     * \param initiator
     *     
     *     The handle of the contact who initiated the tube.
     *
     * \param type
     *     
     *     The tube type, as defined by the Tube_Type enum.
     *
     * \param service
     *     
     *     A string representing the service that will be used over the tube.
     *
     * \param parameters
     *     
     *     The new tube&apos;s properties.
     *
     * \param state
     *     
     *     The new tube&apos;s state.
     */
    void NewTube(uint ID, uint initiator, uint type, const QString& service, const QVariantMap& parameters, uint state);

    /**
     * Represents the signal \c TubeStateChanged on the remote object.
     * 
     * Emitted when the state of a tube changes.
     *
     * \param ID
     *     
     *     The ID of the tube that changed state.
     *
     * \param state
     *     
     *     The new state of the tube; see the Tube_State enumeration.
     */
    void TubeStateChanged(uint ID, uint state);

    /**
     * Represents the signal \c TubeClosed on the remote object.
     * 
     * Emitted when a tube has been closed. The ID of a closed tube is no 
     * longer valid. The ID may later be reused for a new tube.
     *
     * \param ID
     *     
     *     The ID of the tube that was closed.
     */
    void TubeClosed(uint ID);

    /**
     * Represents the signal \c DBusNamesChanged on the remote object.
     * 
     * Emitted on a multi-user (i.e. Handle_Type_Room) D-Bus tube when a 
     * participant opens or closes the tube.
     *
     * \param ID
     *     
     *     The ID of the tube whose names have changed.
     *
     * \param added
     *     
     *     Array of handles and D-Bus names of new participants.
     *
     * \param removed
     *     
     *     Array of handles of former participants.
     */
    void DBusNamesChanged(uint ID, const Tp::DBusTubeMemberList& added, const Tp::UIntList& removed);

    /**
     * Represents the signal \c StreamTubeNewConnection on the remote object.
     * 
     * Emitted on a stream tube when a participant opens a new connection to 
     * its socket.
     *
     * \param ID
     *     
     *     The ID of the tube
     *
     * \param handle
     *     
     *     The handle of the participant who opened the new connection
     */
    void StreamTubeNewConnection(uint ID, uint handle);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::ChannelInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceAnonymityInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceCallStateInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceCaptchaAuthenticationInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceChatStateInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceConferenceInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceDTMFInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceDestroyableInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceFileTransferMetadataInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceGroupInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceHoldInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceMediaSignallingInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceMessagesInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfacePasswordInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceRoomConfigInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceRoomInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceSASLAuthenticationInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceSMSInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceSecurableInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceServicePointInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceSubjectInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelInterfaceTubeInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeCallInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeContactListInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeContactSearchInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeDBusTubeInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeFileTransferInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeRoomListInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeServerAuthenticationInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeServerTLSConnectionInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeStreamTubeInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeStreamedMediaInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeTextInterface*)
Q_DECLARE_METATYPE(Tp::Client::ChannelTypeTubesInterface*)
