/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.util.mime;

import java.io.IOException;
import java.io.OutputStream;

final class QuotedPrintableDecoder {
    private static final int UPPER_NIBBLE_SHIFT = 4;

    private QuotedPrintableDecoder() {
    }

    public static int decode(byte[] byArray, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = byArray.length;
        int n3 = n + n2;
        int n4 = 0;
        while (n < n3) {
            byte by;
            if ((by = byArray[n++]) == 95) {
                outputStream.write(32);
                continue;
            }
            if (by == 61) {
                if (n + 1 >= n3) {
                    throw new IOException("Invalid quoted printable encoding; truncated escape sequence");
                }
                byte by2 = byArray[n++];
                byte by3 = byArray[n++];
                if (by2 == 13) {
                    if (by3 == 10) continue;
                    throw new IOException("Invalid quoted printable encoding; CR must be followed by LF");
                }
                int n5 = QuotedPrintableDecoder.hexToBinary(by2);
                int n6 = QuotedPrintableDecoder.hexToBinary(by3);
                outputStream.write(n5 << 4 | n6);
                ++n4;
                continue;
            }
            outputStream.write(by);
            ++n4;
        }
        return n4;
    }

    private static int hexToBinary(byte by) throws IOException {
        int n = Character.digit((char)by, 16);
        if (n == -1) {
            throw new IOException("Invalid quoted printable encoding: not a valid hex digit: " + by);
        }
        return n;
    }
}

