/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.RequestUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.parser.Host;
import org.apache.tomcat.util.res.StringManager;

public class RemoteIpFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    protected static final String HTTP_SERVER_PORT_PARAMETER = "httpServerPort";
    protected static final String HTTPS_SERVER_PORT_PARAMETER = "httpsServerPort";
    protected static final String INTERNAL_PROXIES_PARAMETER = "internalProxies";
    private transient Log log = LogFactory.getLog(RemoteIpFilter.class);
    protected static final StringManager sm = StringManager.getManager(RemoteIpFilter.class);
    protected static final String PROTOCOL_HEADER_PARAMETER = "protocolHeader";
    protected static final String PROTOCOL_HEADER_HTTPS_VALUE_PARAMETER = "protocolHeaderHttpsValue";
    protected static final String HOST_HEADER_PARAMETER = "hostHeader";
    protected static final String PORT_HEADER_PARAMETER = "portHeader";
    protected static final String CHANGE_LOCAL_NAME_PARAMETER = "changeLocalName";
    protected static final String CHANGE_LOCAL_PORT_PARAMETER = "changeLocalPort";
    protected static final String PROXIES_HEADER_PARAMETER = "proxiesHeader";
    protected static final String REMOTE_IP_HEADER_PARAMETER = "remoteIpHeader";
    protected static final String TRUSTED_PROXIES_PARAMETER = "trustedProxies";
    protected static final String ENABLE_LOOKUPS_PARAMETER = "enableLookups";
    private int httpServerPort = 80;
    private int httpsServerPort = 443;
    private Pattern internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1");
    private String protocolHeader = "X-Forwarded-Proto";
    private String protocolHeaderHttpsValue = "https";
    private String hostHeader = null;
    private boolean changeLocalName = false;
    private String portHeader = null;
    private boolean changeLocalPort = false;
    private String proxiesHeader = "X-Forwarded-By";
    private String remoteIpHeader = "X-Forwarded-For";
    private boolean requestAttributesEnabled = true;
    private Pattern trustedProxies = null;
    private boolean enableLookups;

    protected static String[] commaDelimitedListToStringArray(String string) {
        return string == null || string.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(string);
    }

    @Deprecated
    protected static String listToCommaDelimitedString(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null) continue;
            stringBuilder.append((Object)string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean bl;
        boolean bl2 = bl = this.internalProxies != null && this.internalProxies.matcher(httpServletRequest.getRemoteAddr()).matches();
        if (bl || this.trustedProxies != null && this.trustedProxies.matcher(httpServletRequest.getRemoteAddr()).matches()) {
            Object object;
            Object object2;
            Object object3;
            int n;
            Object object4 = null;
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = httpServletRequest.getHeaders(this.remoteIpHeader);
            while (stringArray.hasMoreElements()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)stringArray.nextElement());
            }
            stringArray = RemoteIpFilter.commaDelimitedListToStringArray(stringBuilder.toString());
            if (!bl) {
                arrayDeque.addFirst(httpServletRequest.getRemoteAddr());
            }
            for (n = stringArray.length - 1; n >= 0; --n) {
                object4 = object3 = stringArray[n];
                if (this.internalProxies != null && this.internalProxies.matcher((CharSequence)object3).matches()) continue;
                if (this.trustedProxies != null && this.trustedProxies.matcher((CharSequence)object3).matches()) {
                    arrayDeque.addFirst(object3);
                    continue;
                }
                --n;
                break;
            }
            object3 = new LinkedList();
            while (n >= 0) {
                object2 = stringArray[n];
                ((LinkedList)object3).addFirst(object2);
                --n;
            }
            object2 = new XForwardedRequest(httpServletRequest);
            if (object4 != null) {
                ((XForwardedRequest)((Object)object2)).setRemoteAddr((String)object4);
                if (this.getEnableLookups()) {
                    try {
                        object = InetAddress.getByName((String)object4);
                        ((XForwardedRequest)((Object)object2)).setRemoteHost(((InetAddress)object).getCanonicalHostName());
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.log.debug((Object)sm.getString("remoteIpFilter.invalidRemoteAddress", new Object[]{object4}), (Throwable)unknownHostException);
                        ((XForwardedRequest)((Object)object2)).setRemoteHost((String)object4);
                    }
                } else {
                    ((XForwardedRequest)((Object)object2)).setRemoteHost((String)object4);
                }
                if (arrayDeque.size() == 0) {
                    ((XForwardedRequest)((Object)object2)).removeHeader(this.proxiesHeader);
                } else {
                    object = StringUtils.join(arrayDeque);
                    ((XForwardedRequest)((Object)object2)).setHeader(this.proxiesHeader, (String)object);
                }
                if (((LinkedList)object3).size() == 0) {
                    ((XForwardedRequest)((Object)object2)).removeHeader(this.remoteIpHeader);
                } else {
                    object = StringUtils.join((Collection)object3);
                    ((XForwardedRequest)((Object)object2)).setHeader(this.remoteIpHeader, (String)object);
                }
            }
            if (this.protocolHeader != null && (object = httpServletRequest.getHeader(this.protocolHeader)) != null) {
                if (this.isForwardedProtoHeaderValueSecure((String)object)) {
                    ((XForwardedRequest)((Object)object2)).setSecure(true);
                    ((XForwardedRequest)((Object)object2)).setScheme("https");
                    this.setPorts((XForwardedRequest)((Object)object2), this.httpsServerPort);
                } else {
                    ((XForwardedRequest)((Object)object2)).setSecure(false);
                    ((XForwardedRequest)((Object)object2)).setScheme("http");
                    this.setPorts((XForwardedRequest)((Object)object2), this.httpServerPort);
                }
            }
            if (this.hostHeader != null && (object = httpServletRequest.getHeader(this.hostHeader)) != null) {
                try {
                    int n2 = Host.parse((String)object);
                    if (n2 > -1) {
                        this.log.debug((Object)sm.getString("remoteIpFilter.invalidHostWithPort", new Object[]{object, this.hostHeader}));
                        object = ((String)object).substring(0, n2);
                    }
                    ((XForwardedRequest)((Object)object2)).setServerName((String)object);
                    if (this.isChangeLocalName()) {
                        ((XForwardedRequest)((Object)object2)).setLocalName((String)object);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.debug((Object)sm.getString("remoteIpFilter.invalidHostHeader", new Object[]{object, this.hostHeader}));
                }
            }
            httpServletRequest.setAttribute("org.apache.tomcat.request.forwarded", (Object)Boolean.TRUE);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Incoming request " + httpServletRequest.getRequestURI() + " with originalRemoteAddr [" + httpServletRequest.getRemoteAddr() + "], originalRemoteHost=[" + httpServletRequest.getRemoteHost() + "], originalSecure=[" + httpServletRequest.isSecure() + "], originalScheme=[" + httpServletRequest.getScheme() + "], originalServerName=[" + httpServletRequest.getServerName() + "], originalServerPort=[" + httpServletRequest.getServerPort() + "] will be seen as newRemoteAddr=[" + ((XForwardedRequest)((Object)object2)).getRemoteAddr() + "], newRemoteHost=[" + ((XForwardedRequest)((Object)object2)).getRemoteHost() + "], newSecure=[" + ((XForwardedRequest)((Object)object2)).isSecure() + "], newScheme=[" + ((XForwardedRequest)((Object)object2)).getScheme() + "], newServerName=[" + ((XForwardedRequest)((Object)object2)).getServerName() + "], newServerPort=[" + ((XForwardedRequest)((Object)object2)).getServerPort() + "]"));
            }
            if (this.requestAttributesEnabled) {
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.RemoteAddr", (Object)((XForwardedRequest)((Object)object2)).getRemoteAddr());
                httpServletRequest.setAttribute("org.apache.tomcat.remoteAddr", (Object)((XForwardedRequest)((Object)object2)).getRemoteAddr());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.RemoteHost", (Object)((XForwardedRequest)((Object)object2)).getRemoteHost());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.Protocol", (Object)object2.getProtocol());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.ServerName", (Object)((XForwardedRequest)((Object)object2)).getServerName());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.ServerPort", (Object)((XForwardedRequest)((Object)object2)).getServerPort());
            }
            filterChain.doFilter((ServletRequest)object2, (ServletResponse)httpServletResponse);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Skip RemoteIpFilter for request " + httpServletRequest.getRequestURI() + " with originalRemoteAddr '" + httpServletRequest.getRemoteAddr() + "'"));
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean isForwardedProtoHeaderValueSecure(String string) {
        if (!string.contains(",")) {
            return this.protocolHeaderHttpsValue.equalsIgnoreCase(string);
        }
        String[] stringArray = RemoteIpFilter.commaDelimitedListToStringArray(string);
        if (stringArray.length == 0) {
            return false;
        }
        for (String string2 : stringArray) {
            if (this.protocolHeaderHttpsValue.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    private void setPorts(XForwardedRequest xForwardedRequest, int n) {
        String string;
        int n2 = n;
        if (this.getPortHeader() != null && (string = xForwardedRequest.getHeader(this.getPortHeader())) != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.debug((Object)("Invalid port value [" + string + "] provided in header [" + this.getPortHeader() + "]"));
            }
        }
        xForwardedRequest.setServerPort(n2);
        if (this.isChangeLocalPort()) {
            xForwardedRequest.setLocalPort(n2);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public boolean isChangeLocalName() {
        return this.changeLocalName;
    }

    public boolean isChangeLocalPort() {
        return this.changeLocalPort;
    }

    public int getHttpsServerPort() {
        return this.httpsServerPort;
    }

    public Pattern getInternalProxies() {
        return this.internalProxies;
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    public String getProtocolHeaderHttpsValue() {
        return this.protocolHeaderHttpsValue;
    }

    public String getProxiesHeader() {
        return this.proxiesHeader;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public Pattern getTrustedProxies() {
        return this.trustedProxies;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void init() throws ServletException {
        if (this.getInitParameter(INTERNAL_PROXIES_PARAMETER) != null) {
            this.setInternalProxies(this.getInitParameter(INTERNAL_PROXIES_PARAMETER));
        }
        if (this.getInitParameter(PROTOCOL_HEADER_PARAMETER) != null) {
            this.setProtocolHeader(this.getInitParameter(PROTOCOL_HEADER_PARAMETER));
        }
        if (this.getInitParameter(PROTOCOL_HEADER_HTTPS_VALUE_PARAMETER) != null) {
            this.setProtocolHeaderHttpsValue(this.getInitParameter(PROTOCOL_HEADER_HTTPS_VALUE_PARAMETER));
        }
        if (this.getInitParameter(HOST_HEADER_PARAMETER) != null) {
            this.setHostHeader(this.getInitParameter(HOST_HEADER_PARAMETER));
        }
        if (this.getInitParameter(PORT_HEADER_PARAMETER) != null) {
            this.setPortHeader(this.getInitParameter(PORT_HEADER_PARAMETER));
        }
        if (this.getInitParameter(CHANGE_LOCAL_NAME_PARAMETER) != null) {
            this.setChangeLocalName(Boolean.parseBoolean(this.getInitParameter(CHANGE_LOCAL_NAME_PARAMETER)));
        }
        if (this.getInitParameter(CHANGE_LOCAL_PORT_PARAMETER) != null) {
            this.setChangeLocalPort(Boolean.parseBoolean(this.getInitParameter(CHANGE_LOCAL_PORT_PARAMETER)));
        }
        if (this.getInitParameter(PROXIES_HEADER_PARAMETER) != null) {
            this.setProxiesHeader(this.getInitParameter(PROXIES_HEADER_PARAMETER));
        }
        if (this.getInitParameter(REMOTE_IP_HEADER_PARAMETER) != null) {
            this.setRemoteIpHeader(this.getInitParameter(REMOTE_IP_HEADER_PARAMETER));
        }
        if (this.getInitParameter(TRUSTED_PROXIES_PARAMETER) != null) {
            this.setTrustedProxies(this.getInitParameter(TRUSTED_PROXIES_PARAMETER));
        }
        if (this.getInitParameter(HTTP_SERVER_PORT_PARAMETER) != null) {
            try {
                this.setHttpServerPort(Integer.parseInt(this.getInitParameter(HTTP_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(sm.getString("remoteIpFilter.invalidNumber", new Object[]{HTTP_SERVER_PORT_PARAMETER, numberFormatException.getLocalizedMessage()}));
            }
        }
        if (this.getInitParameter(HTTPS_SERVER_PORT_PARAMETER) != null) {
            try {
                this.setHttpsServerPort(Integer.parseInt(this.getInitParameter(HTTPS_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(sm.getString("remoteIpFilter.invalidNumber", new Object[]{HTTPS_SERVER_PORT_PARAMETER, numberFormatException.getLocalizedMessage()}));
            }
        }
        if (this.getInitParameter(ENABLE_LOOKUPS_PARAMETER) != null) {
            this.setEnableLookups(Boolean.parseBoolean(this.getInitParameter(ENABLE_LOOKUPS_PARAMETER)));
        }
    }

    public void setChangeLocalName(boolean bl) {
        this.changeLocalName = bl;
    }

    public void setChangeLocalPort(boolean bl) {
        this.changeLocalPort = bl;
    }

    public void setHttpServerPort(int n) {
        this.httpServerPort = n;
    }

    public void setHttpsServerPort(int n) {
        this.httpsServerPort = n;
    }

    public void setInternalProxies(String string) {
        this.internalProxies = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public void setHostHeader(String string) {
        this.hostHeader = string;
    }

    public void setPortHeader(String string) {
        this.portHeader = string;
    }

    public void setProtocolHeader(String string) {
        this.protocolHeader = string;
    }

    public void setProtocolHeaderHttpsValue(String string) {
        this.protocolHeaderHttpsValue = string;
    }

    public void setProxiesHeader(String string) {
        this.proxiesHeader = string;
    }

    public void setRemoteIpHeader(String string) {
        this.remoteIpHeader = string;
    }

    public void setRequestAttributesEnabled(boolean bl) {
        this.requestAttributesEnabled = bl;
    }

    public void setTrustedProxies(String string) {
        this.trustedProxies = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public void setEnableLookups(boolean bl) {
        this.enableLookups = bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog(RemoteIpFilter.class);
    }

    public static class XForwardedRequest
    extends HttpServletRequestWrapper {
        protected final Map<String, List<String>> headers;
        protected String localName;
        protected int localPort;
        protected String remoteAddr;
        protected String remoteHost;
        protected String scheme;
        protected boolean secure;
        protected String serverName;
        protected int serverPort;

        public XForwardedRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
            this.localName = httpServletRequest.getLocalName();
            this.localPort = httpServletRequest.getLocalPort();
            this.remoteAddr = httpServletRequest.getRemoteAddr();
            this.remoteHost = httpServletRequest.getRemoteHost();
            this.scheme = httpServletRequest.getScheme();
            this.secure = httpServletRequest.isSecure();
            this.serverName = httpServletRequest.getServerName();
            this.serverPort = httpServletRequest.getServerPort();
            this.headers = new HashMap<String, List<String>>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.headers.put(string, Collections.list(httpServletRequest.getHeaders(string)));
            }
        }

        public long getDateHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1L;
            }
            long l = FastHttpDateFormat.parseDate((String)string2);
            if (l == -1L) {
                throw new IllegalArgumentException(string2);
            }
            return l;
        }

        public String getHeader(String string) {
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry == null || entry.getValue() == null || entry.getValue().isEmpty()) {
                return null;
            }
            return entry.getValue().get(0);
        }

        protected Map.Entry<String, List<String>> getHeaderEntry(String string) {
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(string)) continue;
                return entry;
            }
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public Enumeration<String> getHeaders(String string) {
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry == null || entry.getValue() == null) {
                return Collections.enumeration(Collections.emptyList());
            }
            return Collections.enumeration((Collection)entry.getValue());
        }

        public int getIntHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1;
            }
            return Integer.parseInt(string2);
        }

        public String getLocalName() {
            return this.localName;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void removeHeader(String string) {
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry != null) {
                this.headers.remove(entry.getKey());
            }
        }

        public void setHeader(String string, String string2) {
            List<String> list = Collections.singletonList(string2);
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry == null) {
                this.headers.put(string, list);
            } else {
                entry.setValue(list);
            }
        }

        public void setLocalName(String string) {
            this.localName = string;
        }

        public void setLocalPort(int n) {
            this.localPort = n;
        }

        public void setRemoteAddr(String string) {
            this.remoteAddr = string;
        }

        public void setRemoteHost(String string) {
            this.remoteHost = string;
        }

        public void setScheme(String string) {
            this.scheme = string;
        }

        public void setSecure(boolean bl) {
            this.secure = bl;
        }

        public void setServerName(String string) {
            this.serverName = string;
        }

        public void setServerPort(int n) {
            this.serverPort = n;
        }

        public StringBuffer getRequestURL() {
            return RequestUtil.getRequestURL((HttpServletRequest)this);
        }

        public PushBuilder newPushBuilder() {
            ServletRequest servletRequest = this.getRequest();
            while (servletRequest instanceof ServletRequestWrapper) {
                servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
            }
            if (servletRequest instanceof RequestFacade) {
                return ((RequestFacade)servletRequest).newPushBuilder((HttpServletRequest)this);
            }
            return null;
        }
    }
}

