/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;

@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject
implements Constantizable {
    private final int hashCode;
    private final transient Object constant;
    static final byte[] nilBytes = new byte[]{110, 105, 108};
    private static final ByteList nil = new ByteList(nilBytes, (Encoding)USASCIIEncoding.INSTANCE);
    @Deprecated
    public static final ObjectAllocator NIL_ALLOCATOR = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;

    public RubyNil(Ruby runtime2) {
        super(runtime2, runtime2.getNilClass(), false);
        this.flags |= NIL_F | FALSE_F | FROZEN_F;
        this.hashCode = RubyInstanceConfig.CONSISTENT_HASHING_ENABLED ? 34 : System.identityHashCode(this);
        this.constant = OptoFactory.newConstantWrapper(IRubyObject.class, this);
    }

    public static RubyClass createNilClass(Ruby runtime2) {
        RubyClass nilClass = runtime2.defineClass("NilClass", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        nilClass.setClassIndex(ClassIndex.NIL);
        nilClass.setReifiedClass(RubyNil.class);
        nilClass.defineAnnotatedMethods(RubyNil.class);
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.NIL;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Void.TYPE;
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    @JRubyMethod
    public static RubyFixnum to_i(ThreadContext context, IRubyObject recv2) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public static RubyFloat to_f(ThreadContext context, IRubyObject recv2) {
        return RubyFloat.newFloat(context.runtime, 0.0);
    }

    @JRubyMethod
    public static RubyString to_s(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getNilString();
    }

    @JRubyMethod
    public static RubyArray to_a(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newEmptyArray();
    }

    @JRubyMethod
    public static RubyHash to_h(ThreadContext context, IRubyObject recv2) {
        return RubyHash.newSmallHash(context.runtime);
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        return RubyNil.inspect(this.metaClass.runtime);
    }

    static RubyString inspect(Ruby runtime2) {
        return RubyString.newStringShared(runtime2, runtime2.getString(), nil);
    }

    @Override
    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return this;
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return context.fals;
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, obj.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, obj.isTrue());
    }

    @Override
    @JRubyMethod(name={"nil?"})
    public RubyBoolean nil_p(ThreadContext context) {
        return context.tru;
    }

    @Deprecated
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public RubyFixnum id() {
        return RubyFixnum.newFixnum(this.metaClass.runtime, 8L);
    }

    @JRubyMethod
    public static IRubyObject to_c(ThreadContext context, IRubyObject recv2) {
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod
    public static IRubyObject to_r(ThreadContext context, IRubyObject recv2) {
        return RubyRational.newRationalCanonicalize(context, 0L);
    }

    @JRubyMethod(optional=1)
    public static IRubyObject rationalize(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyNil.to_r(context, recv2);
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target.isPrimitive()) {
            if (target == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (target == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            switch (target.getSimpleName().charAt(0)) {
                case 'b': {
                    return (T)Byte.valueOf((byte)0);
                }
                case 's': {
                    return (T)Short.valueOf((short)0);
                }
                case 'i': {
                    return (T)Integer.valueOf(0);
                }
                case 'l': {
                    return (T)Long.valueOf(0L);
                }
                case 'f': {
                    return (T)Float.valueOf(0.0f);
                }
                case 'd': {
                    return (T)Double.valueOf(0.0);
                }
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public IRubyObject taint(ThreadContext context) {
        return this;
    }
}

