/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.ad.CleanState;
import org.opensearch.ad.MaintenanceState;
import org.opensearch.ad.NodeState;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.ml.SingleStreamModelIdMapper;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.BackPressureRouting;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.ExceptionUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;

public class NodeStateManager
implements MaintenanceState,
CleanState {
    private static final Logger LOG = LogManager.getLogger(NodeStateManager.class);
    public static final String NO_ERROR = "no_error";
    private ConcurrentHashMap<String, NodeState> states = new ConcurrentHashMap();
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClientUtil clientUtil;
    private Map<String, Map<String, BackPressureRouting>> backpressureMuter;
    private final Clock clock;
    private final Duration stateTtl;
    private int maxRetryForUnresponsiveNode;
    private TimeValue mutePeriod;

    public NodeStateManager(Client client, NamedXContentRegistry xContentRegistry, Settings settings, ClientUtil clientUtil, Clock clock, Duration stateTtl, ClusterService clusterService) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clientUtil = clientUtil;
        this.backpressureMuter = new ConcurrentHashMap<String, Map<String, BackPressureRouting>>();
        this.clock = clock;
        this.stateTtl = stateTtl;
        this.maxRetryForUnresponsiveNode = (Integer)AnomalyDetectorSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE, it -> {
            this.maxRetryForUnresponsiveNode = it;
            for (Map<String, BackPressureRouting> entry : this.backpressureMuter.values()) {
                entry.values().forEach(v -> v.setMaxRetryForUnresponsiveNode((int)it));
            }
        });
        this.mutePeriod = (TimeValue)AnomalyDetectorSettings.BACKOFF_MINUTES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.BACKOFF_MINUTES, it -> {
            this.mutePeriod = it;
            for (Map<String, BackPressureRouting> entry : this.backpressureMuter.values()) {
                entry.values().forEach(v -> v.setMutePeriod((TimeValue)it));
            }
        });
    }

    public Optional<AnomalyDetector> getAnomalyDetectorIfPresent(String adID) {
        NodeState state = this.states.get(adID);
        return Optional.ofNullable(state).map(NodeState::getDetectorDef);
    }

    public void getAnomalyDetector(String adID, ActionListener<Optional<AnomalyDetector>> listener) {
        NodeState state = this.states.get(adID);
        if (state != null && state.getDetectorDef() != null) {
            listener.onResponse(Optional.of(state.getDetectorDef()));
        } else {
            GetRequest request = new GetRequest(".opendistro-anomaly-detectors", adID);
            this.clientUtil.asyncRequest(request, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), this.onGetDetectorResponse(adID, listener));
        }
    }

    private ActionListener<GetResponse> onGetDetectorResponse(String adID, ActionListener<Optional<AnomalyDetector>> listener) {
        return ActionListener.wrap(response -> {
            if (response == null || !response.isExists()) {
                listener.onResponse(Optional.empty());
                return;
            }
            String xc = response.getSourceAsString();
            LOG.debug("Fetched anomaly detector: {}", (Object)xc);
            try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, xc);){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                AnomalyDetector detector = AnomalyDetector.parse(parser, response.getId());
                if (detector.getEnabledFeatureIds().isEmpty()) {
                    listener.onFailure((Exception)new EndRunException(adID, "Having trouble querying data because all of your features have been disabled.", true).countedInStats(false));
                    return;
                }
                NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
                state.setDetectorDef(detector);
                listener.onResponse(Optional.of(detector));
            }
            catch (Exception t) {
                LOG.error("Fail to parse detector {}", (Object)adID);
                LOG.error("Stack trace:", (Throwable)t);
                listener.onResponse(Optional.empty());
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void getDetectorCheckpoint(String adID, ActionListener<Boolean> listener) {
        NodeState state = this.states.get(adID);
        if (state != null && state.doesCheckpointExists()) {
            listener.onResponse((Object)Boolean.TRUE);
            return;
        }
        GetRequest request = new GetRequest(".opendistro-anomaly-checkpoints", SingleStreamModelIdMapper.getRcfModelId(adID, 0));
        this.clientUtil.asyncRequest(request, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), this.onGetCheckpointResponse(adID, listener));
    }

    private ActionListener<GetResponse> onGetCheckpointResponse(String adID, ActionListener<Boolean> listener) {
        return ActionListener.wrap(response -> {
            if (response == null || !response.isExists()) {
                listener.onResponse((Object)Boolean.FALSE);
            } else {
                NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
                state.setCheckpointExists(true);
                listener.onResponse((Object)Boolean.TRUE);
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    @Override
    public void clear(String detectorId) {
        Map<String, BackPressureRouting> routingMap = this.backpressureMuter.get(detectorId);
        if (routingMap != null) {
            routingMap.clear();
            this.backpressureMuter.remove(detectorId);
        }
        this.states.remove(detectorId);
    }

    @Override
    public void maintenance() {
        this.maintenance(this.states, this.stateTtl);
    }

    public boolean isMuted(String nodeId, String detectorId) {
        Map<String, BackPressureRouting> routingMap = this.backpressureMuter.get(detectorId);
        if (routingMap == null || routingMap.isEmpty()) {
            return false;
        }
        BackPressureRouting routing = routingMap.get(nodeId);
        return routing != null && routing.isMuted();
    }

    public void addPressure(String nodeId, String detectorId) {
        Map routingMap = this.backpressureMuter.computeIfAbsent(detectorId, k -> new HashMap());
        routingMap.computeIfAbsent(nodeId, k -> new BackPressureRouting((String)k, this.clock, this.maxRetryForUnresponsiveNode, this.mutePeriod)).addPressure();
    }

    public void resetBackpressureCounter(String nodeId, String detectorId) {
        Map<String, BackPressureRouting> routingMap = this.backpressureMuter.get(detectorId);
        if (routingMap == null || routingMap.isEmpty()) {
            this.backpressureMuter.remove(detectorId);
            return;
        }
        routingMap.remove(nodeId);
    }

    public boolean hasRunningQuery(AnomalyDetector detector) {
        return this.clientUtil.hasRunningQuery(detector);
    }

    public String getLastDetectionError(String adID) {
        return Optional.ofNullable(this.states.get(adID)).flatMap(state -> state.getLastDetectionError()).orElse(NO_ERROR);
    }

    public void setLastDetectionError(String adID, String error) {
        NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
        state.setLastDetectionError(error);
    }

    public Optional<Exception> fetchExceptionAndClear(String adID) {
        NodeState state = this.states.get(adID);
        if (state == null) {
            return Optional.empty();
        }
        Optional<Exception> exception = state.getException();
        exception.ifPresent(e -> state.setException(null));
        return exception;
    }

    public void setException(String detectorId, Exception e) {
        Exception higherPriorityException;
        if (e == null || Strings.isEmpty((CharSequence)detectorId)) {
            return;
        }
        NodeState state = this.states.computeIfAbsent(detectorId, d -> new NodeState(detectorId, this.clock));
        Optional<Exception> exception = state.getException();
        if (exception.isPresent() && (higherPriorityException = ExceptionUtil.selectHigherPriorityException(e, exception.get())) != e) {
            return;
        }
        state.setException(e);
    }

    public boolean isColdStartRunning(String adID) {
        NodeState state = this.states.get(adID);
        if (state != null) {
            return state.isColdStartRunning();
        }
        return false;
    }

    public Releasable markColdStartRunning(String adID) {
        NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
        state.setColdStartRunning(true);
        return () -> {
            NodeState nodeState = this.states.get(adID);
            if (nodeState != null) {
                nodeState.setColdStartRunning(false);
            }
        };
    }

    public void getAnomalyDetectorJob(String adID, ActionListener<Optional<AnomalyDetectorJob>> listener) {
        NodeState state = this.states.get(adID);
        if (state != null && state.getDetectorJob() != null) {
            listener.onResponse(Optional.of(state.getDetectorJob()));
        } else {
            GetRequest request = new GetRequest(".opendistro-anomaly-detector-jobs", adID);
            this.clientUtil.asyncRequest(request, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), this.onGetDetectorJobResponse(adID, listener));
        }
    }

    private ActionListener<GetResponse> onGetDetectorJobResponse(String adID, ActionListener<Optional<AnomalyDetectorJob>> listener) {
        return ActionListener.wrap(response -> {
            if (response == null || !response.isExists()) {
                listener.onResponse(Optional.empty());
                return;
            }
            String xc = response.getSourceAsString();
            LOG.debug("Fetched anomaly detector: {}", (Object)xc);
            try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                AnomalyDetectorJob job = AnomalyDetectorJob.parse(parser);
                NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
                state.setDetectorJob(job);
                listener.onResponse(Optional.of(job));
            }
            catch (Exception t) {
                LOG.error((Message)new ParameterizedMessage("Fail to parse job {}", (Object)adID), (Throwable)t);
                listener.onResponse(Optional.empty());
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

