/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest.handler;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.ADTaskState;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.AnomalyDetectorJobResponse;
import org.opensearch.ad.transport.StopDetectorAction;
import org.opensearch.ad.transport.StopDetectorRequest;
import org.opensearch.ad.transport.StopDetectorResponse;
import org.opensearch.ad.util.ExceptionUtil;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.rest.RestStatus;
import org.opensearch.transport.TransportService;

public class IndexAnomalyDetectorJobActionHandler {
    private final AnomalyDetectionIndices anomalyDetectionIndices;
    private final String detectorId;
    private final Long seqNo;
    private final Long primaryTerm;
    private final Client client;
    private final ActionListener<AnomalyDetectorJobResponse> listener;
    private final NamedXContentRegistry xContentRegistry;
    private final TransportService transportService;
    private final ADTaskManager adTaskManager;
    private final Logger logger = LogManager.getLogger(IndexAnomalyDetectorJobActionHandler.class);
    private final TimeValue requestTimeout;

    public IndexAnomalyDetectorJobActionHandler(Client client, ActionListener<AnomalyDetectorJobResponse> listener, AnomalyDetectionIndices anomalyDetectionIndices, String detectorId, Long seqNo, Long primaryTerm, TimeValue requestTimeout, NamedXContentRegistry xContentRegistry, TransportService transportService, ADTaskManager adTaskManager) {
        this.client = client;
        this.listener = listener;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.detectorId = detectorId;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.requestTimeout = requestTimeout;
        this.xContentRegistry = xContentRegistry;
        this.transportService = transportService;
        this.adTaskManager = adTaskManager;
    }

    public void startAnomalyDetectorJob(AnomalyDetector detector) {
        if (!this.anomalyDetectionIndices.doesAnomalyDetectorJobIndexExist()) {
            this.anomalyDetectionIndices.initAnomalyDetectorJobIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.logger.info("Created {} with mappings.", (Object)".opendistro-anomaly-detectors");
                    this.createJob(detector);
                } else {
                    this.logger.warn("Created {} with mappings call not acknowledged.", (Object)".opendistro-anomaly-detectors");
                    this.listener.onFailure((Exception)new OpenSearchStatusException("Created .opendistro-anomaly-detectors with mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }, exception -> this.listener.onFailure(exception)));
        } else {
            this.createJob(detector);
        }
    }

    private void createJob(AnomalyDetector detector) {
        try {
            IntervalTimeConfiguration interval = (IntervalTimeConfiguration)detector.getDetectionInterval();
            IntervalSchedule schedule = new IntervalSchedule(Instant.now(), (int)interval.getInterval(), interval.getUnit());
            Duration duration = Duration.of(interval.getInterval(), interval.getUnit());
            AnomalyDetectorJob job = new AnomalyDetectorJob(detector.getDetectorId(), (Schedule)schedule, detector.getWindowDelay(), true, Instant.now(), null, Instant.now(), duration.getSeconds(), detector.getUser(), detector.getResultIndex());
            this.getAnomalyDetectorJobForWrite(detector, job);
        }
        catch (Exception e) {
            String message = "Failed to parse anomaly detector job " + this.detectorId;
            this.logger.error(message, (Throwable)e);
            this.listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void getAnomalyDetectorJobForWrite(AnomalyDetector detector, AnomalyDetectorJob job) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs").id(this.detectorId);
        this.client.get(getRequest, ActionListener.wrap(response -> this.onGetAnomalyDetectorJobForWrite((GetResponse)response, detector, job), exception -> this.listener.onFailure(exception)));
    }

    private void onGetAnomalyDetectorJobForWrite(GetResponse response, AnomalyDetector detector, AnomalyDetectorJob job) throws IOException {
        if (response.isExists()) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                AnomalyDetectorJob currentAdJob = AnomalyDetectorJob.parse(parser);
                if (currentAdJob.isEnabled()) {
                    this.listener.onFailure((Exception)new OpenSearchStatusException("Anomaly detector job is already running: " + this.detectorId, RestStatus.OK, new Object[0]));
                    return;
                }
                AnomalyDetectorJob newJob = new AnomalyDetectorJob(job.getName(), job.getSchedule(), job.getWindowDelay(), job.isEnabled(), Instant.now(), currentAdJob.getDisabledTime(), Instant.now(), job.getLockDurationSeconds(), job.getUser(), job.getResultIndex());
                this.adTaskManager.startDetector(detector, null, job.getUser(), this.transportService, (ActionListener<AnomalyDetectorJobResponse>)ActionListener.wrap(r -> this.indexAnomalyDetectorJob(newJob, null), e -> this.listener.onFailure(e)));
            }
            catch (IOException e2) {
                String message = "Failed to parse anomaly detector job " + job.getName();
                this.logger.error(message, (Throwable)e2);
                this.listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        } else {
            this.adTaskManager.startDetector(detector, null, job.getUser(), this.transportService, (ActionListener<AnomalyDetectorJobResponse>)ActionListener.wrap(r -> this.indexAnomalyDetectorJob(job, null), e -> this.listener.onFailure(e)));
        }
    }

    private void indexAnomalyDetectorJob(AnomalyDetectorJob job, AnomalyDetectorFunction function) throws IOException {
        IndexRequest indexRequest = ((IndexRequest)((IndexRequest)new IndexRequest(".opendistro-anomaly-detector-jobs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(job.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE)).setIfSeqNo(this.seqNo.longValue()).setIfPrimaryTerm(this.primaryTerm.longValue()).timeout(this.requestTimeout)).id(this.detectorId);
        this.client.index(indexRequest, ActionListener.wrap(response -> this.onIndexAnomalyDetectorJobResponse((IndexResponse)response, function), exception -> this.listener.onFailure(exception)));
    }

    private void onIndexAnomalyDetectorJobResponse(IndexResponse response, AnomalyDetectorFunction function) {
        if (response == null || response.getResult() != DocWriteResponse.Result.CREATED && response.getResult() != DocWriteResponse.Result.UPDATED) {
            String errorMsg = ExceptionUtil.getShardsFailure(response);
            this.listener.onFailure((Exception)new OpenSearchStatusException(errorMsg, response.status(), new Object[0]));
            return;
        }
        if (function != null) {
            function.execute();
        } else {
            AnomalyDetectorJobResponse anomalyDetectorJobResponse = new AnomalyDetectorJobResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), RestStatus.OK);
            this.listener.onResponse((Object)anomalyDetectorJobResponse);
        }
    }

    public void stopAnomalyDetectorJob(String detectorId) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs").id(detectorId);
        this.client.get(getRequest, ActionListener.wrap(response -> {
            if (response.isExists()) {
                try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    AnomalyDetectorJob job = AnomalyDetectorJob.parse(parser);
                    if (!job.isEnabled()) {
                        this.adTaskManager.stopLatestRealtimeTask(detectorId, ADTaskState.STOPPED, null, this.transportService, this.listener);
                    } else {
                        AnomalyDetectorJob newJob = new AnomalyDetectorJob(job.getName(), job.getSchedule(), job.getWindowDelay(), false, job.getEnabledTime(), Instant.now(), Instant.now(), job.getLockDurationSeconds(), job.getUser(), job.getResultIndex());
                        this.indexAnomalyDetectorJob(newJob, () -> this.client.execute((ActionType)StopDetectorAction.INSTANCE, (ActionRequest)new StopDetectorRequest(detectorId), this.stopAdDetectorListener(detectorId)));
                    }
                }
                catch (IOException e) {
                    String message = "Failed to parse anomaly detector job " + detectorId;
                    this.logger.error(message, (Throwable)e);
                    this.listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            } else {
                this.listener.onFailure((Exception)new OpenSearchStatusException("Anomaly detector job not exist: " + detectorId, RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, exception -> this.listener.onFailure(exception)));
    }

    private ActionListener<StopDetectorResponse> stopAdDetectorListener(final String detectorId) {
        return new ActionListener<StopDetectorResponse>(){

            public void onResponse(StopDetectorResponse stopDetectorResponse) {
                if (stopDetectorResponse.success()) {
                    IndexAnomalyDetectorJobActionHandler.this.logger.info("AD model deleted successfully for detector {}", (Object)detectorId);
                    IndexAnomalyDetectorJobActionHandler.this.adTaskManager.stopLatestRealtimeTask(detectorId, ADTaskState.STOPPED, null, null, IndexAnomalyDetectorJobActionHandler.this.listener);
                } else {
                    IndexAnomalyDetectorJobActionHandler.this.logger.error("Failed to delete AD model for detector {}", (Object)detectorId);
                    IndexAnomalyDetectorJobActionHandler.this.adTaskManager.stopLatestRealtimeTask(detectorId, ADTaskState.FAILED, (Exception)new OpenSearchStatusException("Failed to delete AD model", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]), IndexAnomalyDetectorJobActionHandler.this.transportService, IndexAnomalyDetectorJobActionHandler.this.listener);
                }
            }

            public void onFailure(Exception e) {
                IndexAnomalyDetectorJobActionHandler.this.logger.error("Failed to delete AD model for detector " + detectorId, (Throwable)e);
                IndexAnomalyDetectorJobActionHandler.this.adTaskManager.stopLatestRealtimeTask(detectorId, ADTaskState.FAILED, (Exception)new OpenSearchStatusException("Failed to execute stop detector action", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]), IndexAnomalyDetectorJobActionHandler.this.transportService, IndexAnomalyDetectorJobActionHandler.this.listener);
            }
        };
    }
}

