/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import com.google.common.base.Objects;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;

public class ExprDateValue
extends AbstractExprValue {
    private final LocalDate date;

    public ExprDateValue(String date) {
        try {
            this.date = LocalDate.parse(date);
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("date:%s in unsupported format, please use yyyy-MM-dd", date));
        }
    }

    @Override
    public String value() {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(this.date);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.DATE;
    }

    @Override
    public LocalDate dateValue() {
        return this.date;
    }

    @Override
    public LocalTime timeValue() {
        return LocalTime.of(0, 0, 0);
    }

    @Override
    public LocalDateTime datetimeValue() {
        return LocalDateTime.of(this.date, this.timeValue());
    }

    @Override
    public Instant timestampValue() {
        return ZonedDateTime.of(this.date, this.timeValue(), ZoneId.systemDefault()).toInstant();
    }

    public String toString() {
        return String.format("DATE '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.date.compareTo(other.dateValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.date.equals(other.dateValue());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.date});
    }

    @Generated
    public ExprDateValue(LocalDate date) {
        this.date = date;
    }
}

