import * as lsp from 'vscode-languageserver';
import { RequestHandler } from 'vscode-jsonrpc';
import type { tsp } from './ts-protocol.js';
export type InlayHintsParams = {
    /**
     * The document to format.
     */
    textDocument: lsp.TextDocumentIdentifier;
    /**
     * The range to format
     */
    range?: lsp.Range;
};
type InlayHint = {
    text: string;
    position: lsp.Position;
    kind: tsp.InlayHintKind;
    whitespaceBefore?: boolean;
    whitespaceAfter?: boolean;
};
export type InlayHintsResult = {
    inlayHints: InlayHint[];
};
export declare const type: lsp.RequestType<InlayHintsParams, InlayHintsResult, lsp.TextDocumentRegistrationOptions>;
export type HandlerSignature = RequestHandler<InlayHintsParams, InlayHintsResult | null, void>;
export {};
//# sourceMappingURL=lsp-protocol.inlayHints.proposed.d.ts.map