//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.8
//
// <auto-generated>
//
// Generated from file `FileServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IcePatch2_FileServer_h__
#define __IcePatch2_FileServer_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <IcePatch2/FileInfo.h>
#include <IceUtil/UndefSysMacros.h>
#include <IcePatch2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 8
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEPATCH2_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEPATCH2_API /**/
#   elif defined(ICEPATCH2_API_EXPORTS)
#       define ICEPATCH2_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEPATCH2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IcePatch2
{

class FileServer;
class FileServerPrx;

}

namespace IcePatch2
{

/**
 * A sequence of byte sequences. Each element is the checksum for a
 * partition.
 */
using ByteSeqSeq = ::std::vector<::Ice::ByteSeq>;

/**
 * A <code>partition</code> argument was not in the range 0-255.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICE_CLASS(ICEPATCH2_API) PartitionOutOfRangeException : public ::Ice::UserExceptionHelper<PartitionOutOfRangeException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEPATCH2_API) virtual ~PartitionOutOfRangeException();

    PartitionOutOfRangeException(const PartitionOutOfRangeException&) = default;

    PartitionOutOfRangeException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static PartitionOutOfRangeException _iceS_PartitionOutOfRangeException_init;
/// \endcond

/**
 * This exception is raised if a file's contents cannot be read.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICE_CLASS(ICEPATCH2_API) FileAccessException : public ::Ice::UserExceptionHelper<FileAccessException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEPATCH2_API) virtual ~FileAccessException();

    FileAccessException(const FileAccessException&) = default;

    FileAccessException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason An explanation of the reason for the failure.
     */
    FileAccessException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();

    /**
     * An explanation of the reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception is raised if an operation tries to use a file whose size is
 * larger than 2.1 GB. Use the "large" versions of the operations instead.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICE_CLASS(ICEPATCH2_API) FileSizeRangeException : public ::Ice::UserExceptionHelper<FileSizeRangeException, FileAccessException>
{
public:

    ICE_MEMBER(ICEPATCH2_API) virtual ~FileSizeRangeException();

    FileSizeRangeException(const FileSizeRangeException&) = default;

    FileSizeRangeException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason An explanation of the reason for the failure.
     */
    FileSizeRangeException(const ::std::string& reason) :
        ::Ice::UserExceptionHelper<FileSizeRangeException, FileAccessException>(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();
};

}

namespace IcePatch2
{

/**
 * The interface that provides access to files.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICEPATCH2_API FileServer : public virtual ::Ice::Object
{
public:

    using ProxyType = FileServerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param current The Current object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") virtual FileInfoSeq getFileInfoSeq(int partition, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param current The Current object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     */
    virtual LargeFileInfoSeq getLargeFileInfoSeq(int partition, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLargeFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the checksums for all partitions.
     * @param current The Current object for the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     */
    virtual ByteSeqSeq getChecksumSeq(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getChecksumSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param current The Current object for the invocation.
     * @return The master checksum for the file set.
     */
    virtual ::Ice::ByteSeq getChecksum(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getChecksum(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") virtual void getFileCompressedAsync(::std::string path, int pos, int num, ::std::function<void(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     */
    virtual void getLargeFileCompressedAsync(::std::string path, long long int pos, int num, ::std::function<void(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLargeFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IcePatch2
{

/**
 * The interface that provides access to files.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICE_CLASS(ICEPATCH2_API) FileServerPrx : public virtual ::Ice::Proxy<FileServerPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") FileInfoSeq getFileInfoSeq(int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IcePatch2::FileInfoSeq>(true, this, &FileServerPrx::_iceI_getFileInfoSeq, partition, context).get();
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    template<template<typename> class P = ::std::promise>
    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") auto getFileInfoSeqAsync(int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IcePatch2::FileInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IcePatch2::FileInfoSeq, P>(false, this, &FileServerPrx::_iceI_getFileInfoSeq, partition, context);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ::std::function<void()>
    getFileInfoSeqAsync(int partition,
                        ::std::function<void(::IcePatch2::FileInfoSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IcePatch2::FileInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IcePatch2::FileServerPrx::_iceI_getFileInfoSeq, partition, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEPATCH2_API) void _iceI_getFileInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::FileInfoSeq>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     */
    LargeFileInfoSeq getLargeFileInfoSeq(int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IcePatch2::LargeFileInfoSeq>(true, this, &FileServerPrx::_iceI_getLargeFileInfoSeq, partition, context).get();
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLargeFileInfoSeqAsync(int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IcePatch2::LargeFileInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IcePatch2::LargeFileInfoSeq, P>(false, this, &FileServerPrx::_iceI_getLargeFileInfoSeq, partition, context);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLargeFileInfoSeqAsync(int partition,
                             ::std::function<void(::IcePatch2::LargeFileInfoSeq)> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IcePatch2::LargeFileInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IcePatch2::FileServerPrx::_iceI_getLargeFileInfoSeq, partition, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEPATCH2_API) void _iceI_getLargeFileInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::LargeFileInfoSeq>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     */
    ByteSeqSeq getChecksumSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IcePatch2::ByteSeqSeq>(true, this, &FileServerPrx::_iceI_getChecksumSeq, context).get();
    }

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getChecksumSeqAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IcePatch2::ByteSeqSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IcePatch2::ByteSeqSeq, P>(false, this, &FileServerPrx::_iceI_getChecksumSeq, context);
    }

    /**
     * Return the checksums for all partitions.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getChecksumSeqAsync(::std::function<void(::IcePatch2::ByteSeqSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IcePatch2::ByteSeqSeq>(std::move(response), std::move(ex), std::move(sent), this, &IcePatch2::FileServerPrx::_iceI_getChecksumSeq, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEPATCH2_API) void _iceI_getChecksumSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::ByteSeqSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @return The master checksum for the file set.
     */
    ::Ice::ByteSeq getChecksum(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ByteSeq>(true, this, &FileServerPrx::_iceI_getChecksum, context).get();
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getChecksumAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ByteSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ByteSeq, P>(false, this, &FileServerPrx::_iceI_getChecksum, context);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getChecksumAsync(::std::function<void(::Ice::ByteSeq)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ByteSeq>(std::move(response), std::move(ex), std::move(sent), this, &IcePatch2::FileServerPrx::_iceI_getChecksum, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEPATCH2_API) void _iceI_getChecksum(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") ::Ice::ByteSeq getFileCompressed(const ::std::string& path, int pos, int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ByteSeq>(true, this, &FileServerPrx::_iceI_getFileCompressed, path, pos, num, context).get();
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    template<template<typename> class P = ::std::promise>
    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") auto getFileCompressedAsync(const ::std::string& path, int pos, int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ByteSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ByteSeq, P>(false, this, &FileServerPrx::_iceI_getFileCompressed, path, pos, num, context);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ICE_MEMBER(ICEPATCH2_API) ::std::function<void()>
    getFileCompressedAsync(const ::std::string& path, int pos, int num,
                           ::std::function<void(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext);

    /// \cond INTERNAL
    ICE_MEMBER(ICEPATCH2_API) void _iceI_getFileCompressed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>&, const ::std::string&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     */
    ::Ice::ByteSeq getLargeFileCompressed(const ::std::string& path, long long int pos, int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ByteSeq>(true, this, &FileServerPrx::_iceI_getLargeFileCompressed, path, pos, num, context).get();
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLargeFileCompressedAsync(const ::std::string& path, long long int pos, int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ByteSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ByteSeq, P>(false, this, &FileServerPrx::_iceI_getLargeFileCompressed, path, pos, num, context);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ICE_MEMBER(ICEPATCH2_API) ::std::function<void()>
    getLargeFileCompressedAsync(const ::std::string& path, long long int pos, int num,
                                ::std::function<void(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>)> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = ::Ice::noExplicitContext);

    /// \cond INTERNAL
    ICE_MEMBER(ICEPATCH2_API) void _iceI_getLargeFileCompressed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>&, const ::std::string&, long long int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    FileServerPrx() = default;
    friend ::std::shared_ptr<FileServerPrx> IceInternal::createProxy<FileServerPrx>();

    ICE_MEMBER(ICEPATCH2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::IcePatch2::FileAccessException, S>
{
    static void read(S* istr, ::IcePatch2::FileAccessException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamWriter<::IcePatch2::FileSizeRangeException, S>
{
    static void write(S*, const ::IcePatch2::FileSizeRangeException&)
    {
    }
};

template<typename S>
struct StreamReader<::IcePatch2::FileSizeRangeException, S>
{
    static void read(S*, ::IcePatch2::FileSizeRangeException&)
    {
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IcePatch2
{

using FileServerPtr = ::std::shared_ptr<FileServer>;
using FileServerPrxPtr = ::std::shared_ptr<FileServerPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IcePatch2
{

class FileServer;
/// \cond INTERNAL
ICEPATCH2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< FileServer>&);
ICEPATCH2_API ::IceProxy::Ice::Object* upCast(FileServer*);
/// \endcond

}

}

namespace IcePatch2
{

class FileServer;
/// \cond INTERNAL
ICEPATCH2_API ::Ice::Object* upCast(FileServer*);
/// \endcond
typedef ::IceInternal::Handle< FileServer> FileServerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IcePatch2::FileServer> FileServerPrx;
typedef FileServerPrx FileServerPrxPtr;
/// \cond INTERNAL
ICEPATCH2_API void _icePatchObjectPtr(FileServerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IcePatch2
{

/**
 * A sequence of byte sequences. Each element is the checksum for a
 * partition.
 */
typedef ::std::vector< ::Ice::ByteSeq> ByteSeqSeq;

/**
 * A <code>partition</code> argument was not in the range 0-255.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICEPATCH2_API PartitionOutOfRangeException : public ::Ice::UserException
{
public:

    PartitionOutOfRangeException() {}

#ifdef ICE_CPP11_COMPILER
    PartitionOutOfRangeException(const PartitionOutOfRangeException&) = default;
    virtual ~PartitionOutOfRangeException();
#else
    virtual ~PartitionOutOfRangeException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual PartitionOutOfRangeException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static PartitionOutOfRangeException _iceS_PartitionOutOfRangeException_init;
/// \endcond

/**
 * This exception is raised if a file's contents cannot be read.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICEPATCH2_API FileAccessException : public ::Ice::UserException
{
public:

    FileAccessException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason An explanation of the reason for the failure.
     */
    explicit FileAccessException(const ::std::string& reason);

#ifdef ICE_CPP11_COMPILER
    FileAccessException(const FileAccessException&) = default;
    virtual ~FileAccessException();
#else
    virtual ~FileAccessException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual FileAccessException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * An explanation of the reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an operation tries to use a file whose size is
 * larger than 2.1 GB. Use the "large" versions of the operations instead.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICEPATCH2_API FileSizeRangeException : public FileAccessException
{
public:

    FileSizeRangeException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason An explanation of the reason for the failure.
     */
    explicit FileSizeRangeException(const ::std::string& reason);

#ifdef ICE_CPP11_COMPILER
    FileSizeRangeException(const FileSizeRangeException&) = default;
    virtual ~FileSizeRangeException();
#else
    virtual ~FileSizeRangeException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual FileSizeRangeException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

}

namespace IcePatch2
{

/**
 * AMD callback class for IcePatch2::FileServer::getFileCompressed_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEPATCH2_API AMD_FileServer_getFileCompressed : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_FileServer_getFileCompressed();

    /**
     * Call ice_response for a successful completion.
     * @param result A sequence containing the compressed file contents.
     */
    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& result) = 0;
};

typedef ::IceUtil::Handle< ::IcePatch2::AMD_FileServer_getFileCompressed> AMD_FileServer_getFileCompressedPtr;

/**
 * AMD callback class for IcePatch2::FileServer::getLargeFileCompressed_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEPATCH2_API AMD_FileServer_getLargeFileCompressed : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_FileServer_getLargeFileCompressed();

    /**
     * Call ice_response for a successful completion.
     * @param result A sequence containing the compressed file contents.
     */
    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& result) = 0;
};

typedef ::IceUtil::Handle< ::IcePatch2::AMD_FileServer_getLargeFileCompressed> AMD_FileServer_getLargeFileCompressedPtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace IcePatch2
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEPATCH2_API AMD_FileServer_getFileCompressed : public ::IcePatch2::AMD_FileServer_getFileCompressed, public ::IceInternal::IncomingAsync
{
public:

    AMD_FileServer_getFileCompressed(::IceInternal::Incoming&);

    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEPATCH2_API AMD_FileServer_getLargeFileCompressed : public ::IcePatch2::AMD_FileServer_getLargeFileCompressed, public ::IceInternal::IncomingAsync
{
public:

    AMD_FileServer_getLargeFileCompressed(::IceInternal::Incoming&);

    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace IcePatch2
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getFileInfoSeq.
 */
class Callback_FileServer_getFileInfoSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getFileInfoSeq_Base> Callback_FileServer_getFileInfoSeqPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getLargeFileInfoSeq.
 */
class Callback_FileServer_getLargeFileInfoSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getLargeFileInfoSeq_Base> Callback_FileServer_getLargeFileInfoSeqPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getChecksumSeq.
 */
class Callback_FileServer_getChecksumSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getChecksumSeq_Base> Callback_FileServer_getChecksumSeqPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getChecksum.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getChecksum.
 */
class Callback_FileServer_getChecksum_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getChecksum_Base> Callback_FileServer_getChecksumPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getFileCompressed.
 */
class Callback_FileServer_getFileCompressed_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getFileCompressed_Base> Callback_FileServer_getFileCompressedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getLargeFileCompressed.
 */
class Callback_FileServer_getLargeFileCompressed_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getLargeFileCompressed_Base> Callback_FileServer_getLargeFileCompressedPtr;

}

namespace IceProxy
{

namespace IcePatch2
{

class ICE_CLASS(ICEPATCH2_API) FileServer : public virtual ::Ice::Proxy<FileServer, ::IceProxy::Ice::Object>
{
public:

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::FileInfoSeq getFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getFileInfoSeq(_iceI_begin_getFileInfoSeq(partition, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getFileInfoSeq(partition, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int partition, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(partition, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(partition, context, cb, cookie);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int partition, const ::IcePatch2::Callback_FileServer_getFileInfoSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(partition, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getFileInfoSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(partition, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getFileInfoSeq.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     */
    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::FileInfoSeq end_getFileInfoSeq(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getFileInfoSeq(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     */
    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::LargeFileInfoSeq getLargeFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLargeFileInfoSeq(_iceI_begin_getLargeFileInfoSeq(partition, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLargeFileInfoSeq(partition, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int partition, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(partition, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(partition, context, cb, cookie);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int partition, const ::IcePatch2::Callback_FileServer_getLargeFileInfoSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(partition, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int partition, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getLargeFileInfoSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(partition, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLargeFileInfoSeq.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     */
    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::LargeFileInfoSeq end_getLargeFileInfoSeq(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getLargeFileInfoSeq(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     */
    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::ByteSeqSeq getChecksumSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getChecksumSeq(_iceI_begin_getChecksumSeq(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getChecksumSeq(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the checksums for all partitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(context, cb, cookie);
    }

    /**
     * Return the checksums for all partitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::IcePatch2::Callback_FileServer_getChecksumSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getChecksumSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getChecksumSeq.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     */
    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::ByteSeqSeq end_getChecksumSeq(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getChecksumSeq(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @return The master checksum for the file set.
     */
    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq getChecksum(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getChecksum(_iceI_begin_getChecksum(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getChecksum(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(context, cb, cookie);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksum(const ::IcePatch2::Callback_FileServer_getChecksumPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getChecksumPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getChecksum.
     * @param result The asynchronous result object for the invocation.
     * @return The master checksum for the file set.
     */
    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq end_getChecksum(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getChecksum(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq getFileCompressed(const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getFileCompressed(_iceI_begin_getFileCompressed(path, pos, num, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getFileCompressed(path, pos, num, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(path, pos, num, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(path, pos, num, context, cb, cookie);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::IcePatch2::Callback_FileServer_getFileCompressedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(path, pos, num, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getFileCompressedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(path, pos, num, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getFileCompressed.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     */
    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq end_getFileCompressed(const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICEPATCH2_API) void _iceI_end_getFileCompressed(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getFileCompressed(const ::std::string&, ::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     */
    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq getLargeFileCompressed(const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLargeFileCompressed(_iceI_begin_getLargeFileCompressed(path, pos, num, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLargeFileCompressed(path, pos, num, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(path, pos, num, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(path, pos, num, context, cb, cookie);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::IcePatch2::Callback_FileServer_getLargeFileCompressedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(path, pos, num, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getLargeFileCompressedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(path, pos, num, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLargeFileCompressed.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     */
    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq end_getLargeFileCompressed(const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICEPATCH2_API) void _iceI_end_getLargeFileCompressed(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getLargeFileCompressed(const ::std::string&, ::Ice::Long, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEPATCH2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IcePatch2
{

/**
 * The interface that provides access to files.
 * \headerfile IcePatch2/IcePatch2.h
 */
class ICEPATCH2_API FileServer : public virtual ::Ice::Object
{
public:

    typedef FileServerPrx ProxyType;
    typedef FileServerPtr PointerType;

    virtual ~FileServer();

#ifdef ICE_CPP11_COMPILER
    FileServer() = default;
    FileServer(const FileServer&) = default;
    FileServer& operator=(const FileServer&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param current The Current object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     *
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     */
    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") virtual FileInfoSeq getFileInfoSeq(::Ice::Int partition, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param current The Current object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws IcePatch2::PartitionOutOfRangeException If the partition number is out of range.
     */
    virtual LargeFileInfoSeq getLargeFileInfoSeq(::Ice::Int partition, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLargeFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the checksums for all partitions.
     * @param current The Current object for the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     */
    virtual ByteSeqSeq getChecksumSeq(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getChecksumSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param current The Current object for the invocation.
     * @return The master checksum for the file set.
     */
    virtual ::Ice::ByteSeq getChecksum(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getChecksum(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param cb The AMD callback object for the invocation.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param current The Current object for the invocation.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     * @throws IcePatch2::FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     */
    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") virtual void getFileCompressed_async(const ::IcePatch2::AMD_FileServer_getFileCompressedPtr& cb, const ::std::string& path, ::Ice::Int pos, ::Ice::Int num, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param cb The AMD callback object for the invocation.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param current The Current object for the invocation.
     * @throws IcePatch2::FileAccessException If an error occurred while trying to read the file.
     */
    virtual void getLargeFileCompressed_async(const ::IcePatch2::AMD_FileServer_getLargeFileCompressedPtr& cb, const ::std::string& path, ::Ice::Long pos, ::Ice::Int num, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLargeFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const FileServer& lhs, const FileServer& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileServer& lhs, const FileServer& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IcePatch2::PartitionOutOfRangeException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IcePatch2::FileAccessException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IcePatch2::FileAccessException, S>
{
    static void write(S* ostr, const ::IcePatch2::FileAccessException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IcePatch2::FileAccessException, S>
{
    static void read(S* istr, ::IcePatch2::FileAccessException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IcePatch2::FileSizeRangeException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace IcePatch2
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getFileInfoSeq.
 */
template<class T>
class CallbackNC_FileServer_getFileInfoSeq : public Callback_FileServer_getFileInfoSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const FileInfoSeq&);

    CallbackNC_FileServer_getFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        FileInfoSeq ret;
        try
        {
            ret = proxy->end_getFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 */
template<class T> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const FileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileInfoSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 */
template<class T> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(T* instance, void (T::*cb)(const FileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileInfoSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getFileInfoSeq.
 */
template<class T, typename CT>
class Callback_FileServer_getFileInfoSeq : public Callback_FileServer_getFileInfoSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const FileInfoSeq&, const CT&);

    Callback_FileServer_getFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        FileInfoSeq ret;
        try
        {
            ret = proxy->end_getFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 */
template<class T, typename CT> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const FileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileInfoSeq.
 */
template<class T, typename CT> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(T* instance, void (T::*cb)(const FileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getLargeFileInfoSeq.
 */
template<class T>
class CallbackNC_FileServer_getLargeFileInfoSeq : public Callback_FileServer_getLargeFileInfoSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LargeFileInfoSeq&);

    CallbackNC_FileServer_getLargeFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        LargeFileInfoSeq ret;
        try
        {
            ret = proxy->end_getLargeFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 */
template<class T> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const LargeFileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileInfoSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 */
template<class T> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(T* instance, void (T::*cb)(const LargeFileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileInfoSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getLargeFileInfoSeq.
 */
template<class T, typename CT>
class Callback_FileServer_getLargeFileInfoSeq : public Callback_FileServer_getLargeFileInfoSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LargeFileInfoSeq&, const CT&);

    Callback_FileServer_getLargeFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        LargeFileInfoSeq ret;
        try
        {
            ret = proxy->end_getLargeFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 */
template<class T, typename CT> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const LargeFileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileInfoSeq.
 */
template<class T, typename CT> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(T* instance, void (T::*cb)(const LargeFileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getChecksumSeq.
 */
template<class T>
class CallbackNC_FileServer_getChecksumSeq : public Callback_FileServer_getChecksumSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ByteSeqSeq&);

    CallbackNC_FileServer_getChecksumSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ByteSeqSeq ret;
        try
        {
            ret = proxy->end_getChecksumSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 */
template<class T> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ByteSeqSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksumSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 */
template<class T> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(T* instance, void (T::*cb)(const ByteSeqSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksumSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getChecksumSeq.
 */
template<class T, typename CT>
class Callback_FileServer_getChecksumSeq : public Callback_FileServer_getChecksumSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ByteSeqSeq&, const CT&);

    Callback_FileServer_getChecksumSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ByteSeqSeq ret;
        try
        {
            ret = proxy->end_getChecksumSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 */
template<class T, typename CT> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ByteSeqSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksumSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksumSeq.
 */
template<class T, typename CT> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(T* instance, void (T::*cb)(const ByteSeqSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksumSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getChecksum.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getChecksum.
 */
template<class T>
class CallbackNC_FileServer_getChecksum : public Callback_FileServer_getChecksum_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ByteSeq&);

    CallbackNC_FileServer_getChecksum(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ::Ice::ByteSeq ret;
        try
        {
            ret = proxy->end_getChecksum(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksum.
 */
template<class T> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ByteSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksum<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksum.
 */
template<class T> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(T* instance, void (T::*cb)(const ::Ice::ByteSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksum<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getChecksum.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getChecksum.
 */
template<class T, typename CT>
class Callback_FileServer_getChecksum : public Callback_FileServer_getChecksum_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ByteSeq&, const CT&);

    Callback_FileServer_getChecksum(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ::Ice::ByteSeq ret;
        try
        {
            ret = proxy->end_getChecksum(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksum.
 */
template<class T, typename CT> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ByteSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksum<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getChecksum.
 */
template<class T, typename CT> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(T* instance, void (T::*cb)(const ::Ice::ByteSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksum<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getFileCompressed.
 */
template<class T>
class CallbackNC_FileServer_getFileCompressed : public Callback_FileServer_getFileCompressed_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);

    CallbackNC_FileServer_getFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 */
template<class T> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileCompressed<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 */
template<class T> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileCompressed<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getFileCompressed.
 */
template<class T, typename CT>
class Callback_FileServer_getFileCompressed : public Callback_FileServer_getFileCompressed_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&);

    Callback_FileServer_getFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 */
template<class T, typename CT> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getFileCompressed.
 */
template<class T, typename CT> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getLargeFileCompressed.
 */
template<class T>
class CallbackNC_FileServer_getLargeFileCompressed : public Callback_FileServer_getLargeFileCompressed_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);

    CallbackNC_FileServer_getLargeFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getLargeFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 */
template<class T> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileCompressed<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 */
template<class T> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileCompressed<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 * Create a wrapper instance by calling ::IcePatch2::newCallback_FileServer_getLargeFileCompressed.
 */
template<class T, typename CT>
class Callback_FileServer_getLargeFileCompressed : public Callback_FileServer_getLargeFileCompressed_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&);

    Callback_FileServer_getLargeFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileServerPrx proxy = FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getLargeFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 */
template<class T, typename CT> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IcePatch2::FileServer::begin_getLargeFileCompressed.
 */
template<class T, typename CT> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
